package relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlREGWORD</b> is generated from vxml20.rxg by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="REGWORD">
 *   <empty/>
 * </elementRule>
 * 
 * <tag name="REGWORD">
 *   <attribute name="STRING" type="string"/>
 *   <attribute name="READING" type="string"/>
 *   <attribute name="PARTOFSP" type="string"/>
 *   <attribute name="SYMSAMPA" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="REGWORD"&gt;
 *   &lt;empty/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="REGWORD"&gt;
 *   &lt;attribute name="STRING" type="string"/&gt;
 *   &lt;attribute name="READING" type="string"/&gt;
 *   &lt;attribute name="PARTOFSP" type="string"/&gt;
 *   &lt;attribute name="SYMSAMPA" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version vxml20.rxg (Thu Aug 14 17:30:01 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class VxmlREGWORD implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlCONTEXTMixed, IVxmlCONTEXTMixedChoice, IVxmlJVOICEMixed, IVxmlJVOICEMixedChoice, IVxmlPITCHMixed, IVxmlPITCHMixedChoice, IVxmlEmphasisMixed, IVxmlEmphasisMixedChoice, IVxmlLANGMixed, IVxmlLANGMixedChoice, IVxmlParagraphMixed, IVxmlParagraphMixedChoice, IVxmlSentenceMixed, IVxmlSentenceMixedChoice, IVxmlPARTOFSPMixed, IVxmlPARTOFSPMixedChoice, IVxmlPMixed, IVxmlPMixedChoice, IVxmlSMixed, IVxmlSMixedChoice, IVxmlPRONMixed, IVxmlPRONMixedChoice, IVxmlRATEMixed, IVxmlRATEMixedChoice, IVxmlVOLUMEMixed, IVxmlVOLUMEMixedChoice, IVxmlEnumerateMixed, IVxmlEnumerateMixedChoice, IVxmlEMPHMixed, IVxmlEMPHMixedChoice, IVxmlSPELLMixed, IVxmlSPELLMixedChoice, IVxmlSPEECHMixed, IVxmlSPEECHMixedChoice, IVxmlEmotionMixed, IVxmlEmotionMixedChoice, IVxmlVoiceMixed, IVxmlVoiceMixedChoice, IVxmlProsodyMixed, IVxmlProsodyMixedChoice, IVxmlAudioMixed, IVxmlAudioMixedChoice, IVxmlChoiceMixed, IVxmlChoiceMixedChoice, IVxmlPromptMixed, IVxmlPromptMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String STRING_;
    private String READING_;
    private String PARTOFSP_;
    private String SYMSAMPA_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlREGWORD</code>.
     *
     */
    public VxmlREGWORD() {
    }

    /**
     * Creates a <code>VxmlREGWORD</code>.
     *
     * @param source
     */
    public VxmlREGWORD(VxmlREGWORD source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlREGWORD</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlREGWORD(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlREGWORD</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlREGWORD(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlREGWORD</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlREGWORD(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlREGWORD</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlREGWORD(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlREGWORD</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlREGWORD(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlREGWORD</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlREGWORD(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlREGWORD</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlREGWORD(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlREGWORD</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlREGWORD(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlREGWORD</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlREGWORD(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlREGWORD</code> by the VxmlREGWORD <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlREGWORD source) {
        int size;
        setSTRING(source.getSTRING());
        setREADING(source.getREADING());
        setPARTOFSP(source.getPARTOFSP());
        setSYMSAMPA(source.getSYMSAMPA());
    }

    /**
     * Initializes the <code>VxmlREGWORD</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlREGWORD</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlREGWORD</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        STRING_ = URelaxer.getAttributePropertyAsString(element, "STRING");
        READING_ = URelaxer.getAttributePropertyAsString(element, "READING");
        PARTOFSP_ = URelaxer.getAttributePropertyAsString(element, "PARTOFSP");
        SYMSAMPA_ = URelaxer.getAttributePropertyAsString(element, "SYMSAMPA");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlREGWORD(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "REGWORD");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.STRING_ != null) {
            URelaxer.setAttributePropertyByString(element, "STRING", this.STRING_);
        }
        if (this.READING_ != null) {
            URelaxer.setAttributePropertyByString(element, "READING", this.READING_);
        }
        if (this.PARTOFSP_ != null) {
            URelaxer.setAttributePropertyByString(element, "PARTOFSP", this.PARTOFSP_);
        }
        if (this.SYMSAMPA_ != null) {
            URelaxer.setAttributePropertyByString(element, "SYMSAMPA", this.SYMSAMPA_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlREGWORD</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlREGWORD</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlREGWORD</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlREGWORD</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlREGWORD</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlREGWORD</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>STRING</b>.
     *
     * @return String
     */
    public final String getSTRING() {
        return (STRING_);
    }

    /**
     * Sets the String property <b>STRING</b>.
     *
     * @param STRING
     */
    public final void setSTRING(String STRING) {
        this.STRING_ = STRING;
    }

    /**
     * Gets the String property <b>READING</b>.
     *
     * @return String
     */
    public final String getREADING() {
        return (READING_);
    }

    /**
     * Sets the String property <b>READING</b>.
     *
     * @param READING
     */
    public final void setREADING(String READING) {
        this.READING_ = READING;
    }

    /**
     * Gets the String property <b>PARTOFSP</b>.
     *
     * @return String
     */
    public final String getPARTOFSP() {
        return (PARTOFSP_);
    }

    /**
     * Sets the String property <b>PARTOFSP</b>.
     *
     * @param PARTOFSP
     */
    public final void setPARTOFSP(String PARTOFSP) {
        this.PARTOFSP_ = PARTOFSP;
    }

    /**
     * Gets the String property <b>SYMSAMPA</b>.
     *
     * @return String
     */
    public final String getSYMSAMPA() {
        return (SYMSAMPA_);
    }

    /**
     * Sets the String property <b>SYMSAMPA</b>.
     *
     * @param SYMSAMPA
     */
    public final void setSYMSAMPA(String SYMSAMPA) {
        this.SYMSAMPA_ = SYMSAMPA;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "REGWORD", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (STRING_ != null) {
            buffer.append(" ");
            buffer.append("STRING");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getSTRING())));
            buffer.append("\"");
        }
        if (READING_ != null) {
            buffer.append(" ");
            buffer.append("READING");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getREADING())));
            buffer.append("\"");
        }
        if (PARTOFSP_ != null) {
            buffer.append(" ");
            buffer.append("PARTOFSP");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getPARTOFSP())));
            buffer.append("\"");
        }
        if (SYMSAMPA_ != null) {
            buffer.append(" ");
            buffer.append("SYMSAMPA");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getSYMSAMPA())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</");
        URelaxer.makeQName(prefix, "REGWORD", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "REGWORD", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (STRING_ != null) {
            buffer.write(" ");
            buffer.write("STRING");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getSTRING())));
            buffer.write("\"");
        }
        if (READING_ != null) {
            buffer.write(" ");
            buffer.write("READING");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getREADING())));
            buffer.write("\"");
        }
        if (PARTOFSP_ != null) {
            buffer.write(" ");
            buffer.write("PARTOFSP");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getPARTOFSP())));
            buffer.write("\"");
        }
        if (SYMSAMPA_ != null) {
            buffer.write(" ");
            buffer.write("SYMSAMPA");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getSYMSAMPA())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</");
        URelaxer.makeQName(prefix, "REGWORD", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "REGWORD", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (STRING_ != null) {
            buffer.print(" ");
            buffer.print("STRING");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getSTRING())));
            buffer.print("\"");
        }
        if (READING_ != null) {
            buffer.print(" ");
            buffer.print("READING");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getREADING())));
            buffer.print("\"");
        }
        if (PARTOFSP_ != null) {
            buffer.print(" ");
            buffer.print("PARTOFSP");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getPARTOFSP())));
            buffer.print("\"");
        }
        if (SYMSAMPA_ != null) {
            buffer.print(" ");
            buffer.print("SYMSAMPA");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getSYMSAMPA())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</");
        URelaxer.makeQName(prefix, "REGWORD", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSTRINGAsString() {
        return (URelaxer.getString(getSTRING()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getREADINGAsString() {
        return (URelaxer.getString(getREADING()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getPARTOFSPAsString() {
        return (URelaxer.getString(getPARTOFSP()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSYMSAMPAAsString() {
        return (URelaxer.getString(getSYMSAMPA()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSTRINGByString(String string) {
        setSTRING(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setREADINGByString(String string) {
        setREADING(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setPARTOFSPByString(String string) {
        setPARTOFSP(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSYMSAMPAByString(String string) {
        setSYMSAMPA(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlREGWORD</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "REGWORD")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlREGWORD</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlREGWORD</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
