package relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlCatch</b> is generated from vxml20.rxg by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="catch">
 *   <mixed>
 *     <choice occurs="*">
 *       <ref label="audio"/>
 *       <ref label="enumerate"/>
 *       <ref label="value"/>
 *       <ref label="assign"/>
 *       <ref label="clear"/>
 *       <ref label="disconnect"/>
 *       <ref label="exit"/>
 *       <ref label="goto"/>
 *       <ref label="if"/>
 *       <ref label="log"/>
 *       <ref label="native"/>
 *       <ref label="prompt"/>
 *       <ref label="reprompt"/>
 *       <ref label="return"/>
 *       <ref label="script"/>
 *       <ref label="submit"/>
 *       <ref label="throw"/>
 *       <ref label="var"/>
 *     </choice>
 *   </mixed>
 * </elementRule>
 * 
 * <tag name="catch">
 *   <attribute name="event" required="true" type="string"/>
 *   <attribute name="count" type="string"/>
 *   <attribute name="cond" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="catch"&gt;
 *   &lt;mixed&gt;
 *     &lt;choice occurs="*"&gt;
 *       &lt;ref label="audio"/&gt;
 *       &lt;ref label="enumerate"/&gt;
 *       &lt;ref label="value"/&gt;
 *       &lt;ref label="assign"/&gt;
 *       &lt;ref label="clear"/&gt;
 *       &lt;ref label="disconnect"/&gt;
 *       &lt;ref label="exit"/&gt;
 *       &lt;ref label="goto"/&gt;
 *       &lt;ref label="if"/&gt;
 *       &lt;ref label="log"/&gt;
 *       &lt;ref label="native"/&gt;
 *       &lt;ref label="prompt"/&gt;
 *       &lt;ref label="reprompt"/&gt;
 *       &lt;ref label="return"/&gt;
 *       &lt;ref label="script"/&gt;
 *       &lt;ref label="submit"/&gt;
 *       &lt;ref label="throw"/&gt;
 *       &lt;ref label="var"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/mixed&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="catch"&gt;
 *   &lt;attribute name="event" required="true" type="string"/&gt;
 *   &lt;attribute name="count" type="string"/&gt;
 *   &lt;attribute name="cond" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version vxml20.rxg (Thu Aug 14 17:30:01 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class VxmlCatch implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlMenuMixed, IVxmlMenuMixedChoice, IVxmlVxmlChoice, IVxmlObjectMixed, IVxmlObjectMixedChoice, IVxmlSubdialogMixed, IVxmlSubdialogMixedChoice, IVxmlRecordMixed, IVxmlRecordMixedChoice, IVxmlTransferMixed, IVxmlTransferMixedChoice, IVxmlFieldMixed, IVxmlFieldMixedChoice, IVxmlFormChoice, IVxmlInitialMixed, IVxmlInitialMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String event_;
    private String count_;
    private String cond_;
    // List<IVxmlCatchMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlCatch</code>.
     *
     */
    public VxmlCatch() {
        event_ = "";
    }

    /**
     * Creates a <code>VxmlCatch</code>.
     *
     * @param source
     */
    public VxmlCatch(VxmlCatch source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlCatch</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlCatch(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlCatch</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlCatch(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlCatch</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlCatch(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlCatch</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCatch(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlCatch</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCatch(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlCatch</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCatch(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlCatch</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCatch(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlCatch</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCatch(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlCatch</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlCatch(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlCatch</code> by the VxmlCatch <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlCatch source) {
        int size;
        setEvent(source.getEvent());
        setCount(source.getCount());
        setCond(source.getCond());
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlCatchMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlCatch</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlCatch</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlCatch</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        event_ = URelaxer.getAttributePropertyAsString(element, "event");
        count_ = URelaxer.getAttributePropertyAsString(element, "count");
        cond_ = URelaxer.getAttributePropertyAsString(element, "cond");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlSubmit.isMatch(stack)) {
                addContent(new VxmlSubmit(stack));
            } else if (VxmlGoto.isMatch(stack)) {
                addContent(new VxmlGoto(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlPrompt.isMatch(stack)) {
                addContent(new VxmlPrompt(stack));
            } else if (VxmlScript.isMatch(stack)) {
                addContent(new VxmlScript(stack));
            } else if (VxmlThrow.isMatch(stack)) {
                addContent(new VxmlThrow(stack));
            } else if (VxmlLog.isMatch(stack)) {
                addContent(new VxmlLog(stack));
            } else if (VxmlNative.isMatch(stack)) {
                addContent(new VxmlNative(stack));
            } else if (VxmlAssign.isMatch(stack)) {
                addContent(new VxmlAssign(stack));
            } else if (VxmlExit.isMatch(stack)) {
                addContent(new VxmlExit(stack));
            } else if (VxmlIf.isMatch(stack)) {
                addContent(new VxmlIf(stack));
            } else if (VxmlReturn.isMatch(stack)) {
                addContent(new VxmlReturn(stack));
            } else if (VxmlVar.isMatch(stack)) {
                addContent(new VxmlVar(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlClear.isMatch(stack)) {
                addContent(new VxmlClear(stack));
            } else if (VxmlDisconnect.isMatch(stack)) {
                addContent(new VxmlDisconnect(stack));
            } else if (VxmlReprompt.isMatch(stack)) {
                addContent(new VxmlReprompt(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlCatch(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "catch");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.event_ != null) {
            URelaxer.setAttributePropertyByString(element, "event", this.event_);
        }
        if (this.count_ != null) {
            URelaxer.setAttributePropertyByString(element, "count", this.count_);
        }
        if (this.cond_ != null) {
            URelaxer.setAttributePropertyByString(element, "cond", this.cond_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCatchMixed value = (IVxmlCatchMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlCatch</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlCatch</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlCatch</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlCatch</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlCatch</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlCatch</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContent(String text) {
        setContent(new RString(text));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContentByString(String text) {
        setContent(new RString(text));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>event</b>.
     *
     * @return String
     */
    public final String getEvent() {
        return (event_);
    }

    /**
     * Sets the String property <b>event</b>.
     *
     * @param event
     */
    public final void setEvent(String event) {
        this.event_ = event;
    }

    /**
     * Gets the String property <b>count</b>.
     *
     * @return String
     */
    public final String getCount() {
        return (count_);
    }

    /**
     * Sets the String property <b>count</b>.
     *
     * @param count
     */
    public final void setCount(String count) {
        this.count_ = count;
    }

    /**
     * Gets the String property <b>cond</b>.
     *
     * @return String
     */
    public final String getCond() {
        return (cond_);
    }

    /**
     * Sets the String property <b>cond</b>.
     *
     * @param cond
     */
    public final void setCond(String cond) {
        this.cond_ = cond;
    }

    /**
     * Gets the IVxmlCatchMixed property <b>content</b>.
     *
     * @return IVxmlCatchMixed[]
     */
    public final IVxmlCatchMixed[] getContent() {
        IVxmlCatchMixed[] array = new IVxmlCatchMixed[content_.size()];
        return ((IVxmlCatchMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlCatchMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlCatchMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlCatchMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlCatchMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlCatchMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlCatchMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlCatchMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlCatchMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlCatchMixed property <b>content</b>.
     *
     * @return int
     */
    public final int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlCatchMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlCatchMixed
     */
    public final IVxmlCatchMixed getContent(int index) {
        return ((IVxmlCatchMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlCatchMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IVxmlCatchMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlCatchMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void addContent(int index, IVxmlCatchMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlCatchMixed property <b>content</b> by index.
     *
     * @param index
     */
    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlCatchMixed property <b>content</b> by object.
     *
     * @param content
     */
    public final void removeContent(IVxmlCatchMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlCatchMixed property <b>content</b>.
     *
     */
    public final void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "catch", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (event_ != null) {
            buffer.append(" ");
            buffer.append("event");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.append("\"");
        }
        if (count_ != null) {
            buffer.append(" ");
            buffer.append("count");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCount())));
            buffer.append("\"");
        }
        if (cond_ != null) {
            buffer.append(" ");
            buffer.append("cond");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCatchMixed value = (IVxmlCatchMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCatchMixed value = (IVxmlCatchMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "catch", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "catch", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (event_ != null) {
            buffer.write(" ");
            buffer.write("event");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.write("\"");
        }
        if (count_ != null) {
            buffer.write(" ");
            buffer.write("count");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCount())));
            buffer.write("\"");
        }
        if (cond_ != null) {
            buffer.write(" ");
            buffer.write("cond");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCatchMixed value = (IVxmlCatchMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCatchMixed value = (IVxmlCatchMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "catch", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "catch", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (event_ != null) {
            buffer.print(" ");
            buffer.print("event");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.print("\"");
        }
        if (count_ != null) {
            buffer.print(" ");
            buffer.print("count");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCount())));
            buffer.print("\"");
        }
        if (cond_ != null) {
            buffer.print(" ");
            buffer.print("cond");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCatchMixed value = (IVxmlCatchMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlCatchMixed value = (IVxmlCatchMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "catch", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getEventAsString() {
        return (URelaxer.getString(getEvent()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCountAsString() {
        return (URelaxer.getString(getCount()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCondAsString() {
        return (URelaxer.getString(getCond()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setEventByString(String string) {
        setEvent(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCountByString(String string) {
        setCount(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCondByString(String string) {
        setCond(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlCatch</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "catch")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (VxmlSubmit.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlGoto.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPrompt.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlScript.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlThrow.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLog.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNative.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlAssign.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlExit.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlIf.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlReturn.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVar.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlClear.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlDisconnect.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlReprompt.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlCatch</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlCatch</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
