package relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocVoice</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="voice">
 *   <optional>
 *     <attribute name="with">
 *       <data type="token"/>
 *     </attribute>
 *   </optional>
 *   <optional>
 *     <attribute name="bargein" relaxer:default="true">
 *       <data type="boolean"/>
 *     </attribute>
 *   </optional>
 *   <data type="token"/>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="voice"&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="with"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="bargein" relaxer:default="true"&gt;
 *       &lt;data type="boolean"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;data type="token"/&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pdoc.rng (Thu Aug 14 17:30:12 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class PdocVoice implements java.io.Serializable, Cloneable, IPdocAddChoice {
    private String content_;
    private String with_;
    private Boolean bargein_;

    /**
     * Creates a <code>PdocVoice</code>.
     *
     */
    public PdocVoice() {
    }

    /**
     * Creates a <code>PdocVoice</code>.
     *
     * @param source
     */
    public PdocVoice(PdocVoice source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocVoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocVoice(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocVoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocVoice(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocVoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocVoice(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocVoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocVoice(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocVoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocVoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocVoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocVoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocVoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocVoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocVoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocVoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocVoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocVoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocVoice</code> by the PdocVoice <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocVoice source) {
        int size;
        setContent(source.getContent());
        setWith(source.getWith());
        setBargein(source.getBargein());
    }

    /**
     * Initializes the <code>PdocVoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocVoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocVoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        content_ = URelaxer.getElementPropertyAsString(element);
        with_ = URelaxer.getAttributePropertyAsString(element, "with");
        bargein_ = URelaxer.getAttributePropertyAsBooleanObject(element, "bargein");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocVoice(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("voice");
        URelaxer.setElementPropertyByString(element, this.content_);
        int size;
        if (this.with_ != null) {
            URelaxer.setAttributePropertyByString(element, "with", this.with_);
        }
        if (this.bargein_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "bargein", this.bargein_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocVoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocVoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocVoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocVoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocVoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocVoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>content</b>.
     *
     * @return String
     */
    public final String getContent() {
        return (content_);
    }

    /**
     * Sets the String property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(String content) {
        this.content_ = content;
    }

    /**
     * Gets the String property <b>with</b>.
     *
     * @return String
     */
    public final String getWith() {
        return (with_);
    }

    /**
     * Sets the String property <b>with</b>.
     *
     * @param with
     */
    public final void setWith(String with) {
        this.with_ = with;
    }

    /**
     * Gets the boolean property <b>bargein</b>.
     *
     * @return boolean
     */
    public boolean getBargein() {
        if (bargein_ == null) {
            return(true);
        }
        return (bargein_.booleanValue());
    }

    /**
     * Gets the boolean property <b>bargein</b>.
     *
     * @param bargein
     * @return boolean
     */
    public boolean getBargein(boolean bargein) {
        if (bargein_ == null) {
            return(bargein);
        }
        return (this.bargein_.booleanValue());
    }

    /**
     * Gets the boolean property <b>bargein</b>.
     *
     * @return Boolean
     */
    public Boolean getBargeinAsBoolean() {
        return (bargein_);
    }

    /**
     * Check the boolean property <b>bargein</b>.
     *
     * @return boolean
     */
    public boolean checkBargein() {
        return (bargein_ != null);
    }

    /**
     * Sets the boolean property <b>bargein</b>.
     *
     * @param bargein
     */
    public void setBargein(boolean bargein) {
        this.bargein_ = new Boolean(bargein);
    }

    /**
     * Sets the boolean property <b>bargein</b>.
     *
     * @param bargein
     */
    public void setBargein(Boolean bargein) {
        this.bargein_ = bargein;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<voice");
        if (with_ != null) {
            buffer.append(" with=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getWith())));
            buffer.append("\"");
        }
        if (bargein_ != null) {
            buffer.append(" bargein=\"");
            buffer.append(URelaxer.getString(getBargein()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(getContent())));
        buffer.append("</voice>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<voice");
        if (with_ != null) {
            buffer.write(" with=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getWith())));
            buffer.write("\"");
        }
        if (bargein_ != null) {
            buffer.write(" bargein=\"");
            buffer.write(URelaxer.getString(getBargein()));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(getContent())));
        buffer.write("</voice>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<voice");
        if (with_ != null) {
            buffer.print(" with=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getWith())));
            buffer.print("\"");
        }
        if (bargein_ != null) {
            buffer.print(" bargein=\"");
            buffer.print(URelaxer.getString(getBargein()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(getContent())));
        buffer.print("</voice>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getContentAsString() {
        return (URelaxer.getString(getContent()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getWithAsString() {
        return (URelaxer.getString(getWith()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getBargeinAsString() {
        return (URelaxer.getString(getBargein()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setContentByString(String string) {
        setContent(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setWithByString(String string) {
        setWith(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setBargeinByString(String string) {
        setBargein(new Boolean(string).booleanValue());
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocVoice</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "voice")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocVoice</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocVoice</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
