package relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocCmd</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="cmd">
 *   <optional>
 *     <attribute name="cond">
 *       <data type="token"/>
 *     </attribute>
 *   </optional>
 *   <ref name="cmdContents"/>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="cmd"&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="cond"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;ref name="cmdContents"/&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pdoc.rng (Thu Aug 14 17:30:12 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class PdocCmd implements java.io.Serializable, Cloneable, IPdocCmdContentsChoice {
    private String cond_;
    // List<IPdocCmdContentsChoice>
    private java.util.List cmdContents_ = new java.util.ArrayList();

    /**
     * Creates a <code>PdocCmd</code>.
     *
     */
    public PdocCmd() {
    }

    /**
     * Creates a <code>PdocCmd</code>.
     *
     * @param source
     */
    public PdocCmd(PdocCmd source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocCmd</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocCmd(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocCmd</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocCmd(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocCmd</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocCmd(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocCmd</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCmd(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocCmd</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCmd(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocCmd</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCmd(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocCmd</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCmd(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocCmd</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCmd(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocCmd</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCmd(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocCmd</code> by the PdocCmd <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocCmd source) {
        int size;
        setCond(source.getCond());
        this.cmdContents_.clear();
        size = source.cmdContents_.size();
        for (int i = 0;i < size;i++) {
            addCmdContents((IPdocCmdContentsChoice)source.getCmdContents(i).clone());
        }
    }

    /**
     * Initializes the <code>PdocCmd</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocCmd</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocCmd</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        cond_ = URelaxer.getAttributePropertyAsString(element, "cond");
        cmdContents_.clear();
        while (true) {
            if (PdocEnd.isMatch(stack)) {
                addCmdContents(new PdocEnd(stack));
            } else if (PdocAdd.isMatch(stack)) {
                addCmdContents(new PdocAdd(stack));
            } else if (PdocScript.isMatch(stack)) {
                addCmdContents(new PdocScript(stack));
            } else if (PdocCmd.isMatch(stack)) {
                addCmdContents(new PdocCmd(stack));
            } else if (PdocGoto.isMatch(stack)) {
                addCmdContents(new PdocGoto(stack));
            } else if (PdocNext.isMatch(stack)) {
                addCmdContents(new PdocNext(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocCmd(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("cmd");
        int size;
        if (this.cond_ != null) {
            URelaxer.setAttributePropertyByString(element, "cond", this.cond_);
        }
        size = this.cmdContents_.size();
        for (int i = 0;i < size;i++) {
            IPdocCmdContentsChoice value = (IPdocCmdContentsChoice)this.cmdContents_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocCmd</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocCmd</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCmd</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCmd</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCmd</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCmd</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>cond</b>.
     *
     * @return String
     */
    public final String getCond() {
        return (cond_);
    }

    /**
     * Sets the String property <b>cond</b>.
     *
     * @param cond
     */
    public final void setCond(String cond) {
        this.cond_ = cond;
    }

    /**
     * Gets the IPdocCmdContentsChoice property <b>cmdContents</b>.
     *
     * @return IPdocCmdContentsChoice[]
     */
    public final IPdocCmdContentsChoice[] getCmdContents() {
        IPdocCmdContentsChoice[] array = new IPdocCmdContentsChoice[cmdContents_.size()];
        return ((IPdocCmdContentsChoice[])cmdContents_.toArray(array));
    }

    /**
     * Sets the IPdocCmdContentsChoice property <b>cmdContents</b>.
     *
     * @param cmdContents
     */
    public final void setCmdContents(IPdocCmdContentsChoice[] cmdContents) {
        this.cmdContents_.clear();
        for (int i = 0;i < cmdContents.length;i++) {
            addCmdContents(cmdContents[i]);
        }
    }

    /**
     * Sets the IPdocCmdContentsChoice property <b>cmdContents</b>.
     *
     * @param cmdContents
     */
    public final void setCmdContents(IPdocCmdContentsChoice cmdContents) {
        this.cmdContents_.clear();
        addCmdContents(cmdContents);
    }

    /**
     * Adds the IPdocCmdContentsChoice property <b>cmdContents</b>.
     *
     * @param cmdContents
     */
    public final void addCmdContents(IPdocCmdContentsChoice cmdContents) {
        this.cmdContents_.add(cmdContents);
    }

    /**
     * Adds the IPdocCmdContentsChoice property <b>cmdContents</b>.
     *
     * @param cmdContents
     */
    public final void addCmdContents(IPdocCmdContentsChoice[] cmdContents) {
        for (int i = 0;i < cmdContents.length;i++) {
            addCmdContents(cmdContents[i]);
        }
    }

    /**
     * Gets number of the IPdocCmdContentsChoice property <b>cmdContents</b>.
     *
     * @return int
     */
    public final int sizeCmdContents() {
        return (cmdContents_.size());
    }

    /**
     * Gets the IPdocCmdContentsChoice property <b>cmdContents</b> by index.
     *
     * @param index
     * @return IPdocCmdContentsChoice
     */
    public final IPdocCmdContentsChoice getCmdContents(int index) {
        return ((IPdocCmdContentsChoice)cmdContents_.get(index));
    }

    /**
     * Sets the IPdocCmdContentsChoice property <b>cmdContents</b> by index.
     *
     * @param index
     * @param cmdContents
     */
    public final void setCmdContents(int index, IPdocCmdContentsChoice cmdContents) {
        this.cmdContents_.set(index, cmdContents);
    }

    /**
     * Adds the IPdocCmdContentsChoice property <b>cmdContents</b> by index.
     *
     * @param index
     * @param cmdContents
     */
    public final void addCmdContents(int index, IPdocCmdContentsChoice cmdContents) {
        this.cmdContents_.add(index, cmdContents);
    }

    /**
     * Remove the IPdocCmdContentsChoice property <b>cmdContents</b> by index.
     *
     * @param index
     */
    public final void removeCmdContents(int index) {
        this.cmdContents_.remove(index);
    }

    /**
     * Remove the IPdocCmdContentsChoice property <b>cmdContents</b> by object.
     *
     * @param cmdContents
     */
    public final void removeCmdContents(IPdocCmdContentsChoice cmdContents) {
        this.cmdContents_.remove(cmdContents);
    }

    /**
     * Clear the IPdocCmdContentsChoice property <b>cmdContents</b>.
     *
     */
    public final void clearCmdContents() {
        this.cmdContents_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<cmd");
        if (cond_ != null) {
            buffer.append(" cond=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.append("\"");
        }
        size = this.cmdContents_.size();
        for (int i = 0;i < size;i++) {
            IPdocCmdContentsChoice value = (IPdocCmdContentsChoice)this.cmdContents_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.cmdContents_.size();
        for (int i = 0;i < size;i++) {
            IPdocCmdContentsChoice value = (IPdocCmdContentsChoice)this.cmdContents_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</cmd>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<cmd");
        if (cond_ != null) {
            buffer.write(" cond=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.write("\"");
        }
        size = this.cmdContents_.size();
        for (int i = 0;i < size;i++) {
            IPdocCmdContentsChoice value = (IPdocCmdContentsChoice)this.cmdContents_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.cmdContents_.size();
        for (int i = 0;i < size;i++) {
            IPdocCmdContentsChoice value = (IPdocCmdContentsChoice)this.cmdContents_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</cmd>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<cmd");
        if (cond_ != null) {
            buffer.print(" cond=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.print("\"");
        }
        size = this.cmdContents_.size();
        for (int i = 0;i < size;i++) {
            IPdocCmdContentsChoice value = (IPdocCmdContentsChoice)this.cmdContents_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.cmdContents_.size();
        for (int i = 0;i < size;i++) {
            IPdocCmdContentsChoice value = (IPdocCmdContentsChoice)this.cmdContents_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</cmd>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCondAsString() {
        return (URelaxer.getString(getCond()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCondByString(String string) {
        setCond(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocCmd</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "cmd")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (PdocEnd.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocAdd.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocScript.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocCmd.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocGoto.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocNext.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocCmd</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocCmd</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
