/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: VoiceOutItem.java,v 1.5 2003/07/25 09:56:34 nishi Exp $
 */

package outitem;

import util.*;
import main.*;
import scripting.ECMAScript;

public class VoiceOutItem extends OutItem
{
    private Debug dbg = new Debug(1);

    private String arg_ = "";
    public String getArg() { return arg_; }

    private String with_ = "";

    public void setWith(String s) {
	with_ = s;
    }
    public String getWith() {
	return with_;
    }

    private boolean gender_ = true;             // True = , False = 
    private String tts_;                        // TTS

    /*
    public VoiceOutItem(String tts)
      // :TTS򥻥å
    {

	this(tts, null, true);

    }

    public VoiceOutItem(String tts, boolean bargein)
      // :TTS򥻥å
    {

	this(tts, gs, true);

    }

    public VoiceOutItem(String tts, GrammarSet gs, boolean gen)
      // :TTS̤򥻥å
    {

	myDevice_ = OutputDevices.Type.VOICE;
	isInstant_ = false;
	tts_ = tts;
	gs_ = gs;
	gender_ = gen;

    }
    */

    public VoiceOutItem(String tts, String with)
    {
	this(tts, with, true);
    }

    public VoiceOutItem(String tts, String with, boolean bargein)
    {
	myDevice_ = OutputDevices.Type.VOICE;
	isInstant_ = false;
	tts_ = tts;
	bargein_ = bargein;
	gender_ = true;
	with_ = with;
    }

    public void doOutput(OutputDevices od)     // ºݤ˽
    {
	String str = null;
	if (eval_) {
	    String script;
	    if ( with_.length() > 0 ) {
		script = "with(" + with_ + "){" + tts_ + "}";
	    } else {
		script = tts_;
	    }
	    str = ECMAScript.doEvaluate(script);

	} else {
	    str = tts_;
	}

	arg_ = str;
	OutputDevice d = od.getDevice(myDevice_);
	d.outputDeviceStart(this);
    }

    public String toString()
    {
	String wt = Util.encodeXmlChars(with_);
	String str = Util.encodeXmlChars(tts_);

	String s = "<voice";
	if ( bargein_ == false ) {
	    s += " bargein=\"false\"";
	}
	if ( eval_ == true && wt.length() > 0 ) {
	    s += " with=\"" + wt + "\"";
	}
	s += ">";
	if ( eval_ == true ) {
	    s += str;
	} else {
	    s += "'" + str + "'";
	}
	s += "</voice>";
	return s;
    }
    
    private boolean eval_ = true;  // false ? ͤ ECMAScript Ȥ eval 뤫

    public void setEval(boolean b)
    {
	eval_ = b;
    }

    public boolean getEval()
    {
	return eval_;
    }

}
