/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 *  $Id: NativeOutItem.java,v 1.4 2003/07/25 09:56:34 nishi Exp $
 */

package outitem;

import scripting.ECMAScript;
import main.*;

public class NativeOutItem extends OutItem 
{
    //private Debug dbg = new Debug("NativeOutItem");

    private String arg_ = "";
    public String getArg() { return arg_; }

    private String with_ = "";

    public void setWith(String s) {
	with_ = s;
    }
    public String getWith() {
	return with_;
    }

    private String text_;

    public NativeOutItem(String tts)
    {
	this(tts, "");
    }

    public NativeOutItem(String tts, String with)
    {
	myDevice_ = OutputDevices.Type.NATIVE;
	isInstant_ = true;
	text_ = tts;
	gs_ = null;
	with_ = with;
    }

    public void doOutput(OutputDevices od)     // ºݤ˽
    {
	String str = null;
	if (eval_) {
	    String script;
	    if ( with_.length() > 0 ) {
		script = "with(" + with_ + "){" + text_ + "}";
	    } else {
		script = text_;
	    }
	    str = ECMAScript.doEvaluate(script);
	} else {
	    str = text_;
	}

	arg_ = str;
	OutputDevice d = od.getDevice(myDevice_);
	d.outputDeviceStart(this);
    }

    public String toString()
    {
	String s = "<native";
	if ( eval_ == true && with_.length() > 0 ) {
	    s += " with=\"" + with_ + "\"";
	}
	s += ">";
	if ( eval_ == true ) {
	    s += text_;
	} else {
	    s += "'" + text_ + "'";
	}
	s += "</native>";
	return s;
    }
    
    private boolean eval_ = true; // false;  // ͤ ECMAScript Ȥ eval 뤫

    /*
    public void setEval(boolean b)
    {
	eval_ = b;
    }

    public boolean getEval()
    {
	return eval_;
    }
    */

}
