/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: BreakOutItem.java,v 1.5 2003/07/25 09:56:34 nishi Exp $
 */

package outitem;

import main.*;
import relaxer.pdoc.*;
import scripting.ECMAScript;

public class BreakOutItem extends OutItem
{
    String script_ = "";

    public BreakOutItem(double msec)
    {
	this(msec, true);
    }

    private String _double2script(double sec)
    {
	return "'" + Double.toString(sec) + "'";
    }

    public BreakOutItem(double msec, boolean bargein)
    {
	myDevice_ = OutputDevices.Type.BREAK;
	isInstant_ = false;
	script_ = _double2script(msec);
	bargein_ = bargein;
    }

    public BreakOutItem(PdocBreak pb)
    {
	myDevice_ = OutputDevices.Type.BREAK;
	isInstant_ = false;

	bargein_ = pb.getBargein();

	String content = pb.getContent();
	if ( content == null ) {
	    script_ = _double2script(pb.getLength());
	} else {
	    script_ = content;
	}
    }

    public BreakOutItem(String script, boolean bargein)
    {
	myDevice_ = OutputDevices.Type.BREAK;
	isInstant_ = false;
	bargein_ = bargein;
	script_ = script;
    }

    public double getArgAsDouble() 
    { 
	String str = ECMAScript.doEvaluate(script_);
	if ( str.equals("undefined") ) {
	    return 5.0;
	}
	double sec = Double.parseDouble(str) / 1000.0;
	return sec; 
    }

    public void doOutput(OutputDevices od)
    {

	OutputDevice d = od.getDevice(myDevice_);
	d.outputDeviceStart(this);

    }

    public String toString()
    {
	String s = "<break";
	if ( bargein_ == false ) {
	    s += " bargein=\"false\"";
	}
	s += ">";
	s += script_;
	s += "</break>";
	return s;
    }
    
}
