/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: AudioOutItem.java,v 1.4 2003/07/25 09:56:34 nishi Exp $
 */

package outitem;

import main.*;

public class AudioOutItem extends OutItem
{

    private String src_;

    public String getArg() { 
	return scripting.ECMAScript.doEvaluate(src_); 
    }

    public AudioOutItem(String src, boolean bargein)
    {

	myDevice_ = OutputDevices.Type.AUDIO;
	isInstant_ = false;
	src_ = src;
	bargein_ = bargein;

    }

    public AudioOutItem(String src)
    {
	myDevice_ = OutputDevices.Type.AUDIO;
	isInstant_ = false;
	src_ = src;
	gs_ = null;
    }

    public void doOutput(OutputDevices od)
    {
	OutputDevice d = od.getDevice(myDevice_);
	d.outputDeviceStart(this);
    }

    public String toString()
    {
	String s = "<audio";
	if ( bargein_ == false ) {
	    s += " bargein=\"false\"";
	}
	s += ">";
	s += src_;
	s += "</audio>";
	return s;
    }
}
