/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: StateMap.java,v 1.8 2003/08/20 11:30:25 nishi Exp $
 */

package main;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xpath.*;
import java.util.*;
import command.*;
import outitem.*;
import util.*;

public class StateMap
{
    public static final String PDOC_ENCODING = "euc-jp";
    private static float PDOC_VERSION = 0.6f;

    private Debug dbg = new Debug("StateMap");

    private float pdocVersion_ = 0.0f;

    public void setPdocVersion(float f)
    {
	pdocVersion_ = f;
    }

    // Map<String, ContentState>
    private HashMap hashMap_ = null; 

    private String firstStateName_ = null;

    // array to keep the order of put
    private Vector states_ = null;

    // document-wide grammar set
    private GrammarSet grammarSet_ = null;

    public StateMap()
    {
	hashMap_ = new HashMap();
	states_ = new Vector();

	setPdocVersion( PDOC_VERSION );

	//Document doc;
	//Node n1 = XPathAPI.selectSingleNode(doc, "/hoge/text()");
    }

    /**
     * if fails, returns null
     */
    public ContentState put(String key, ContentState value)
    {
	states_.add((Object)key);
	ContentState ret = (ContentState)hashMap_.put((Object)key, (Object)value);
	dbg.ASSERT(ret==null, "put with no override");
	return ret;
    }

    public ContentState get(String key)
    {
	dbg.print("using StateMap.get(" + key + ")" );
	ContentState cs = (ContentState)hashMap_.get((Object)key);
	/*
	if (cs == null) {
	    dbg.DIE("StateMap.get(" + key + ") not found !" );
	}
	*/
	return cs;
    }

    public boolean has(String key)
    {
	ContentState cs = (ContentState)hashMap_.get((Object)key);
	if (cs == null) {
	    return false;
	}
	return true;
    }

    public String newState(String id) 
    {
	ContentState state;
	String newID = id;
	state = (ContentState)hashMap_.get((Object)newID);
	if ( state != null )
	    return id;
	/*
	while ( state != null ) {
	    newID += "_";
	    state = (ContentState)hashMap_.get((Object)newID);
	}
	*/
	dbg.ASSERT( state == null, "newState()");
	state = new ContentState();
	state.setName(newID);
	state.setExecOnly(false);
	dbg.print( "newState:" + newID );
	put(newID, state);

	return newID;
    }
    
    public void addCommand(String id, Command c)
    {
	ContentState state = get(id);
	if ( state == null ) {
	    String newID = newState(id);
	    state = get(newID);
	    dbg.ASSERT(id.equals(newID), "addCommand()");
	}
	dbg.ASSERT(state != null, "addCommand()");
	if (c != null) {
	    if ( c instanceof CompositeCommand && ! c.hasCondition() ) {
		Vector commands = ((CompositeCommand)c).getCommands();
		for ( int i = 0; i < commands.size(); i++ ) {
		    state.addCommand((Command)commands.get(i));
		}
	    } else {
		state.addCommand(c);
	    }
	}
    }

    public void addCommand(String id, Vector commands)
    {
	ContentState state = get(id);
	dbg.ASSERT(state != null, "addCommand()");
	if (commands != null) {
	    for ( int i = 0; i < commands.size(); i++ ) {
		addCommand(id, (Command)commands.get(i));
	    }
	}
    }

    public void addCommandOnTop(String id, Command c)
    {
	ContentState state = get(id);
	dbg.ASSERT(state != null, "addCommandOnTop()");
	state.addCommandOnTop(c);
    }

    public void addScriptCommand(String id, String script)
    {
	addCommand(id, new EvaluateCommand(script));
    }

    public void addScriptCommand(String id, String script, String with)
    {
	addCommand(id, new EvaluateCommand(script, with));
    }

    public void addTrans(String src, String dst, String input) 
    {
	dbg.print( "addTrans: " + src + ", " + dst + ", " + input );
	ContentState state = get(src);
	dbg.ASSERT(state != null, "addTrans()");
	state.putEventHandler(input, dst);
    }

    public void addNomatch(String src, String dst) 
    {
	addTrans(src, dst, "<nomatch>");
    }

    public void setNext(String id, String dst)
    {
	addCommand(id, new SetNextCommand("'"+dst+"'"));
    }

    public void setFirstStateName(String name)
    {
	firstStateName_ = name;
    }

    public String getFirstStateName()
    {
	return firstStateName_;
    }

    public ContentState getFirstState()
    {
	return (ContentState)(hashMap_.get(firstStateName_));
    }
    
    public void add(ContentState state) {
	put(state.getName(), state);
    }

    public GrammarSet getGrammarSet()
    {
	return grammarSet_;
    }
    
    public void setGrammarSet(GrammarSet g)
    {
	grammarSet_ = g;
    }
    
    public String toString()
    {
	StringBuffer s = new StringBuffer();
	s.append("<?xml version=\"1.0\" encoding=\"" );
	s.append(PDOC_ENCODING);
	s.append("\" ?>\n");
	s.append("<pdoc version=\"");
	s.append(pdocVersion_);
	s.append("\">\n");

	s.append("<head>\n");
	if ( grammarSet_ != null ) {
	    s.append(grammarSet_.getRulesAsString());
	    s.append("\n");
	    s.append("<!--\n");
	    s.append(grammarSet_.getSRMGramStr());
	    s.append("\n");
	    s.append("-->\n");
	}
	s.append("</head>\n\n");

	s.append("<body start=\"");
	s.append(firstStateName_);
	s.append("\">\n");
	
	for ( int i = 0; i < states_.size(); i++ ) {
	    String keyname = (String)states_.get(i);
	    ContentState state = (ContentState)hashMap_.get((Object)keyname);
	    s.append(state.toString());
	    s.append("\n");
	}
	s.append("</body>\n");
	s.append("</pdoc>\n");
	return s.toString();
    }

}
