/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: OutputDevices.java,v 1.2 2003/07/25 09:56:34 nishi Exp $
 */

package main;

public class OutputDevices
{

    private final int N_DEVS = 6;

    private OutputDevice[] oda_;

    public static class Type
    {

	private int typenum_;
	private String type_;

	public static final OutputDevices.Type AUDIO
	    = new OutputDevices.Type("OutputDevices.Type.AUDIO", 0);
	public static final OutputDevices.Type VOICE
	    = new OutputDevices.Type("OutputDevices.Type.VOICE", 1);
	public static final OutputDevices.Type BREAK
	    = new OutputDevices.Type("OutputDevices.Type.BREAK", 2);
	public static final OutputDevices.Type IMAGE
	    = new OutputDevices.Type("OutputDevices.Type.IMAGE", 3);
	public static final OutputDevices.Type LOG
	    = new OutputDevices.Type("OutputDevices.Type.LOG", 4);
	public static final OutputDevices.Type NATIVE
	    = new OutputDevices.Type("OutputDevices.Type.NATIVE", 5);

	// TypeɲäN_DEVS䤹

	protected Type(String type, int typenum)
	{
	    type_ = type;
	    typenum_ = typenum;
	}

	protected int getNum()
	{
	    return typenum_;
	}

	public String toString()
	{
	    return type_;
	}

    }

    public OutputDevices()
    {

	oda_ = new OutputDevice[N_DEVS];

    }

    public void addDevice(OutputDevice od, OutputDevices.Type type)
    {

	oda_[type.getNum()] = od;

    }

    public OutputDevice getDevice(OutputDevices.Type type)
    {

	return(oda_[type.getNum()]);

    }

    public void terminate(OutputDevices.Type type)
    {

	oda_[type.getNum()].terminate();

    }

}
