/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: InterpreterContextManager.java,v 1.4 2003/07/25 09:56:34 nishi Exp $
 */

package main;

import java.util.*;
import java.io.File;
import java.net.URL;
import util.*;
import command.*;

public class InterpreterContextManager
{

    private Debug dbg = new Debug("ICM", 0);
    private StateMap stateMap_;
    private ContentState currState_;
    private String initialUrl_;
    private String nextStateName_ = null; // <setnext> command

    public GrammarSet getGrammarSet()
    {
	dbg.ASSERT(stateMap_ != null, "InterpreterContextManager.getGrammarSet()");
	return stateMap_.getGrammarSet();
    }

    // :ǽ˳ե̾
    public InterpreterContextManager(String fn) throws Exception 
    {
	if(fn.startsWith("http://")) {
	    initialUrl_ = fn;
	}
	else {
	    //newDocument(new File(fn), fn);
	    newDocument(fn, fn);
	}
    }

    public void newDocument(String fn, String path) throws Exception
    {
	DocLoader doc = new DocLoader(fn, path);
	stateMap_ = doc.getStateMap();
	currState_ = stateMap_.getFirstState();
	if ( currState_ == null ) {
	    dbg.print("newDocument: no __first__ state.");
	}
	nextStateName_ = null;
    }

    public InterpreterContextManager() { }

    public void setDocument(DocLoader doc)
    {
	stateMap_ = doc.getStateMap();
	currState_ = stateMap_.getFirstState();
	if ( currState_ == null ) {
	    dbg.print("newDocument: no __first__ state.");
	}
	nextStateName_ = null;
    }

    public synchronized void inputText(String str)
    {
	//String next = (String)currState_.getEventHandler(str);
	String next = (String)currState_.findEventHandler(str);
	dbg.print("ICM: inputText next= "+ next);
	if (next == null) {
	    next = (String)currState_.getEventHandler("<nomatch>");
	    if (next == null) {
		dbg.print("<nomatch> not found in state="+currState_);
		return;
	    }
	}

	currState_ = stateMap_.get(next);
	if (currState_ == null) {
	    Util.halt("Bad destination: "+next);
	}
	dbg.print("inputText: next="+next+" currState="+currState_);
	nextStateName_ = null;
    }

    public synchronized void noinput()
    {
	dbg.print("<noinput> invoked.");
	String next;
	if (nextStateName_ != null) {
	    next = nextStateName_;
	    dbg.print("ICM: <setnext> nextStateName=" + next);
	    /*
	    if (nextStateName_.equals(currState_.getName())) {
		next = nextStateName_;
		dbg.print("ICM: <setnext> nextStateName=" + next);
	    } else {
		// Ϥ <next> ϥɥ򻲾Ȥ
		next = (String)currState_.getEventHandler("<next>");
		dbg.print("ICM: <next>evh nextStateName=" + next);
	    }
	    */
	} else {
	    /*
	    next = (String)currState_.getEventHandler("<noinput>");
	    if (next != null) {
		dbg.print("ICM: (using <noinput>) next=" + next);
	    } else {
		next = (String)currState_.getEventHandler("<next>");
		dbg.print("ICM: <next> next=" + next);
	    }
	    */
	    next = (String)currState_.getEventHandler("<next>");
	    dbg.print("ICM: <next>evh nextStateName=" + next);
	}
	
	//dbg.ASSERT( next != null, "ICM: next not found");
	if (next==null) {
	    dbg.print("ICM: next not found.. continue..");
	    return;
	}
	currState_ = stateMap_.get(next);
	if (currState_ == null) {
	    Util.halt("Bad destination: "+next);
	}

	dbg.print("ICM: STATE-CHANGE: "+next );

	dbg.ASSERT( currState_ != null, "ICM: state not found");
	nextStateName_ = null;
    }

    public synchronized Vector getCmd()
    {

	Vector cmdvec = new Vector();  // Vector<Command>
	boolean ready = false;

	if(initialUrl_ != null) {

	    try{
		cmdvec.add(new HttpGetCommand(new URL(initialUrl_)));
	    }
	    catch(Exception e) {
		e.printStackTrace();
	    }
	    finally {
		initialUrl_ = null;
	    }
	    return cmdvec;

	}

	while(!ready) {

	    dbg.print("getCmd: currState="+currState_);
	    if ( currState_ == null )
		return cmdvec;

	    cmdvec.addAll(currState_.getCommands());

	    if(currState_.isExecOnly()) {
		String next;
		next = (String)currState_.getEventHandler("<next>");
		dbg.print("getCmd: next="+next);
		if(next == null) {
		    //cmdvec.add(new EndCommand(false));
		    ready = true;
		}
		else {
		    // ƱɥȤǤΰưΤߡ
		    dbg.print("stateMap_:" + stateMap_);
		    currState_ = stateMap_.get(next);
		    nextStateName_ = null;
		    dbg.print("setting CurrState_ to:" + currState_);
		    ready = false;
		}
	    }
	    else {
		ready = true;
	    }

	}

	dbg.print("ICM: " + currState_.getName() + " has " + cmdvec.size()+" commands.");

	return cmdvec;

    }

    // <noinput> <next> ϥɥ餬ʤܤ֤
    public synchronized void setNextState(String state)
    {
	dbg.print("ICM: setnext="+state);
	nextStateName_ = state;
    }

}
