/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: VXMLDoc.java,v 1.21 2003/08/18 06:53:22 nishi Exp $
 */

package document;

import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.util.*;
import java.net.*;
import relaxer.vxml20.*;
import scripting.*;
import util.*;
import main.*;
import command.*;
import outitem.*;


public class VXMLDoc implements AbstractDoc // VoiceXML
{
    private static double promptTimeout_ = 10.0;
    private static double startupWait_ = 10.0;

    private Debug dbg = new Debug("VXMLDoc");
    private String docAddress_ = null;
    private GrammarSet grammarSet_ = null;
    private VxmlVxml vxml_ = null;
    private StateMap stateMap_ = null;

    private Vector docErrors_ = null;
    private Vector docWarnings_ = null;

    private int unique_ = 0;

    private String _getEvalWith(String s, String w) {
	if (s == null) 
	    return "true";
	if ( w.length() > 0 ) {
	    // "with(" + w + "){" + s + "}"
	    StringBuffer script = new StringBuffer("with(");
	    script.append(w);
	    script.append("){");
	    script.append(s);
	    script.append("}");
	    return script.toString();
	} 
	return s;
    }


    // in: "1s"   out:1000
    // in: "50ms" out:50
    private String _getCSS2TimesAsMsec(String in) {
	String ret = in;
	if (in.endsWith("ms")) {
	    String num = in.substring(0,in.length()-2);
	    int n = Float.valueOf(num).intValue();
	    ret = Integer.toString(n);
	} else if (in.endsWith("s")) {
	    String num = in.substring(0,in.length()-1);
	    float d = Float.valueOf(num).floatValue();
	    int n = new Float(d * 1000.0).intValue();
	    ret = Integer.toString(n);
	}
	return ret;
    }


    private String _getUniqueId()
    {
	unique_++;
	StringBuffer id = new StringBuffer("$").append(unique_);
	return id.toString();
    }

    public String getDocAddress()
    {
	return docAddress_;
    }

    public void setDocAddress(String adrs)
    {
	docAddress_ = adrs;
    }

    /**
     * ɥpathpathѴ
     */
    public String resolveAdrs(String org)
    {
	return Util.resolveAdrs(docAddress_, org);
    }


    /**
     * ʬƱե fragment Ǥ true ֤
     */
    public boolean isInsideDoc(String f)
    {
	return Util.isSameFile(docAddress_, f);
    }


    public String getDialogID(String f)
    {
	String dlg = "__default__";
	try {
	    URI u = new URI(f);
	    dlg = u.getFragment();
	} catch (Exception e) {}
	return dlg;
    }


    /**
     * @return άγ dialog ID  or null
     * document order Ƭ form ޤ menu 
     */
    private String getFirstDialogID()
    {
	String firstId = null;
	dbg.print( "vxml_:" + vxml_ );
	int nContent = vxml_.sizeContent();
	dbg.print( "nContent:" + nContent,2);
	for ( int i = 0; i < nContent; i++ ) {
	    IVxmlVxmlChoice choice = vxml_.getContent(i);
	    if ( choice instanceof VxmlForm ) {
		VxmlForm o = (VxmlForm)choice;
		firstId = o.getId();
		if ( firstId == null ) {
		    o.setId("__first_dialog__");
		    firstId = o.getId();
		}
		else if ( firstId.equals("") ) {
		    o.setId("__first_dialog__");
		    firstId = o.getId();
		}
		dbg.print("firstId:" + firstId);
		break;
	    } 
	    else if ( choice instanceof VxmlMenu ) {
		VxmlMenu o = (VxmlMenu)choice;
		firstId = o.getId();
		if ( firstId == null ) {
		    o.setId("__first_dialog__");
		    firstId = o.getId();
		}
		else if ( firstId.equals("") ) {
		    o.setId("__first_dialog__");
		    firstId = o.getId();
		}
		dbg.print("firstId:" + firstId);
		break;
	    } 
	}
	return firstId;
    }


    private String getText(IVxmlChoiceMixed cm)
    {
	String text = "";
	if ( cm instanceof RString ) {
	    // <choice>coffee</choice>
	    RString rs = (RString)cm;
	    text = Util.removeSpaces(rs.getText());
	} else if ( cm instanceof GramGrammar ) {
	    // <choice><rule><token>coffee</token></rule></choice>
	    GramGrammar gram = (GramGrammar) cm;
	    for ( int j = 0; j < gram.sizeContent(); j++ ) {
		IGramGrammarChoice gc = gram.getContent(j);
		if ( gc instanceof GramRule ) {
		    GramRule rule = (GramRule) gc;
		    for ( int k = 0; k < rule.sizeContent(); k++ ) {
			IGramRuleMixed rm = rule.getContent(k);
			if ( rm instanceof GramToken ) {
			    GramToken gt = (GramToken)rm;
			    text = Util.removeSpaces(gt.getContent());
			}
		    }
		}
	    }
	}
	return text;
    }


    private void _addJulianGrammarToGS( GrammarSet gs, GramGrammar gram ) throws Exception
    {
	String src = gram.getSrc();
	String julianGramName = null;

	if ( src != null ) {
	    julianGramName = src;
	} else {
	    julianGramName = System.getProperty("GrammarName");
	}
	
	gs.setJulian(true);
	gs.setJulianGramName(julianGramName);
    }


    private void _addGrammarToGS( GrammarSet gs, GramGrammar gram ) throws Exception
    {
	String type = gram.getType();
	
	if ( type == null ) {
	    type = "application/srgs+xml";
	}
		
	if ( type.equals("application/julian") || type.equals("julian") ) {
	    _addJulianGrammarToGS(gs, gram);
	} else {

	    dbg.ASSERT(type.equals("application/srgs+xml"), "grammar type error");
		    
	    GramGrammar gramXml = null;
	    String gramAdrs = null;
	    String src = gram.getSrc();
		    
	    if ( src == null ) {
		gramXml = gram;
		gramAdrs = docAddress_;
			
	    } else {
		gramAdrs = Util.resolveAdrs(docAddress_, src);
			
		// TODO:
		// httpξϥɤ tmp filename  set 
		// 뤤ϡɤԤ־֤
		gramXml = new GramGrammar(gramAdrs);
	    }
	    
	    GrammarUtil.makePhonemeFromSym(gramXml);
	    gs.setJulian(false);
	    gs.addRules(gramXml, gramAdrs);
	}
    }


    /**
     * Visitor: <vxml> contents
     */
    protected class Visitor extends relaxer.vxml20.RVisitorBase 
    {
	// ֤줿ƥȡʥסˤݻ
	protected class Dialog
	{
	    // for adding executable contents
	    private String currFormName_ = null;   // weather

	    public void setName(String s) {
		currFormName_ = s;		
	    }
	    public String getName() {
		return currFormName_;
	    }

	    // FormItem

	    private String currFormItemName_ = null;   // place

	    public void setItemName(String s) {
		currFormItemName_ = s;		
	    }
	    public String getItemName() {
		return currFormItemName_;
	    }

	}

	private Dialog dialog_ = new Dialog();
	private HashArray formItems_ = null;
	private String formVarInitScript_ = null; // var νޥ

	// object tree
	private Stack visitorStack_ = new Stack(); // VxmlXXX Object

	// prompt selection

	protected class Prompt {
	    public int count = 1;
	    public String cond = null;
	    public Vector commands = null;
	}

	private Vector promptList_ = null; // Vector of Prompt

	// commands

	protected class Commands
	{
	    private Vector cmdvec_ = null;

	    public void setupCommands() {
		if ( cmdvec_ == null ) {
		    cmdvec_ = new Vector();
		}
	    }
	    
	    public void appendCommands( Command c ) {
		dbg.print("appendCommands:" + c.toString() );
		if ( cmdvec_ != null ) {
		    cmdvec_.add(c);
		}
	    }
	    
	    public void flushCommands( String s ) {
		if ( cmdvec_ != null && cmdvec_.size() > 0 ) {
		    stateMap_.addCommand(s, cmdvec_);
		    cmdvec_ = null;
		}
	    }

	    public Vector getCommands() {
		return cmdvec_;
	    }

	    // äȤ (prompt)
	    public void setCommands(Vector v) {
		cmdvec_ = v;
	    }

	    public void clearCommands() {
		cmdvec_ = null;
	    }
	}

	Commands commands_ = new Commands();

	// executable content

	protected class ExecContents
	{
	    private Stack execContentsStack_ = new Stack();
	    private int stackCount_ = 0;

	    private void setupExecContent(String cond) {
		stackCount_++;
		dbg.print("setupExecContent: "+ stackCount_ + " " + cond);
		// create context
		Vector c = new Vector();
		CompositeCommand co = new CompositeCommand(c, cond);
		
		// save context
		execContentsStack_.push((Object)co);
	    }
	    
	    private void setupExecContent() {
		setupExecContent("true");
	    }
	    
	    private void appendExecContent(Command c) {
		dbg.print("appendExecContent: "+ stackCount_ + " " + c);
		if ( ! execContentsStack_.empty() ) {
		    CompositeCommand co = (CompositeCommand)execContentsStack_.peek();
		    if ( co != null )
			co.getCommands().add(c);
		}
	    }

	    private void flushExecContent() {
		dbg.print("flushExecContent: " + stackCount_);
		stackCount_--;
		if ( ! execContentsStack_.empty() ) {
		    CompositeCommand co = (CompositeCommand)execContentsStack_.pop();
		    //if ( co != null )
		    // commands_.appendCommands(co);
		    if ( execContentsStack_.empty() ) {
			commands_.appendCommands(co);
		    } else {
			CompositeCommand c = (CompositeCommand)execContentsStack_.peek();
			c.getCommands().add(co);
		    }
		}
	    }
	}

	ExecContents execContents_ = new ExecContents();

	// for speak buffer / log buffer / native command buffer

	protected class TextBuf
	{
	    private class BaseText
	    {
		private StringBuffer text_ = null;

		public void resetText() { 
		    text_ = new StringBuffer();
		}

		public StringBuffer getText() { 
		    if (text_ == null) {
			text_ = new StringBuffer("");
		    }
		    return text_; 
		}

		public void setText( StringBuffer text ) { 
		    text_ = text;
		}

		public void appendString(String text) {
		    dbg.ASSERT(context_ != null, "context_ null error");
		    StringBuffer sb = context_.getText();
		    if ( sb != null && text != null && text.length() > 0 ) {
			if ( sb.length() > 0 ) {
			    sb.append("+");
			}
			sb.append("'");
			sb.append(text);
			sb.append("'");
			context_.setText(sb);
		    }
		}

		public void appendValue(String expr) {
		    dbg.ASSERT(context_ != null, "context_ null error");
		    StringBuffer sb = context_.getText();
		    if ( sb != null && expr != null && expr.length() > 0 ) {
			if ( sb.length() > 0 ) {
			    sb.append("+");
			}
			sb.append(expr);
			context_.setText(sb);
		    }
		}

	    }

	    private class SpeakText extends BaseText 
	    {
		public void appendString(String text) {
		    String s = Util.xmlSafeRemoveSpaces(text);
		    super.appendString(s);
		}
	    }

	    private class LogText extends BaseText 
	    {
		public void appendString(String text) {
		    String s = Util.removeNewLines(text);
		    super.appendString(s);
		}
	    }

	    private class NativeText extends BaseText
	    {
	    }

	    private BaseText speakText_  = new SpeakText();
	    private BaseText logText_    = new LogText();
	    private BaseText nativeText_ = new NativeText();

	    private BaseText context_ = speakText_;

	    public void appendString(String text) {
		context_.appendString(text);
	    }

	    public void appendValue(String expr) {
		context_.appendValue(expr);
	    }

	    public void setupSpeak() {
		context_ = speakText_;
		context_.resetText();
	    }
	    
	    public void flushSpeak() {
		dbg.ASSERT(context_ instanceof SpeakText, "error");
		StringBuffer sb = context_.getText();
		if ( sb != null ) {
		    String text = new String(sb).trim();
		    if (text.length() > 0) {
			VoiceOutItem item = new VoiceOutItem
			    (text, dialog_.getName(), currPromptBargein_);
			//item.setEval(true);
			Command c = new AddOutItemCommand(item);
			execContents_.appendExecContent(c);
		    }
		    context_.resetText();
		}
	    }

	    public void setupLog() {
		context_ = logText_;
		context_.resetText();
	    }
	    
	    public void flushLog() {
		dbg.ASSERT(context_ instanceof LogText, "error flushLog()");
		StringBuffer log = context_.getText();
		if ( log  != null ) {
		    String text = new String(log).trim();
		    if (text.length() > 0) {
			LogOutItem item = new LogOutItem(text, dialog_.getName());
			//item.setEval(true);
			Command c = new AddOutItemCommand(item);
			execContents_.appendExecContent(c);
		    }
		    context_.resetText();
		}
		context_ = speakText_;
	    }

	    public void setupNative() {
		context_ = nativeText_;
		context_.resetText();
	    }
	    
	    public void flushNative() {
		dbg.ASSERT(context_ instanceof NativeText, "error flushNative()");
		StringBuffer sb = context_.getText();
		if ( sb != null ) {
		    String text = new String(sb).trim();
		    if (text.length() > 0) {
			NativeOutItem item = new NativeOutItem(text, dialog_.getName());
			//item.setEval(true);
			Command c = new AddOutItemCommand(item);
			execContents_.appendExecContent(c);
		    }
		    context_.resetText();
		}
		context_ = speakText_;
	    }

	}

	TextBuf textBuf_ = new TextBuf();

	// vxml

	public boolean enter(VxmlVxml v) {
	    visitorStack_.push(v);
	    return true;
	}

	public void leave(VxmlVxml v) {
	    visitorStack_.pop();
	}


	private void _grammarProcState(String text) {
	    // create new state
	    // <state id="@weather.when.g3" next="@weather.@process">
	    // <script>weather.when = 'today';</script>
	    // <script>weather.when$.justfilled = true;</script>
	    // </state>

	    String formitem = dialog_.getName() + "." + dialog_.getItemName(); // weather.place
	    String filled = "@" + dialog_.getName() + ".@process"; // @weather.@process
	    String s = "@" + formitem + "." + _getUniqueId(); // @weather.place.s1??
	    String newID = stateMap_.newState(s);   // @weather.place.s1

	    stateMap_.addTrans("@" + formitem, newID, text); // @weather.place -> @weather.place.s1
	    stateMap_.addCommand(newID, new EvaluateCommand
		(formitem + "='" + text + "';\n")); // weather.place = 'today';
	    stateMap_.addCommand(newID, new EvaluateCommand
		(formitem + "$.justfilled = true;\n")); // weather.place$.justfilled = true;
	    stateMap_.setNext(newID, filled); // @weather.place.s1 -> @weather.@process

	}

	
	// grammar
	// TODO: פιθ
	// TODO: ruleľtokenΤߤƤ
	
	public boolean enter(GramGrammar gram) {
	    // Object parent = stack_.peek();
	    // parent may instanceof VxmlVxml/VxmlChoice/VxmlForm/VxmlField

	    // non-standard, but supported: <vxml> <grammar/> </vxml>
	    // <grammar type="application/srgs+xml" src="xxx.grxml" /> (default)
	    // <grammar type="application/julian"   src="xxx" />
	    try {
		_addGrammarToGS(grammarSet_, gram);
	    } catch (Exception e) { e.printStackTrace(); }

	    if (visitorStack_.peek() instanceof VxmlField) {
		for ( int k = 0; k < gram.sizeContent(); k++ ) {
		    IGramGrammarChoice gc = gram.getContent(k);
		    if ( gc instanceof GramRule ) {
			GramRule rule = (GramRule) gc;
			for ( int l = 0; l < rule.sizeContent(); l++ ) {
			    IGramRuleMixed rm = rule.getContent(l);
			    if ( rm instanceof GramToken ) {
				GramToken gt = (GramToken)rm;
				String text = Util.removeSpaces(gt.getContent());
				_grammarProcState(text);
			    }
			}
		    }
		}
	    }

	    return(true);
	}

	// form

	private String _makeFormState() {
	    /*
	      <script>
	      weather = new Object();
	      weather.next$ = undefined;
	      </script>
	    */

	    // [@weather]
	    String form = "@" + dialog_.getName();
	    String t = stateMap_.newState(form);
	    dbg.ASSERT(t.equals(form), "VxmlForm#leave");

	    String sc;
	    sc = dialog_.getName() + " = new Object();\n";
	    sc += dialog_.getName() + ".next$ = undefined;\n";
	    sc += formVarInitScript_;
	    stateMap_.addCommand(form, new EvaluateCommand(sc));
	    
	    /*
	      <script>
	      weather.initial1 = undefined;
	      weather.initial1$ = new Object();
	      weather.initial1$.promptcount = 1;

	      weather.place  = undefined;
	      weather.place$ = new Object();
	      weather.place$.promptcount = 1;
	      weather.place$.justfilled = false;

	      weather.when   = undefined;
	      weather.when$ = new Object();
	      weather.when$.promptcount = 1;
	      weather.when$.justfilled = false;

	      weather.block2 = undefined;
	      </script>
	    */

	    for ( int i = 0; i < formItems_.size(); i++ ) {
		String name = formItems_.getKey(i);
		sc = dialog_.getName() + "." + name + " = undefined;\n";
		stateMap_.addScriptCommand(form, sc);

		Object fi = formItems_.get(i);
		String shadow = dialog_.getName() + "." + name + "$";
		if ( fi instanceof VxmlField ) {
		    sc  = shadow + " = new Object();\n";
		    sc += shadow + ".promptcount = 1;\n";
		    sc += shadow + ".justfilled = false;\n";
		    sc += shadow + ".noprompt = false;\n";
		    stateMap_.addScriptCommand(form, sc);
		}
	    }

	    return form;
	}

	private String _makeFormSelectState() {
	    // @weather.@select
	    String select = "@" + dialog_.getName() + ".@select";
	    String t = stateMap_.newState(select);
	    dbg.ASSERT(t.equals(select), "VxmlForm#leave");

	    /*
	    <script>
	    if (weather.next$ == undefined) {
	     if (weather.initial1 == undefined) {
	      weather.next$ = "@weather.initial1";
	     } elseif (weather.place == undefined) {
	      weather.next$ = "@weather.place";
	     } elseif (weather.when == undefined) {
	      weather.next$ = "@weather.when";
	     } elseif (weather.block2 == undefined) {
	      weather.next$ = "@weather.block2";
	     }
	    }
	    </script>
	    <script>weather.place$.justfilled = false;</script>
	    <script>weather.when$.justfilled = false;</script>
	    */

	    String sc = ""; 

	    for ( int i = 0; i < formItems_.size(); i++ ) {
		String name = formItems_.getKey(i);
		if ( i > 0 ) {
		    sc += "} else ";
		}
		sc += "if (" + dialog_.getName() + "." + name + " == undefined) {\n";
		sc += dialog_.getName() + ".next$ = '@" + dialog_.getName() + "." + name + "';\n";
	    }
	    sc +="}\n"; 


	    stateMap_.addCommand(select, new EvaluateCommand(sc));

	    for ( int i = 0; i < formItems_.size(); i++ ) {
		String name = formItems_.getKey(i);
		Object fi = formItems_.get(i);
		if ( fi instanceof VxmlField ) {
		    sc = dialog_.getName() + "." + name + "$.justfilled = false;";
		    stateMap_.addCommand(select, new EvaluateCommand(sc));
		}
	    }

	    // shadowѿͤɾξ̾Ȥ
	    sc = dialog_.getName() + ".next$";
	    stateMap_.addCommand(select, new SetNextCommand(sc));

	    return select;
	}

	private String _makeFormFilledState() {
	    // @weather.@process
	    String filled = "@" + dialog_.getName() + ".@process";
	    String t = stateMap_.newState(filled);
	    dbg.ASSERT(t.equals(filled), "VxmlForm#leave");
	    return filled;
	}


	public boolean enter(VxmlForm vxmlForm) {
	    dialog_.setName(vxmlForm.getId());

	    formItems_ = new HashArray();
	    formVarInitScript_ = "";

	    visitorStack_.push(vxmlForm);
	    return(true);
	}

	public void leave(VxmlForm o) {
	    String form = _makeFormState();
	    String select = _makeFormSelectState();
	    String filled = _makeFormFilledState();

	    stateMap_.setNext(form, select);
	    stateMap_.setNext(filled, select);

	    // test
	    // stateMap_.setNext(select, "@weather.place");

	    visitorStack_.pop(); 
	}

	// block
	//<state id="@weather.block1" next="@weather.@select">
	//<script>weather.block1 = true;</script>
	//<add><voice with="weather">'ŷ󥵡ӥؤ褦'</voice></add>
	//</state>

	public boolean enter(VxmlBlock vxmlBlock) {
	    if ( vxmlBlock.getName() == null ) {
		dialog_.setItemName(_getUniqueId()); // s1
	    } else {
		dialog_.setItemName(vxmlBlock.getName());
	    }

	    String s = "@" + dialog_.getName() + "." + dialog_.getItemName();
	    String t = stateMap_.newState(s);
	    // @weather.s1
	    dbg.ASSERT(t.equals(s), "VxmlBlock#enter");

	    stateMap_.addCommand(s, new EvaluateCommand
		(dialog_.getName() + "." + dialog_.getItemName() + "= true;\n"));

	    visitorStack_.push(vxmlBlock);
	    formItems_.put(dialog_.getItemName(), (Object)vxmlBlock);

	    commands_.setupCommands();
	    execContents_.setupExecContent();
	    textBuf_.setupSpeak();
	    return true;
	}

	public void leave(VxmlBlock vxmlBlock) {
	    textBuf_.flushSpeak();
	    execContents_.flushExecContent();

	    String s = "@" + dialog_.getName() + "." + dialog_.getItemName();
	    commands_.flushCommands(s);
	    stateMap_.setNext(s, "@" + dialog_.getName() + ".@select");

	    visitorStack_.pop(); 
	}


	// <filled>
	public boolean enter(VxmlFilled e) {
	    String cond = "true";
	    dbg.print("VXMLDoc:enter#VxmlFilled peek:" + visitorStack_.peek());
	    commands_.setupCommands();

	    if (visitorStack_.peek() instanceof VxmlField) {
		String sWith = dialog_.getName() + "." + dialog_.getItemName() + "$";
		cond = sWith + ".justfilled";
	    } else {
		// <filled> ٤Ƥ FormItem θ˽и뤳Ȥ
		// with(form){item1 != undefined && item2 != undefined}
		cond = "with("+dialog_.getName()+"){";
		for ( int i = 0; i < formItems_.size(); i++ ) {
		    String name = formItems_.getKey(i);
		    if ( i > 0 ) {
			cond += " && ";
		    }
		    cond += name +"!=undefined";
		}
		cond += "}";
	    }
	    execContents_.setupExecContent(cond);

	    textBuf_.setupSpeak();
	    visitorStack_.push(e);
	    return true;
	}

	public void leave(VxmlFilled e) {
	    // [@weather.@process]
	    visitorStack_.pop(); 
	    textBuf_.flushSpeak();

	    execContents_.flushExecContent();

	    String filled = "@" + dialog_.getName() + ".@process"; 
	    commands_.flushCommands(filled); 
	}


	// <field>

	private void _makeInputEventHandler(String field) {
	    String select = "@" + dialog_.getName() + ".@select";

	    // VXML catch ¹Ը prompt ߤ (repromptǺƳ)
	    // [@main.place.noinput] main.place$.noprompt = true;
	    //String nopromptScript = dialog_.getName() + "." 
	    // + dialog_.getItemName() + "$" + ".noprompt = true;";

	    // [@main.place.noinput]
	    String noinput = stateMap_.newState(field + ".noinput");
	    stateMap_.setNext(field, noinput);
	    stateMap_.setNext(noinput, select);

	    // [@main.place.nomatch]
	    String nomatch = stateMap_.newState(field + ".nomatch");
	    stateMap_.addTrans(field, nomatch, "<nomatch>");
	    stateMap_.setNext(nomatch, select);

	    // [@main.place.help]
	    String help = stateMap_.newState(field + ".help");
	    stateMap_.addTrans(field, help, "HELP");
	    stateMap_.setNext(help, select);

	    // TODO: error
	}

	public boolean enter(VxmlField vxmlField) {
	    // field.name (place)
	    if ( vxmlField.getName() == null ) {
		dialog_.setItemName(_getUniqueId());
	    } else {
		if ( formItems_.has(vxmlField.getName()) ) {
		    docErrors_.add(new DocError("Field name dupulication."));
		    return false;
		}
		dialog_.setItemName(vxmlField.getName());
	    }

	    formItems_.put(dialog_.getItemName(), (Object)vxmlField);

	    dbg.ASSERT(dialog_.getItemName() != null, "vxmlForm#enter");

	    // [@main.place]
	    String f = "@" + dialog_.getName() + "." + dialog_.getItemName(); 
	    String field = stateMap_.newState(f);

	    _makeInputEventHandler(field);

	    // initialize promptList_
	    promptList_ = new Vector();

	    visitorStack_.push(vxmlField);
	    return true;
	}


	private void _makePromptSelect() {

	    // [@main.place]

	    String field = "@"+dialog_.getName()+"."+dialog_.getItemName(); 

	    // default noinput handler
	    //stateMap_.setNext(field, field);

	    //  prompt 
	    String promptCond = "!" + dialog_.getName() + "." 
		+ dialog_.getItemName() + "$" + ".noprompt";
	    //promptCond = "true"; // debug
	    CompositeCommand promptCmd = new CompositeCommand
		(new Vector(), promptCond);

	    if (promptList_ == null) {
		return; 
		// leave Prompt  timeout ղäΤ
		// ̾Ϥʤ
	    }

	    // script with="main.place$"
	    String sWith = dialog_.getName()+"."+dialog_.getItemName()+"$";

	    // ʤ cond == false 
	    //<script with="main.place$">
	    //  p1 = true;    
	    //  p2 = true;    
	    //</script>

	    String script = "";
	    for (int i = 0; i < promptList_.size(); i++) {
		Prompt prompt = (Prompt)promptList_.get(i);
		if ( prompt.cond == null ) {
		    script += "p" + i + " = true;\n";
		} else {
		    script += "p" + i + " = (" + prompt.cond + ");\n";
		}
	    }
	    promptCmd.addScriptCommand(script, sWith);

	    // cc := ߤΥͰʲǡǤ count °κ
	    //   <script with="main.place$">
	    //     cc = 1;	    
	    //     // p1: count=1
	    //     // p2: count=3
	    //     if ( 1 <= promptcount && cc < 1 ) {cc = 1};
	    //     if ( 3 <= promptcount && cc < 3 ) {cc = 3};
	    //   </script>
	    script = "cc = 1;\n";
	    for (int i = 0; i < promptList_.size(); i++) {
		Prompt prompt = (Prompt)promptList_.get(i);
		int n = prompt.count;
		script += "if(" + n + "<=promptcount && cc<" + n + "){cc=" + n + "};\n";
	    }
	    promptCmd.addScriptCommand(script, sWith);

	    // cc Ʊ count ͤʤǤꥹȤ
	    //  cond Ǻ줿ΤϤ餫 false
	    //<script with="confirm._menu_$">
	    //     if ( 1 != cc ) { p1=false };
	    //     if ( 3 != cc ) { p2=false };
	    //</script>
	    script = "";
	    for (int i = 0; i < promptList_.size(); i++) {
		Prompt prompt = (Prompt)promptList_.get(i);
		int n = prompt.count;
		script += "if(" + n + "!=cc){p" + i + "=false};\n";
	    }
	    promptCmd.addScriptCommand(script, sWith);


	    // Ск inc
	    //  <script>main.place$.promptcount++;</script>
	    script = dialog_.getName() + "." + dialog_.getItemName() + "$" + 
		".promptcount++;\n";
	    promptCmd.addScriptCommand(script);

	    // for debug
	    //String text ="'promptcount='+promptcount";
	    //LogOutItem item = new LogOutItem(text, sWith);
	    //item.setEval(true);
	    //Command logcmd = new AddOutItemCommand(item);
	    //promptCmd.addCommand(logcmd);

	    // execute prompt list 
	    //  <cmd cond="main.place$.p1">
	    //   <add><voice with="main">'ɤ'</voice></add>
	    //   <add><break length="10.0"/></add>
	    //  </cmd>
	    //  ʲƱ
	    for (int i = 0; i < promptList_.size(); i++) {
		Prompt prompt = (Prompt)promptList_.get(i);
		String cond = "with(" + sWith + "){p" + i +"}";
		if (prompt.commands.size() == 1 
		    && prompt.commands.get(0) instanceof CompositeCommand ) {
		    // ĹҤɤ
		    Command co = (Command)prompt.commands.get(0);
		    co.setCondition(cond);
		    promptCmd.addCommand(co);
		} else {
		    CompositeCommand co = new CompositeCommand
			(prompt.commands, cond);
		    promptCmd.addCommand(co);
		}
	    }

	    // promptCmd  field ɲ
	    stateMap_.addCommand(field, promptCmd);

	    // timeout
	    Command c = new AddOutItemCommand
	    (new BreakOutItem("$prompt_timeout", currPromptBargein_));
	    stateMap_.addCommand(field, c);
	}

	public void leave(VxmlField vxmlField) {
	    visitorStack_.pop(); 

	    _makePromptSelect();
	}
	
	// <var>  Block  Field ʤΤ ExecContext ǤϤʤ
	// state(@form) 
	//   <script>form.name=expr</script>
	// ޤ
	//   <script>form.name=undefined</script>
	//  append  (formVarInitScript_)
	public boolean enter(VxmlVar e) {
	    if ( e.getName() == null ) {
		return false;
	    }
	    String aname = e.getName();
	    String aexpr = "undefined";
	    if ( e.getExpr() != null ) {
		aexpr = e.getExpr();
	    }
	    if (visitorStack_.peek() instanceof VxmlVxml) {
		String sc = _getEvalWith(aname + "=" + aexpr, "document");
		formVarInitScript_ += sc + ";\n";
	    } else if (visitorStack_.peek() instanceof VxmlForm) {
		String sc = _getEvalWith(aname + "=" + aexpr, dialog_.getName());
		formVarInitScript_ += sc + ";\n";
	    }
	    return true;
	}

	// <menu>

	public boolean enter(VxmlMenu vxmlMenu) {
	    // menu.id (confirm)
	    if ( vxmlMenu.getId() == null ) {
		dialog_.setName(_getUniqueId());
	    } else {
		dialog_.setName(vxmlMenu.getId());
	    }
	    dialog_.setItemName("_menu_");
	    
	    // [@confirm]
	    String m = "@" + dialog_.getName();
	    String menu = stateMap_.newState(m);
	    dbg.ASSERT(m.equals(menu), "vxmlMenu#enter");
	    
	    // [@confirm.@select]
	    // <state id="@confirm.@select">
	    // <cmd><next>'@confirm.menu'</next></cmd>
	    // </state>
	    String select = stateMap_.newState(menu + ".@select");

	    // [@confirm._menu_]
	    String f = "@"+dialog_.getName()+"."+dialog_.getItemName();  
	    String field = stateMap_.newState(f);
	    dbg.ASSERT(f.equals(field), "vxmlMenu#enter");

	    stateMap_.setNext(menu, select);
	    stateMap_.setNext(select, field);

	    _makeInputEventHandler(field);

	    // initialize promptList_
	    promptList_ = new Vector();
	    visitorStack_.push(vxmlMenu);
	    return(true);
	}

	public void leave(VxmlMenu o) { 
	    visitorStack_.pop(); 

	    String form  = "@" + dialog_.getName();
	    String field = form + "." + dialog_.getItemName();  

	    // [@confirm]
	    String script;
	    script  = dialog_.getName() + " = new Object();\n";
	    String shadow = dialog_.getName() + "._menu_$";
	    script += shadow + " = new Object();\n";
	    script += shadow + ".promptcount = 1;\n";
	    script += shadow + ".noprompt = false;\n";
	    stateMap_.addScriptCommand(form, script);
	    stateMap_.setNext(form, field);

	    _makePromptSelect();
	}

	// choice (in menu)

	public boolean enter(VxmlChoice vxmlChoice) {
	    String next = null;
	    String n = vxmlChoice.getNext();
	    if (n == null) {
		docErrors_.add(new DocError("No next in choice."));
		return false;
	    }
	    next = Util.removeSpaces(n);

	    String image = "";
	    String im = vxmlChoice.getImage();
	    if(im != null) {
		image = Util.removeSpaces(im);
		image = resolveAdrs(image);
		dbg.ASSERT( image != null, "VxmlChoce#enter");
	    }

	    String menuState = "@" + dialog_.getName() + "._menu_";

	    for ( int i = 0; i < vxmlChoice.sizeContent(); i++ ) {
		String text = getText(vxmlChoice.getContent(i));
		dbg.ASSERT( text != null, "VxmlChoce#enter");

		if(text.length() > 0 ) {

		    if(next.startsWith("#")) {
			String nextState = "@" + next.substring(1);
			stateMap_.addTrans(menuState, nextState, text);
		    } else if(next.startsWith("http://")) {
			Command c = null;
			try {
			    c = new HttpGetCommand(new URL(next));
			} catch (Exception e) { e.printStackTrace(); }
			stateMap_.addCommand(menuState, c);
		    } 
		    
		    //if( image.length() > 0 ) {
		    // stateMap_.addCommandOnTop(menuState, new AddOutItemCommand
		    // (new ShowImageOutItem(image, text)));
		    //}
		}
	    } 

	    return(true);
	}

	// <prompt>

	private String currPromptCond_  = null;
	private String currPromptCount_ = null;

	private boolean currPromptBargein_ = true;
	private String  currPromptBargeintype_ = "speech"; // speech, hotword
	private String  currPromptTimeout_ = null;

	public boolean enter(VxmlPrompt vxmlPrompt) {

	    if ( vxmlPrompt.getBargein() != null 
		 && vxmlPrompt.getBargein().equals("false") )
		currPromptBargein_ = false;
	    if ( vxmlPrompt.getBargeintype() != null )
		currPromptBargeintype_ = vxmlPrompt.getBargeintype();

	    if (visitorStack_.peek() instanceof VxmlMenu
		|| visitorStack_.peek() instanceof VxmlField) {
		currPromptCond_ = vxmlPrompt.getCond();
		currPromptCount_ = vxmlPrompt.getCount();

		commands_.setCommands(new Vector());

		execContents_.setupExecContent();
	    }

	    if (vxmlPrompt.getTimeout() != null ) {
		String msec = _getCSS2TimesAsMsec(vxmlPrompt.getTimeout());
		String script = "$prompt_timeout = "+msec;
		commands_.appendCommands(new EvaluateCommand(script));
	    }

	    textBuf_.setupSpeak();
	    return(true);
	}

	public void leave(VxmlPrompt vxmlPrompt) {
	    textBuf_.flushSpeak();

	    if (visitorStack_.peek() instanceof VxmlMenu
		|| visitorStack_.peek() instanceof VxmlField) {

		execContents_.flushExecContent();

		// flushCommands ʤ prompt.commands ɲä
		// prompt  promptList_ ɲ

		Prompt prompt = new Prompt();

		if (currPromptCond_ == null ) {
		    prompt.cond = "true";
		} else {
		    prompt.cond = currPromptCond_;
		}

		if (currPromptCount_ == null ) {
		    prompt.count = 1;
		} else {
		    prompt.count=Integer.valueOf(currPromptCount_).intValue();
		}

		prompt.commands = commands_.getCommands();
		commands_.clearCommands();

		promptList_.add(prompt);
	    }

	    // restore default values
	    currPromptBargein_ = true;
	    currPromptBargeintype_ = "speech";
	    currPromptTimeout_ = null;
	}

	// nomatch
	//<state id="@weather.place.nomatch" next="@weather.@select">
	// xxx
	//</state>

	private void _enterNomatch() 
	{
	    commands_.setupCommands();
	    execContents_.setupExecContent();
	    textBuf_.setupSpeak();

	    String shadow = dialog_.getName() + "." + dialog_.getItemName() + "$";
	    execContents_.appendExecContent(new EvaluateCommand("noprompt = true;",shadow));
	}

	public boolean enter(VxmlNomatch o) {
	    // [@weather.place.nomatch]
	    _enterNomatch();
	    visitorStack_.push(o);
	    return(true);
	}

	private void _leaveNomatch()
	{
	    textBuf_.flushSpeak();
	    execContents_.flushExecContent();

	    String nomatch = "@" + dialog_.getName() + "." + dialog_.getItemName() + ".nomatch"; 
	    commands_.flushCommands(nomatch);
	}

	public void leave(VxmlNomatch o) {
	    _leaveNomatch();
	    visitorStack_.pop(); 
	}

	// noinput
	//<state id="@weather.place.noinput" next="@weather.@select">
	// xxx
	//</state>

	private void _enterNoinput()
	{
	    commands_.setupCommands();
	    execContents_.setupExecContent();
	    textBuf_.setupSpeak();

	    String shadow = dialog_.getName() + "." + dialog_.getItemName() + "$";
	    execContents_.appendExecContent(new EvaluateCommand("noprompt = true;",shadow));
	}

	public boolean enter(VxmlNoinput o) {
	    _enterNoinput();
	    visitorStack_.push(o);
	    return(true);
	}

	private void _leaveNoinput()
	{
	    textBuf_.flushSpeak();
	    execContents_.flushExecContent();

	    String noinput = "@" + dialog_.getName() + "." + dialog_.getItemName() + ".noinput"; 
	    commands_.flushCommands(noinput);
	}

	public void leave(VxmlNoinput o) {
	    _leaveNoinput();
	    visitorStack_.pop(); 
	}

	// <help>

	private void _enterHelp()
	{
	    commands_.setupCommands();
	    execContents_.setupExecContent();
	    textBuf_.setupSpeak();

	    String shadow = dialog_.getName() + "." + dialog_.getItemName() + "$";
	    execContents_.appendExecContent(new EvaluateCommand("noprompt = true;",shadow));
	}

	public boolean enter(VxmlHelp o) {
	    _enterHelp();
	    visitorStack_.push(o);
	    return true;
	}

	private void _leaveHelp()
	{
	    textBuf_.flushSpeak();
	    execContents_.flushExecContent();

	    String help = "@" + dialog_.getName() + "." + dialog_.getItemName() + ".help"; 
	    commands_.flushCommands(help);
	}

	public void leave(VxmlHelp e) {
	    _leaveHelp();
	    visitorStack_.pop(); 
	}

	// TODO: event="noinput nomatch help"
	//
	public boolean enter(VxmlCatch o) {
	    if (o.getEvent() == null) {
		docErrors_.add(new DocError("No EVENT in <catch>"));
		return false;
	    }
	    String event = o.getEvent();
	    if ( event.equals("nomatch") ) {
		_enterNomatch();
	    } else if ( event.equals("noinput") ) {
		_enterNoinput();
	    } else if ( event.equals("help") ) {
		_enterHelp();
	    } else if ( event.equals("error") ) {
		docErrors_.add(new DocError("Not supported feature: <catch event=error>"));
		return false;
	    } else {
		docErrors_.add(new DocError("Not supported feature: <catch>"));
		return false;
	    }

	    visitorStack_.push(o);
	    return true;
	}

	public void leave(VxmlCatch o) {
	    if (visitorStack_.peek() instanceof VxmlCatch 
		&& ((VxmlCatch)(visitorStack_.peek())).getEvent() != null ) {
		String event = ((VxmlCatch)(visitorStack_.peek())).getEvent();
		if ( event.equals("nomatch") ) {
		    _leaveNomatch();
		} else if ( event.equals("noinput") ) {
		    _leaveNoinput();
		} else if ( event.equals("help") ) {
		    _leaveHelp();
		}
	    }
	    visitorStack_.pop(); 
	}


	// <reprompt>
	// usage:
	//  <noinput> ʹȤޤ <reprompt/> </noinput>
	//
	public boolean enter(VxmlReprompt e) {
	    textBuf_.flushSpeak();
	    
	    String shadow = dialog_.getName() 
		+ "." + dialog_.getItemName() + "$";
	    String script = "noprompt = false;\n";

	    //String sc = _getEvalWith(script, shadow);
	    execContents_.appendExecContent(new EvaluateCommand(script,shadow));

	    textBuf_.setupSpeak();
	    return true;
	}
	
	// common tags begin:

	public boolean enter(RString rs) {
	    //String text = Util.removeSpaces(rs.getText());
	    String text = rs.getText();
	    dbg.print("RString: "+ text);
	    textBuf_.appendString(text);
	    return true;
	}

	public boolean enter(VxmlValue vxmlValue) {
	    if (vxmlValue.getExpr() != null) {
		String expr = vxmlValue.getExpr();
		// 'xxx'+ 1+2  = xxx12  -> NG
		// 'xxx'+(1+2) = xxx3   -> OK
		textBuf_.appendValue("("+expr+")");
	    }
	    return true;
	}

	public boolean enter(VxmlGoto g) {
	    textBuf_.flushSpeak();

	    String n = g.getNext();
	    if (n == null) {
		docErrors_.add(new DocError("no next in <goto>"));
		return false;
	    }
	    String next = Util.removeSpaces(n);
	    if ( next.startsWith("#") ) {
		String sc = "'@" + next.substring(1) + "'";
		execContents_.appendExecContent(new GotoCommand(sc));
	/*
	    } else if(next.startsWith("http://")) {
		try {
		    Command c = new HttpGetCommand(new URL(next));
		    execContents_.appendExecContent(c);
		} catch (Exception e) { e.printStackTrace(); }
	*/
	    } else {
		boolean now = false;
		String cond = "true";
		String eval = "'" + next + "'";
		Command c = (Command)( new EndCommand(eval, cond, now) );
		execContents_.appendExecContent(c);
	    }
	    textBuf_.setupSpeak();
	    return true;
	}

	public boolean enter(VxmlExit e) {
	    textBuf_.flushSpeak();
	    execContents_.appendExecContent(new EndCommand(false));
	    return true;
	}

	public boolean enter(VxmlAssign e) {
	    textBuf_.flushSpeak();
	    String aname = e.getName();
	    String aexpr = e.getExpr();
	    if ( aname == null || aexpr == null ) {
		docErrors_.add(new DocError("<assign> needs NAME and EXPR."));
		return false;
	    }

	    //String sc = aname + "=" + aexpr + ";";
	    String sc = _getEvalWith(aname + "=" + aexpr, dialog_.getName());
	    execContents_.appendExecContent(new EvaluateCommand(sc));
	    textBuf_.setupSpeak();
	    return true;
	}


	public boolean enter(VxmlScript e) {
	    textBuf_.flushSpeak();
	    String text = e.getContent();
	    String sc = _getEvalWith(text, dialog_.getName());
	    execContents_.appendExecContent(new EvaluateCommand(sc));
	    textBuf_.setupSpeak();
	    return true;
	}


	// if/else/elseif

	private String currIfCond_ = null;
	
	public boolean enter(VxmlIf e) {

	    currIfCond_ = e.getCond();
	    String cond = _getEvalWith(currIfCond_, dialog_.getName());
	    execContents_.setupExecContent(cond);

	    return true;
	}

	public void leave(VxmlIf e) {
	    textBuf_.flushSpeak();
	    execContents_.flushExecContent();
	}

	// TODO:  else ɾ if μ¹Ի˹Ԥʤ٤
	public boolean enter(VxmlElse e) {
	    textBuf_.flushSpeak();
	    execContents_.flushExecContent();

	    String cond = _getEvalWith("!(" + currIfCond_ + ")", dialog_.getName());
	    execContents_.setupExecContent(cond);

	    return true;
	}


	public boolean enter(VxmlElseif e) {
	    // end of previous if
	    textBuf_.flushSpeak();
	    execContents_.flushExecContent();

	    // begin of next if
	    String c = e.getCond();
	    String cond = _getEvalWith(c, dialog_.getName());
	    currIfCond_ = currIfCond_ + " || " + c;

	    execContents_.setupExecContent(cond);
	    textBuf_.setupSpeak();
	    return true;
	}

	// VoiceXML SSML
	// http://www.w3.org/TR/speech-synthesis/#S2.2.3
	//  <break time="3s"/>
	//  <break time="300ms"/>
	//  <break time="medium"/>
	//
	// TODO: large, medium ʤɤͤѤˤ
	//
	public boolean enter(VxmlBreak e) {
	    String time = e.getTime();
	    String msec = "500";
	    if ( time != null ) {
		if ( time.equals("large") ) {
		    msec = "2000";
		} else if ( time.equals("medium") ) {
		    msec = "500";
		} else if ( time.equals("small") ) {
		    msec = "200";
		} else if ( time.equals("none") ) {
		    msec = "100";
		} else {
		    msec = _getCSS2TimesAsMsec(time);
		}
	    }
	    textBuf_.appendString("<SILENCE MSEC=\"" + msec + "\"/>");
	    return true;
	}

	// VoiceXML misc

	// Supported:
	// <clear namelist="city"/>
	// <clear namelist="city state zip"/>
	// TODO:
	// <clear/> .. all form items
	public boolean enter(VxmlClear e) {
	    if ( e.getNamelist() == null ) {
		docErrors_.add(new DocError("Not supported feature: <clear/>"));
		return false;
	    }
	    textBuf_.flushSpeak();

	    String names[] = e.getNamelist().split(" ");
	    for (int i = 0; i < names.length; i++) {
		String aname = names[i];
		String aexpr = "undefined";
		String sc = _getEvalWith(aname + "=" + aexpr, dialog_.getName());
		execContents_.appendExecContent(new EvaluateCommand(sc));
	    }

	    textBuf_.setupSpeak();
	    return true;
	}

	// exit immediately
	public boolean enter(VxmlDisconnect e) {
	    textBuf_.flushSpeak();
	    execContents_.appendExecContent(new EndCommand(true));
	    return true;
	}

	public boolean enter(VxmlEmphasis e) {
	    if ( e.getLevel() != null ) {
		docWarnings_.add(new DocWarning("Ignored feature: <emphasis level>"));
		return false;
	    }
	    textBuf_.appendString("<EMPH>");
	    return true;
	}

	public void leave(VxmlEmphasis e) {
	    textBuf_.appendString("</EMPH>");
	}

	public boolean enter(VxmlEnumerate e) {
	    docErrors_.add(new DocError("Not supported feature: <enumerate>"));
	    return false;
	}

	// <catch event="error"> Ʊ:
	// <error> 顼Ǥλޤ<exit/> </error>
	public boolean enter(VxmlError e) {
	    docErrors_.add(new DocError("Not supported feature: <error>"));
	    return false;
	}

	// VxmlBlock Ʊ褦˰äƤʻ
	public boolean enter(VxmlInitial e) {
	    //docErrors_.add(new DocError("Not supported feature: <initial>"));
	    //return false;

	    if ( e.getName() == null ) {
		dialog_.setItemName(_getUniqueId()); // s1
	    } else {
		dialog_.setItemName(e.getName());
	    }

	    String s = "@" + dialog_.getName() + "." + dialog_.getItemName();
	    String t = stateMap_.newState(s);
	    // @weather.s1
	    dbg.ASSERT(t.equals(s), "VxmlInitial#enter");

	    stateMap_.addCommand(s, new EvaluateCommand
		(dialog_.getName() + "." + dialog_.getItemName() + "= true;\n"));

	    visitorStack_.push(e);
	    formItems_.put(dialog_.getItemName(), (Object)e);

	    commands_.setupCommands();
	    execContents_.setupExecContent();
	    textBuf_.setupSpeak();
	    return true;

	}

	public void leave(VxmlInitial e) {
	    textBuf_.flushSpeak();
	    execContents_.flushExecContent();

	    String s = "@" + dialog_.getName() + "." + dialog_.getItemName();
	    commands_.flushCommands(s);
	    stateMap_.setNext(s, "@" + dialog_.getName() + ".@select");

	    visitorStack_.pop(); 
	}


	public boolean enter(VxmlLink e) {
	    docErrors_.add(new DocError("Not supported feature: <link>"));
	    return false;
	}

	public boolean enter(VxmlLog e) {
	    textBuf_.flushSpeak();
	    textBuf_.setupLog();
	    String expr = e.getExpr();
	    if (expr != null) {
		textBuf_.appendValue("("+expr+")");
	    }
	    return true;
	}
	public void leave(VxmlLog e) {
	    textBuf_.flushLog();
	    textBuf_.setupSpeak();
	}

	public boolean enter(VxmlNative e) {
	    textBuf_.flushSpeak();
	    textBuf_.setupNative();
	    String expr = e.getExpr();
	    if (expr != null) {
		textBuf_.appendValue("("+expr+")");
	    }
	    return true;
	}
	public void leave(VxmlNative e) {
	    textBuf_.flushNative();
	    textBuf_.setupSpeak();
	}

	public boolean enter(VxmlMark e) {
	    return true; // ignored (VXML2.0)
	}

	public boolean enter(VxmlMeta e) {
	    docWarnings_.add(new DocWarning("Ignored feature: <meta>"));
	    return true;
	}

	public boolean enter(VxmlObject e) {
	    docWarnings_.add(new DocWarning("Ignored feature: <object>"));
	    return true;
	}

	public boolean enter(VxmlOption e) {
	    docErrors_.add(new DocError("Not supported feature: <option>"));
	    return false;
	}

	public boolean enter(VxmlParam e) {
	    docErrors_.add(new DocError("Not supported feature: <param>"));
	    return false;
	}

	public boolean enter(VxmlPhoneme e) {
	    textBuf_.appendString("<PRON SYM=\"" + e.getPh() + "\">");
	    return true;
	}
	public void leave(VxmlPhoneme e) {
	    textBuf_.appendString("</PRON>");
	}

	public boolean enter(VxmlProperty e) {
	    docWarnings_.add(new DocWarning("Ignored feature: <property>"));
	    return true;
	}
	
	public boolean enter(VxmlRecord e) {
	    docErrors_.add(new DocError("Not supported feature: <record>"));
	    return false;
	}
	
	public boolean enter(VxmlReturn e) {
	    docErrors_.add(new DocError("Not supported feature: <return>"));
	    return false;
	}
	
	public boolean enter(VxmlSayAs e) {
	    docWarnings_.add(new DocWarning("Ignored feature: <say-as>"));
	    return true;
	}
	
	public boolean enter(VxmlSubmit e) {
	    //docErrors_.add(new DocError("Not supported feature: <submit>"));
	    //return false;

	    textBuf_.flushSpeak();

	    String n = e.getNext();
	    if (n == null) {
		docErrors_.add(new DocError("No 'next' in <submit>"));
		return false;
	    }

	    String namelist = e.getNamelist();
	    if (namelist == null) {
		docErrors_.add(new DocError("No 'namelist' in <submit>"));
		return false;
	    }

	    String next = Util.removeSpaces(n);
	    boolean now = false;
	    String cond = "true";
	    String script = "'" + next + "?'";

	    String names[] = namelist.split(" ");
	    for (int i = 0; i < names.length; i++) {
		if ( i != 0 ) {
		    script += "+'&'";
		}
		script += "+'" + names[i] + "='+" + names[i];
	    }
	    
	    String eval = _getEvalWith(script, dialog_.getName());
	    Command c = (Command)( new EndCommand(eval, cond, now) );
	    execContents_.appendExecContent(c);
	    textBuf_.setupSpeak();
	    return true;

	}
	
	public boolean enter(VxmlThrow e) {
	    docErrors_.add(new DocError("Not supported feature: <throw>"));
	    return false;
	}
	
	public boolean enter(VxmlTransfer e) {
	    docWarnings_.add(new DocWarning("Not supported feature: <transfer>"));

	    textBuf_.flushSpeak();
	    execContents_.appendExecContent(new EndCommand(false));
	    return true;
	}
	
	public boolean enter(VxmlVoice e) {
	    String optional = "male01"; // default
	    if (e.getName() != null) {
		optional = e.getName();
	    } else {
		if (e.getGender() != null) {
		    if ( e.getGender().equals("male")) {
			optional = "male01";
		    } else if ( e.getGender().equals("female")) {
			optional = "female01";
		    }
		}
	    }
	    textBuf_.appendString("<VOICE OPTIONAL=\"" + optional + "\">");
	    return true;
	}

	public void leave(VxmlVoice e) {
	    textBuf_.appendString("</VOICE>");
	}

	
	// VoiceXML prosody (macro)

	private String leaveProsodyTag_ = null;

	public boolean enter(VxmlProsody e) {
	    String enterProsodyTag = "";
	    leaveProsodyTag_ = "";

	    if (e.getPitch() != null) {
		if (e.getPitch().equals("x-high")) {
		    enterProsodyTag += "<PITCH LEVEL=\"140\">";
		} else if (e.getPitch().equals("high")) {
		    enterProsodyTag += "<PITCH LEVEL=\"120\">";
		} else if (e.getPitch().equals("medium")) {
		    enterProsodyTag += "<PITCH LEVEL=\"100\">";
		} else if (e.getPitch().equals("low")) {
		    enterProsodyTag += "<PITCH LEVEL=\"80\">";
		} else if (e.getPitch().equals("x-low")) {
		    enterProsodyTag += "<PITCH LEVEL=\"60\">";
		} else if (e.getPitch().equals("default")) {
		    enterProsodyTag += "<PITCH LEVEL=\"100\">";
		}
		leaveProsodyTag_ = "</PITCH>" + leaveProsodyTag_;
	    }

	    if (e.getRange() != null) {
		if (e.getRange().equals("x-high")) {
		    enterProsodyTag += "<PITCH RANGE=\"140\">";
		} else if (e.getRange().equals("high")) {
		    enterProsodyTag += "<PITCH RANGE=\"120\">";
		} else if (e.getRange().equals("medium")) {
		    enterProsodyTag += "<PITCH RANGE=\"100\">";
		} else if (e.getRange().equals("low")) {
		    enterProsodyTag += "<PITCH RANGE=\"80\">";
		} else if (e.getRange().equals("x-low")) {
		    enterProsodyTag += "<PITCH RANGE=\"60\">";
		} else if (e.getRange().equals("default")) {
		    enterProsodyTag += "<PITCH RANGE=\"100\">";
		}
		leaveProsodyTag_ = "</PITCH>" + leaveProsodyTag_;
	    }

	    if (e.getVolume() != null) {
		if (e.getRange().equals("silent")) {
		    enterProsodyTag += "<VOLUME LEVEL=\"0\">";
		} else if (e.getRange().equals("x-soft")) {
		    enterProsodyTag += "<VOLUME LEVEL=\"60\">";
		} else if (e.getRange().equals("soft")) {
		    enterProsodyTag += "<VOLUME LEVEL=\"80\">";
		} else if (e.getRange().equals("medium")) {
		    enterProsodyTag += "<VOLUME LEVEL=\"100\">";
		} else if (e.getRange().equals("loud")) {
		    enterProsodyTag += "<VOLUME LEVEL=\"120\">";
		} else if (e.getRange().equals("x-loud")) {
		    enterProsodyTag += "<VOLUME LEVEL=\"140\">";
		} else if (e.getRange().equals("default")) {
		    enterProsodyTag += "<VOLUME LEVEL=\"100\">";
		}
		leaveProsodyTag_ = "</VOLUME>" + leaveProsodyTag_;
	    }

	    textBuf_.appendString(enterProsodyTag);
	    return true;
	}
	public void leave(VxmlProsody e) {
	    dbg.ASSERT(leaveProsodyTag_ != null, "leave VxmlProsody");
	    textBuf_.appendString(leaveProsodyTag_);
	    leaveProsodyTag_ = null;
	}

	// VoiceXML paragraph

	public boolean enter(VxmlP e) {
	    textBuf_.setupSpeak();
	    return true;
	}
	public void leave(VxmlP e) {
	    textBuf_.appendString("<SILENCE MSEC=\"500\"/>");
	    textBuf_.flushSpeak();
	}

	public boolean enter(VxmlParagraph e) {
	    textBuf_.setupSpeak();
	    return true;
	}
	public void leave(VxmlParagraph e) {
	    textBuf_.appendString("<SILENCE MSEC=\"500\"/>");
	    textBuf_.flushSpeak();
	}

	// VoiceXML sentence

	public boolean enter(VxmlS e) {
	    textBuf_.setupSpeak();
	    return true;
	}
	public void leave(VxmlS e) {
	    textBuf_.flushSpeak();
	}

	public boolean enter(VxmlSentence e) {
	    textBuf_.setupSpeak();
	    return true;
	}
	public void leave(VxmlSentence e) {
	    textBuf_.flushSpeak();
	}

	// Galatea extention tags
			
	public boolean enter(VxmlEMPH e) {
	    textBuf_.appendString("<EMPH>");
	    return true;
	}
	public void leave(VxmlEMPH e) {
	    textBuf_.appendString("</EMPH>");
	}

	// SILENCE

	public boolean enter(VxmlSILENCE e) {
	    textBuf_.appendString("<SILENCE MSEC=\"" + e.getMSEC() + "\"/>");
	    return true;
	}

	// PRON

	public boolean enter(VxmlPRON e) {
	    textBuf_.appendString("<PRON SYM=\"" + e.getSYM() + "\">");
	    return true;
	}

	public void leave(VxmlPRON e) {
	    textBuf_.appendString("</PRON>");
	}

	// VOICE

	public boolean enter(VxmlJVOICE e) {
	    String optional = e.getOPTIONAL();
	    if ( optional == null ) {
		if ( e.getREQUIRED() != null ) {
		    if ( e.getREQUIRED().equals("FEMALE") 
			 || e.getREQUIRED().equals("female") ) {
			optional = "female01";
		    } else {
			optional = "male01";
		    }
		}
	    }

	    String str = "<VOICE";
	    if ( optional != null ) {
		str += " OPTIONAL=\"" + optional + "\"";
	    }
	    String alpha = e.getALPHA();
	    if ( alpha != null ) {
		str += " ALPHA=\"" + alpha + "\"";
	    }
	    str +=">";
	    textBuf_.appendString(str);

	    return true;
	}

	public void leave(VxmlJVOICE e) {
	    textBuf_.appendString("</VOICE>");
	}

	// RATE

	public boolean enter(VxmlRATE e) {
	    textBuf_.appendString("<RATE SPEED=\"" + e.getSPEED() + "\">");
	    return true;
	}

	public void leave(VxmlRATE e) {
	    textBuf_.appendString("</RATE>");
	}

	// VOLUME

	public boolean enter(VxmlVOLUME e) {
	    textBuf_.appendString("<VOLUME LEVEL=\"" + e.getLEVEL() + "\">");
	    return true;
	}

	public void leave(VxmlVOLUME e) {
	    textBuf_.appendString("</VOLUME>");
	}

	// PITCH

	public boolean enter(VxmlPITCH e) {
	    String att = "";
	    if ( e.getLEVEL() != null ) {
		att += " LEVEL=\"" + e.getLEVEL() + "\"";
	    }
	    if ( e.getRANGE() != null ) {
		att += " RANGE=\"" + e.getRANGE() + "\"";
	    }
	    textBuf_.appendString("<PITCH" + att+ ">");
	    return true;
	}

	public void leave(VxmlPITCH e) {
	    textBuf_.appendString("</PITCH>");
	}

	// SPELL

	public boolean enter(VxmlSPELL e) {
	    textBuf_.appendString("<SPELL>");
	    return true;
	}

	public void leave(VxmlSPELL e) {
	    textBuf_.appendString("</SPELL>");
	}

	// CONTEXT

	public boolean enter(VxmlCONTEXT e) {
	    String att = "";
	    if ( e.getTYPE() != null ) {
		att += " TYPE=\"" + e.getTYPE() + "\"";
	    }
	    if ( e.getTYPE().equals("NUMBER") ) {
		if ( e.getFORMAT() != null ) {
		    att += " FORMAT=\"" + e.getFORMAT() + "\"";
		}
	    }
	    if ( e.getTYPE().equals("DATE") ) {
		if ( e.getFORMAT() != null ) {
		    att += " FORMAT=\"" + e.getFORMAT() + "\"";
		}
		if ( e.getDELIM() != null ) {
		    att += " DELIM=\"" + e.getDELIM() + "\"";
		}
	    }
	    textBuf_.appendString("<CONTEXT"+att+">");
	    return true;
	}

	public void leave(VxmlCONTEXT e) {
	    textBuf_.appendString("</CONTEXT>");
	}

	// AUDIO

	public boolean enter(VxmlAudio e) {
	    //docWarnings_.add(new DocWarning("Ignored feature: <audio>"));
	    //return true;
	    textBuf_.flushSpeak();
	    String src = e.getSrc();
	    if ( src == null ) {
		docWarnings_.add(new DocWarning("Error: <audio src> missing."));
		return true;
	    }
	    String fileRel = resolveAdrs(src);
	    String userdir = System.getProperty("user.dir") + "/" ;
	    String file = Util.resolveAdrs(userdir, fileRel);
	    file = "'" + file + "'";
	    execContents_.appendExecContent
	    (new AddOutItemCommand(new AudioOutItem(file, currPromptBargein_)));
	    // do not speak inside <audio>
	    // textBuf_.setupSpeak();
	    return true;
	}

	public void leave(VxmlAudio e) {
	    // do not speak inside <audio>
	    // textBuf_.flushSpeak();
	    textBuf_.setupSpeak();
	}


	// EMOTION

	public boolean enter(VxmlEmotion e) {
	    textBuf_.flushSpeak();
	    String typename = e.getType();
	    int value = 100;
	    int duration = 0;
	    int pattern = 1;
	    if ( e.checkPattern() ) {
		value = e.getPattern();
	    }
	    if ( e.checkValue() ) {
		value = e.getValue();
	    }
	    if ( e.checkDuration() ) {
		duration = e.getDuration();
	    }
	    if ( typename == null ) {
		typename = "NEUTRAL";
	    }
	    typename = typename.toUpperCase();

	    if ( typename.equals("SURPRISED") ) {
		value = value / 2;
	    }

	    String text = "'to @FSM set FaceExp = " 
	    + typename + " " + pattern + " " + value + " " + duration + "'";
	    NativeOutItem item = new NativeOutItem(text, dialog_.getName());
	    execContents_.appendExecContent(new AddOutItemCommand(item));

	    textBuf_.setupSpeak();
	    return true;
	}

	public void leave(VxmlEmotion emotion) {
	    // ľ emotion ᤹
	    textBuf_.flushSpeak();
	    String text = "'to @FSM set FaceExp = NEUTRAL'";
	    NativeOutItem item = new NativeOutItem(text, dialog_.getName());
	    execContents_.appendExecContent(new AddOutItemCommand(item));
	    textBuf_.setupSpeak();
	}

	// common tags end

    }

    private void _addAppInitStates(String app, StateMap stateMap) throws Exception
    {
	String appInitScript = 
	    "document = new Object();\n" +
	    "dialog = new Object();\n";
	
	if (app == null) {

	    appInitScript += 
		"session = new Object();\n" +
		"application = new Object();\n";

	} else {
	    
	    appInitScript += 
		"var $root = '" + docAddress_ + "';\n" +
		"if ( $current_root == undefined ) {\n" +
		"  var $current_root;\n" +
		"}\n" +
		"if ( $current_root != $root ) {\n" +
		"  $current_root = $root;\n" +
		"  session = new Object();\n" +
		"  application = new Object();\n";

	    String applicationRoot = resolveAdrs(app);
	    dbg.print("rootVxml:" + applicationRoot );

	    VxmlVxml rootVxml = new VxmlVxml(applicationRoot);

	    dbg.print("Parsing applicationRoot...",2 );
	    int nContent = rootVxml.sizeContent();
	    for ( int i = 0; i < nContent; i++ ) {
		IVxmlVxmlChoice choice = rootVxml.getContent(i);
		
		if ( choice instanceof VxmlVar ) {
		    VxmlVar var = (VxmlVar)choice;
		    String name = var.getName();
		    String expr = var.getExpr();
		    String command = "  application."+name+"="+expr+";\n";

		    appInitScript += command;

		} else if ( choice instanceof VxmlLink ) {
		    VxmlLink link = (VxmlLink)choice;
		    String n = link.getNext();
		    // next  appRoot Хɥ쥹ʤΤɬ
		    String next = Util.resolveAdrs(applicationRoot, n);
		    dbg.print("link next="+next );
		}
	    }
	    appInitScript += "}\n";
	}

	ContentState appInitState = new ContentState();
	String docName = "@document";
	appInitState.setName(docName);
	if ( appInitScript.length() > 0 ) {
	    appInitState.addCommand(new EvaluateCommand(appInitScript));
	}

	String firstID = getFirstDialogID();
	if(firstID == null) {
	    throw new DocError("VXML leaf document " +docAddress_+ " has no menu or form.");
	}

        stateMap.add(appInitState);
	stateMap.setFirstStateName(docName);
	stateMap.setNext(docName, "@" + firstID);

	stateMap.addCommand(docName, new AddOutItemCommand
			     (new BreakOutItem(startupWait_ * 1000.0, false)));

	String script = "$prompt_timeout = "+Double.toString(promptTimeout_ * 1000.0);
	stateMap.addCommand(docName, new EvaluateCommand(script));
    }


    /**
     * @see main() for usage
     */
    public VXMLDoc(Element e, String adrs) throws Exception
    {
	String s;
	s = System.getProperty("VXMLDoc.PromptTimeout", "10.0");
	promptTimeout_ = Double.parseDouble(s);
	s = System.getProperty("VXMLDoc.StartupWait", "10.0");
	startupWait_ = Double.parseDouble(s);

	docErrors_ = new Vector();
	docWarnings_ = new Vector();

	if (VxmlVxml.isMatch(e) == false) {
	    throw new DocError("Not a valid <vxml> document.");
	}
	vxml_ = new VxmlVxml(e);
	
	grammarSet_ = new GrammarSet();
	docAddress_ = adrs;

	stateMap_ = new StateMap();

	_addAppInitStates(vxml_.getApplication(), stateMap_);

	VXMLDoc.Visitor visitor = new VXMLDoc.Visitor();
	URVisitor.traverse(vxml_, visitor);

	if ( docErrors_.size() > 0 ) {
	    String err = "";
	    for ( int i = 0; i < docErrors_.size(); i++ ) {
		err += docErrors_.get(i).toString() + "\n";
	    }
	    throw new DocError("Leaf document has following error(s):\n" + err);
	}
	
	if ( docWarnings_.size() > 0 ) {
	    String err = "";
	    for ( int i = 0; i < docWarnings_.size(); i++ ) {
		System.err.println(e);
	    }
	}
	
	stateMap_.setGrammarSet(grammarSet_);
    }

    public StateMap getStateMap()
    {
	return stateMap_;
    }

}
