/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: EndCommand.java,v 1.3 2003/07/25 09:56:33 nishi Exp $
 */

package command;
import outitem.*;
import scripting.ECMAScript;
import main.*;

public class EndCommand extends Command
{

    boolean now_;
    String next_;

    public EndCommand(boolean now)
    {
	now_ = now;
    }

    public EndCommand(String next, String cond, boolean now)
    {
	now_ = now;
	next_ = next;
	setCondition(cond);
    }

    public EndCommand()
    {
	now_ = false;
    }

    public boolean isNow()
    {
	return(now_);
    }


    public String toString()
    {
	String s = "  <end";
	if ( hasCondition() ) {
	    s += " cond=\"" + getConditionAsEncodedString() + "\"";
	}
	s += " now=\"" + now_ +"\"";
	if ( next_ != null && next_.length() > 0 ) {
	    s += ">" + next_ + "</end>";
	} else {
	    s += "/>";
	}
	return s;
    }


    public void execute(InteractionControler ic)
    {
	if ( evaluateCondition() == true ) {
	    ic.setEndFlag(true);
	    ic.setEndImm(now_);
            if ( next_ != null ) {
		String nf = scripting.ECMAScript.doEvaluate(next_);
		ic.setNextDocFile(nf);
	    } else {
		ic.setNextDocFile("");
	    }
	} 
    }

}
