/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: Command.java,v 1.4 2003/07/25 09:56:33 nishi Exp $
 */

package command;
import outitem.*;
import util.*;
import main.*;
import scripting.ECMAScript;

public abstract class Command
{
    protected Debug dbg = new Debug("Command");

    private String condition_ = "true";

    public void setCondition(String s)
    {
	if (s == null) {
	    condition_ = "true";
	}
	condition_ = s;
    }
    
    public String getConditionAsEncodedString()
    {
	return Util.encodeXmlChars(condition_);
    }

    public boolean hasCondition()
    {
	if (condition_ == null) 
	    return false;
	return ! condition_.equals("true");
    }

    private String with_ = "";

    public void setWith(String s) {
	with_ = s;
    }
    public String getWith() {
	return with_;
    }

    public boolean evaluateCondition()
    {
        if (condition_ == null)
            return true;
	if (with_.length() > 0) {
	    condition_ = "with(" + with_ + "){" + condition_ + "}";
	}

	String r = scripting.ECMAScript.doEvaluate(condition_); 
	boolean b = false;
	if (r.equals("true")) {
	    b = true;
	}
        return b;
    }
    
    public String toString()
    {
	String s = "<command/>";
	return s;
    }
    
    public void execute(InteractionControler ic)
    {
	//if ( evaluateCondition() == true ) {
	//    // do something
	//}
    }

}
