#!/usr/local/bin/perl -w
#
# $Id: DM-MCL.pl,v 1.2 2003/08/20 11:30:23 nishi Exp $
#------------------------------------------------------------------
# Dialog Manager Macro Control Layer Ver.0.1
# 
# Filename : DM-MCL.pl
#
# based on AM-MCL.pl coded by Shin-ichi KAWAMOTO (skawa@jaist.ac.jp)
# coded by Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
#
##################################################################
# ɸ⥸塼μ
use strict;
use IPC::Open2;
use IO::Handle;
use IO::Select;

# by nishi
my( %COUNT );	# counter for various action
my( $debug ) = 0;	# set verbose mode if 1
sub print_debug{
    $COUNT{'debugout'}++;
    print( STDERR "From \@DM-MCL tell debug$COUNT{'debugout'}: @_") if $debug ;	# debug out
}

### ϤΥ֥å󥰤ˤ
#select(STDIN); $| = 1;
#select(STDOUT); $| = 1;
#STDOUT->autoflush(1);
### Ԥ
my @bufline = ();		# ޥɼΥޥɥХåե
my @SetRunBufline = ();		# "set Run"ޥѤΥХåե
my @InqBufline = ();		# "inq"ޥѤΥХåե
my @SpeakBufline = ();		# "set Speak"ޥѤΥХåե
### STDIN timeout
my $timeout = 0.1;		# 100ms
### variables for select()
my $read_bits = '';
my $err_bits = '';
my $sel = IO::Select->new();
$sel->add(*STDIN);
my @ready;
### variables for STDIN readlines.
my ($STDINchar, $STDINstr, $readline);
### "set Run"ޥѿ
my $execFlagSetRun = 0;
### "inq"ޥѿ
my $execFlagInq = 0;
### "set Speak"ޥѿ
my $execFlagSpeak = 0;		# ¹ԥե饰
my $execStateSpeak = 0;		# ID
my $execSpeakPhones = "";	# ȯòǷ
my $execSpeakReadySSM = 0;	# νλե饰
my $execSpeakReadyFSM = 0;	# νλե饰
my $execSpeaking = 0;		# ȯե饰
my @tmp2Phone = ();
my @tmp2PhoneA = ();
my @tmp2PhoneB = ();
my $tmp1 = "";
my $tmp2 = "";
my $tmp3 = "";
my $tmp4 = "";
my $tmp1old = "";
my $tmp2old = "";
my $tmpPhoneNum = 0;
my $tmpDuration = 0;
my $SSM_silB_dur = 0;
my $SSM_wait_time = 0;
my $FSM_wait_time = 0;
### MCL_Macro
my $MacroReadline ='';
### exec*
my $ExecReadline ='';
my $MacroExecFlag = 0;		# Υǥޥ⥸塼ƤӽФ



### Ԥ
while (1) {
  $MacroExecFlag = 0;
  STDOUT->flush();
  STDERR->flush();
  # ɸϤɤ߹ #################################
  ### select()ؿν
  $read_bits = '';
  $err_bits = '';
  vec($read_bits, fileno(STDIN), 1) = 1;
  $err_bits=$read_bits;
  select($read_bits, undef, $err_bits, $timeout);
  if (vec($read_bits, fileno(STDIN), 1)) { # STDINɤ߹߲ǽʤ
    # ʸɤ߹
    	STDIN->sysread($STDINchar, 1) or die("read-net:$!");
    #	STDIN->sysread($STDINchar, 1) or next;
    	$STDINstr .= $STDINchar;
    #$STDINstr = <STDIN>;
    #$STDINchar = "\n";
    if ($STDINchar =~ /\n/) {	# ɤ߹ߴλ
      if ($STDINstr =~ /^\s*\n$/ || $STDINstr eq "") {
	# ԤSKIP
      } elsif ($STDINstr =~ /^\s*From/) { # moduleν
	MCL_Macro($STDINstr); # ¨ޥϤ
	$MacroExecFlag = 1;
      } elsif ($STDINstr =~ /^\s*set\s+Speak\s*=\s*STOP\s*$/) {
	# set Speak = STOP
	MCL_Macro($STDINstr); # ¨ޥϤ
      }	else {			# ޥޥ
	push(@bufline,$STDINstr); # ޥɤХåեݻ
      }
      $STDINstr = '';		# 
    }
  }
  # ХåեΥޥɽ #################################
  if($MacroExecFlag!=1){
    if ($#bufline<0) {		 # ХåեΤȤ
      # оݥޥɤ̵ΤSKIP
    } else {			# Хåե˥ޥɤ߹ߺѤߤΤȤ
      if (Check_MCL_Macro()==0) { # ޥǤʤ
	$readline = shift(@bufline);
	MCL_Macro($readline);	# ޥ˥ޥɤϤ
      }
    }
  }
}
exit(1);
##################################################################
# ޥޥɽ⥸塼
my $insideBlock = 0;
my $insideRecogOut = 0;

sub MCL_Macro{
    my $content;

  ($MacroReadline) = @_;
  $_ = $MacroReadline;
  chomp;

    # by nishi
    # "From @MON" ǤϤޤ or "to @???" ǤϤޤ
    if (/^From \@MON (.*)$/) {
	print STDOUT "to \@MON set SysLogText = $1\n";
	STDOUT->flush();
    }
    if (/^to /) {
	print STDOUT "to \@MON set SysLogText = $_\n";
	STDOUT->flush();
    }

  if (/^From/) {		# moduleν
    if (Check_SetRun()!=0) {	# "set Run"ޥʤ
      execSetRun($MacroReadline);
    }
    if (Check_Inq()!=0) {	# "inq"ޥʤ
      execInq($MacroReadline);
    }

    # by nishi 
    #
    # From @SRM tell <INPUT STATUS="STARTREC" TIME="1051946298"/>
    # From @SRM tell <INPUT STATUS="ENDREC" TIME="1051946300"/>
    # From @SRM tell << EOM
    # From @SRM <RECOGOUT>
    # From @SRM   <SHYPO RANK="1" SCORE="-3556.441895" GRAM="5">
    # From @SRM     <WHYPO WORD="silB" CLASSID="15" PHONE="silB"/>
    # From @SRM     <WHYPO WORD="꤬Ȥ" CLASSID="13" PHONE="a r i g a t o:"/>
    # From @SRM     <WHYPO WORD="silE" CLASSID="16" PHONE="silE"/>
    # From @SRM   </SHYPO>
    # From @SRM </RECOGOUT>
    # From @SRM EOM
    # From @SRM tell <INPUT STATUS="LISTEN" TIME="1051946300"/>

    # From @SRM tell <INPUT STATUS="STARTREC" TIME="1051946298"/>
    # From @SRM tell <INPUT STATUS="ENDREC" TIME="1051946300"/>
    # From @SRM tell <RECOGFAIL>
    # From @SRM tell <INPUT STATUS="LISTEN" TIME="1051946300"/>

    # From @SRM tell grammar send complete

    if ($MacroReadline =~ /^\s*From\s+\@SRM\s+(.*)$/) {
	if ( $1 =~ m/tell\s+<<\s+EOM/ ) {
	    # tell << EOM
	    print_debug("Block = BEGIN\n");
	    $insideBlock = 1;
	} elsif ( $1 =~ m/EOM/ ) {
	    # EOM
	    print_debug("Block = END\n");
	    $insideBlock = 0;
	} elsif ( $1 =~ m/tell\s+<INPUT\s+(.*)\/>$/ ) {
	    # <INPUT STATUS=??
	    print_debug("RecogStatus = $1\n");
	    print STDOUT "to \@SIM set RecogStatus = $1\n";
	    STDOUT->flush();
	} elsif ( $1 =~ m/tell\s+<RECOGFAIL>$/ ) {
	    # <INPUT STATUS=??
	    print_debug("RecogStatus = RECOGFAIL\n");
	    print STDOUT "to \@SIM set RecogStatus = RECOGFAIL\n";
	    STDOUT->flush();
	} elsif ( $1 =~ m/tell grammar conversion complete/ ) {
	    # 
	    print_debug("RecogStatus = GRAMMAR_CONVERSION_COMPLETE\n");
	    print STDOUT "to \@SIM set RecogStatus = GRAMMAR_CONVERSION_COMPLETE\n";
	    STDOUT->flush();
	} elsif ( $1 =~ m/tell grammar send complete/ ) {
	    # 
	    print_debug("RecogStatus = GRAMMAR_SEND_COMPLETE\n");
	    print STDOUT "to \@SIM set RecogStatus = GRAMMAR_SEND_COMPLETE\n";
	    STDOUT->flush();
	} elsif ( $1 =~ m/tell error/ ) {
	    #
	    print_debug("RecogStatus = GRAMMAR_ERROR\n");
	    print STDOUT "to \@SIM set RecogStatus = GRAMMAR_ERROR\n";
	    STDOUT->flush();
	} elsif ( $1 =~ m/tell unsupported/ ) {
	    #
	    print_debug("RecogStatus = GRAMMAR_ERROR\n");
	    print STDOUT "to \@SIM set RecogStatus = GRAMMAR_ERROR\n";
	    STDOUT->flush();
	} elsif ( $1 =~ m/tell grammar conversion failed/ ) {
	    #
	    print_debug("RecogStatus = GRAMMAR_ERROR\n");
	    print STDOUT "to \@SIM set RecogStatus = GRAMMAR_ERROR\n";
	    STDOUT->flush();
	} else {
	    if ($insideBlock) {
		$content = $1; 
		if ( $content =~ m/<RECOGOUT>/ ) {
		    $insideRecogOut = 1;
		    print STDOUT "to \@SIM set RecogOut = $content\n";
		    STDOUT->flush();
		} elsif ( $content =~ m/<\/RECOGOUT>/ ) {
		    print STDOUT "to \@SIM set RecogOut = $content\n";
		    STDOUT->flush();
		    $insideRecogOut = 0;
		} else {
		    if ( $insideRecogOut ) {
			print STDOUT "to \@SIM set RecogOut = $content\n";
			STDOUT->flush();
		    }
		}
	    } else {
		print_debug("RecogOut = IGNORE $1\n");
	    }
	}
    }

    #
    # GUI,MON,SIM  to @XXX ޥɤۿ
    #
    if ($MacroReadline =~ /^\s*From\s+\@GUI\s+(.*)$/) {
	print STDOUT "$1\n";
	STDOUT->flush();
    }

    if ($MacroReadline =~ /^\s*From\s+\@MON\s+(.*)$/) {
	print STDOUT "$1\n";
	STDOUT->flush();
    }

    if ($MacroReadline =~ /^\s*From\s+\@SIM\s+(.*)$/) {
	print STDOUT "$1\n";
	STDOUT->flush();
    }

    #
    # PAR  SSM/FSM ̿
    #

    if ($MacroReadline =~ /^\s*From\s+\@PAR\s+(.*)$/) {
	print STDOUT "$1\n";
	STDOUT->flush();
    }

    if ($MacroReadline =~ /^\s*From\s+\@SSM\s+rep\s+Speak\.stat\s*=\s*(.*)$/) {
	print STDOUT "to \@PAR set SSMSpeak.stat = $1\n";
	STDOUT->flush();
    }

    if ($MacroReadline =~ /^\s*From\s+\@FSM\s+rep\s+Speak\.stat\s*=\s*(.*)$/) {
	print STDOUT "to \@PAR set FSMSpeak.stat = $1\n";
	STDOUT->flush();
    }

  } else {			# ޥޥ
    if ($MacroReadline =~ /^\s*macro\s+(.*)/) {	# Ƭ"macro"cut
      $MacroReadline = $1;
    }

    # "set Run"ޥ
    if ($MacroReadline =~ /set\s+Run\./) {
      if (Check_SetRun()==0) {	# "set Run"ޥǤʤ
	if ($#SetRunBufline<0) {  # Хåե
	  # ꥳޥɤ¨¹
	} else {
	  # ꥳޥɤϥХåեݻ
	  push(@SetRunBufline,$MacroReadline);
	  # ХåեƬޥɤ¹
	  $MacroReadline = shift(@SetRunBufline);
	}
	execSetRun($MacroReadline); # ޥɼ¹
      } else {
	push(@SetRunBufline,$MacroReadline); # ޥɤХåեݻ
      }
    }
    # "inq"ޥ
    if ($MacroReadline =~ /inq/) {
      if (Check_Inq()==0) {	# "inq"ޥǤʤ
	if ($#InqBufline<0) { 	# Хåե
	  # ꥳޥɤ¨¹
	} else {
	  # ꥳޥɤϥХåեݻ
	  push(@InqBufline,$MacroReadline);
	  # ХåեƬޥɤ¹
	  $MacroReadline = shift(@InqBufline);
	}
	execInq($MacroReadline); # ޥɼ¹
      } else {
	push(@InqBufline,$MacroReadline); # ޥɤХåեݻ
      }
    }
  }
}
##################################################################
# ޥޥɽå⥸塼
sub Check_SetRun{		# "set Run"ޥɼ¹Ծ
  $execFlagSetRun;
}
sub Check_Inq{			# "inq"ޥɼ¹Ծ
  $execFlagInq;
}
sub Check_Speak{		# "set Speak"ޥɼ¹Ծ
  $execFlagSpeak;
}
sub Check_MCL_Macro{
  $execFlagSpeak;
  #    if($execFlagSetRun==0
  #       && $execFlagInq==0
  #       && $execFlagSpeak==0){
  #	0;
  #    }else{
  #	1;
  #    }
}
##################################################################
# ƥޥɤμ¹ԥ⥸塼
sub execSetRun{			# "set Run"¹ԥޥ
  ($ExecReadline) = @_;

  $execFlagSetRun = 1;		# ¹
  #
  # set Run.(⥸塼̾) = ()
  #
  $_ = $ExecReadline;
  chomp;
  if (/^set\s+Run\.(\S+)\s*=\s*(\S+)\s*$/) {
    my ($com,$slot,$module,$value);
    $com = "set";
    $slot = "Run";
    $module = $1;
    $value = $2;
    print STDOUT "to \@$module $com $slot = $value\n";
    STDOUT->flush();
  }
  $execFlagSetRun = 0;		# ¹
}
#-----------------------------------------------------------------
sub execInq{			# "inq"¹ԥޥ
  ($ExecReadline) = @_;

  $execFlagInq = 1;		# ¹
  #
  # inq (Run|ProtocolVersion|ModuleVersion).(⥸塼̾)
  #
  $_ = $ExecReadline;
  chomp;
  if (/^inq\s+(Run|ProtocolVersion|ModuleVersion)\.(\S+)\s*$/) {
    my ($com,$slot,$module);
    $com = "inq";
    $slot = $1;
    $module = $2;
    print STDOUT "to \@$module $com $slot\n";
    STDOUT->flush();
  }
  elsif (/^inq\s+Speak\.(\S+)\s*$/) {
    my ($com,$slot,$module);
    $com = "inq";
    $slot = "Speak.$1";
    $module = "SSM";		# 䤤碌⥸塼ϲ⥸塼˸
    print STDOUT "to \@$module $com $slot\n";
    STDOUT->flush();
  }
  $execFlagInq = 0;		# ¹
}
#-----------------------------------------------------------------

##################################################################
# EOF
##################################################################
