/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;

public class Util {
    public static void halt() {
        System.err.println("Dialog Manager Halted. Press Ctrl-C to quit.");
        while (true) {
            // Infinite loop
        }
    }

    public static void halt(String string) {
        System.err.println(string);
        Util.halt();
    }

    public static String removeSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString();
    }

    public static String xmlSafeRemoveSpaces(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("<") && !string2.equals("<")) {
                bl = true;
            }
            if (string2.endsWith(">")) {
                bl = false;
            }
            stringBuffer.append(string2);
            if (!bl) continue;
            stringBuffer.append(" ");
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString();
    }

    public static String removeNewLines(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString();
    }

    public static String encodeXmlChars(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String decodeXmlChars(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        string2 = string2.replaceAll("&lt;", "<");
        string2 = string2.replaceAll("&gt;", ">");
        string2 = string2.replaceAll("&amp;", "&");
        return string2;
    }

    public static String resolveAdrs(String string, String string2) {
        String string3;
        if (string == null || string2 == null) {
            return "";
        }
        try {
            URI uRI = new URI(string);
            URI uRI2 = new URI(string2);
            URI uRI3 = uRI.resolve(uRI2);
            string3 = uRI3.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            string3 = "_error_resolveAdrs_";
        }
        return string3;
    }

    public static boolean isSameFile(String string, String string2) {
        boolean bl = false;
        try {
            URI uRI = new URI(string);
            URI uRI2 = new URI(string2);
            URI uRI3 = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI2.getFragment());
            if (uRI2.equals(uRI3)) {
                bl = true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "if (1<=num && 2>nantoka) {infiniteLoop}";
        System.out.println(string);
        string = Util.encodeXmlChars(string);
        System.out.println(string);
        string = Util.decodeXmlChars(string);
        System.out.println(string);
    }
}

