/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import main.Debug;

public class SubProcess {
    private Debug dbg = new Debug(8);
    private String module_command;
    private Runtime rt;
    private Process child;
    private InputStream out;
    private InputStream err;
    private OutputStream in;
    private PrintStream stdin;
    private BufferedReader stdout;
    private BufferedReader stderr;
    private boolean running = false;

    public SubProcess() {
    }

    public SubProcess(String string) {
        this();
        this.module_command = string;
    }

    public void SetCommand(String string) {
        this.module_command = string;
    }

    public boolean Run() {
        String[] stringArray = new String[3];
        if (this.module_command.length() == 0) {
            this.dbg.err("SubProcess.Run(): 'module_command' is undefined.");
            return false;
        }
        stringArray[0] = "/bin/sh";
        stringArray[1] = "-c";
        stringArray[2] = this.module_command;
        this.rt = Runtime.getRuntime();
        try {
            this.child = this.rt.exec(stringArray);
        }
        catch (IOException iOException) {
            this.dbg.err("SubProcess.Run(): Runtime.exec() failed.");
            return false;
        }
        this.in = this.child.getOutputStream();
        this.out = this.child.getInputStream();
        this.err = this.child.getErrorStream();
        this.stdin = new PrintStream(this.in);
        this.stdout = new BufferedReader(new InputStreamReader(this.out));
        this.stderr = new BufferedReader(new InputStreamReader(this.err));
        this.running = true;
        return true;
    }

    public boolean IsRunning() {
        return this.running;
    }

    public void ToStdin(String string) {
        this.dbg.print("ToStdin: " + string, 9);
        this.stdin.println(string);
        this.stdin.flush();
    }

    public String FromStdout() {
        String string;
        try {
            string = this.stdout.readLine();
            this.dbg.print("FromStdout: " + string, 9);
        }
        catch (IOException iOException) {
            this.dbg.err("SubProcess.FromStdout(): BufferedReader.readLine() failed.", 8);
            return null;
        }
        return string;
    }

    public String FromStdoutNB() {
        String string;
        try {
            if (this.stdout.ready()) {
                string = this.stdout.readLine();
                this.dbg.print("FromStdoutNB: " + string, 9);
            } else {
                string = "";
            }
        }
        catch (IOException iOException) {
            this.dbg.err("SubProcess.FromStdout(): BufferedReader.readLine() failed.");
            return null;
        }
        return string;
    }

    public String FromStderr() {
        String string;
        try {
            string = this.stderr.readLine();
        }
        catch (IOException iOException) {
            this.dbg.err("SubProcess.FromStderr(): BufferedReader.readLine() failed.");
            return null;
        }
        return string;
    }

    public String FromStderrNB() {
        String string;
        try {
            string = this.stderr.ready() ? this.stderr.readLine() : "";
        }
        catch (IOException iOException) {
            this.dbg.err("SubProcess.FromStderr(): BufferedReader.readLine() failed.");
            return null;
        }
        return string;
    }

    public InputStream GetStdout() {
        if (this.running) {
            return this.out;
        }
        return null;
    }

    public InputStream GetStderr() {
        if (this.running) {
            return this.err;
        }
        return null;
    }

    public OutputStream GetStdin() {
        if (this.running) {
            return this.in;
        }
        return null;
    }

    public void waitFor() throws InterruptedException {
        this.child.waitFor();
    }

    public void destroy() {
        this.child.destroy();
    }

    public int exitValue() throws IllegalThreadStateException {
        return this.child.exitValue();
    }
}

