/*
 * Decompiled with CFR 0.152.
 */
package relaxer.vxml20;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.vxml20.IRNSContainer;
import relaxer.vxml20.IRNode;
import relaxer.vxml20.IRVisitable;
import relaxer.vxml20.IRVisitor;
import relaxer.vxml20.IVxmlVxmlChoice;
import relaxer.vxml20.RNSContext;
import relaxer.vxml20.RStack;
import relaxer.vxml20.UJAXP;
import relaxer.vxml20.URelaxer;
import relaxer.vxml20.URelaxer2;

public class VxmlMeta
implements Serializable,
Cloneable,
IRNSContainer,
IRVisitable,
IRNode,
IVxmlVxmlChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String name_;
    private String content_;
    private String httpEquiv_;
    private IRNode parentRNode_;

    public VxmlMeta() {
        this.content_ = "";
    }

    public VxmlMeta(VxmlMeta vxmlMeta) {
        this.setup(vxmlMeta);
    }

    public VxmlMeta(RStack rStack) {
        this.setup(rStack);
    }

    public VxmlMeta(Document document) {
        this.setup(document.getDocumentElement());
    }

    public VxmlMeta(Element element) {
        this.setup(element);
    }

    public VxmlMeta(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public VxmlMeta(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public VxmlMeta(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public VxmlMeta(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public VxmlMeta(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public VxmlMeta(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(VxmlMeta vxmlMeta) {
        this.setName(vxmlMeta.getName());
        this.setContent(vxmlMeta.getContent());
        this.setHttpEquiv(vxmlMeta.getHttpEquiv());
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.init(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.content_ = URelaxer.getAttributePropertyAsString(element, "content");
        this.httpEquiv_ = URelaxer.getAttributePropertyAsString(element, "http-equiv");
    }

    public Object clone() {
        return new VxmlMeta(this);
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "meta");
        this.rNSContext_.setupNamespace(element);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.content_ != null) {
            URelaxer.setAttributePropertyByString(element, "content", this.content_);
        }
        if (this.httpEquiv_ != null) {
            URelaxer.setAttributePropertyByString(element, "http-equiv", this.httpEquiv_);
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 2));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 2));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 2));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String string) {
        this.name_ = string;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String string) {
        this.content_ = string;
    }

    public final String getHttpEquiv() {
        return this.httpEquiv_;
    }

    public final void setHttpEquiv(String string) {
        this.httpEquiv_ = string;
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        String string = this.rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        stringBuffer.append("<");
        URelaxer.makeQName(string, "meta", stringBuffer);
        this.rNSContext_.makeNSMappings(stringBuffer);
        if (this.name_ != null) {
            stringBuffer.append(" ");
            stringBuffer.append("name");
            stringBuffer.append("=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            stringBuffer.append("\"");
        }
        if (this.content_ != null) {
            stringBuffer.append(" ");
            stringBuffer.append("content");
            stringBuffer.append("=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getContent())));
            stringBuffer.append("\"");
        }
        if (this.httpEquiv_ != null) {
            stringBuffer.append(" ");
            stringBuffer.append("http-equiv");
            stringBuffer.append("=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHttpEquiv())));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append("</");
        URelaxer.makeQName(string, "meta", stringBuffer);
        stringBuffer.append(">");
    }

    public void makeTextElement(Writer writer) throws IOException {
        String string = this.rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        writer.write("<");
        URelaxer.makeQName(string, "meta", writer);
        this.rNSContext_.makeNSMappings(writer);
        if (this.name_ != null) {
            writer.write(" ");
            writer.write("name");
            writer.write("=\"");
            writer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            writer.write("\"");
        }
        if (this.content_ != null) {
            writer.write(" ");
            writer.write("content");
            writer.write("=\"");
            writer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getContent())));
            writer.write("\"");
        }
        if (this.httpEquiv_ != null) {
            writer.write(" ");
            writer.write("http-equiv");
            writer.write("=\"");
            writer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHttpEquiv())));
            writer.write("\"");
        }
        writer.write(">");
        writer.write("</");
        URelaxer.makeQName(string, "meta", writer);
        writer.write(">");
    }

    public void makeTextElement(PrintWriter printWriter) {
        String string = this.rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        printWriter.print("<");
        URelaxer.makeQName(string, "meta", printWriter);
        this.rNSContext_.makeNSMappings(printWriter);
        if (this.name_ != null) {
            printWriter.print(" ");
            printWriter.print("name");
            printWriter.print("=\"");
            printWriter.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            printWriter.print("\"");
        }
        if (this.content_ != null) {
            printWriter.print(" ");
            printWriter.print("content");
            printWriter.print("=\"");
            printWriter.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getContent())));
            printWriter.print("\"");
        }
        if (this.httpEquiv_ != null) {
            printWriter.print(" ");
            printWriter.print("http-equiv");
            printWriter.print("=\"");
            printWriter.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHttpEquiv())));
            printWriter.print("\"");
        }
        printWriter.print(">");
        printWriter.print("</");
        URelaxer.makeQName(string, "meta", printWriter);
        printWriter.print(">");
    }

    public void makeTextAttribute(StringBuffer stringBuffer) {
    }

    public void makeTextAttribute(Writer writer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter printWriter) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getHttpEquivAsString() {
        return URelaxer.getString(this.getHttpEquiv());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setHttpEquivByString(String string) {
        this.setHttpEquiv(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public boolean enter(IRVisitor iRVisitor) {
        return iRVisitor.enter(this);
    }

    public void leave(IRVisitor iRVisitor) {
        iRVisitor.leave(this);
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode iRNode) {
        this.parentRNode_ = iRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList arrayList = new ArrayList();
        IRNode[] iRNodeArray = new IRNode[arrayList.size()];
        return arrayList.toArray(iRNodeArray);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "meta")) {
            return false;
        }
        RStack rStack = new RStack(element);
        boolean bl = false;
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return VxmlMeta.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (VxmlMeta.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

