/*
 * Decompiled with CFR 0.152.
 */
package relaxer.vxml20;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class RStack {
    private Element element_;
    private Object[] children_;
    private HashSet consumedAttrNodes_ = null;
    private HashSet consumedElementNodes_ = null;
    private HashMap pi_ = new HashMap();
    private int index_;

    protected RStack() {
    }

    public RStack(Element element) {
        this.element_ = element;
        NodeList nodeList = element.getChildNodes();
        ArrayList arrayList = new ArrayList();
        this._makeList(nodeList, arrayList);
        int n = arrayList.size();
        this.children_ = new Object[n];
        this.children_ = arrayList.toArray(this.children_);
        this.index_ = 0;
    }

    private void _makeList(NodeList nodeList, List list) {
        int n = nodeList.getLength();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                if (stringBuffer != null) {
                    list.add(new String(stringBuffer));
                    stringBuffer = null;
                }
                list.add(node);
                continue;
            }
            if (node instanceof Text) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(((Text)node).getData());
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                this.pi_.put(processingInstruction.getTarget(), processingInstruction.getData());
                continue;
            }
            if (!(node instanceof EntityReference)) continue;
            this._makeList(node.getChildNodes(), list);
        }
        if (stringBuffer != null) {
            list.add(new String(stringBuffer));
        }
    }

    public Element getContextElement() {
        return this.element_;
    }

    public boolean isEmpty() {
        return this.index_ == this.children_.length;
    }

    public boolean isEmptyElement() {
        if (this.index_ == this.children_.length) {
            return true;
        }
        for (int i = this.index_; i < this.children_.length; ++i) {
            if (!(this.children_[i] instanceof Element)) continue;
            return false;
        }
        return true;
    }

    public Object pop() {
        return this.children_[this.index_++];
    }

    public Object peek() {
        if (this.index_ == this.children_.length) {
            return null;
        }
        return this.children_[this.index_];
    }

    public Element popElement() {
        if (this.index_ == this.children_.length) {
            return null;
        }
        while (this.index_ < this.children_.length) {
            Object object;
            if (!((object = this.children_[this.index_++]) instanceof Element)) continue;
            return (Element)object;
        }
        return null;
    }

    public Element peekElement() {
        if (this.index_ == this.children_.length) {
            return null;
        }
        for (int i = this.index_; i < this.children_.length; ++i) {
            Object object = this.children_[i];
            if (!(object instanceof Element)) continue;
            return (Element)object;
        }
        return null;
    }

    public Element[] peekElements() {
        if (this.index_ == this.children_.length) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = this.index_; i < this.children_.length; ++i) {
            Object object = this.children_[i];
            if (!(object instanceof Element)) continue;
            arrayList.add(object);
        }
        Element[] elementArray = new Element[arrayList.size()];
        return arrayList.toArray(elementArray);
    }

    public Map getPIMap() {
        return (Map)this.pi_.clone();
    }

    public boolean isConsumedElement(Attr attr) {
        if (this.consumedElementNodes_ == null) {
            return false;
        }
        return this.consumedElementNodes_.contains(attr);
    }

    public void consumeElement(Attr attr) {
        if (this.consumedElementNodes_ == null) {
            this.consumedElementNodes_ = new HashSet();
        }
        this.consumedElementNodes_.add(attr);
    }

    public boolean isConsumedAttribute(Attr attr) {
        if (this.consumedAttrNodes_ == null) {
            return false;
        }
        return this.consumedAttrNodes_.contains(attr);
    }

    public void consumeAttribute(Attr attr) {
        if (attr == null) {
            return;
        }
        if (this.consumedAttrNodes_ == null) {
            this.consumedAttrNodes_ = new HashSet();
        }
        this.consumedAttrNodes_.add(attr);
    }

    public void addDirectAttributes(Map map) {
        NamedNodeMap namedNodeMap = this.element_.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (this.isConsumedAttribute(attr)) continue;
            map.put(attr.getName(), attr.getValue());
        }
    }

    public RStack makeClone() {
        RStack rStack = new RStack();
        rStack.element_ = this.element_;
        rStack.children_ = (Object[])this.children_.clone();
        if (this.consumedAttrNodes_ != null) {
            rStack.consumedAttrNodes_ = (HashSet)this.consumedAttrNodes_.clone();
        }
        if (this.consumedElementNodes_ != null) {
            rStack.consumedElementNodes_ = (HashSet)this.consumedElementNodes_.clone();
        }
        rStack.pi_ = (HashMap)this.pi_.clone();
        rStack.index_ = this.index_;
        return rStack;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.index_ < this.children_.length) {
            Object object = this.children_[this.index_];
            stringBuffer.append(object);
            for (int i = this.index_ + 1; i < this.children_.length; ++i) {
                stringBuffer.append(",");
                object = this.children_[i];
                stringBuffer.append(object);
            }
        }
        stringBuffer.append("]");
        return new String(stringBuffer);
    }
}

