/*
 * Decompiled with CFR 0.152.
 */
package relaxer.vxml20;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import relaxer.vxml20.IRNSContainer;
import relaxer.vxml20.IRNode;
import relaxer.vxml20.URelaxer;

public class RNSContext
implements Serializable {
    private static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    private IRNode rnode_;
    private String namespaceUri_;
    private Map prefixByUri_ = new HashMap();
    private Map uriByPrefix_ = new HashMap();

    public RNSContext(IRNode iRNode, String string) {
        this.rnode_ = iRNode;
        this.namespaceUri_ = string;
    }

    public void declareNamespace(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string2 = attr.getName();
            if (string2.startsWith("xmlns:")) {
                string = attr.getValue();
                String string3 = string2.substring("xmlns:".length());
                this.declareNamespace(string3, string);
                if (!string3.equals(element.getPrefix())) continue;
                this._updateNamespaceUri(string);
                continue;
            }
            if (!string2.startsWith("xmlns")) continue;
            string = attr.getValue();
            this.declareNamespace("", string);
            this._updateNamespaceUri(string);
        }
    }

    public void declareNamespace(String string, String string2) {
        this.prefixByUri_.put(string2, string);
        this.uriByPrefix_.put(string, string2);
    }

    public void setupNamespace(Element element) {
        this._setupNamespaceTagPrefix(element);
        this._setupNamespacePrefixDeclare(element);
    }

    private void _setupNamespaceTagPrefix(Element element) {
        String string;
        String string2 = element.getNamespaceURI();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.getPrefixByUri(string2)) != null) {
            IRNSContainer iRNSContainer;
            if (!"".equals(string)) {
                element.setPrefix(string);
            }
            if ((iRNSContainer = (IRNSContainer)((Object)this.rnode_.rGetParentRNode())) == null) {
                this.addPrefixDecl(element, string, string2);
                return;
            }
            RNSContext rNSContext = iRNSContainer.rGetRNSContext();
            String string3 = rNSContext.getPrefixByUri(string2);
            if (!string.equals(string3)) {
                this.addPrefixDecl(element, string, string2);
            }
        } else {
            IRNSContainer iRNSContainer = (IRNSContainer)((Object)this.rnode_.rGetParentRNode());
            if (iRNSContainer == null) {
                if ("".equals(string2)) {
                    return;
                }
                this.addPrefixDecl(element, null, string2);
                return;
            }
            RNSContext rNSContext = iRNSContainer.rGetRNSContext();
            if (!string2.equals(rNSContext.getNamespaceUri())) {
                this.addPrefixDecl(element, string, string2);
                return;
            }
            String string4 = rNSContext.getPrefixByUri(string2);
            if (string4 != null) {
                this.addPrefixDecl(element, string, string2);
            }
        }
    }

    private void _setupNamespacePrefixDeclare(Element element) {
        String string = element.getNamespaceURI();
        if (string == null) {
            string = "";
        }
        Set set = this.prefixByUri_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            if (string.equals(string3) || (string2 = (String)this.prefixByUri_.get(string3)) == null) continue;
            this.addPrefixDecl(element, string2, string3);
        }
    }

    public void addPrefixDecl(Element element, String string, String string2) {
        try {
            this._addPrefixDeclDOM2(element, string, string2);
        }
        catch (DOMException dOMException) {
            this._addPrefixDeclXerces(element, string, string2);
        }
    }

    private void _addPrefixDeclXerces(Element element, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (string == null || "".equals(string)) {
            Document document = element.getOwnerDocument();
            Attr attr = document.createAttribute("xmlns");
            attr.setValue(string2);
            element.setAttributeNode(attr);
        } else {
            Document document = element.getOwnerDocument();
            Attr attr = document.createAttribute("xmlns:" + string);
            attr.setValue(string2);
            element.setAttributeNode(attr);
        }
    }

    private void _addPrefixDeclDOM2(Element element, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (string == null || "".equals(string)) {
            Document document = element.getOwnerDocument();
            Attr attr = document.createAttributeNS(XMLNS_NS, "xmlns");
            attr.setValue(string2);
            element.setAttributeNode(attr);
        } else {
            Document document = element.getOwnerDocument();
            Attr attr = document.createAttributeNS(XMLNS_NS, "xmlns:" + string);
            attr.setValue(string2);
            element.setAttributeNode(attr);
        }
    }

    public void startNSMappings(ContentHandler contentHandler) {
        Set set = this.prefixByUri_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.prefixByUri_.get(string);
            try {
                contentHandler.startPrefixMapping(string2, string);
            }
            catch (SAXException sAXException) {}
        }
    }

    public void endNSMappings(ContentHandler contentHandler) {
        Set set = this.prefixByUri_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.prefixByUri_.get(string);
            try {
                contentHandler.endPrefixMapping(string2);
            }
            catch (SAXException sAXException) {}
        }
    }

    public void makeNSMappings(StringBuffer stringBuffer) {
        if (this.rnode_.rGetParentRNode() == null && this.getPrefixByUri(this.namespaceUri_) == null && !"".equals(this.namespaceUri_)) {
            stringBuffer.append(URelaxer.getNSMapping("", this.namespaceUri_));
        }
        Set set = this.prefixByUri_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(this.makeNSMapping(string));
        }
    }

    public void makeNSMappings(Writer writer) throws IOException {
        if (this.rnode_.rGetParentRNode() == null && this.getPrefixByUri(this.namespaceUri_) == null && !"".equals(this.namespaceUri_)) {
            writer.write(URelaxer.getNSMapping("", this.namespaceUri_));
        }
        Set set = this.prefixByUri_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            writer.write(this.makeNSMapping(string));
        }
    }

    public void makeNSMappings(PrintWriter printWriter) {
        if (this.rnode_.rGetParentRNode() == null && this.getPrefixByUri(this.namespaceUri_) == null && !"".equals(this.namespaceUri_)) {
            printWriter.print(URelaxer.getNSMapping("", this.namespaceUri_));
        }
        Set set = this.prefixByUri_.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            printWriter.print(this.makeNSMapping(string));
        }
    }

    public String makeQName(String string, String string2) {
        return URelaxer.getQName(this.getPrefixByUri(string), string2);
    }

    public void makeQName(String string, String string2, StringBuffer stringBuffer) {
        URelaxer.makeQName(this.getPrefixByUri(string), string2, stringBuffer);
    }

    public void makeQName(String string, String string2, Writer writer) throws IOException {
        URelaxer.makeQName(this.getPrefixByUri(string), string2, writer);
    }

    public void makeQName(String string, String string2, PrintWriter printWriter) {
        URelaxer.makeQName(this.getPrefixByUri(string), string2, printWriter);
    }

    public String makeNSMapping(String string) {
        String string2 = (String)this.prefixByUri_.get(string);
        if (string2 == null) {
            return "";
        }
        return URelaxer.getNSMapping(string2, string);
    }

    public String getNamespaceUri() {
        return this.namespaceUri_;
    }

    private void _updateNamespaceUri(String string) {
        this.namespaceUri_ = string;
    }

    public String getPrefix() {
        return this.getPrefixByUri(this.namespaceUri_);
    }

    public void setPrefix(String string) {
        this.declareNamespace(string, this.namespaceUri_);
    }

    public String getPrefixByUri(String string) {
        if (XML_NS.equals(string)) {
            return "xml";
        }
        if (XMLNS_NS.equals(string)) {
            return "xmlns";
        }
        String string2 = (String)this.prefixByUri_.get(string);
        if (string2 != null) {
            return string2;
        }
        IRNSContainer iRNSContainer = (IRNSContainer)((Object)this.rnode_.rGetParentRNode());
        if (iRNSContainer == null) {
            return null;
        }
        return iRNSContainer.rGetRNSContext().getPrefixByUri(string);
    }

    public String getUriByPrefix(String string) {
        if ("xml".equals(string)) {
            return XML_NS;
        }
        if ("xmlns".equals(string)) {
            return XMLNS_NS;
        }
        String string2 = (String)this.uriByPrefix_.get(string);
        if (string2 != null) {
            return string2;
        }
        IRNSContainer iRNSContainer = (IRNSContainer)((Object)this.rnode_.rGetParentRNode());
        if (iRNSContainer == null) {
            return null;
        }
        return iRNSContainer.rGetRNSContext().getUriByPrefix(string);
    }

    public String getDefaultNamespace() {
        return this.getUriByPrefix("");
    }
}

