/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.PdocBody;
import relaxer.pdoc.PdocHead;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocPdoc
implements Serializable,
Cloneable {
    private float version_;
    private PdocHead head_;
    private PdocBody body_;

    public PdocPdoc() {
    }

    public PdocPdoc(PdocPdoc pdocPdoc) {
        this.setup(pdocPdoc);
    }

    public PdocPdoc(RStack rStack) {
        this.setup(rStack);
    }

    public PdocPdoc(Document document) {
        this.setup(document.getDocumentElement());
    }

    public PdocPdoc(Element element) {
        this.setup(element);
    }

    public PdocPdoc(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocPdoc(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public PdocPdoc(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public PdocPdoc(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public PdocPdoc(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public PdocPdoc(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocPdoc pdocPdoc) {
        this.setVersion(pdocPdoc.getVersion());
        this.setHead((PdocHead)pdocPdoc.getHead().clone());
        this.setBody((PdocBody)pdocPdoc.getBody().clone());
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.init(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.version_ = URelaxer.getAttributePropertyAsFloat(element, "version");
        this.setHead(new PdocHead(rStack));
        this.setBody(new PdocBody(rStack));
    }

    public Object clone() {
        return new PdocPdoc(this);
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("pdoc");
        URelaxer.setAttributePropertyByFloat(element, "version", this.version_);
        this.head_.makeElement(element);
        this.body_.makeElement(element);
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 0));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 0));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 0));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final float getVersion() {
        return this.version_;
    }

    public final void setVersion(float f) {
        this.version_ = f;
    }

    public final PdocHead getHead() {
        return this.head_;
    }

    public final void setHead(PdocHead pdocHead) {
        this.head_ = pdocHead;
    }

    public final PdocBody getBody() {
        return this.body_;
    }

    public final void setBody(PdocBody pdocBody) {
        this.body_ = pdocBody;
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<pdoc");
        stringBuffer.append(" version=\"");
        stringBuffer.append(URelaxer.getString(this.getVersion()));
        stringBuffer.append("\"");
        stringBuffer.append(">");
        this.head_.makeTextElement(stringBuffer);
        this.body_.makeTextElement(stringBuffer);
        stringBuffer.append("</pdoc>");
    }

    public void makeTextElement(Writer writer) throws IOException {
        writer.write("<pdoc");
        writer.write(" version=\"");
        writer.write(URelaxer.getString(this.getVersion()));
        writer.write("\"");
        writer.write(">");
        this.head_.makeTextElement(writer);
        this.body_.makeTextElement(writer);
        writer.write("</pdoc>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<pdoc");
        printWriter.print(" version=\"");
        printWriter.print(URelaxer.getString(this.getVersion()));
        printWriter.print("\"");
        printWriter.print(">");
        this.head_.makeTextElement(printWriter);
        this.body_.makeTextElement(printWriter);
        printWriter.print("</pdoc>");
    }

    public void makeTextAttribute(StringBuffer stringBuffer) {
    }

    public void makeTextAttribute(Writer writer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter printWriter) {
    }

    public String getVersionAsString() {
        return URelaxer.getString(this.getVersion());
    }

    public void setVersionByString(String string) {
        this.setVersion(Float.parseFloat(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "pdoc")) {
            return false;
        }
        RStack rStack = new RStack(element);
        boolean bl = false;
        if (!URelaxer.hasAttributeHungry(rStack, "version")) {
            return false;
        }
        bl = true;
        if (!PdocHead.isMatchHungry(rStack)) {
            return false;
        }
        bl = true;
        if (!PdocBody.isMatchHungry(rStack)) {
            return false;
        }
        bl = true;
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocPdoc.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocPdoc.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

