/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.IPdocHeadChoice;
import relaxer.pdoc.PdocGrammar;
import relaxer.pdoc.PdocJulian;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocHead
implements Serializable,
Cloneable {
    private IPdocHeadChoice content_;

    public PdocHead() {
    }

    public PdocHead(PdocHead pdocHead) {
        this.setup(pdocHead);
    }

    public PdocHead(RStack rStack) {
        this.setup(rStack);
    }

    public PdocHead(Document document) {
        this.setup(document.getDocumentElement());
    }

    public PdocHead(Element element) {
        this.setup(element);
    }

    public PdocHead(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocHead(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public PdocHead(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public PdocHead(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public PdocHead(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public PdocHead(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocHead pdocHead) {
        this.setContent((IPdocHeadChoice)pdocHead.getContent().clone());
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.init(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        if (PdocGrammar.isMatch(rStack)) {
            this.setContent(new PdocGrammar(rStack));
        } else if (PdocJulian.isMatch(rStack)) {
            this.setContent(new PdocJulian(rStack));
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Object clone() {
        return new PdocHead(this);
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("head");
        this.content_.makeElement(element);
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 0));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 0));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 0));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final IPdocHeadChoice getContent() {
        return this.content_;
    }

    public final void setContent(IPdocHeadChoice iPdocHeadChoice) {
        this.content_ = iPdocHeadChoice;
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<head");
        this.content_.makeTextAttribute(stringBuffer);
        stringBuffer.append(">");
        this.content_.makeTextElement(stringBuffer);
        stringBuffer.append("</head>");
    }

    public void makeTextElement(Writer writer) throws IOException {
        writer.write("<head");
        this.content_.makeTextAttribute(writer);
        writer.write(">");
        this.content_.makeTextElement(writer);
        writer.write("</head>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<head");
        this.content_.makeTextAttribute(printWriter);
        printWriter.print(">");
        this.content_.makeTextElement(printWriter);
        printWriter.print("</head>");
    }

    public void makeTextAttribute(StringBuffer stringBuffer) {
    }

    public void makeTextAttribute(Writer writer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter printWriter) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "head")) {
            return false;
        }
        RStack rStack = new RStack(element);
        boolean bl = false;
        if (PdocGrammar.isMatchHungry(rStack)) {
            bl = true;
        } else if (PdocJulian.isMatchHungry(rStack)) {
            bl = true;
        } else {
            return false;
        }
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocHead.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocHead.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

