/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.IPdocAddChoice;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocBreak
implements Serializable,
Cloneable,
IPdocAddChoice {
    private String content_;
    private Double length_;
    private Boolean bargein_;

    public PdocBreak() {
    }

    public PdocBreak(PdocBreak pdocBreak) {
        this.setup(pdocBreak);
    }

    public PdocBreak(RStack rStack) {
        this.setup(rStack);
    }

    public PdocBreak(Document document) {
        this.setup(document.getDocumentElement());
    }

    public PdocBreak(Element element) {
        this.setup(element);
    }

    public PdocBreak(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocBreak(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public PdocBreak(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public PdocBreak(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public PdocBreak(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public PdocBreak(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocBreak pdocBreak) {
        this.setContent(pdocBreak.getContent());
        this.setLength(pdocBreak.getLength());
        this.setBargein(pdocBreak.getBargein());
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.init(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.length_ = URelaxer.getAttributePropertyAsDoubleObject(element, "length");
        this.bargein_ = URelaxer.getAttributePropertyAsBooleanObject(element, "bargein");
    }

    public Object clone() {
        return new PdocBreak(this);
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("break");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.length_ != null) {
            URelaxer.setAttributePropertyByDouble(element, "length", this.length_);
        }
        if (this.bargein_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "bargein", this.bargein_);
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 0));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 0));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 0));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String string) {
        this.content_ = string;
    }

    public double getLength() {
        if (this.length_ == null) {
            return 0.0;
        }
        return this.length_;
    }

    public double getLength(double d) {
        if (this.length_ == null) {
            return d;
        }
        return this.length_;
    }

    public Double getLengthAsDouble() {
        return this.length_;
    }

    public boolean checkLength() {
        return this.length_ != null;
    }

    public void setLength(double d) {
        this.length_ = new Double(d);
    }

    public void setLength(Double d) {
        this.length_ = d;
    }

    public boolean getBargein() {
        if (this.bargein_ == null) {
            return true;
        }
        return this.bargein_;
    }

    public boolean getBargein(boolean bl) {
        if (this.bargein_ == null) {
            return bl;
        }
        return this.bargein_;
    }

    public Boolean getBargeinAsBoolean() {
        return this.bargein_;
    }

    public boolean checkBargein() {
        return this.bargein_ != null;
    }

    public void setBargein(boolean bl) {
        this.bargein_ = new Boolean(bl);
    }

    public void setBargein(Boolean bl) {
        this.bargein_ = bl;
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<break");
        if (this.length_ != null) {
            stringBuffer.append(" length=\"");
            stringBuffer.append(URelaxer.getString(this.getLength()));
            stringBuffer.append("\"");
        }
        if (this.bargein_ != null) {
            stringBuffer.append(" bargein=\"");
            stringBuffer.append(URelaxer.getString(this.getBargein()));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        stringBuffer.append("</break>");
    }

    public void makeTextElement(Writer writer) throws IOException {
        writer.write("<break");
        if (this.length_ != null) {
            writer.write(" length=\"");
            writer.write(URelaxer.getString(this.getLength()));
            writer.write("\"");
        }
        if (this.bargein_ != null) {
            writer.write(" bargein=\"");
            writer.write(URelaxer.getString(this.getBargein()));
            writer.write("\"");
        }
        writer.write(">");
        writer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        writer.write("</break>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<break");
        if (this.length_ != null) {
            printWriter.print(" length=\"");
            printWriter.print(URelaxer.getString(this.getLength()));
            printWriter.print("\"");
        }
        if (this.bargein_ != null) {
            printWriter.print(" bargein=\"");
            printWriter.print(URelaxer.getString(this.getBargein()));
            printWriter.print("\"");
        }
        printWriter.print(">");
        printWriter.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        printWriter.print("</break>");
    }

    public void makeTextAttribute(StringBuffer stringBuffer) {
    }

    public void makeTextAttribute(Writer writer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter printWriter) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getLengthAsString() {
        return URelaxer.getString(this.getLength());
    }

    public String getBargeinAsString() {
        return URelaxer.getString(this.getBargein());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setLengthByString(String string) {
        this.setLength(Double.parseDouble(string));
    }

    public void setBargeinByString(String string) {
        this.setBargein((boolean)new Boolean(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "break")) {
            return false;
        }
        RStack rStack = new RStack(element);
        boolean bl = false;
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocBreak.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocBreak.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

