/*
 * Decompiled with CFR 0.152.
 */
package main;

import command.HttpGetCommand;
import java.net.URL;
import java.util.Vector;
import main.ContentState;
import main.Debug;
import main.DocLoader;
import main.GrammarSet;
import main.StateMap;
import util.Util;

public class InterpreterContextManager {
    private Debug dbg = new Debug("ICM", 0);
    private StateMap stateMap_;
    private ContentState currState_;
    private String initialUrl_;
    private String nextStateName_ = null;

    public GrammarSet getGrammarSet() {
        this.dbg.ASSERT(this.stateMap_ != null, "InterpreterContextManager.getGrammarSet()");
        return this.stateMap_.getGrammarSet();
    }

    public InterpreterContextManager(String string) throws Exception {
        if (string.startsWith("http://")) {
            this.initialUrl_ = string;
        } else {
            this.newDocument(string, string);
        }
    }

    public void newDocument(String string, String string2) throws Exception {
        DocLoader docLoader = new DocLoader(string, string2);
        this.stateMap_ = docLoader.getStateMap();
        this.currState_ = this.stateMap_.getFirstState();
        if (this.currState_ == null) {
            this.dbg.print("newDocument: no __first__ state.");
        }
        this.nextStateName_ = null;
    }

    public InterpreterContextManager() {
    }

    public void setDocument(DocLoader docLoader) {
        this.stateMap_ = docLoader.getStateMap();
        this.currState_ = this.stateMap_.getFirstState();
        if (this.currState_ == null) {
            this.dbg.print("newDocument: no __first__ state.");
        }
        this.nextStateName_ = null;
    }

    public synchronized void inputText(String string) {
        String string2 = this.currState_.findEventHandler(string);
        this.dbg.print("ICM: inputText next= " + string2);
        if (string2 == null && (string2 = this.currState_.getEventHandler("<nomatch>")) == null) {
            this.dbg.print("<nomatch> not found in state=" + this.currState_);
            return;
        }
        this.currState_ = this.stateMap_.get(string2);
        if (this.currState_ == null) {
            Util.halt("Bad destination: " + string2);
        }
        this.dbg.print("inputText: next=" + string2 + " currState=" + this.currState_);
        this.nextStateName_ = null;
    }

    public synchronized void noinput() {
        String string;
        this.dbg.print("<noinput> invoked.");
        if (this.nextStateName_ != null) {
            string = this.nextStateName_;
            this.dbg.print("ICM: <setnext> nextStateName=" + string);
        } else {
            string = this.currState_.getEventHandler("<next>");
            this.dbg.print("ICM: <next>evh nextStateName=" + string);
        }
        if (string == null) {
            this.dbg.print("ICM: next not found.. continue..");
            return;
        }
        this.currState_ = this.stateMap_.get(string);
        if (this.currState_ == null) {
            Util.halt("Bad destination: " + string);
        }
        this.dbg.print("ICM: STATE-CHANGE: " + string);
        this.dbg.ASSERT(this.currState_ != null, "ICM: state not found");
        this.nextStateName_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector getCmd() {
        Vector<HttpGetCommand> vector = new Vector<HttpGetCommand>();
        boolean bl = false;
        if (this.initialUrl_ != null) {
            try {
                vector.add(new HttpGetCommand(new URL(this.initialUrl_)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.initialUrl_ = null;
            }
            return vector;
        }
        while (!bl) {
            this.dbg.print("getCmd: currState=" + this.currState_);
            if (this.currState_ == null) {
                return vector;
            }
            vector.addAll(this.currState_.getCommands());
            if (this.currState_.isExecOnly()) {
                String string = this.currState_.getEventHandler("<next>");
                this.dbg.print("getCmd: next=" + string);
                if (string == null) {
                    bl = true;
                    continue;
                }
                this.dbg.print("stateMap_:" + this.stateMap_);
                this.currState_ = this.stateMap_.get(string);
                this.nextStateName_ = null;
                this.dbg.print("setting CurrState_ to:" + this.currState_);
                bl = false;
                continue;
            }
            bl = true;
        }
        this.dbg.print("ICM: " + this.currState_.getName() + " has " + vector.size() + " commands.");
        return vector;
    }

    public synchronized void setNextState(String string) {
        this.dbg.print("ICM: setnext=" + string);
        this.nextStateName_ = string;
    }
}

