/*
 * Decompiled with CFR 0.152.
 */
package main;

import document.AbstractDoc;
import document.RawPhoenixDoc;
import document.VXMLDoc;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import main.DocError;
import main.StateMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class DocLoader {
    private AbstractDoc doc;
    private StateMap stateMap;

    public DocLoader(String string, String string2) throws Exception {
        Document document;
        Object object;
        Object object2;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (string.startsWith("http:")) {
            String string3;
            object2 = "";
            object = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
            httpURLConnection.setRequestMethod("GET");
            InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                object2 = (String)object2 + string3;
            }
            document = documentBuilder.parse(new ByteArrayInputStream(((String)object2).getBytes()));
            bufferedReader.close();
            httpURLConnection.disconnect();
        } else {
            document = documentBuilder.parse(string);
        }
        object2 = document.getDocumentElement();
        object = object2.getNodeType() == 1 ? object2.getNodeName() : "";
        if (((String)object).equals("vxml")) {
            this.doc = new VXMLDoc((Element)object2, string2);
        } else if (((String)object).equals("pdoc")) {
            this.doc = new RawPhoenixDoc((Element)object2, string2);
        } else {
            this.doc = null;
            throw new DocError("Not a valid document.");
        }
    }

    public StateMap getStateMap() {
        if (this.doc != null) {
            this.stateMap = this.doc.getStateMap();
            return this.stateMap;
        }
        return null;
    }

    public static void convert(String string) {
        try {
            DocLoader docLoader = new DocLoader(string, string);
            StateMap stateMap = docLoader.getStateMap();
            if (stateMap == null) {
                System.err.println("DocLoader stopped: stateMap null.");
                return;
            }
            String string2 = stateMap.toString();
            System.out.print(string2);
        }
        catch (DocError docError) {
            System.err.println();
            System.err.println(docError);
            System.err.println("DocLoader stopped.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println();
            System.err.println(fileNotFoundException);
            System.err.println("DocLoader stopped.");
        }
        catch (SAXParseException sAXParseException) {
            System.err.println();
            System.err.println(sAXParseException);
            System.err.println("Source:" + string);
            System.err.println("Line:" + sAXParseException.getLineNumber() + " Column:" + sAXParseException.getColumnNumber());
            System.err.println("DocLoader stopped.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

