/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import main.Debug;
import main.DocError;
import main.DocLoader;
import main.InteractionControler;
import org.xml.sax.SAXParseException;
import util.Getopt;
import util.Util;

public class Phoenix {
    public static final String COPYRIGHT = "(c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)\nUses Mozilla Rhino from mozilla.org.\nSee http://www.mozilla.org/rhino/.\n";
    public static final String NAME = "Galatea Dialog Manager 1.0.1 ";

    public static void showVersion() {
        System.out.println("Galatea Dialog Manager 1.0.1 (050720.0653)");
        System.out.print(COPYRIGHT);
        System.out.println();
    }

    public static void showUsage() {
        System.out.println("Usage:\tgalatea [options] document.vxml");
        System.out.println("\t -v : show version");
        System.out.println("\t -p : print translation results");
        System.out.println();
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        String string = "phoenix.conf";
        boolean bl = false;
        Getopt getopt = new Getopt("", stringArray, "c:p");
        getopt.setOpterr(false);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 99: {
                    string = getopt.getOptarg();
                    break;
                }
                case 112: {
                    bl = true;
                }
            }
        }
        File file = new File(string);
        if (!file.canRead()) {
            System.err.println("Cannot read configration file.");
            System.exit(1);
        }
        if (stringArray.length - getopt.getOptind() != 1) {
            Phoenix.showVersion();
            Phoenix.showUsage();
            System.exit(1);
        }
        try {
            object = new Properties(System.getProperties());
            ((Properties)object).load(new FileInputStream(file));
            System.setProperties((Properties)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (bl) {
            DocLoader.convert(stringArray[getopt.getOptind()]);
            System.exit(0);
        }
        if (Integer.parseInt((String)(object = System.getProperty("ShowVersion", "1"))) != 0) {
            Phoenix.showVersion();
        }
        object = System.getProperty("EnableTerminate", "0");
        boolean bl2 = false;
        if (Integer.parseInt((String)object) != 0) {
            bl2 = true;
        }
        Debug debug = new Debug("Phoenix");
        try {
            String string2 = stringArray[getopt.getOptind()];
            InteractionControler interactionControler = new InteractionControler();
            while (string2.length() > 0) {
                debug.print("Phoenix: filename:" + string2);
                interactionControler.loadDocument(string2);
                interactionControler.mainLoop();
                String string3 = interactionControler.getNextDocFile();
                if (string3.length() > 0) {
                    debug.print("Phoenix: nf:" + string3);
                    string2 = Util.resolveAdrs(string2, string3);
                    continue;
                }
                string2 = "";
            }
            if (bl2) {
                interactionControler.terminate();
            }
        }
        catch (DocError docError) {
            System.err.println();
            System.err.println(docError);
            System.err.println("Document error.");
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println();
            System.err.println("File not found.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl2) {
            System.err.println("Dialog Manager Terminated.");
            System.exit(0);
        } else {
            Util.halt();
        }
    }
}

