<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.BaseVo"
import = "jp.mosp.mospcommon.system.vo.LaborAgreementListVo"
%><%
LaborAgreementListVo vo = (LaborAgreementListVo)request.getAttribute(MospConst.ATT_VO);
String[] aryAgreeCode		= vo.getEscAryAgreeCode();
String[] aryAgreeType		= vo.getEscAryAgreeType();
String[] aryOverTimeCode	= vo.getEscAryOverTimeCode();
String[] aryWorkOnCode		= vo.getEscAryWorkOnCode();
String[] aryDelete			= vo.getEscAryDelete();
String[] aryAgreeName 		= vo.getAryAgreeName();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="agreementList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table>
			<tr>
				<td id="tdAgreeCode">
					<span><%= vo.NAM_AGREE_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="CodeTextBox" id="<%= LaborAgreementListVo.PRM_TXT_AGREE_CODE %>" name="<%= LaborAgreementListVo.PRM_TXT_AGREE_CODE %>" value="<%= vo.getEscTxtAgreeCode() %>" />
				</td>
				<td id="tdDelete">
					<span><%= vo.NAM_DELETE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="DeleteFlagSelect" id="<%= LaborAgreementListVo.PRM_PLT_DELETE %>" name="<%= LaborAgreementListVo.PRM_PLT_DELETE %>">
						<option value=""></option>
						<%= HtmlUtility.getDeleteFlagSelectOption(vo.getPltDelete()) %>
					</select>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'S2511')"><%= CommonConst.NAM_SEARCH %></button>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfo(vo) %>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thAgreeCode" onclick="doSubmitKey(document.form, 'S2513', '<%= vo.KEY_AGREE_CODE %>', '')">&nbsp;<%= vo.NAM_AGREE_CODE %>&nbsp;<%= vo.getSortMark(vo.KEY_AGREE_CODE) %></th>
					<th id="thOverTimeCode" onclick="doSubmitKey(document.form, 'S2513', '<%= vo.KEY_OVER_TIME_CODE %>', '')">&nbsp;<%= vo.NAM_OVER_TIME %>&nbsp;<%= vo.getSortMark(vo.KEY_OVER_TIME_CODE) %></th>
					<th id="thWorkOnCode" onclick="doSubmitKey(document.form, 'S2513', '<%= vo.KEY_WORK_ON_CODE %>', '')">&nbsp;<%= vo.NAM_WORK_ON %>&nbsp;<%= vo.getSortMark(vo.KEY_WORK_ON_CODE) %></th>
					<th id="thDelete" onclick="doSubmitKey(document.form, 'S2513', '<%= vo.KEY_DELETE %>', '')">&nbsp;<%= vo.NAM_DELETE %>&nbsp;<%= vo.getSortMark(vo.KEY_DELETE) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'S2516', '<%= aryAgreeCode[i] %>' , '<%= aryAgreeType[i] %>')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td><%= BaseVo.escapeHTML(aryAgreeName[i]) %></td>
					<td><%= aryOverTimeCode[i] %></td>
					<td><%= aryWorkOnCode[i] %></td>
					<td class="tdDelete"><%= aryDelete[i] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
	<div class="ButtonDiv">
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'S2515')"><%= CommonConst.NAM_MAKE_NEW_DATA %></button>
		<button type="button" class="MenuButton" onclick="doSubmit(document.form, 'S2500')"><%= CommonConst.TTL_LABOR_AGREEMENT_MANAGEMENT %></button>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
