/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.workflow.dto.AmRouteDto;
import jp.mosp.workflow.dto.PmAttendanceDto;
import jp.mosp.workflow.vo.AttendanceRouteCardVo;

/**
 * @author yoshida
 *
 */
public class AttendanceRouteCardAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_ROUTE_CARD_SHOW		= "S2835";	// \(ǉ)
	private static final String	CMD_ROUTE_CARD_SELECT	= "S2836";	// \(I)
	private static final String	CMD_ROUTE_CARD_INSERT	= "S2837";	// o^
	private static final String	CMD_ROUTE_CARD_UPDATE	= "S2838";	// XV
																	
	
	/**
	 * RXgN^
	 */
	public AttendanceRouteCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ROUTE_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_ROUTE_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_ROUTE_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_ROUTE_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceRouteCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		AttendanceRouteCardVo vo = (AttendanceRouteCardVo)getVo();
		// ƏR[hꗗ
		vo.aryPltOffice = StringUtil.addArrayFirstRowSpace(getOfficeArrayAll());
		// R[hꗗ
		vo.aryPltSection = StringUtil.addArrayFirstRowSpace(getSectionArrayAll());
		// ΑӗpF[gR[hꗗ
		vo.aryPltRoute = getRouteArrayAvailable();
		// l{
		vo.aryUser = part().human().getBasisArrayAll();
		// mFpz
		vo.aryBelongSection = part().human().getBasisArrayAllWithSectionCode();
		vo.aryBelongOffice = part().human().getBasisArrayAllWithOfficeCode();
		vo.setParams(request);
	}
	
	@Override
	protected void show() {
		AttendanceRouteCardVo vo = (AttendanceRouteCardVo)getVo();
		vo.setDefaultValues();
		// [hݒ
		setMode();
	}
	
	@Override
	protected void select() throws Exception {
		AttendanceRouteCardVo vo = (AttendanceRouteCardVo)getVo();
		// f[^̎擾
		PmAttendanceDto dto = pmAttendDao().findForKey(key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		vo.setMode(AttendanceRouteCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		AttendanceRouteCardVo vo = (AttendanceRouteCardVo)getVo();
		// p[^̑ÓmF
		vo.validate();
		// ݃`FbN
		chkDuplicate(pmAttendDao().findForCondition(vo.getPltSection(), vo.getTxtKCode(), vo.getPltRouteCode()));
		if (StringUtil.isNotNull(vo.getTxtKCode())) {
			chkDuplicate(pmAttendDao().findForKCode(vo.getTxtKCode()));
		}
		// őlZbg
		String maxEno = pmAttendDao().findForMax();
		if (StringUtil.isNull(maxEno)) {
			maxEno = "-1";
		} else {
			pmAttendDao().findForUpdate(maxEno);
		}
		// DTȌ
		PmAttendanceDto dto = new PmAttendanceDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setDtoFields(dto);
		dto.setRouteId(Integer.parseInt(maxEno) + 1);
		// f[^̑}
		pmAttendDao().insert(dto);
		// DTO̍Ď擾
		dto = pmAttendDao().findForKey(String.valueOf(dto.getRouteId()));
		// R~bg
		commit();
		// [hݒ
		vo.setMode(AttendanceRouteCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		PmAttendanceDto dto = (PmAttendanceDto)getSessionDto();
		AttendanceRouteCardVo vo = (AttendanceRouteCardVo)getVo();
		vo.setHidRouteid(String.valueOf(dto.getRouteId()));
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(dto, pmAttendDao().findForUpdate(vo.getHidRouteid()));
		// őlZbg
		String maxRouteId = pmAttendDao().findForMax();
		if (StringUtil.isNull(maxRouteId)) {
			maxRouteId = "-1";
		} else {
			pmAttendDao().findForUpdate(maxRouteId);
		}
		if (pmAttendDao().findForUpdate(String.valueOf(dto.getRouteId())) != null) {
			dto.setDeleteFlag(MospConst.DELETE_FLAG_ON);
			// _폜
			pmAttendDao().update(dto);
		}
		// DTȌ
		vo.setDtoFields(dto);
		dto.setRouteId(Integer.parseInt(maxRouteId) + 1);
		// f[^̍XV
		pmAttendDao().insert(dto);
		// DTO̍Ď擾
		PmAttendanceDto retDto = pmAttendDao().findForKey(String.valueOf(dto.getRouteId()));
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(AttendanceRouteCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * ΑӗpF[gR[hꗗiꎟAŏIj
	 * @return	String[][]	[gR[hz
	 * @throws Exception 	Oꍇ
	 */
	private String[][] getRouteArrayAvailable() throws Exception {
		// ̎擾
		List<AmRouteDto> listRoute = routeDao().findForAttendanceRoute();
		// z̍쐬		
		String[][] aryRoute = new String[listRoute.size()][2];
		String[][] aryUnit = getCurrentUnitArray();
		for (int i = 0; i < aryRoute.length; i++) {
			aryRoute[i][0] = listRoute.get(i).getRtCode();
			StringBuffer sb = new StringBuffer();
			sb.append(CommonConst.MSG_APPROVAL_FIRST);
			sb.append(StringUtil.surroundBracket(StringUtil.getCodeName(listRoute.get(i).getLayer1(), aryUnit)));
			sb.append(CommonConst.MSG_APPROVAL_SECOND);
			sb.append(StringUtil.surroundBracket(StringUtil.getCodeName(listRoute.get(i).getLastLayer(), aryUnit)));
			aryRoute[i][1] = sb.toString();
		}
		return aryRoute;
	}
	
	/**
	 * [hݒ
	 */
	private void setMode() {
		AttendanceRouteCardVo vo = (AttendanceRouteCardVo)getVo();
		// [hݒ
		if (vo.aryPltRoute.length == 0) {
			vo.setMode(AttendanceRouteCardVo.MODE_IMPOSSIBLE);
		} else {
			vo.setMode(AttendanceRouteCardVo.MODE_INSERT);
		}
	}
	
}
