/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.workflow.dto.AmUnitDto;
import jp.mosp.workflow.vo.ApprovalUnitCardVo;

/**
 * @author yoshida
 *
 */
public class ApprovalUnitCardAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_UNIT_CARD_SHOW		= "S2815";	// \(ǉ)
	private static final String	CMD_UNIT_CARD_SELECT	= "S2816";	// \(I)
	private static final String	CMD_UNIT_CARD_INSERT	= "S2817";	// o^
	private static final String	CMD_UNIT_CARD_UPDATE	= "S2818";	// XV
																	
	
	/**
	 * RXgN^
	 */
	public ApprovalUnitCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_UNIT_CARD_SHOW)) {
			show();
		} else if (cmd.equals(CMD_UNIT_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_UNIT_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_UNIT_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ApprovalUnitCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// v_ẼZbg
		ApprovalUnitCardVo vo = (ApprovalUnitCardVo)getVo();
		// MANAGERLЈR[hꗗ
		vo.aryPltManager = part().human().getBasisArrayForApproval();
		// N
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 10, 5);
		// 
		vo.aryPltMonth = StringUtil.getMonthArray();
		/*
		 * 		2008/11/06	m.yoshida	C
		 */
		// 
		vo.aryPltDay = StringUtil.getDayArray();
		vo.setParams(request);
	}
	
	@Override
	protected void show() throws Exception {
		ApprovalUnitCardVo vo = (ApprovalUnitCardVo)getVo();
		vo.setDefaultValues();
		Date todayDate = DateUtil.getSystemDate();
		vo.setPltStartYear(String.valueOf(MospUtility.getYear(getStartDate(todayDate))));
		vo.setPltStartMonth(String.valueOf(MospUtility.getMonth(getStartDate(todayDate))));
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		vo.setPltStartDay(String.valueOf(MospUtility.getDay(getStartDate(todayDate))));
		// [hݒ
		setMode();
	}
	
	@Override
	protected void select() throws Exception {
		ApprovalUnitCardVo vo = (ApprovalUnitCardVo)getVo();
		// f[^̎擾
		AmUnitDto dto = unitDao().findForKey(key1, key2);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		vo.setMode(ApprovalUnitCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		ApprovalUnitCardVo vo = (ApprovalUnitCardVo)getVo();
		// p[^̑ÓmF
		vo.validate();
		// ݃`FbN
		chkDuplicate(unitDao().findForKey(vo.getTxtUnitCode(), DateUtil.convStringDateFormattedByHyphen(
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		vo.getPltStartYear(), vo.getPltStartMonth(), vo.getPltStartDay())));
		// DTȌ
		AmUnitDto dto = new AmUnitDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setDtoFields(dto);
		// f[^̑}
		unitDao().insert(dto);
		// DTO̍Ď擾
		dto = unitDao().findForKey(dto.getUnitCode(), dto.getStartDate());
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ApprovalUnitCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		AmUnitDto dto = (AmUnitDto)getSessionDto();
		ApprovalUnitCardVo vo = (ApprovalUnitCardVo)getVo();
		// R[h擾
		vo.setTxtUnitCode(dto.getUnitCode());
		// N擾
		vo.setPltStartYear(String.valueOf(MospUtility.getYear(dto.getStartDate())));
		vo.setPltStartMonth(String.valueOf(MospUtility.getMonth(dto.getStartDate())));
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		vo.setPltStartDay(String.valueOf(MospUtility.getDay(dto.getStartDate())));
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(dto, unitDao().findForUpdate(vo.getTxtUnitCode(), DateUtil.convStringDateFormattedByHyphen(
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		vo.getPltStartYear(), vo.getPltStartMonth(), vo.getPltStartDay())));
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		unitDao().update(dto);
		// DTO̍Ď擾
		AmUnitDto retDto = unitDao().findForKey(dto.getUnitCode(), dto.getStartDate());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ApprovalUnitCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * [hݒ
	 */
	private void setMode() {
		ApprovalUnitCardVo vo = (ApprovalUnitCardVo)getVo();
		// [hݒ
		if (vo.aryPltManager.length == 0) {
			vo.setMode(ApprovalUnitCardVo.MODE_IMPOSSIBLE);
		} else {
			vo.setMode(ApprovalUnitCardVo.MODE_INSERT);
		}
	}
	
}
