/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.dto.MKihonDto;

/**
 * @author yoshida
 *
 */
public class FirstHumanAccountCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 2220781986812948427L;
	
	// 萔
	public static final int		MODE_INSERT			= 0;
	public static final int		MODE_VIEW			= 1;
	
	// p[^
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	public static final String	PRM_TXT_USER_NAME	= "txtUserName";
	public static final String	PRM_PLT_OFFICE		= "pltOffice";
	public static final String	PRM_PLT_SECTION		= "pltSection";
	public static final String	PRM_PLT_POSITION	= "pltPosition";
	
	// tB[h
	private String				txtKCode;
	private String				txtUserName;
	private String				pltOffice;
	private String				pltSection;
	private String				pltPosition;
	
	// v_EXg
	public String[][]			aryPltOfficeAll;
	public String[][]			aryPltSectionAll;
	public String[][]			aryPltPosition;
	
	// [h(0FVKo^A1:\)
	private int					mode;
	
	// tB[hyѐ
	public String				NAM_K_CODE;
	public String				NAM_USER_NAME;
	public String				NAM_OFFICE;
	public String				NAM_SECTION;
	public String				NAM_POSITION;
	public int					LEN_K_CODE;
	public int					LEN_USER_NAME;
	

	/**
	 * RXgN^
	 */
	public FirstHumanAccountCardVo() {
		super();
		setViewPath(getClassName());
		mode = 0;
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ACCOUNT_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_USER_NAME = CommonConst.NAM_USER_NAME;
		NAM_OFFICE = CommonConst.NAM_OFFICE;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_POSITION = CommonConst.NAM_POSITION1;
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_USER_NAME = CommonConst.LEN_K_NAME;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		txtKCode = "";
		txtUserName = "";
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtUserName = request.getParameter(PRM_TXT_USER_NAME);
		pltOffice = request.getParameter(PRM_PLT_OFFICE);
		pltSection = request.getParameter(PRM_PLT_SECTION);
		pltPosition = request.getParameter(PRM_PLT_POSITION);
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 */
	public void setFields(MKihonDto dto) {
		txtKCode = dto.getKCode();
		txtUserName = dto.getSimei();
		pltOffice = dto.getJCode();
		pltSection = dto.getSCode();
		pltPosition = dto.getYCode() + CommonConst.STR_TIME_SEPARATOR + dto.getTokyu();
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtKCode, NAM_K_CODE, PRM_TXT_K_CODE);
		checkRequired(txtUserName, NAM_USER_NAME, PRM_TXT_USER_NAME);
		// R[hmF
		checkCode(txtKCode, NAM_K_CODE, PRM_TXT_K_CODE);
		// 񒷊mF
		checkLength(txtKCode, LEN_K_CODE, NAM_K_CODE, PRM_TXT_K_CODE);
		checkLength(txtUserName, LEN_USER_NAME, NAM_USER_NAME, PRM_TXT_USER_NAME);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	public String getTxtKCode() {
		return txtKCode;
	}
	
	public String getTxtUserName() {
		return txtUserName;
	}
	
	public String getPltOffice() {
		return pltOffice;
	}
	
	public String getPltSection() {
		return pltSection;
	}
	
	public String getPltPosition() {
		return pltPosition;
	}
	
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	public String getEscTxtUserName() {
		return escapeHTML(txtUserName);
	}
	
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
