/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.system.vo.AccountMasterCardVo;

/**
 * @author yoshida
 *
 */
public class AccountMasterCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_ACCOUNT_MASTER_CARD_SHOW	= "S2405";
	private static final String	CMD_ACCOUNT_MASTER_CARD_SELECT	= "S2406";
	private static final String	CMD_ACCOUNT_MASTER_CARD_INSERT	= "S2407";
	private static final String	CMD_ACCOUNT_MASTER_CARD_UPDATE	= "S2408";
	

	/**
	 * RXgN^
	 */
	public AccountMasterCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ACCOUNT_MASTER_CARD_SHOW)) {
			show();
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_CARD_SELECT)) {
			select();
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AccountMasterCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		AccountMasterCardVo vo = (AccountMasterCardVo)getVo();
		/*						
		 *  	2009/01/09	k.taniai	j[AWΉ
		 */
		vo.aryPltAuthority = StringUtil.combineArray(getCodeArray(CommonConst.TID_AUTHORITY), getArrangeAuthArray());
	}
	
	@Override
	protected void show() {
		AccountMasterCardVo vo = (AccountMasterCardVo)getVo();
		vo.setDefaultValues();
	}
	
	@Override
	protected void select() throws Exception {
		AccountMasterCardVo vo = (AccountMasterCardVo)getVo();
		// f[^̎擾
		CmUserDto dto = part().mospuser().getMosPUserDao().findForKey(key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		setMode();
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		AccountMasterCardVo vo = (AccountMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		CmUserDto dto = new CmUserDto();
		vo.setDtoFields(dto);
		dto.setPassword(MospUtility.getDigest(MospUtility.getDigest(dto.getUserId())));
		dto.setKCode("");
		dto.setChangePass(new Date());
		// DAȌ
		MosPUserDao dao = part().mospuser().getMosPUserDao();
		// ݃`FbN
		chkDuplicate(dao.findForKey(dto.getUserId()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		CmUserDto retDto = dao.findForKey(dto.getUserId());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		CmUserDto dto = (CmUserDto)getSessionDto();
		AccountMasterCardVo vo = (AccountMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		// DAȌ
		MosPUserDao dao = part().mospuser().getMosPUserDao();
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getUserId()));
		// f[^̍XV
		dao.update(dto, true);
		// DTO̍Ď擾
		CmUserDto retDto = dao.findForKey(dto.getUserId());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// VÕ[hݒ
		setMode();
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * [hݒ
	 * @throws Exception  	Oꍇ
	 */
	private void setMode() throws Exception {
		AccountMasterCardVo vo = (AccountMasterCardVo)getVo();
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(AccountMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(AccountMasterCardVo.MODE_UPDATE);
		}
	}
	
}
