/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.ResidenceTaxDto;

/**
 * @author koike
 *
 */
public class ResidenceTaxDao extends PayrollDao {
	
	//
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE				= PhPaymentDao.COL_KCODE;
	/**
	 * vZN
	 */
	public static final String	COL_CALC_DATE			= PhPaymentDao.COL_CALC_MONTH;
	/**
	 * ^x
	 */
	public static final String	COL_PAYDAY				= PhPaymentDao.COL_PAY_DATE;
	/**
	 * Ј
	 */
	public static final String	COL_K_NAME				= MKihonPayrollDao.COL_SIMEI;
	/**
	 * sR[h
	 */
	public static final String	COL_CITY_CODE			= CmCityDao.COL_CITY_CODE;
	/**
	 * s
	 */
	public static final String	COL_CITY_NAME			= CmCityDao.COL_CITY_NAME;
	/**
	 * [t
	 */
	public static final String	COL_PAYMENT_CITY_CODE	= CmResidenceTaxDao.COL_PAYMENT_CITY_CODE;
	/**
	 * [tKp
	 */
	public static final String	COL_RES_EXPECTED_DATE	= CmResidenceTaxDao.COL_RES_EXPECTED_DATE;
	/**
	 * Z
	 */
	public static final String	COL_AMOUNT				= PdPayDeductionDao.COL_AMOUNT;
	/**
	 * 
	 */
	public static final String	COL_DETAIL_CODE_PD007	= "PD007";
	

	/**
	 * RXgN^
	 */
	public ResidenceTaxDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<ResidenceTaxDto> mappingAll() throws SQLException {
		List<ResidenceTaxDto> all = new ArrayList<ResidenceTaxDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmResidenceTaxDto R[h
	 * @throws SQLException SQLOꍇ
	 */
	private ResidenceTaxDto mapping() throws SQLException {
		ResidenceTaxDto dto = new ResidenceTaxDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setCalcDate(rs.getDate(COL_CALC_DATE)); // vZN
		dto.setPayday(rs.getDate(COL_PAYDAY)); // ^x
		dto.setKName(rs.getString(COL_K_NAME)); // Ј
		dto.setResidenceTax(rs.getInt(COL_AMOUNT)); // Z
		dto.setCityCode(rs.getString(COL_CITY_CODE)); // sR[h
		dto.setCityName(rs.getString(COL_CITY_NAME)); // s
		dto.setPaymentCityCode(rs.getString(COL_PAYMENT_CITY_CODE)); // [t
		return dto;
	}
	
	/**
	 * ɂNf[^擾
	 * @param calcDate Ώ۔N 
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 */
	public List<ResidenceTaxDto> findForCondition(Date calcDate) throws SQLException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		setCityTax(sb);
		sb.append(" ");
		sb.append(getOrderBy());
		sb.append(" CMTAX.");
		sb.append(COL_PAYMENT_CITY_CODE);
		sb.append(" , ");
		sb.append(" PHPAY.");
		sb.append(COL_K_CODE);
		try {
			prepareStatement(sb.toString());
			//^̏ꍇvZݒ
			setDateParam(index++, calcDate);
			setDateParam(index++, calcDate);
			setDateParam(index++, calcDate);
			// s
			executeQuery();
			List<ResidenceTaxDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	private void setCityTax(StringBuffer sb) {
		throw new CloudzeroUnsupportedException();
/*		sb.append("SELECT ");
		sb.append(" PHPAY.");
		sb.append(COL_K_CODE);
		sb.append(", ");
		sb.append(" PHPAY.");
		sb.append(COL_CALC_DATE);
		sb.append(", ");
		sb.append(" PHPAY.");
		sb.append(COL_PAYDAY);
		sb.append(", ");
		sb.append(" MKIHON.");
		sb.append(COL_K_NAME);
		sb.append(", ");
		sb.append(" PDDED.");
		sb.append(PdPayDeductionDao.COL_AMOUNT);
		sb.append(", ");
		sb.append(" CMTAX.");
		sb.append(COL_PAYMENT_CITY_CODE);
		sb.append(", ");
		sb.append(" CMCITY.");
		sb.append(COL_CITY_CODE);
		sb.append(", ");
		sb.append(" CMCITY.");
		sb.append(COL_CITY_NAME);
		sb.append(" FROM   ");
		sb.append(PhPaymentDao.TABLE + " PHPAY");
		sb.append(", ");
		sb.append(CmResidenceTaxDao.TABLE + " CMTAX");
		sb.append(", ");
		sb.append(CmCityDao.TABLE + " CMCITY");
		sb.append(", ");
		sb.append(PdPayDeductionDao.TABLE + " PDDED");
		sb.append(", ");
		sb.append(MKihonPayrollDao.TABLE + " MKIHON");
		sb.append(" WHERE ");
		sb.append(" CMTAX.");
		sb.append(CmResidenceTaxDao.COL_RES_EXPECTED_DATE);
		sb.append(" = ");
		sb.append(" ( ");
		sb.append(" SELECT ");
		sb.append(" MAX(");
		sb.append("CMTAX2.");
		sb.append(CmResidenceTaxDao.COL_RES_EXPECTED_DATE);
		sb.append(")");
		sb.append(" FROM   ");
		sb.append(CmResidenceTaxDao.TABLE + " CMTAX2");
		sb.append(" WHERE ");
		sb.append(" CMTAX.");
		sb.append(CmResidenceTaxDao.COL_K_CODE);
		sb.append(" = ");
		sb.append(" CMTAX2.");
		sb.append(CmResidenceTaxDao.COL_K_CODE);
		sb.append(" AND ");
		sb.append(" CMTAX2.");
		sb.append(CmResidenceTaxDao.COL_RES_EXPECTED_DATE);
		sb.append(" <=? ");
		sb.append(" ) ");
		sb.append(" AND ");
		sb.append(" PHPAY.");
		sb.append(PhPaymentDao.COL_KCODE);
		sb.append(" = ");
		sb.append(" CMTAX.");
		sb.append(CmResidenceTaxDao.COL_K_CODE);
		sb.append(" AND ");
		sb.append(" CMTAX.");
		sb.append(CmResidenceTaxDao.COL_PAYMENT_CITY_CODE);
		sb.append(" = ");
		sb.append(" CMCITY.");
		sb.append(CmCityDao.COL_CITY_CODE);
		sb.append(" AND ");
		sb.append(" PHPAY.");
		sb.append(PhPaymentDao.COL_CALC_MONTH);
		sb.append(" =? ");
		sb.append(" AND ");
		sb.append(" PDDED.");
		sb.append(PdPayDeductionDao.COL_KCODE);
		sb.append(" = ");
		sb.append(" CMTAX.");
		sb.append(CmResidenceTaxDao.COL_K_CODE);
		sb.append(" AND ");
		sb.append(" PDDED.");
		sb.append(PdPayDeductionDao.COL_CALC_DATE);
		sb.append(" =? ");
		sb.append(" AND ");
		sb.append(" PDDED.");
		sb.append(PdPayDeductionDao.COL_DETAIL_CODE);
		sb.append(" = ");
		sb.append("'" + COL_DETAIL_CODE_PD007 + "'");
		sb.append(" AND ");
		sb.append(" MKIHON.");
		sb.append(MKihonPayrollDao.COL_KCODE);
		sb.append(" = ");
		sb.append(" CMTAX.");
		sb.append(CmResidenceTaxDao.COL_K_CODE);*/
	}
}
