/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.appengine.api.datastore.Query;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.getset.gae.bigtable.Statement.Mode;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmIncomeTaxDto;

public class CmIncomeTaxDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE					= "CM_INCOME_TAX";
	public static final String	KEY_1					= "K_CODE";			// ЈR[h
	public static final String	KEY_2					= "INC_EXPECTED_DATE";	// œKpN
																				
	// 
	public static final String	COL_K_CODE				= "K_CODE";			// ЈR[h
	public static final String	COL_INC_EXPECTED_DATE	= "INC_EXPECTED_DATE";	// œKpN
	public static final String	COL_INCOME_TAX_TYPE		= "INCOME_TAX_TYPE";	// ېŋ敪
	public static final String	COL_ADJUSTMENT_TYPE		= "ADJUSTMENT_TYPE";	// N敪
	public static final String	COL_SELF_WIDOW_TYPE		= "SELF_WIDOW_TYPE";	// {lǕw敪
	public static final String	COL_SELF_HANDICAP_TYPE	= "SELF_HANDICAP_TYPE"; // {lQ敪
	public static final String	COL_SELF_STUDENT_TYPE	= "SELF_STUDENT_TYPE";	// {lw敪
	public static final String	COL_SPOUSE_INTEND_TYPE	= "SPOUSE_INTEND_TYPE"; // zҋ敪
	public static final String	COL_GENERAL_DEPENDENT	= "GENERAL_DEPENDENT";	// ʕ}{e
	public static final String	COL_SPECIFIC_DEPENDENT	= "SPECIFIC_DEPENDENT"; // }{e
	public static final String	COL_ELDERLY_DEPENDENT	= "ELDERLY_DEPENDENT";	// Vl}{e
	public static final String	COL_LIVE_WITH_ELD_REL	= "LIVE_WITH_ELD_REL";	// Ve
	public static final String	COL_LIVE_WITH_HANDI_GE	= "LIVE_WITH_HANDI_GE"; // 
	public static final String	COL_LIVE_WITH_HANDI_SP	= "LIVE_WITH_HANDI_SP"; // 
	public static final String	COL_LIVE_WITH_HANDI_EL	= "LIVE_WITH_HANDI_EL"; // Vl
	public static final String	COL_LIVE_WITH_HANDI_ER	= "LIVE_WITH_HANDI_ER"; // Ve
	public static final String	COL_GENERAL_HANDICAP	= "GENERAL_HANDICAP";	// ʏQ
	public static final String	COL_SPECIFIC_HANDICAP	= "SPECIFIC_HANDICAP";	// ʏQ
	public static final String	COL_DEPENDENT_COUNT		= "DEPENDENT_COUNT";	// }{̐
																				
	
	/**
	 * RXgN^
	 */
	public CmIncomeTaxDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmIncomeTaxDto> mappingAll() throws SQLException {
		List<CmIncomeTaxDto> all = new ArrayList<CmIncomeTaxDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmIncomeTaxDto R[h
	 * @throws SQLException
	 */
	private CmIncomeTaxDto mapping() throws SQLException {
		CmIncomeTaxDto dto = new CmIncomeTaxDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setIncExpectedDate(rs.getDate(COL_INC_EXPECTED_DATE)); // œKpN
		dto.setIncomeTaxType(rs.getString(COL_INCOME_TAX_TYPE)); // ېŋ敪
		dto.setAdjustmentType(rs.getString(COL_ADJUSTMENT_TYPE)); // N敪
		dto.setSelfWidowType(rs.getString(COL_SELF_WIDOW_TYPE)); // {lǕw敪
		dto.setSelfHandicapType(rs.getString(COL_SELF_HANDICAP_TYPE)); // {lQ敪
		dto.setSelfStudentType(rs.getString(COL_SELF_STUDENT_TYPE)); // {lw敪
		dto.setSpouseIntendType(rs.getString(COL_SPOUSE_INTEND_TYPE)); // zҋ敪
		dto.setGeneralDependent(rs.getInt(COL_GENERAL_DEPENDENT)); // ʕ}{e
		dto.setSpecificDependent(rs.getInt(COL_SPECIFIC_DEPENDENT)); // }{e
		dto.setElderlyDependent(rs.getInt(COL_ELDERLY_DEPENDENT)); // Vl}{e
		dto.setLiveWithEldRel(rs.getInt(COL_LIVE_WITH_ELD_REL)); // Ve
		dto.setLiveWithHandiGe(rs.getInt(COL_LIVE_WITH_HANDI_GE)); // 
		dto.setLiveWithHandiSp(rs.getInt(COL_LIVE_WITH_HANDI_SP)); // 
		dto.setLiveWithHandiEl(rs.getInt(COL_LIVE_WITH_HANDI_EL)); // Vl
		dto.setLiveWithHandiEr(rs.getInt(COL_LIVE_WITH_HANDI_ER)); // Ve
		dto.setGeneralHandicap(rs.getInt(COL_GENERAL_HANDICAP)); // ʏQ
		dto.setSpecificHandicap(rs.getInt(COL_SPECIFIC_HANDICAP)); // ʏQ
		dto.setDependentCount(rs.getInt(COL_DEPENDENT_COUNT)); // }{̐
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʎ擾(DTOMap)
	 * @return Map }bv
	 * @throws SQLException
	 */
	private Map<String, CmIncomeTaxDto> mappingAllMap() throws SQLException {
		Map<String, CmIncomeTaxDto> all = new HashMap<String, CmIncomeTaxDto>();
		while (rs.next()) {
			CmIncomeTaxDto dto = mapping();
			all.put(dto.getKCode(), dto);
		}
		return all;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmIncomeTaxDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmIncomeTaxDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode           ЈR[h(L[)
	 * @param incExpectedDate œKpN(L[)
	 * @return CmIncomeTaxDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmIncomeTaxDto findForKey(String kCode, Date incExpectedDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, incExpectedDate);
			executeQuery();
			CmIncomeTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^擾
	 * @param kCode           ЈR[h(L[)
	 * @param incExpectedDate KpN  (L[)
	 * @return CmIncomeTaxDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public CmIncomeTaxDto findForEmployeeDate(String kCode, Date incExpectedDate) throws SQLException,
			IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(getSelectStatement(getClass()) + " ");
			sb.append("FROM ");
			sb.append(getHistoryTableForDate() + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			
			prepareStatement(sb.toString());
			setParam(index++, incExpectedDate);
			setParam(index++, kCode);
			executeQuery();
			CmIncomeTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public CmIncomeTaxDto findForEmployee(String kCode) throws SQLException, IllegalAccessException {
		try {
//			index = 1;
//			prepareStatement(getHistoryTable());
//			setParam(index++, kCode);
//			executeQuery();
//			CmIncomeTaxDto dto = null;
//			if (rs.next()) {
//				dto = mapping();
//			}
//			return dto;
			
			// TuNG̎擾
			this.setPreparedStatement(Mode.SELECT, TABLE);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL, kCode);
			this.pob.appendGroupBy(COL_K_CODE);
			this.pob.appendOperationMax(COL_INC_EXPECTED_DATE);
			prepareStatement(null);
			executeQuery();
			List<Object> hKCodes = new ArrayList<Object>();
			List<Object> hEepectedDates = new ArrayList<Object>();
			while (rs.next()) {
				Object hKCode = rs.getObject(COL_K_CODE);
				if (!hKCodes.contains(hKCode)) {
					hKCodes.add(hKCode);
				}
				Object hEepectedDate = rs.getObject(COL_INC_EXPECTED_DATE);
				if (!hEepectedDates.contains(hEepectedDate)) {
					hEepectedDates.add(hEepectedDate);
				}
			}
			// {̎擾
			this.setPreparedStatement(Mode.SELECT, TABLE);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.IN, hKCodes);
			this.pob.appendWhere(COL_INC_EXPECTED_DATE, Query.FilterOperator.IN, hEepectedDates);
			prepareStatement(null);
			executeQuery();
			CmIncomeTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
			
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂzf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return CmIncomeTaxDto (DTO)
	 * @throws SQLException
	 */
	public List<CmIncomeTaxDto> findForEmployeeList(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT * FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			
			this.setPreparedStatement(Mode.SELECT, TABLE);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeQuery();
			List<CmIncomeTaxDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public CmIncomeTaxDto findForUpdate(String kCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			CmIncomeTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode           ЈR[h(L[)
	 * @param incExpectedDate œKpN(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmIncomeTaxDto findForUpdate(String kCode, Date incExpectedDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, incExpectedDate);
			executeQuery();
			CmIncomeTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmIncomeTaxDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmIncomeTaxDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getIncExpectedDate());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			
			this.setPreparedStatement(Mode.DELETE, TABLE);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CmIncomeTaxDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getIncExpectedDate());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @param incExpectedDate œKpN(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public Map<String, CmIncomeTaxDto> findForHumanData(Date incExpectedDate) throws SQLException,
			IllegalAccessException {
		try {
			index = 1;
			prepareStatement(getHistoryTableForHumanData());
			setParam(index++, incExpectedDate);
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
//	/**
//	 * f[^SQL擾
//	 * @return f[^擾SQL
//	 * @throws IllegalAccessException 
//	 */
//	private String getHistoryTable() throws IllegalAccessException {
//		StringBuffer sb = new StringBuffer();
//		sb.append(getSelectStatement(getClass()));
//		sb.append("FROM ");
//		sb.append(TABLE + ", ");
//		sb.append("(");
//		sb.append("SELECT ");
//		sb.append(COL_K_CODE + " AS H_K_CODE, ");
//		sb.append("MAX(" + COL_INC_EXPECTED_DATE + ") AS H_EXPECTED_DATE ");
//		sb.append("FROM " + TABLE + " ");
//		sb.append("WHERE ");
//		sb.append(COL_K_CODE + " = ? ");
//		sb.append("GROUP BY " + COL_K_CODE + " ");
//		sb.append(") HISTORY ");
//		sb.append("WHERE ");
//		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
//		sb.append("AND ");
//		sb.append(COL_INC_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE ");
//		return sb.toString();
//	}
	
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException 
	 */
	private String getHistoryTableForHumanData() throws IllegalAccessException {
		throw new CloudzeroUnsupportedException();
/*		StringBuffer sb = new StringBuffer();
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append("SELECT ");
		sb.append(COL_K_CODE + " AS H_K_CODE, ");
		sb.append("MAX(" + COL_INC_EXPECTED_DATE + ") AS H_EXPECTED_DATE ");
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE " + COL_INC_EXPECTED_DATE + " <= ? ");
		sb.append("GROUP BY " + COL_K_CODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_INC_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE ");
		return sb.toString();*/
	}
	
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException 
	 */
	public String getHistoryTableForDate() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(getHistoryTableForHumanData());
		sb.append(") " + TABLE + " ");
		return sb.toString();
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmIncomeTaxDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); // ЈR[h
		setParam(index++, dto.getIncExpectedDate()); // œKpN
		setParam(index++, dto.getIncomeTaxType()); // ېŋ敪
		setParam(index++, dto.getAdjustmentType()); // N敪
		setParam(index++, dto.getSelfWidowType()); // {lǕw敪
		setParam(index++, dto.getSelfHandicapType()); // {lQ敪
		setParam(index++, dto.getSelfStudentType()); // {lw敪
		setParam(index++, dto.getSpouseIntendType()); // zҋ敪
		setParam(index++, dto.getGeneralDependent()); // ʕ}{e
		setParam(index++, dto.getSpecificDependent()); // }{e
		setParam(index++, dto.getElderlyDependent()); // Vl}{e
		setParam(index++, dto.getLiveWithEldRel()); // Ve
		setParam(index++, dto.getLiveWithHandiGe()); // 
		setParam(index++, dto.getLiveWithHandiSp()); // 
		setParam(index++, dto.getLiveWithHandiEl()); // Vl
		setParam(index++, dto.getLiveWithHandiEr()); // Ve
		setParam(index++, dto.getGeneralHandicap()); // ʏQ
		setParam(index++, dto.getSpecificHandicap()); // ʏQ
		setParam(index++, dto.getDependentCount()); // }{̐
		setCommonParams(isInsert);
	}
}
