/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.dto.PdBonusDto;

public class PdBonusDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE					= "UD_BONUS";
	public static final String	KEY_1					= "K_CODE";				// ЈR[h
	public static final String	KEY_2					= "CALC_DATE";				// vZN
	public static final String	KEY_3					= "PAYDAY";				// ܗ^x
																					
	// 
	public static final String	COL_K_CODE				= "K_CODE";				// ЈR[h
	public static final String	COL_CALC_DATE			= "CALC_DATE";				// vZN
	public static final String	COL_PAYDAY				= "PAYDAY";				// ܗ^x
	public static final String	COL_CALC_STATUS			= "CALC_STATUS";			// vZXe[^X
	public static final String	COL_K_NAME				= "K_NAME";				// Ј
	public static final String	COL_STATION_CODE		= "STATION_CODE";			// R[h
	public static final String	COL_POSITION_CODE		= "POSITION_CODE";			// EʃR[h
	public static final String	COL_EMPLOYMENT_TYPE		= "EMPLOYMENT_TYPE";		// ٗp敪
	public static final String	COL_BONUS_ALLOWANCE_01	= "BONUS_ALLOWANCE_01";	// ܗ^x01
	public static final String	COL_BONUS_ALLOWANCE_02	= "BONUS_ALLOWANCE_02";	// ܗ^x02
	public static final String	COL_BONUS_ALLOWANCE_03	= "BONUS_ALLOWANCE_03";	// ܗ^x03
	public static final String	COL_BONUS_ALLOWANCE_04	= "BONUS_ALLOWANCE_04";	// ܗ^x04
	public static final String	COL_BONUS_ALLOWANCE_05	= "BONUS_ALLOWANCE_05";	// ܗ^x05
	public static final String	COL_BONUS_ALLOWANCE_06	= "BONUS_ALLOWANCE_06";	// ܗ^x06
	public static final String	COL_BONUS_ALLOWANCE_07	= "BONUS_ALLOWANCE_07";	// ܗ^x07
	public static final String	COL_BONUS_ALLOWANCE_08	= "BONUS_ALLOWANCE_08";	// ܗ^x08
	public static final String	COL_BONUS_ALLOWANCE_09	= "BONUS_ALLOWANCE_09";	// ܗ^x09
	public static final String	COL_BONUS_ALLOWANCE_10	= "BONUS_ALLOWANCE_10";	// ܗ^x10
	public static final String	COL_BONUS_ALLOWANCE_11	= "BONUS_ALLOWANCE_11";	// ܗ^x11
	public static final String	COL_BONUS_ALLOWANCE_12	= "BONUS_ALLOWANCE_12";	// ܗ^x12
	public static final String	COL_BONUS_ALLOWANCE_13	= "BONUS_ALLOWANCE_13";	// ܗ^x13
	public static final String	COL_BONUS_ALLOWANCE_14	= "BONUS_ALLOWANCE_14";	// ܗ^x14
	public static final String	COL_BONUS_ALLOWANCE_15	= "BONUS_ALLOWANCE_15";	// ܗ^x15
	public static final String	COL_BONUS_ALLOWANCE_16	= "BONUS_ALLOWANCE_16";	// ܗ^x16
	public static final String	COL_BONUS_ALLOWANCE_17	= "BONUS_ALLOWANCE_17";	// ܗ^x17
	public static final String	COL_BONUS_ALLOWANCE_18	= "BONUS_ALLOWANCE_18";	// ܗ^x18
	public static final String	COL_BONUS_ALLOWANCE_19	= "BONUS_ALLOWANCE_19";	// ܗ^x19
	public static final String	COL_BONUS_ALLOWANCE_20	= "BONUS_ALLOWANCE_20";	// ܗ^x20
	public static final String	COL_HEALTH_INSURANCE	= "HEALTH_INSURANCE";		// Nی
	public static final String	COL_PENSION_INSURANCE	= "PENSION_INSURANCE";		// Nی
	public static final String	COL_EMPLOYEE_INSURANCE	= "EMPLOYEE_INSURANCE";	// ٗpی
	public static final String	COL_INCOME_TAX			= "INCOME_TAX";			// 
	public static final String	COL_NURSING_INSURANCE	= "NURSING_INSURANCE";		// ی
	public static final String	COL_BONUS_DEDUCTION_06	= "BONUS_DEDUCTION_06";	// ܗ^T06
	public static final String	COL_BONUS_DEDUCTION_07	= "BONUS_DEDUCTION_07";	// ܗ^T07
	public static final String	COL_BONUS_DEDUCTION_08	= "BONUS_DEDUCTION_08";	// ܗ^T08
	public static final String	COL_BONUS_DEDUCTION_09	= "BONUS_DEDUCTION_09";	// ܗ^T09
	public static final String	COL_BONUS_DEDUCTION_10	= "BONUS_DEDUCTION_10";	// ܗ^T10
	public static final String	COL_BONUS_DEDUCTION_11	= "BONUS_DEDUCTION_11";	// ܗ^T11
	public static final String	COL_BONUS_DEDUCTION_12	= "BONUS_DEDUCTION_12";	// ܗ^T12
	public static final String	COL_BONUS_DEDUCTION_13	= "BONUS_DEDUCTION_13";	// ܗ^T13
	public static final String	COL_BONUS_DEDUCTION_14	= "BONUS_DEDUCTION_14";	// ܗ^T14
	public static final String	COL_BONUS_DEDUCTION_15	= "BONUS_DEDUCTION_15";	// ܗ^T15
	public static final String	COL_BONUS_DEDUCTION_16	= "BONUS_DEDUCTION_16";	// ܗ^T16
	public static final String	COL_BONUS_DEDUCTION_17	= "BONUS_DEDUCTION_17";	// ܗ^T17
	public static final String	COL_BONUS_DEDUCTION_18	= "BONUS_DEDUCTION_18";	// ܗ^T18
	public static final String	COL_BONUS_DEDUCTION_19	= "BONUS_DEDUCTION_19";	// ܗ^T19
	public static final String	COL_BONUS_DEDUCTION_20	= "BONUS_DEDUCTION_20";	// ܗ^T10
	public static final String	COL_ALLOWANCE_TOTAL		= "ALLOWANCE_TOTAL";		// xz
	public static final String	COL_DEDUCTION_TOTAL		= "DEDUCTION_TOTAL";		// Tz
	public static final String	COL_PAYMENT_TOTAL		= "PAYMENT_TOTAL";			// xz
	public static final String	COL_BANK1_PAY_AMOUNT	= "BANK1_PAY_AMOUNT";		// s1Uz
	public static final String	COL_BANK2_PAY_AMOUNT	= "BANK2_PAY_AMOUNT";		// s2Uz
	public static final String	COL_CASH_PAY_AMOUNT		= "CASH_PAY_AMOUNT";		// xz
	public static final String	COL_DEPENDENT_COUNT		= "DEPENDENT_COUNT";		// }{̐
	public static final String	COL_LAST_MONTH_TAXATION	= "LAST_MONTH_TAXATION";	// Ő^ېőΏۊz
	public static final String	COL_TOTAL_YEAR_BONUS	= "TOTAL_YEAR_BONUS";		// Nx݌vܗ^z
	public static final String	COL_INCOME_RATE			= "INCOME_RATE";			// ŗ
	public static final String	COL_EMP_INS_BASIC		= "EMP_INS_BASIC";			// ٕۑΏۊz
																					
	
	/**
	 * RXgN^
	 */
	public PdBonusDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PdBonusDto> mappingAll() throws SQLException {
		List<PdBonusDto> all = new ArrayList<PdBonusDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PdBonusDto UD_PAYMENTR[h
	 * @throws SQLException
	 */
	private PdBonusDto mapping() throws SQLException {
		PdBonusDto dto = new PdBonusDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setCalcDate(rs.getDate(COL_CALC_DATE)); // vZN
		dto.setPayday(rs.getDate(COL_PAYDAY)); // ܗ^x
		dto.setCalcStatus(rs.getString(COL_CALC_STATUS)); // vZXe[^X
		dto.setKName(rs.getString(COL_K_NAME)); // Ј
		dto.setStationCode(rs.getString(COL_STATION_CODE)); // R[h
		dto.setPositionCode(rs.getString(COL_POSITION_CODE)); // EʃR[h
		dto.setEmploymentType(rs.getString(COL_EMPLOYMENT_TYPE)); // ٗp敪
		dto.setBonusAllowance01(rs.getInt(COL_BONUS_ALLOWANCE_01)); // ܗ^x01
		dto.setBonusAllowance02(rs.getInt(COL_BONUS_ALLOWANCE_02)); // ܗ^x02
		dto.setBonusAllowance03(rs.getInt(COL_BONUS_ALLOWANCE_03)); // ܗ^x03
		dto.setBonusAllowance04(rs.getInt(COL_BONUS_ALLOWANCE_04)); // ܗ^x04
		dto.setBonusAllowance05(rs.getInt(COL_BONUS_ALLOWANCE_05)); // ܗ^x05
		dto.setBonusAllowance06(rs.getInt(COL_BONUS_ALLOWANCE_06)); // ܗ^x06
		dto.setBonusAllowance07(rs.getInt(COL_BONUS_ALLOWANCE_07)); // ܗ^x07
		dto.setBonusAllowance08(rs.getInt(COL_BONUS_ALLOWANCE_08)); // ܗ^x08
		dto.setBonusAllowance09(rs.getInt(COL_BONUS_ALLOWANCE_09)); // ܗ^x09
		dto.setBonusAllowance10(rs.getInt(COL_BONUS_ALLOWANCE_10)); // ܗ^x10
		dto.setBonusAllowance11(rs.getInt(COL_BONUS_ALLOWANCE_11)); // ܗ^x11
		dto.setBonusAllowance12(rs.getInt(COL_BONUS_ALLOWANCE_12)); // ܗ^x12
		dto.setBonusAllowance13(rs.getInt(COL_BONUS_ALLOWANCE_13)); // ܗ^x13
		dto.setBonusAllowance14(rs.getInt(COL_BONUS_ALLOWANCE_14)); // ܗ^x14
		dto.setBonusAllowance15(rs.getInt(COL_BONUS_ALLOWANCE_15)); // ܗ^x15
		dto.setBonusAllowance16(rs.getInt(COL_BONUS_ALLOWANCE_16)); // ܗ^x16
		dto.setBonusAllowance17(rs.getInt(COL_BONUS_ALLOWANCE_17)); // ܗ^x17
		dto.setBonusAllowance18(rs.getInt(COL_BONUS_ALLOWANCE_18)); // ܗ^x18
		dto.setBonusAllowance19(rs.getInt(COL_BONUS_ALLOWANCE_19)); // ܗ^x19
		dto.setBonusAllowance20(rs.getInt(COL_BONUS_ALLOWANCE_20)); // ܗ^x20
		dto.setHealthInsurance(rs.getInt(COL_HEALTH_INSURANCE)); // Nی
		dto.setPensionInsurance(rs.getInt(COL_PENSION_INSURANCE)); // Nی
		dto.setEmployeeInsurance(rs.getInt(COL_EMPLOYEE_INSURANCE)); // ٗpی
		dto.setIncomeTax(rs.getInt(COL_INCOME_TAX)); // 
		dto.setNursingInsurance(rs.getInt(COL_NURSING_INSURANCE)); // ی
		dto.setBonusDeduction06(rs.getInt(COL_BONUS_DEDUCTION_06)); // ܗ^T06
		dto.setBonusDeduction07(rs.getInt(COL_BONUS_DEDUCTION_07)); // ܗ^T07
		dto.setBonusDeduction08(rs.getInt(COL_BONUS_DEDUCTION_08)); // ܗ^T08
		dto.setBonusDeduction09(rs.getInt(COL_BONUS_DEDUCTION_09)); // ܗ^T09
		dto.setBonusDeduction10(rs.getInt(COL_BONUS_DEDUCTION_10)); // ܗ^T10
		dto.setBonusDeduction11(rs.getInt(COL_BONUS_DEDUCTION_11)); // ܗ^T11
		dto.setBonusDeduction12(rs.getInt(COL_BONUS_DEDUCTION_12)); // ܗ^T12
		dto.setBonusDeduction13(rs.getInt(COL_BONUS_DEDUCTION_13)); // ܗ^T13
		dto.setBonusDeduction14(rs.getInt(COL_BONUS_DEDUCTION_14)); // ܗ^T14
		dto.setBonusDeduction15(rs.getInt(COL_BONUS_DEDUCTION_15)); // ܗ^T15
		dto.setBonusDeduction16(rs.getInt(COL_BONUS_DEDUCTION_16)); // ܗ^T16
		dto.setBonusDeduction17(rs.getInt(COL_BONUS_DEDUCTION_17)); // ܗ^T17
		dto.setBonusDeduction18(rs.getInt(COL_BONUS_DEDUCTION_18)); // ܗ^T18
		dto.setBonusDeduction19(rs.getInt(COL_BONUS_DEDUCTION_19)); // ܗ^T19
		dto.setBonusDeduction20(rs.getInt(COL_BONUS_DEDUCTION_20)); // ܗ^T20
		dto.setAllowanceTotal(rs.getInt(COL_ALLOWANCE_TOTAL)); // xz
		dto.setDeductionTotal(rs.getInt(COL_DEDUCTION_TOTAL)); // Tz
		dto.setPaymentTotal(rs.getInt(COL_PAYMENT_TOTAL)); // xz
		dto.setBank1PayAmount(rs.getInt(COL_BANK1_PAY_AMOUNT)); // s1Uz
		dto.setBank2PayAmount(rs.getInt(COL_BANK2_PAY_AMOUNT)); // s2Uz
		dto.setCashPayAmount(rs.getInt(COL_CASH_PAY_AMOUNT)); // xz
		dto.setDependentCount(rs.getInt(COL_DEPENDENT_COUNT)); // }{̐
		dto.setLastMonthTaxation(rs.getInt(COL_LAST_MONTH_TAXATION)); // O^̉ېőΏۊz
		dto.setTotalYearBonus(rs.getInt(COL_TOTAL_YEAR_BONUS)); // Nx݌vܗ^z
		dto.setIncomeRate(rs.getFloat(COL_INCOME_RATE)); // ŗ
		dto.setEmpInsBasic(rs.getInt(COL_EMP_INS_BASIC)); // ٕۑΏۊz
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdBonusDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PdBonusDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param calcDate vZN(L[)
	 * @return PdBonusDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PdBonusDto findForKey(String kCode, Date calcDate, Date payday) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, calcDate);
			setParam(index++, payday);
			executeQuery();
			PdBonusDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @param calcDate vZN(L[)
	 * @return PdBonusDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PdBonusDto findForUpdate(String kCode, Date calcDate, Date payday) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, calcDate);
			setParam(index++, payday);
			executeQuery();
			PdBonusDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdBonusDto> findForCondition(Date calcDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_CALC_DATE, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, calcDate);
			executeQuery();
			List<PdBonusDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param startDate ΏۊJnN
	 * @param endDate ΏۏIN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdBonusDto> findForConditionDate(String kCode, Date startDate, Date endDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_CALC_DATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_CALC_DATE);
		sb.append(" <= ? ");
		this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
		this.pob.appendWhere(COL_CALC_DATE, Query.FilterOperator.GREATER_THAN_OR_EQUAL);
		this.pob.appendWhere(COL_CALC_DATE, Query.FilterOperator.LESS_THAN_OR_EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			List<PdBonusDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param startDate ΏۊJnN
	 * @param endDate ΏۏIN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdBonusDto> findForPaydayOfYear(String kCode, Date startDate, Date endDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_PAYDAY);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_PAYDAY);
		sb.append(" <= ? ");
		this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
		this.pob.appendWhere(COL_PAYDAY, Query.FilterOperator.GREATER_THAN_OR_EQUAL);
		this.pob.appendWhere(COL_PAYDAY, Query.FilterOperator.LESS_THAN_OR_EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			List<PdBonusDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdBonusDto> findForPayday(Date payday) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_PAYDAY);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_PAYDAY, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, payday);
			executeQuery();
			List<PdBonusDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdBonusDto> findForDataLineUp(String kCode, String kName, String stationCode, Date calcDate)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_CALC_DATE, Query.FilterOperator.EQUAL);
		if (kCode != null && !kCode.equals("")) {
			sb.append(COL_K_CODE + " = ");
			sb.append(" ? ");
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			if (kName != null && !kName.equals("") || stationCode != null && !stationCode.equals("")) {
				sb.append("AND ");
			}
		}
		
		if (kName != null && !kName.equals("")) {
			sb.append(COL_K_NAME + " = ");
			sb.append(" ? ");
			this.pob.appendWhere(COL_K_NAME, Query.FilterOperator.EQUAL);
			if (stationCode != null && !stationCode.equals("")) {
				sb.append("AND ");
			}
		}
		
		if (stationCode != null && !stationCode.equals("")) {
			sb.append(COL_STATION_CODE + " = ");
			sb.append(" ? ");
			this.pob.appendWhere(COL_STATION_CODE, Query.FilterOperator.EQUAL);
		}
		
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, calcDate);
			if (kCode != null && !kCode.equals("")) {
				setParam(index++, kCode);
			}
			
			if (kName != null && !kName.equals("")) {
				setParam(index++, kName);
			}
			
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			executeQuery();
			List<PdBonusDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^폜
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public int deleteForPayday(Date payday) throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("DELETE FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_PAYDAY);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_PAYDAY, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(sb.toString());
			setParam(index++, payday);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^폜
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public int deleteForCondition(Date calcDate) throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("DELETE FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		try {
			prepareStatement(sb.toString());
			setParam(index++, calcDate);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PdBonusDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}(Abv[h)
	 * @param aryCsvDate }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 */
	public int insertUpload(String[] aryHeaderNo, String[] aryCsvData, Date calcDate, Date payday, String kName,
			String stationCode, String employmentType, String positionCode) throws SQLException {
		try {
			Date date = new Date();
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("INSERT INTO ");
			sb.append(TABLE);
			sb.append(" ( ");
			sb.append(createCol(aryHeaderNo, true));
			sb.append(COL_CALC_DATE);
			sb.append(", ");
			sb.append(COL_PAYDAY);
			sb.append(", ");
			sb.append(COL_K_NAME);
			sb.append(", ");
			sb.append(COL_STATION_CODE);
			sb.append(", ");
			sb.append(COL_CALC_STATUS);
			sb.append(", ");
			sb.append(COL_EMPLOYMENT_TYPE);
			sb.append(", ");
			sb.append(COL_POSITION_CODE);
			sb.append(", ");
			if (!INSERT_DATE.equals("")) {
				sb.append(INSERT_DATE + ", ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append(INSERT_USER + ", ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + ", ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + " ");
			}
			sb.append(" ) VALUES ( ");
			sb.append(insertRow(aryCsvData));
			sb.append("?, ");
			sb.append("?, ");
			sb.append("?, ");
			sb.append("?, ");
			sb.append("?, ");
			sb.append("?, ");
			sb.append("?, ");
			if (!INSERT_DATE.equals("")) {
				sb.append("?, ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append("?, ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append("?, ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append("?  ");
			}
			sb.append(" ) ");
			prepareStatement(sb.toString());
			for (String element : aryCsvData) {
				setParam(index++, element);
			}
			setParam(index++, calcDate);
			setParam(index++, payday);
			setParam(index++, kName);
			setParam(index++, stationCode);
			setParam(index++, BonusConst.CALC_STATUS_CRE);
			setParam(index++, employmentType);
			setParam(index++, positionCode);
			if (!INSERT_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!INSERT_USER.equals("")) {
				setParam(index++, userId);
			}
			if (!UPDATE_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!UPDATE_USER.equals("")) {
				setParam(index++, userId);
			}
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * IĴSQL쐬
	 * @param aryHeaderNo
	 * @param isInsert
	 * @return
	 */
	
	public String createCol(String[] aryHeaderNo, boolean isInsert) {
		index = 1;
		StringBuffer sb = new StringBuffer();
		for (String element : aryHeaderNo) {
			sb.append(getColumn(Integer.parseInt(element)));
			if (!isInsert) {
				sb.append(" = ? ");
			}
			sb.append(BonusConst.STR_CSV_SEPARATOR);
		}
		return sb.toString();
		
	}
	
	/**
	 * o^p[^
	 * @param aryCsvData
	 * @return
	 */
	
	public String insertRow(String[] aryCsvData) {
		index = 1;
		StringBuffer sb = new StringBuffer();
		for (String element : aryCsvData) {
			sb.append(" ? ");
			sb.append(BonusConst.STR_CSV_SEPARATOR);
		}
		return sb.toString();
		
	}
	
	/**
	 * f[^XV(Abv[h)
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 */
	public int updateUpload(String[] aryHeaderNo, String[] aryCsvData, String kCode, Date calcDate, Date payday,
			String kName, String stationCode, String employmentType, String positionCode) throws SQLException {
		try {
			Date date = new Date();
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("UPDATE ");
			sb.append(TABLE);
			sb.append(" SET ");
			sb.append(createCol(aryHeaderNo, false));
			sb.append(COL_CALC_DATE + " = ?, ");
			sb.append(COL_PAYDAY + " = ?, ");
			sb.append(COL_K_NAME + " = ?, ");
			sb.append(COL_STATION_CODE + " = ?, ");
			sb.append(COL_CALC_STATUS + " = ?, ");
			sb.append(COL_EMPLOYMENT_TYPE + " = ?, ");
			sb.append(COL_POSITION_CODE + " = ?, ");
			
			sb.append(COL_ALLOWANCE_TOTAL + " = ?, ");
			sb.append(COL_DEDUCTION_TOTAL + " = ?, ");
			sb.append(COL_PAYMENT_TOTAL + " = ?, ");
			sb.append(COL_BANK1_PAY_AMOUNT + " = ?, ");
			sb.append(COL_BANK2_PAY_AMOUNT + " = ?, ");
			sb.append(COL_CASH_PAY_AMOUNT + " = ?, ");
			sb.append(COL_LAST_MONTH_TAXATION + " = ?, ");
			sb.append(COL_TOTAL_YEAR_BONUS + " = ?, ");
			
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + " = ?, ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + " = ? ");
			}
			sb.append(" WHERE ");
			sb.append(COL_K_CODE);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_CALC_DATE);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_PAYDAY);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			for (String element : aryCsvData) {
				setParam(index++, element);
			}
			setParam(index++, calcDate);
			setParam(index++, payday);
			setParam(index++, kName);
			setParam(index++, stationCode);
			setParam(index++, BonusConst.CALC_STATUS_CRE);
			setParam(index++, employmentType);
			setParam(index++, positionCode);
			
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			if (!UPDATE_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!UPDATE_USER.equals("")) {
				setParam(index++, userId);
			}
			setParam(index++, kCode);
			setParam(index++, calcDate);
			setParam(index++, payday);
			executeUpdate();
			return cnt;
			
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV(Abv[h)
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException 
	 */
	public List<PdBonusDto> selectCalYear(String kCode, String calYear) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT ");
			sb.append(" * ");
			sb.append(" FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append(" AND YEAR( ");
			sb.append(COL_CALC_DATE);
			sb.append(" ) ");
			sb.append(" = ?  ");
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, calYear);
			executeQuery();
			List<PdBonusDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Nxf[^
	 * @param kCode@ΏێЈR[h
	 * @param startDate Ώ۔N(Jn)
	 * @param endDate Ώ۔N(I)
	 * @return
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	
	public List<PdBonusDto> selectTheYear(String kCode, Date startDate, Date endDate) throws SQLException,
			IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT ");
			sb.append(" * ");
			sb.append(" FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append(" AND  ");
			sb.append(" ? ");
			sb.append(" <= ");
			sb.append(COL_PAYDAY);
			sb.append(" AND  ");
			sb.append(COL_PAYDAY);
			sb.append(" <= ?  ");
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			List<PdBonusDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV(Abv[h)
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException 
	 */
	public PdBonusDto selectCalTime(String kCode, String calYear, String calMonth) throws SQLException,
			IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT ");
			sb.append(" * ");
			sb.append(" FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append(" AND YEAR( ");
			sb.append(COL_CALC_DATE);
			sb.append(" ) ");
			sb.append(" = ?  ");
			sb.append(" AND MONTH( ");
			sb.append(COL_CALC_DATE);
			sb.append(" ) ");
			sb.append(" = ?  ");
			prepareStatement(sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, calYear);
			setParam(index++, calMonth);
			executeQuery();
			PdBonusDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
			
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV(Abv[h)
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException 
	 */
	public PdBonusDto selectCalTimeForUpdate(String kCode, String calYear, String calMonth) throws SQLException,
			IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT ");
			sb.append(" * ");
			sb.append(" FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append(" AND YEAR( ");
			sb.append(COL_CALC_DATE);
			sb.append(" ) ");
			sb.append(" = ?  ");
			sb.append(" AND MONTH( ");
			sb.append(COL_CALC_DATE);
			sb.append(" ) ");
			sb.append(" = ?  ");
			prepareStatement(sb.toString() + getOrderForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, calYear);
			setParam(index++, calMonth);
			executeQuery();
			PdBonusDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
			
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @param needLog Oo͗v
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PdBonusDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate(needLog);
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B<br>
	 * wNɂmς݃f[^𒊏oB<br>
	 * kCodenullɂƁAЈR[hɂwsȂB<br>
	 * ܗ^FBf[^o͎ɗpB
	 * @param payday x
	 * @param kCode    ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdBonusDto> findForFBDataOutputDetail(Date payday, String kCode) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		if (kCode != null) {
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
		}
		sb.append(COL_PAYDAY + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_STATUS + " = '" + BonusConst.CALC_STATUS_FIX + "' ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (kCode != null) {
				setParam(index++, kCode);
			}
			setParam(index++, payday);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B<br>
	 * wNɂmς݃f[^𒊏oB<br>
	 * kCodenullɂƁAЈR[hɂwsȂB<br>
	 * ܗ^FBf[^o͎ɗpB
	 * @param payday x
	 * @param kCode    ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdBonusDto> findForCalcDate(Date calcDate, String kCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		if (kCode != null) {
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
		}
		sb.append(COL_CALC_DATE + " = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (kCode != null) {
				setParam(index++, kCode);
			}
			setParam(index++, calcDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @param needLog Oo͗v
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PdBonusDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getCalcDate());
			setParam(index++, dto.getPayday());
			executeUpdate(needLog);
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B<br>
	 * wNɂmς݃f[^𒊏oB<br>
	 * kCodenullɂƁAЈR[hɂwsȂB<br>
	 * ^׏o͎ɗpB
	 * @param calcDate vZN
	 * @param kCode    ЈR[h
	 * @param stationCode R[h(Ə)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdBonusDto> findForOutputDetail(Date calcDate, Date payday, String kCode, String stationCode)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		if (kCode != null) {
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
		}
		sb.append(COL_CALC_DATE + " = ? ");
		sb.append("AND ");
		sb.append(COL_PAYDAY + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_STATUS + " IN ('" + BonusConst.CALC_STATUS_FIX + "','" + BonusConst.CALC_STATUS_FB + "')");
		if (stationCode != null) {
			if (!stationCode.equals("")) {
				sb.append("AND ");
				sb.append(COL_STATION_CODE + " IN  ( " + PmStationDao.getStationQuery() + " ) ");
			}
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (kCode != null) {
				setParam(index++, kCode);
			}
			setParam(index++, calcDate);
			setParam(index++, payday);
			if (stationCode != null) {
				if (!stationCode.equals("")) {
					setParam(index++, stationCode);
				}
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PdBonusDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getCalcDate());
			setParam(index++, dto.getPayday());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PdBonusDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); // ЈR[h
		setParam(index++, dto.getCalcDate()); // vZN
		setParam(index++, dto.getPayday()); // ܗ^x
		setParam(index++, dto.getCalcStatus()); // vZXe[^X
		setParam(index++, dto.getKName()); // Ј
		setParam(index++, dto.getStationCode()); // R[h
		setParam(index++, dto.getPositionCode()); // EʃR[h
		setParam(index++, dto.getEmploymentType()); // ٗp敪
		setParam(index++, dto.getBonusAllowance01()); // ܗ^x01
		setParam(index++, dto.getBonusAllowance02()); // ܗ^x02
		setParam(index++, dto.getBonusAllowance03()); // ܗ^x03
		setParam(index++, dto.getBonusAllowance04()); // ܗ^x04
		setParam(index++, dto.getBonusAllowance05()); // ܗ^x05
		setParam(index++, dto.getBonusAllowance06()); // ܗ^x06
		setParam(index++, dto.getBonusAllowance07()); // ܗ^x07
		setParam(index++, dto.getBonusAllowance08()); // ܗ^x08
		setParam(index++, dto.getBonusAllowance09()); // ܗ^x09
		setParam(index++, dto.getBonusAllowance10()); // ܗ^x10
		setParam(index++, dto.getBonusAllowance11()); // ܗ^x11
		setParam(index++, dto.getBonusAllowance12()); // ܗ^x12
		setParam(index++, dto.getBonusAllowance13()); // ܗ^x13
		setParam(index++, dto.getBonusAllowance14()); // ܗ^x14
		setParam(index++, dto.getBonusAllowance15()); // ܗ^x15
		setParam(index++, dto.getBonusAllowance16()); // ܗ^x16
		setParam(index++, dto.getBonusAllowance17()); // ܗ^x17
		setParam(index++, dto.getBonusAllowance18()); // ܗ^x18
		setParam(index++, dto.getBonusAllowance19()); // ܗ^x19
		setParam(index++, dto.getBonusAllowance20()); // ܗ^x20
		setParam(index++, dto.getHealthInsurance()); // Nی
		setParam(index++, dto.getPensionInsurance()); // Nی
		setParam(index++, dto.getEmployeeInsurance()); // ٗpی
		setParam(index++, dto.getIncomeTax()); // 
		setParam(index++, dto.getNursingInsurance()); // ی
		setParam(index++, dto.getBonusDeduction06()); // ܗ^T06
		setParam(index++, dto.getBonusDeduction07()); // ܗ^T07
		setParam(index++, dto.getBonusDeduction08()); // ܗ^T08
		setParam(index++, dto.getBonusDeduction09()); // ܗ^T09
		setParam(index++, dto.getBonusDeduction10()); // ܗ^T10
		setParam(index++, dto.getBonusDeduction11()); // ܗ^T11
		setParam(index++, dto.getBonusDeduction12()); // ܗ^T12
		setParam(index++, dto.getBonusDeduction13()); // ܗ^T13
		setParam(index++, dto.getBonusDeduction14()); // ܗ^T14
		setParam(index++, dto.getBonusDeduction15()); // ܗ^T15
		setParam(index++, dto.getBonusDeduction16()); // ܗ^T16
		setParam(index++, dto.getBonusDeduction17()); // ܗ^T17
		setParam(index++, dto.getBonusDeduction18()); // ܗ^T18
		setParam(index++, dto.getBonusDeduction19()); // ܗ^T19
		setParam(index++, dto.getBonusDeduction20()); // ܗ^T20
		setParam(index++, dto.getAllowanceTotal()); // xz
		setParam(index++, dto.getDeductionTotal()); // Tz
		setParam(index++, dto.getPaymentTotal()); // xz
		setParam(index++, dto.getBank1PayAmount()); // s1Uz
		setParam(index++, dto.getBank2PayAmount()); // s2Uz
		setParam(index++, dto.getCashPayAmount()); // xz
		setParam(index++, dto.getDependentCount()); // }{̐
		setParam(index++, dto.getLastMonthTaxation()); // O^̉ېőΏۊz
		setParam(index++, dto.getTotalYearBonus()); // Nx݌vܗ^z
		setParam(index++, dto.getIncomeRate()); // ŗ
		setParam(index++, dto.getEmpInsBasic()); // ٕۑΏۊz
		setCommonParams(isInsert);
	}
	
	/**
	 * J擾
	 * @param idx
	 * @return J
	 */
	public String getColumn(int idx) {
		switch (idx) {
			case 0:
				return COL_K_CODE; //	ЈR[h
			case 1:
				return COL_BONUS_ALLOWANCE_01; //	ܗ^x01
			case 2:
				return COL_BONUS_ALLOWANCE_02; //	ܗ^x02
			case 3:
				return COL_BONUS_ALLOWANCE_03; //	ܗ^x03
			case 4:
				return COL_BONUS_ALLOWANCE_04; //	ܗ^x04
			case 5:
				return COL_BONUS_ALLOWANCE_05; //	ܗ^x05
			case 6:
				return COL_BONUS_ALLOWANCE_06; //	ܗ^x06
			case 7:
				return COL_BONUS_ALLOWANCE_07; //	ܗ^x07
			case 8:
				return COL_BONUS_ALLOWANCE_08; //	ܗ^x08
			case 9:
				return COL_BONUS_ALLOWANCE_09; //	ܗ^x09
			case 10:
				return COL_BONUS_ALLOWANCE_10; //	ܗ^x10
			case 11:
				return COL_BONUS_ALLOWANCE_11; //	ܗ^x11
			case 12:
				return COL_BONUS_ALLOWANCE_12; //	ܗ^x12
			case 13:
				return COL_BONUS_ALLOWANCE_13; //	ܗ^x13
			case 14:
				return COL_BONUS_ALLOWANCE_14; //	ܗ^x14
			case 15:
				return COL_BONUS_ALLOWANCE_15; //	ܗ^x15
			case 16:
				return COL_BONUS_ALLOWANCE_16; //	ܗ^x16
			case 17:
				return COL_BONUS_ALLOWANCE_17; //	ܗ^x17
			case 18:
				return COL_BONUS_ALLOWANCE_18; //	ܗ^x18
			case 19:
				return COL_BONUS_ALLOWANCE_19; //	ܗ^x19
			case 20:
				return COL_BONUS_ALLOWANCE_20; //	ܗ^x20
			case 21:
				return COL_BONUS_DEDUCTION_06; //	ܗ^T06
			case 22:
				return COL_BONUS_DEDUCTION_07; //	ܗ^T07
			case 23:
				return COL_BONUS_DEDUCTION_08; //	ܗ^T08
			case 24:
				return COL_BONUS_DEDUCTION_09; //	ܗ^T09
			case 25:
				return COL_BONUS_DEDUCTION_10; //	ܗ^T10
			case 26:
				return COL_BONUS_DEDUCTION_11; //	ܗ^T11
			case 27:
				return COL_BONUS_DEDUCTION_12; //	ܗ^T12
			case 28:
				return COL_BONUS_DEDUCTION_13; //	ܗ^T13
			case 29:
				return COL_BONUS_DEDUCTION_14; //	ܗ^T14
			case 30:
				return COL_BONUS_DEDUCTION_15; //	ܗ^T15
			case 31:
				return COL_BONUS_DEDUCTION_16; //	ܗ^T16
			case 32:
				return COL_BONUS_DEDUCTION_17; //	ܗ^T17
			case 33:
				return COL_BONUS_DEDUCTION_18; //	ܗ^T18
			case 34:
				return COL_BONUS_DEDUCTION_19; //	ܗ^T19
			case 35:
				return COL_BONUS_DEDUCTION_20; //	ܗ^T10
			default:
				return "";
		}
	}
}
