/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.payroll.dao.MKintaiKeisanDao;
import jp.mosp.payroll.dto.MKintaiKeisanDto;
import jp.mosp.payroll.vo.AttendanceCalculateStartCardVo;

/**
 * @author yoshida
 *
 */
public class AttendanceCalculateStartCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_START_CARD_SHOW		= "P1020";
	private static final String	CMD_START_CARD_UPDATE	= "P1021";
	

	/**
	 * RXgN^
	 */
	public AttendanceCalculateStartCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_START_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_START_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceCalculateStartCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		AttendanceCalculateStartCardVo vo = (AttendanceCalculateStartCardVo)getVo();
		// NxXg擾
		vo.aryPltKTnen = StringUtil.getYearArray(MospUtility.getYear(getCalcMonth()), 1, 1);
		// Xg擾
		vo.aryPltKTtuki = StringUtil.getMonthArray();
	}
	
	@Override
	protected void show() throws Exception {
		AttendanceCalculateStartCardVo vo = (AttendanceCalculateStartCardVo)getVo();
		vo.setDefaultValues();
		MKintaiKeisanDto dto = part().calculate().findForCalc();
		if (VariousUtil.isNull(dto)) {
			dto = new MKintaiKeisanDto();
			Date calcMonth = getCalcAttendanceMonth(DateUtil.getSystemDate());
			dto.setKTNen(MospUtility.getYear(calcMonth));
			dto.setKTTuki(MospUtility.getMonth(calcMonth));
		}
		// vZΏ۔NZbg
		vo.setFields(dto);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		MKintaiKeisanDto dto = (MKintaiKeisanDto)getSessionDto();
		AttendanceCalculateStartCardVo vo = (AttendanceCalculateStartCardVo)getVo();
		vo.setParams(request);
		// DAȌ
		MKintaiKeisanDao dao = part().calculate().getKeisanDao();
		// XVOf[^fds
		MKintaiKeisanDto formerDto = dao.findForUpdate();
		// ͓t
		Date change = DateUtil.getFirstDateOfMonth(vo.getPltKTnen(), vo.getPltKTtuki());
		// XVOdto݂邩ǂ`FbN
		if (VariousUtil.isNotNull(formerDto)) {
			// Wvt
			Date current = DateUtil.getFirstDateOfMonth(formerDto.getKTNen(), formerDto.getKTTuki());
			// p[^̑ÓmF
			vo.validate(formerDto, current, change);
			// 폜
			dao.delete(formerDto);
		}
		// ύXlDTOɃZbg
		vo.setDtoFields(dto);
		// ^vZZbg
		dto.setKSNen(MospUtility.getYear(getCalcPayment(change)));
		dto.setKSTuki(MospUtility.getMonth(getCalcPayment(change)));
		dto.setKShi(MospUtility.getDay(getCalcPayment(change)));
		// o^	
		dao.insert(dto);
		// DTO̍Ď擾
		MKintaiKeisanDto retDto = dao.findForKey(dto.getKTNen());
		chkUpdate(retDto);
		vo.setFields(retDto);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// R~bg
		commit();
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
}
