/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dto.CmLimitStandardDto;

/**
 * CM_LIMIT_STANDARD(x}X^)DAONX B
 */
public class CmLimitStandardDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * CM_LIMIT_STANDARD(x}X^)B
	 */
	public static final String	TABLE				= "CM_LIMIT_STANDARD";
	
	/**
	 * KEY_1 = LIMIT_CODE(xR[h)B
	 */
	public static final String	KEY_1				= "LIMIT_CODE";
	
	// 
	/**
	 * LIMIT_CODE(xR[h)B
	 */
	public static final String	COL_LIMIT_CODE		= "LIMIT_CODE";
	/**
	 * LIMIT_NAME(x)B
	 */
	public static final String	COL_LIMIT_NAME		= "LIMIT_NAME";
	/**
	 * TERM_TYPE(Ԃ̎)B
	 */
	public static final String	COL_TERM_TYPE		= "TERM_TYPE";
	/**
	 * PRESCRIBED_TIME(J)B
	 */
	public static final String	COL_PRESCRIBED_TIME	= "PRESCRIBED_TIME";
	/**
	 * CAUTION_DAY(1̌x)B
	 */
	public static final String	COL_CAUTION_DAY		= "CAUTION_DAY";
	/**
	 * CAUTION_TERM(wԂ̌x)B
	 */
	public static final String	COL_CAUTION_TERM	= "CAUTION_TERM";
	/**
	 * CAUTION_YEAR(1Ňx)B
	 */
	public static final String	COL_CAUTION_YEAR	= "CAUTION_YEAR";
	/**
	 * LIMIT_DAY(̌x)B
	 */
	public static final String	COL_LIMIT_DAY		= "LIMIT_DAY";
	/**
	 * LIMIT_TERM(wԂ̌x)B
	 */
	public static final String	COL_LIMIT_TERM		= "LIMIT_TERM";
	/**
	 * LIMIT_YEAR(1Ňx)B
	 */
	public static final String	COL_LIMIT_YEAR		= "LIMIT_YEAR";
	/**
	 * RATE_TERM(wԂ̊)B
	 */
	public static final String	COL_RATE_TERM		= "RATE_TERM";
	/**
	 * RATE_YEAR(1N̊)B
	 */
	public static final String	COL_RATE_YEAR		= "RATE_YEAR";
	/**
	 * DELETE_FLAG(폜tO)B
	 */
	public static final String	COL_DELETE_FLAG		= "DELETE_FLAG";
	

	/**
	 * RXgN^B
	 */
	public CmLimitStandardDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)B
	 * @return ʃXg
	 * @throws SQLException 	SQLOꍇ
	 */
	private List<CmLimitStandardDto> mappingAll() throws SQLException {
		List<CmLimitStandardDto> all = new ArrayList<CmLimitStandardDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)B
	 * @return CM_LIMIT_STANDARDR[h
	 * @throws SQLException 	SQLOꍇ
	 */
	private CmLimitStandardDto mapping() throws SQLException {
		CmLimitStandardDto dto = new CmLimitStandardDto();
		dto.setLimitCode(rs.getString(COL_LIMIT_CODE));
		dto.setLimitName(rs.getString(COL_LIMIT_NAME));
		dto.setTermType(rs.getString(COL_TERM_TYPE));
		dto.setPrescribedTime(rs.getInt(COL_PRESCRIBED_TIME));
		dto.setCautionDay(rs.getInt(COL_CAUTION_DAY));
		dto.setCautionTerm(rs.getInt(COL_CAUTION_TERM));
		dto.setCautionYear(rs.getInt(COL_CAUTION_YEAR));
		dto.setLimitDay(rs.getInt(COL_LIMIT_DAY));
		dto.setLimitTerm(rs.getInt(COL_LIMIT_TERM));
		dto.setLimitYear(rs.getInt(COL_LIMIT_YEAR));
		dto.setRateTerm(rs.getInt(COL_RATE_TERM));
		dto.setRateYear(rs.getInt(COL_RATE_YEAR));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾B
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmLimitStandardDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param limitCode xR[h
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmLimitStandardDto findForKey(String limitCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, limitCode);
			executeQuery();
			CmLimitStandardDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾B
	 * @param limitCode xR[h
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmLimitStandardDto findForUpdate(String limitCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, limitCode);
			executeQuery();
			CmLimitStandardDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param limitCode xR[h
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmLimitStandardDto> findForCondition(String limitCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_LIMIT_CODE);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_LIMIT_CODE, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, limitCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param limitCode xR[h
	 * @param limitName x
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmLimitStandardDto> findForCondition(String limitCode, String limitName) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_LIMIT_CODE);
		sb.append(" LIKE ? ");
		sb.append("AND");
		sb.append(COL_LIMIT_NAME);
		sb.append(" LIKE ? ");
		this.pob.appendLike(COL_LIMIT_CODE);
		this.pob.appendLike(COL_LIMIT_NAME);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, limitCode + "%");
			setParam(index++, "%" + limitName + "%");
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param limitCode xR[h
	 * @param limitName x
	 * @param deleteFlag 폜tO
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmLimitStandardDto> findForCondition(String limitCode, String limitName, String deleteFlag)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_LIMIT_CODE);
		sb.append(" LIKE ? ");
		sb.append("AND ");
		sb.append(COL_LIMIT_NAME);
		sb.append(" LIKE ? ");
		this.pob.appendLike(COL_LIMIT_CODE);
		this.pob.appendLike(COL_LIMIT_NAME);
		if (!deleteFlag.equals("")) {
			sb.append("AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, limitCode + "%");
			setParam(index++, "%" + limitName + "%");
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmLimitStandardDto> findAvailable() throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF + " ");
		this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param limitCode xR[h
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmLimitStandardDto findForLimitCode(String limitCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_LIMIT_CODE);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_LIMIT_CODE, Query.FilterOperator.EQUAL);
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, limitCode);
			executeQuery();
			CmLimitStandardDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(CmLimitStandardDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(CmLimitStandardDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getLimitCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜B
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(CmLimitStandardDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getLimitCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒB
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseF})
	 * @throws SQLException 	SQLOꍇ
	 */
	private void setParams(CmLimitStandardDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getLimitCode());
		setParam(index++, dto.getLimitName());
		setParam(index++, dto.getTermType());
		setParam(index++, dto.getPrescribedTime());
		setParam(index++, dto.getCautionDay());
		setParam(index++, dto.getCautionTerm());
		setParam(index++, dto.getCautionYear());
		setParam(index++, dto.getLimitDay());
		setParam(index++, dto.getLimitTerm());
		setParam(index++, dto.getLimitYear());
		setParam(index++, dto.getRateTerm());
		setParam(index++, dto.getRateYear());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
