/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.getset.gae.bigtable.PreparedStatement;
import jp.getset.gae.bigtable.option.PreparedProperty;
import jp.getset.gae.bigtable.option.operation.OperationMax;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dto.CmAgreementOverTimeDto;

/**
 * CM_AGREEMENT_OVER_TIME(ԊO}X^)DAONX B
 */
public class CmAgreementOverTimeDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * CM_AGREEMENT_OVER_TIME(ԊO}X^)B
	 */
	public static final String	TABLE							= "CM_AGREEMENT_OVER_TIME";
	
	/**
	 * KEY_1 = OVER_TIME_ID(ԊOID)B
	 */
	public static final String	KEY_1							= "OVER_TIME_ID";
	
	// 
	/**
	 * OVER_TIME_ID(ԊOID)B
	 */
	public static final String	COL_OVER_TIME_ID				= "OVER_TIME_ID";
	/**
	 * OVER_TIME_CODE(ԊOR[h)B
	 */
	public static final String	COL_OVER_TIME_CODE				= "OVER_TIME_CODE";
	/**
	 * WORK_TYPE_NAME(Ɩ̎)B
	 */
	public static final String	COL_WORK_TYPE_NAME				= "WORK_TYPE_NAME";
	/**
	 * CAUSE(̓IR)B
	 */
	public static final String	COL_CAUSE						= "CAUSE";
	/**
	 * AGREE_TYPE()B
	 */
	public static final String	COL_AGREE_TYPE					= "AGREE_TYPE";
	/**
	 * LIMIT_CODE(xR[h)B
	 */
	public static final String	COL_LIMIT_CODE					= "LIMIT_CODE";
	/**
	 * OVER_TIME_RATE(ԊO)B
	 */
	public static final String	COL_OVER_TIME_RATE				= "OVER_TIME_RATE";
	/**
	 * CAUTION_MONTH(60ԎԊOx)B
	 */
	public static final String	COL_CAUTION_MONTH				= "CAUTION_MONTH";
	/**
	 * MONTHLY_OVER_TIME_RATE(60ԎԊO)B
	 */
	public static final String	COL_MONTHLY_OVER_TIME_RATE		= "MONTHLY_OVER_TIME_RATE";
	/**
	 * SUB_ACQUIRE_RATE(֋xɎ擾)B
	 */
	public static final String	COL_SUB_ACQUIRE_RATE			= "SUB_ACQUIRE_RATE";
	/**
	 * SUB_ACQUIRE_HOLIDAY_RATE(֋xɎ擾x)B
	 */
	public static final String	COL_SUB_ACQUIRE_HOLIDAY_RATE	= "SUB_ACQUIRE_HOLIDAY_RATE";
	/**
	 * SUB_QUIT_RATE(֋xɕ)B
	 */
	public static final String	COL_SUB_QUIT_RATE				= "SUB_QUIT_RATE";
	/**
	 * START_DATE(JnN)B
	 */
	public static final String	COL_START_DATE					= "START_DATE";
	/**
	 * DELETE_FLAG(폜tO)B
	 */
	public static final String	COL_DELETE_FLAG					= "DELETE_FLAG";
	

	/**
	 * RXgN^B
	 */
	public CmAgreementOverTimeDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)B
	 * @return ʃXg
	 * @throws SQLException 	SQLOꍇ
	 */
	private List<CmAgreementOverTimeDto> mappingAll() throws SQLException {
		List<CmAgreementOverTimeDto> all = new ArrayList<CmAgreementOverTimeDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)B
	 * @return CM_AGREEMENT_OVER_TIMER[h
	 * @throws SQLException 	SQLOꍇ
	 */
	private CmAgreementOverTimeDto mapping() throws SQLException {
		CmAgreementOverTimeDto dto = new CmAgreementOverTimeDto();
		dto.setOverTimeId(rs.getInt(COL_OVER_TIME_ID));
		dto.setOverTimeCode(rs.getString(COL_OVER_TIME_CODE));
		dto.setWorkTypeName(rs.getString(COL_WORK_TYPE_NAME));
		dto.setCause(rs.getString(COL_CAUSE));
		dto.setAgreeType(rs.getString(COL_AGREE_TYPE));
		dto.setLimitCode(rs.getString(COL_LIMIT_CODE));
		dto.setOverTimeRate(rs.getInt(COL_OVER_TIME_RATE));
		dto.setCautionMonth(rs.getInt(COL_CAUTION_MONTH));
		dto.setMonthlyOverTimeRate(rs.getInt(COL_MONTHLY_OVER_TIME_RATE));
		dto.setSubAcquireRate(rs.getInt(COL_SUB_ACQUIRE_RATE));
		dto.setSubAcquireHolidayRate(rs.getInt(COL_SUB_ACQUIRE_HOLIDAY_RATE));
		dto.setSubQuitRate(rs.getInt(COL_SUB_QUIT_RATE));
		dto.setStartDate(rs.getDate(COL_START_DATE));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾B
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmAgreementOverTimeDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param overTimeId ԊOID
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementOverTimeDto findForKey(int overTimeId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, overTimeId);
			executeQuery();
			CmAgreementOverTimeDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾B
	 * @param overTimeId ԊOID
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementOverTimeDto findForUpdate(int overTimeId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, overTimeId);
			executeQuery();
			CmAgreementOverTimeDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param overTimeId ԊOID
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmAgreementOverTimeDto> findForCondition(int overTimeId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_OVER_TIME_ID);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_OVER_TIME_ID, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, overTimeId);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param overTimeCode ԊOR[
	 * @param workTypeName Ɩ̎
	 * @param deleteFlag 폜tO
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmAgreementOverTimeDto> findForCondition(String overTimeCode, String workTypeName, String deleteFlag)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_OVER_TIME_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_WORK_TYPE_NAME);
		sb.append(" LIKE ? ");
		this.pob.appendLike(COL_OVER_TIME_CODE);
		this.pob.appendLike(COL_WORK_TYPE_NAME);
		if (!deleteFlag.equals("")) {
			sb.append("AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, overTimeCode + "%");
			setParam(index++, "%" + workTypeName + "%");
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param overTimeCode ԊOR[h
	 * @param startdate ԊOR[h
	 * @param deleteFlag 폜tO
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmAgreementOverTimeDto> findForCondition(String overTimeCode, Date startdate, int deleteFlag)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_OVER_TIME_CODE);
		sb.append(" = ? ");
		sb.append("AND ");
		sb.append(COL_START_DATE);
		sb.append(" = ? ");
		sb.append("AND ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_OVER_TIME_CODE, Query.FilterOperator.EQUAL);
		this.pob.appendWhere(COL_START_DATE, Query.FilterOperator.EQUAL);
		this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, overTimeCode);
			setParam(index++, startdate);
			setParam(index++, deleteFlag);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param overTimeCode ԊOR[h
	 * @param targetDate Ώ۔N
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementOverTimeDto findForAgreement(String overTimeCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_OVER_TIME_CODE);
			sb.append(" = ?");
			sb.append(" AND ");
			sb.append(COL_START_DATE);
			sb.append(" <= ? ");
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_OVER_TIME_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_START_DATE, Query.FilterOperator.LESS_THAN_OR_EQUAL);
			sb.append(getOrderBy());
			sb.append(COL_START_DATE);
			sb.append(" ");
			sb.append(getDesc());
			sb.append(getLimit());
			sb.append("1");
			this.pob.appendSort(COL_START_DATE, Query.SortDirection.DESCENDING);
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			this.pob.setLimit(1);
			setParam(index++, overTimeCode);
			setParam(index++, targetDate);
			executeQuery();
			CmAgreementOverTimeDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param overTimeCode ԊOR[h
	 * @param targetDate Ώ۔N
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementOverTimeDto findForStartDate(String overTimeCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_OVER_TIME_CODE);
			sb.append(" = ?");
			sb.append(" AND ");
			sb.append(COL_START_DATE);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_OVER_TIME_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_START_DATE, Query.FilterOperator.EQUAL);
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, overTimeCode);
			setParam(index++, targetDate);
			executeQuery();
			CmAgreementOverTimeDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * maxl擾
	 * @return String@őA
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String max = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_OVER_TIME_ID);
			sb.append(") FROM ");
			sb.append(TABLE);
			this.setPreparedStatement(PreparedStatement.Mode.SELECT, getClass());
			PreparedProperty operationMax = new PreparedProperty(COL_OVER_TIME_ID);
			operationMax.setOperation(new OperationMax());
			this.pob.appendFilledPreparable(operationMax);
			
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				max = String.valueOf(rs.getLong(1));
			}
			return max;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ԊOR[h擾
	 * @param targetDate Ώ۔N
	 * @return 
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<String> findForOverTimeCode(Date targetDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT DISTINCT ");
			sb.append(COL_OVER_TIME_CODE);
			sb.append(" FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_START_DATE);
			sb.append(" <= ?");
			// GAE
			this.setPreparedStatement(PreparedStatement.Mode.SELECT, getClass());
			this.pob.appendDistinct(COL_OVER_TIME_CODE);
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_START_DATE, Query.FilterOperator.LESS_THAN_OR_EQUAL);
			prepareStatement(sb.toString());
			setParam(index++, targetDate);
			executeQuery();
			List<String> list = new ArrayList<String>();
			while (rs.next()) {
				list.add(rs.getString(COL_OVER_TIME_CODE));
			}
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(CmAgreementOverTimeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(CmAgreementOverTimeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getOverTimeId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜B
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(CmAgreementOverTimeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getOverTimeId());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒB
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseF})
	 * @throws SQLException 	SQLOꍇ
	 */
	private void setParams(CmAgreementOverTimeDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getOverTimeId());
		setParam(index++, dto.getOverTimeCode());
		setParam(index++, dto.getWorkTypeName());
		setParam(index++, dto.getCause());
		setParam(index++, dto.getAgreeType());
		setParam(index++, dto.getLimitCode());
		setParam(index++, dto.getOverTimeRate());
		setParam(index++, dto.getCautionMonth());
		setParam(index++, dto.getMonthlyOverTimeRate());
		setParam(index++, dto.getSubAcquireRate());
		setParam(index++, dto.getSubAcquireHolidayRate());
		setParam(index++, dto.getSubQuitRate());
		setParam(index++, dto.getStartDate());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
