/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

/**
 * @author yoshida
 *
 */
public class PaidHolidayCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 4422751719733412912L;
	
	// tB[h
	private String				lblAttendanceCalcY;
	private String				lblAttendanceCalcM;
	private String				lblPaidHolidayTY;
	private String				lblPaidHolidayLY;
	private String				lblRemainApproved;
	private String				lblApproved;
	private String				lblThisMGet;
	private String				lblThisMDispose;
	private String				lblThisMRestLY;
	private String				lblThisMRestTY;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_PAYROLL_CALC;
	/**
	 * 
	 */
	public String				NAM_LAST_M_REST;
	/**
	 * 
	 */
	public String				NAM_THIS_M_GET;
	/**
	 * 
	 */
	public String				NAM_THIS_M_DISPOSE;
	/**
	 * 
	 */
	public String				NAM_THIS_M_REST;
	/**
	 * 
	 */
	public String				NAM_USE;
	/**
	 * 
	 */
	public String				NAM_REMAIN_APPROVED;
	/**
	 * 
	 */
	public String				NAM_APPROVED;
	/**
	 * 
	 */
	public String				NAM_THIS_YEAR;
	/**
	 * 
	 */
	public String				NAM_LAST_YEAR;
	

	/**
	 * RXgN^
	 */
	public PaidHolidayCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_PAID_HOLIDAY_CHECK;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_PAYROLL_CALC = CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_PROVIDED_YEAR_MONTH;
		NAM_LAST_M_REST = CommonConst.NAM_CUT_OFF_MONTH_THIS + CommonConst.NAM_POSSIBLE_AMOUNT;
		NAM_THIS_M_GET = CommonConst.NAM_GET_SCHEDULE;
		NAM_THIS_M_DISPOSE = CommonConst.NAM_DISPOSE_SCHEDULE;
		NAM_THIS_M_REST = CommonConst.NAM_CUT_OFF_MONTH_AFTER + CommonConst.NAM_POSSIBLE_SCHEDULE;
		NAM_USE = CommonConst.NAM_USE;
		NAM_REMAIN_APPROVED = CommonConst.NAM_APPROVAL_REQUEST;
		NAM_APPROVED = CommonConst.NAM_ALREADY_APPROVED + CommonConst.NAM_PAID_HOLIDAY_AMOUNT;
		NAM_THIS_YEAR = CommonConst.NAM_YEAR_THIS;
		NAM_LAST_YEAR = CommonConst.NAM_YEAR_FORMER;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setLblAttendanceCalcY("");
		setLblAttendanceCalcM("");
		setLblPaidHolidayLY("0");
		setLblPaidHolidayTY("0");
		setLblRemainApproved("0");
		setLblApproved("0");
		setLblThisMGet("0");
		setLblThisMDispose("0");
		setLblThisMRestLY("0");
		setLblThisMRestTY("0");
	}
	
	// ANZT\bh	
	public String getEscLblAttendanceCalcY() {
		return escapeHTML(lblAttendanceCalcY);
	} //ΑӌvZN
	
	public String getEscLblAttendanceCalcM() {
		return escapeHTML(lblAttendanceCalcM);
	} //ΑӌvZ
	
	public String getEscLblPaidHolidayTY() {
		return escapeHTML(lblPaidHolidayTY);
	} //p\iNj
	
	public String getEscLblPaidHolidayLY() {
		return escapeHTML(lblPaidHolidayLY);
	} //p\iONj
	
	public String getEscLblRemainApproved() {
		return escapeHTML(lblRemainApproved);
	} //\
	
	public String getEscLblApproved() {
		return escapeHTML(lblApproved);
	} //F
	
	public String getEscLblThisMGet() {
		return escapeHTML(lblThisMGet);
	} //ǉ\
	
	public String getEscLblThisMDispose() {
		return escapeHTML(lblThisMDispose);
	} //p\
	
	public String getEscLblThisMRestLY() {
		return escapeHTML(lblThisMRestLY);
	} //p\iONj
	
	public String getEscLblThisMRestTY() {
		return escapeHTML(lblThisMRestTY);
	} //p\iNj
	
	public void setLblAttendanceCalcY(String lblAttendanceCalcY) {
		this.lblAttendanceCalcY = lblAttendanceCalcY;
	} //ΑӌvZN
	
	public void setLblAttendanceCalcM(String lblAttendanceCalcM) {
		this.lblAttendanceCalcM = lblAttendanceCalcM;
	} //ΑӌvZ
	
	public void setLblPaidHolidayTY(String lblPaidHolidayTY) {
		this.lblPaidHolidayTY = lblPaidHolidayTY;
	} //p\iNj
	
	public void setLblPaidHolidayLY(String lblPaidHolidayLY) {
		this.lblPaidHolidayLY = lblPaidHolidayLY;
	} //p\iONj
	
	public void setLblRemainApproved(String lblRemainApproved) {
		this.lblRemainApproved = lblRemainApproved;
	} //\
	
	public void setLblApproved(String lblApproved) {
		this.lblApproved = lblApproved;
	} //F
	
	public void setLblThisMGet(String lblThisMGet) {
		this.lblThisMGet = lblThisMGet;
	} //ǉ\
	
	public void setLblThisMDispose(String lblThisMDispose) {
		this.lblThisMDispose = lblThisMDispose;
	} //p\
	
	public void setLblThisMRestTY(String lblThisMRestTY) {
		this.lblThisMRestTY = lblThisMRestTY;
	} //p\iNj
	
	public void setLblThisMRestLY(String lblThisMRestLY) {
		this.lblThisMRestLY = lblThisMRestLY;
	} //p\iONj
	
}
