/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.dto.MSyukkinboDto;

public class AttendanceHolidayCardVo extends AttendanceMenuVo {
	
	private static final long	serialVersionUID			= -4666690261405185923L;
	
	// p[^
	public static final String	PRM_PLT_HOLIDAY_REASON		= "pltHolidayReason";
	public static final String	PRM_PLT_HOLIDAY_CERTIFICATE	= "pltHolidayCertificate";
	public static final String	PRM_TXT_HOLIDAY_COMMENT		= "txtHolidayComment";
	
	public static final String	PRM_PLT_SUBSTITUTE_YEAR		= "pltSubstituteYear";
	public static final String	PRM_PLT_SUBSTITUTE_MONTH	= "pltSubstituteMonth";
	public static final String	PRM_PLT_SUBSTITUTE_DAY		= "pltSubstituteDay";
	
	// tB[hyѐ
	public String				NAM_HOLIDAY_REASON;
	public String				NAM_HOLIDAY_CERTIFICATE;
	public String				NAM_HOLIDAY_COMMENT;
	public String				NAM_SUBSTITUTE_HOLIDAY;
	public int					LEN_COMMENT;
	
	// tB[h
	private String				pltHolidayReason;
	private String				pltHolidayCertificate;
	private String				txtHolidayComment;
	private String				pltSubstituteYear;
	private String				pltSubstituteMonth;
	private String				pltSubstituteDay;
	
	private int					holidayTimes;
	
	// v_EXg
	public String[][]			aryPltHolidayReason;
	public String[][]			aryPltHolidayCertificate;
	public String[][]			aryPltSubstituteYear;
	public String[][]			aryPltSubstituteMonth;
	public String[][]			aryPltSubstituteDay;
	

	/**
	 * RXgN^
	 */
	public AttendanceHolidayCardVo() {
		super();
		setViewPath(getClassName());
		setMode(MODE_EDIT);
		addAttendanceMenuCss();
		addAttendanceMenuJs();
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.NAM_INPUT_HOLIDAY;
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_HOLIDAY_REASON = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_REASON;
		NAM_HOLIDAY_CERTIFICATE = CommonConst.NAM_CERTIFICATE;
		NAM_HOLIDAY_COMMENT = CommonConst.NAM_COMMENT;
		NAM_SUBSTITUTE_HOLIDAY = CommonConst.NAM_APPLY_DATE;
		LEN_COMMENT = 50;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		pltHolidayReason = request.getParameter(PRM_PLT_HOLIDAY_REASON);
		pltHolidayCertificate = request.getParameter(PRM_PLT_HOLIDAY_CERTIFICATE);
		txtHolidayComment = request.getParameter(PRM_TXT_HOLIDAY_COMMENT);
		pltSubstituteYear = request.getParameter(PRM_PLT_SUBSTITUTE_YEAR);
		pltSubstituteMonth = request.getParameter(PRM_PLT_SUBSTITUTE_MONTH);
		pltSubstituteDay = request.getParameter(PRM_PLT_SUBSTITUTE_DAY);
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 */
	public void setFields(MSyukkinboDto dto) {
		pltHolidayReason = dto.getKKRiyuu();
		pltHolidayCertificate = dto.getKKSyoumei();
		txtHolidayComment = dto.getKKComent();
		pltSubstituteYear = DateUtil.convStringDateToArray(dto.getDaiKyuJyu())[0];
		pltSubstituteMonth = DateUtil.convStringDateToArray(dto.getDaiKyuJyu())[1];
		pltSubstituteDay = DateUtil.convStringDateToArray(dto.getDaiKyuJyu())[2];
	}
	
	@Override
	public void setDtoFields(MSyukkinboDto dto) {
		super.setDtoFields(dto);
		dto.setKinmu(CommonConst.ATTENDANCE_TYPE_HOLIDAY);
		dto.setKKRiyuu(pltHolidayReason);
		// [
		if (StringUtil.isNotNull(pltSubstituteYear) && StringUtil.isNotNull(pltSubstituteMonth)
				&& StringUtil.isNotNull(pltSubstituteDay)) {
			dto.setDaiKyuJyu(DateUtil.convStringDateFormatted(pltSubstituteYear, pltSubstituteMonth, pltSubstituteDay));
		}
		dto.setKKComent(txtHolidayComment);
		dto.setKKSyoumei(pltHolidayCertificate);
		dto.setKKJikan(holidayTimes);
		dto.setKKTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
		dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
		dto.setUpdtTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
	}
	
	/**
	 * tB[h
	 */
	public void initFields() {
		pltHolidayReason = "";
		pltHolidayCertificate = "";
		txtHolidayComment = "";
		pltSubstituteYear = "";
		pltSubstituteMonth = "";
		pltSubstituteDay = "";
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// [`FbN
		if (StringUtil.isNotNull(pltSubstituteYear) || StringUtil.isNotNull(pltSubstituteMonth)
				|| StringUtil.isNotNull(pltSubstituteDay)) {
			checkDate(getIntParam(pltSubstituteYear), getIntParam(pltSubstituteMonth), getIntParam(pltSubstituteDay),
					NAM_SUBSTITUTE_HOLIDAY, PRM_PLT_SUBSTITUTE_YEAR);
		}
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	public String getPltHolidayReason() {
		return pltHolidayReason;
	}
	
	public String getPltHolidayCertificate() {
		return pltHolidayCertificate;
	}
	
	public String getTxtHolidayComment() {
		return txtHolidayComment;
	}
	
	public String getPltSubstituteYear() {
		return pltSubstituteYear;
	}
	
	public String getPltSubstituteMonth() {
		return pltSubstituteMonth;
	}
	
	public String getPltSubstituteDay() {
		return pltSubstituteDay;
	}
	
	public String getEscPltHolidayReason() {
		return escapeHTML(pltHolidayReason);
	}
	
	public String getEscPltHolidayCertificate() {
		return escapeHTML(pltHolidayCertificate);
	}
	
	public String getEscTxtHolidayComment() {
		return escapeHTML(txtHolidayComment);
	}
	
	public String getEscPltSubstituteYear() {
		return escapeHTML(pltSubstituteYear);
	}
	
	public String getEscPltSubstituteMonth() {
		return escapeHTML(pltSubstituteMonth);
	}
	
	public String getEscPltSubstituteDay() {
		return escapeHTML(pltSubstituteDay);
	}
	
	public void setHolidayTimes(int holidayTimes) {
		this.holidayTimes = holidayTimes;
	}
	
}
