/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.action;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.report.dao.AttendanceManagementDao;
import jp.mosp.kintai.report.dto.AttendanceManagementDto;
import jp.mosp.payroll.vo.AttendanceExportCardVo;

import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

/**
 * @author yoshida
 *
 */
public class AttendanceManagementAction extends KintaiCommonAction {
	
	private int								row					= 0;	//Row(s) 0`
	private int								pageno				= 0;	//y[W
	private static final int				END_PAGE_L			= 50;	//1y[W̍ŏIs
	private int								gyol				= 2;	//ׂ̉s
	private int								titlel				= 3;	//1y[W̃^Cgʒu
	private int								firstl				= 8;	//1y[W̖׊Jnʒu
	private int								endl;						//ŏIʒugetLastRow()Ŏ擾
	private static final int				LAST_L				= 46;	//1y[W̖׍ŏIs(vs͊܂܂Ȃ)
	private static final int				TOTAL_L				= 48;	//1y[W̍vs	
	private String							file1				= "";
	private int								printcnt			= 0;
	
	// GNZEZԍ
	private static final int[]				CC					= { 12, 19, 26, 33, 40, 47, 54, 61, 68, 75, 82, 89, 96,
		103, 110												};
	
	private String							simei				= "";
	
	private double							snissu				= 0;
	private int								kinmuji				= 0;
	private int								kyukeiji			= 0;
	private double							yukyu				= 0;
	private double							tokukyu				= 0;
	private double							kekkin				= 0;
	private double							skekkin				= 0;
	private int								tisokai				= 0;
	private int								tijikan				= 0;
	private int								zajikan				= 0;
	private int								ksjikan				= 0;
	private int								snjikan				= 0;
	private int								kaikin				= 0;
	private int								syokujikaisu		= 0;
	private int								cyokukaisu1			= 0;
	private int								cyokukaisu2			= 0;
	private int								cyokukaisu3			= 0;
	private int								hokakaisu1			= 0;
	private int								hokakaisu2			= 0;
	private int								hokakaisu3			= 0;
	private int								hokakaisu4			= 0;
	private int								hokakaisu5			= 0;
	
	private double							totalSNissu			= 0;
	private int								totalKinmuJi		= 0;
	private int								totalKyukeiJi		= 0;
	private double							totalYukyu			= 0;
	private double							totalTokukyu		= 0;
	private double							totalKekkin			= 0;
	private double							totalSKekkin		= 0;
	private int								totalTisoKai		= 0;
	private int								totalTiJikan		= 0;
	private int								totalZaJikan		= 0;
	private int								totalKsJikan		= 0;
	private int								totalSnJikan		= 0;
	private int								totalKaikin			= 0;
	private int								totalSyokujiKaisu	= 0;
	private int								totalCyokuKaisu1	= 0;
	private int								totalCyokuKaisu2	= 0;
	private int								totalCyokuKaisu3	= 0;
	private int								totalHokaKaisu1		= 0;
	private int								totalHokaKaisu2		= 0;
	private int								totalHokaKaisu3		= 0;
	private int								totalHokaKaisu4		= 0;
	private int								totalHokaKaisu5		= 0;
	
	private String							sectionName			= "";
	private String							targetYear			= "";
	private String							targetMonth			= "";
	
	private List<AttendanceManagementDto>	managementList;
	
	private static final int				CELL_K_NAME			= 1;
	private static final int				CELL_YEAR			= 6;
	private static final int				CELL_MONTH			= 12;
	private static final int				CELL_SECTION		= 93;
	
	// OpenDocumentp
	private static final int				PAGE_END_ROW		= 50;	// 1y[W̏Iʒu
	private static final int				TITLE_ROW			= 3;	// ^CgJnʒu
	private static final int				DETAIL_ROW			= 7;	// 1y[W̖׊Jnʒu
	private static final int				TOTAL_ROW			= 47;	// 1y[W̍vJnʒu
	private static final int				LEN_EMPLOYEE		= 20;	// 1y[W̍ől
																		
	
	/**
	 * RXgN^
	 */
	public AttendanceManagementAction() {
		super();
		setNeedProcSeq(false);
		final int endline = 50;
		endl = endline; //ŏIʒugetLastRow()Ŏ擾
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		getConnection();
		// VO̎擾
		AttendanceExportCardVo vo = (AttendanceExportCardVo)prepareVo();
		// p[^擾
		vo.setParams(request);
		Date targetYearMonth = DateUtil.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		// ݒ
		if (vo.getPltSection().equals(CommonConst.NAM_COMMON_STRING_INITIAL_VALUE)) {
			sectionName = CommonConst.NAM_ALL_SECTION;
		} else {
			sectionName = getSectionName(vo.getPltSection());
		}
		// N
		targetYear = String.valueOf(MospUtility.getYear(targetYearMonth));
		targetMonth = String.valueOf(MospUtility.getMonth(targetYearMonth));
		// 
		AttendanceManagementDao dao = new AttendanceManagementDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		managementList = dao.findForCondition(DateUtil.convDateToStringYearMonthShort(targetYearMonth), vo
			.getPltSection());
		// [ݒ
		StringBuffer fileName = new StringBuffer();
		fileName.append(DateUtil.convDateToStringYearMonth(targetYearMonth));
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(vo.getPltSection());
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		// [쐬
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
			// ODS
			request.setAttribute(MospConst.ATT_FILE_OBJECT, makeSpreadSheet());
			// t@C
			fileName.append(CommonConst.FILE_SAMP_M_KINTAIKANRI_ODS);
		} else {
			// XLS
			request.setAttribute(MospConst.ATT_FILE_OBJECT, makeWorkbook().getWorkbook());
			// t@C
			fileName.append(CommonConst.FILE_SAMP_M_KINTAIKANRI);
		}
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceExportCardVo();
	}
	
	/**
	 * ΑӊǗꗗ쐬
	 * @return PoiUtilityCX^X
	 * @throws Exception    	Oꍇ
	 */
	private PoiUtility makeWorkbook() throws Exception {
		// [쐬
		PoiUtility poi = new PoiUtility();
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(CommonConst.TEMPLATE_M_KINTAIKANRI);
		poi.crtNewDocR(0, sb.toString());
		// wb_[ݒ
		printTitle(poi);
		// f[^\
		Iterator<AttendanceManagementDto> it = managementList.iterator();
		while (it.hasNext()) {
			AttendanceManagementDto dto = it.next();
			simei = dto.getSimei();
			snissu = Double.valueOf(dto.getSNissu());
			kinmuji = Integer.valueOf(dto.getKinmuJi());
			kyukeiji = Integer.valueOf(dto.getKyukeiJi());
			yukyu = Double.valueOf(dto.getYukyu());
			tokukyu = Double.valueOf(dto.getTokuKyu());
			kekkin = Double.valueOf(dto.getKekkin());
			skekkin = Double.valueOf(dto.getSKekkin());
			tisokai = Integer.valueOf(dto.getTiSoKai());
			tijikan = Integer.valueOf(dto.getTiJikan());
			zajikan = Integer.valueOf(dto.getZaJikan());
			ksjikan = Integer.valueOf(dto.getKsJikan());
			snjikan = Integer.valueOf(dto.getSnJikan());
			kaikin = Integer.valueOf(dto.getKaikin());
			syokujikaisu = Integer.valueOf(dto.getSyokujiKaisu());
			cyokukaisu1 = Integer.valueOf(dto.getCyokuKaisu1());
			cyokukaisu2 = Integer.valueOf(dto.getCyokuKaisu2());
			cyokukaisu3 = Integer.valueOf(dto.getCyokuKaisu3());
			hokakaisu1 = Integer.valueOf(dto.getHokaKaisu1());
			hokakaisu2 = Integer.valueOf(dto.getHokaKaisu2());
			hokakaisu3 = Integer.valueOf(dto.getHokaKaisu3());
			hokakaisu4 = Integer.valueOf(dto.getHokaKaisu4());
			hokakaisu5 = Integer.parseInt(dto.getHokaKaisu5());
			// ׈
			printDetail(poi);
			// v
			addTotal();
		}
		if (printcnt > 0) {
			// v
			printTotal(poi);
			printEnding(poi);
		} else {
			// f[^
			printNothing(poi);
		}
		return poi;
	}
	
	/**
	 * ^Cg\bh
	 * @param poi PoiUtilityCX^X
	 * @throws Exception   	Oꍇ
	 */
	private void printTitle(PoiUtility poi) throws Exception {
		// y[W
		pageno++;
		//^CgʒuZo
		row = (pageno - 1) * END_PAGE_L + (titlel - 1);
		//^Cg,t
		row++;
		// N
		poi.prtItem(row, CELL_YEAR, targetYear);
		poi.prtItem(row, CELL_MONTH, targetMonth);
		// 
		poi.prtItem(row, CELL_SECTION, sectionName);
		// ׈ʒuZo
		row = (pageno - 1) * END_PAGE_L + (firstl - 1 - gyol);
	}
	
	/**
	 * ׈
	 * @param poi PoiUtilityCX^X
	 * @throws Exception   	Oꍇ
	 */
	private void printDetail(PoiUtility poi) throws Exception {
		// ŊmF
		chkNewPage(poi);
		// 
		poi.prtItem(row, CELL_K_NAME, simei);
		// i
		poi.prtItem(row, CC[0], String.valueOf(snissu));
		poi.prtItem(row, CC[1], getHourString(TimeUtil.convIntegerTimeToDoubleTime(kinmuji)));
		poi.prtItem(row, CC[2], getHourString(TimeUtil.convIntegerTimeToDoubleTime(zajikan)));
		poi.prtItem(row, CC[3], getHourString(TimeUtil.convIntegerTimeToDoubleTime(snjikan)));
		poi.prtItem(row, CC[4], getHourString(TimeUtil.convIntegerTimeToDoubleTime(tijikan)));
		poi.prtItem(row, CC[5], tisokai);
		poi.prtItem(row, CC[7], syokujikaisu);
		poi.prtItem(row, CC[8], cyokukaisu2);
		poi.prtItem(row, CC[9], hokakaisu1);
		poi.prtItem(row, CC[10], hokakaisu3);
		poi.prtItem(row, CC[11], hokakaisu5);
		poi.prtItem(row, CC[12], String.valueOf(yukyu));
		poi.prtItem(row, CC[13], String.valueOf(tokukyu));
		// i
		poi.prtItem(row + 1, CC[0], "");
		poi.prtItem(row + 1, CC[1], getHourString(TimeUtil.convIntegerTimeToDoubleTime(kyukeiji)));
		poi.prtItem(row + 1, CC[2], getHourString(TimeUtil.convIntegerTimeToDoubleTime(ksjikan)));
		poi.prtItem(row + 1, CC[7], cyokukaisu1);
		poi.prtItem(row + 1, CC[8], cyokukaisu3);
		poi.prtItem(row + 1, CC[9], hokakaisu2);
		poi.prtItem(row + 1, CC[10], hokakaisu4);
		poi.prtItem(row + 1, CC[11], kaikin);
		poi.prtItem(row + 1, CC[12], String.valueOf(kekkin));
		poi.prtItem(row + 1, CC[13], String.valueOf(skekkin));
		// ׈
		printcnt++;
	}
	
	/**
	 * vʒuZo
	 * @param poi PoiUtilityCX^X
	 * @throws Exception   	Oꍇ
	 */
	private void printTotal(PoiUtility poi) throws Exception {
		row = (pageno - 1) * END_PAGE_L + (TOTAL_L - 1);
		// x
		poi.prtItem(row, CC[0], String.valueOf(totalSNissu));
		poi.prtItem(row, CC[1], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKinmuJi)));
		poi.prtItem(row, CC[2], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalZaJikan)));
		poi.prtItem(row, CC[3], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalSnJikan)));
		poi.prtItem(row, CC[4], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalTiJikan)));
		poi.prtItem(row, CC[5], totalTisoKai);
		poi.prtItem(row, CC[7], totalSyokujiKaisu);
		poi.prtItem(row, CC[8], totalCyokuKaisu2);
		poi.prtItem(row, CC[9], totalHokaKaisu1);
		poi.prtItem(row, CC[10], totalHokaKaisu3);
		poi.prtItem(row, CC[11], totalHokaKaisu5);
		poi.prtItem(row, CC[12], String.valueOf(totalYukyu));
		poi.prtItem(row, CC[13], String.valueOf(totalTokukyu));
		// T
		poi.prtItem(row + 1, CC[1], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKyukeiJi)));
		poi.prtItem(row + 1, CC[2], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKsJikan)));
		poi.prtItem(row + 1, CC[7], totalCyokuKaisu1);
		poi.prtItem(row + 1, CC[8], totalCyokuKaisu3);
		poi.prtItem(row + 1, CC[9], totalHokaKaisu2);
		poi.prtItem(row + 1, CC[10], totalHokaKaisu4);
		poi.prtItem(row + 1, CC[11], totalKaikin);
		poi.prtItem(row + 1, CC[12], String.valueOf(totalKekkin));
		poi.prtItem(row + 1, CC[13], String.valueOf(totalSKekkin));
		// ׈
		printcnt++;
	}
	
	/**
	 * Vō쐬\bh
	 * @param poi PoiUtilityCX^X
	 * @throws Exception   	Oꍇ
	 */
	private void chkNewPage(PoiUtility poi) throws Exception {
		// I[v
		if (pageno == 0) {
			// PageĐ
			crtNewDoc(poi);
			// ^Cg
			printTitle(poi);
		}
		if (row >= ((pageno - 1) * END_PAGE_L + (LAST_L - gyol))) {
			// I[o[t[͍ŏ̈̎A^Cg
			printTitle(poi);
		}
		// s
		row += gyol;
	}
	
	/**
	 * Vō쐬\bh
	 * @param poi PoiUtilityCX^X
	 * @throws Exception   	Oꍇ
	 */
	private void crtNewDoc(PoiUtility poi) throws Exception {
		poi.crtNewDocR(0, file1);
		// ŏIs擾
		endl = poi.getLastRow();
	}
	
	/**
	 * f[^\bh
	 * @param poi PoiUtilityCX^X
	 * @throws Exception   	Oꍇ
	 */
	private void printNothing(PoiUtility poi) throws Exception {
		// ŊmF
		chkNewPage(poi);
		poi.prtItem(7, 1, CommonConst.MSG_ATTENDANCE_REPORT_NO_DATA);
	}
	
	/**
	 * [I
	 * @param poi PoiUtilityCX^X
	 * @throws Exception   	Oꍇ
	 */
	private void printEnding(PoiUtility poi) throws Exception {
		// W
		// I̍ŏ̍s
		row = pageno * END_PAGE_L;
		boolean syori = true;
		// cs폜
		for (; row <= endl; row++) {
			if (syori) {
				poi.dltRow(row);
			}
		}
	}
	
	/**
	 * ΑӊǗꗗ쐬
	 * @return SpreadSheetCX^X
	 * @throws Exception    	Oꍇ
	 */
	private SpreadSheet makeSpreadSheet() throws Exception {
		// ev[gt@C
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(CommonConst.TEMPLATE_M_KINTAIKANRI_ODS);
		// [쐬
		SpreadSheet ss = SpreadSheet.createFromFile(new File(sb.toString()));
		// V[g
		Sheet sheet = ss.getSheet(0);
		// l
		pageno = 0;
		// ^Cg
		printTitle(sheet);
		// f[^\
		Iterator<AttendanceManagementDto> it = managementList.iterator();
		int count = 0;
		while (it.hasNext()) {
			AttendanceManagementDto dto = it.next();
			// 
			sheet.getCellAt(CELL_K_NAME, row).setValue(dto.getSimei());
			snissu = Double.valueOf(dto.getSNissu());
			kinmuji = Integer.valueOf(dto.getKinmuJi());
			kyukeiji = Integer.valueOf(dto.getKyukeiJi());
			yukyu = Double.valueOf(dto.getYukyu());
			tokukyu = Double.valueOf(dto.getTokuKyu());
			kekkin = Double.valueOf(dto.getKekkin());
			skekkin = Double.valueOf(dto.getSKekkin());
			tisokai = Integer.valueOf(dto.getTiSoKai());
			tijikan = Integer.valueOf(dto.getTiJikan());
			zajikan = Integer.valueOf(dto.getZaJikan());
			ksjikan = Integer.valueOf(dto.getKsJikan());
			snjikan = Integer.valueOf(dto.getSnJikan());
			kaikin = Integer.valueOf(dto.getKaikin());
			syokujikaisu = Integer.valueOf(dto.getSyokujiKaisu());
			cyokukaisu1 = Integer.valueOf(dto.getCyokuKaisu1());
			cyokukaisu2 = Integer.valueOf(dto.getCyokuKaisu2());
			cyokukaisu3 = Integer.valueOf(dto.getCyokuKaisu3());
			hokakaisu1 = Integer.valueOf(dto.getHokaKaisu1());
			hokakaisu2 = Integer.valueOf(dto.getHokaKaisu2());
			hokakaisu3 = Integer.valueOf(dto.getHokaKaisu3());
			hokakaisu4 = Integer.valueOf(dto.getHokaKaisu4());
			hokakaisu5 = Integer.parseInt(dto.getHokaKaisu5());
			// ڍ׈
			printDetail(sheet);
			// v
			addTotal();
			// ̐l
			row += 2;
			count++;
			// Ō̈l
			if (!it.hasNext()) {
				// vsֈړ
				row = pageno * PAGE_END_ROW + TOTAL_ROW;
				// v
				printTotal(sheet);
			}
			if (count == LEN_EMPLOYEE) {
				// 
				count = 0;
				// y[W֑J
				addPageNo(sheet);
			}
		}
		return ss;
	}
	
	/**
	 * ^Cg\bh
	 * @param sheet SpreadSheetCX^X
	 */
	private void printTitle(Sheet sheet) {
		row = pageno * PAGE_END_ROW + TITLE_ROW;
		// N
		sheet.getCellAt(CELL_YEAR, row).setValue(targetYear);
		sheet.getCellAt(CELL_MONTH, row).setValue(targetMonth);
		// 
		sheet.getCellAt(CELL_SECTION, row).setValue(sectionName);
		// ׍sֈړ
		row = pageno * PAGE_END_ROW + DETAIL_ROW;
	}
	
	/**
	 * y[Wֈړ
	 * @param sheet SpreadSheetCX^X
	 */
	private void addPageNo(Sheet sheet) {
		// y[WZ
		pageno++;
		// y[W̐擪sֈړ
		row = pageno * PAGE_END_ROW;
		// ^Cgݒ
		printTitle(sheet);
	}
	
	/**
	 * ڍ׈
	 * @param sheet SpreadSheetCX^X
	 */
	private void printDetail(Sheet sheet) {
		// i
		int upper = row;
		sheet.getCellAt(CC[0], upper).setValue(String.valueOf(snissu));
		sheet.getCellAt(CC[1], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(kinmuji)));
		sheet.getCellAt(CC[2], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(zajikan)));
		sheet.getCellAt(CC[3], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(snjikan)));
		sheet.getCellAt(CC[4], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(tijikan)));
		sheet.getCellAt(CC[5], upper).setValue(tisokai);
		sheet.getCellAt(CC[7], upper).setValue(syokujikaisu);
		sheet.getCellAt(CC[8], upper).setValue(cyokukaisu2);
		sheet.getCellAt(CC[9], upper).setValue(hokakaisu1);
		sheet.getCellAt(CC[10], upper).setValue(hokakaisu3);
		sheet.getCellAt(CC[11], upper).setValue(hokakaisu5);
		sheet.getCellAt(CC[12], upper).setValue(String.valueOf(yukyu));
		sheet.getCellAt(CC[13], upper).setValue(String.valueOf(tokukyu));
		// i
		int lower = row + 1;
		sheet.getCellAt(CC[0], lower).setValue("");
		sheet.getCellAt(CC[1], lower).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(kyukeiji)));
		sheet.getCellAt(CC[2], lower).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(ksjikan)));
		sheet.getCellAt(CC[7], lower).setValue(cyokukaisu1);
		sheet.getCellAt(CC[8], lower).setValue(cyokukaisu3);
		sheet.getCellAt(CC[9], lower).setValue(hokakaisu2);
		sheet.getCellAt(CC[10], lower).setValue(hokakaisu4);
		sheet.getCellAt(CC[11], lower).setValue(kaikin);
		sheet.getCellAt(CC[12], lower).setValue(String.valueOf(kekkin));
		sheet.getCellAt(CC[13], lower).setValue(String.valueOf(skekkin));
	}
	
	/**
	 * v
	 * @param sheet SpreadSheetCX^X
	 */
	private void printTotal(Sheet sheet) {
		// i
		int upper = row;
		sheet.getCellAt(CC[0], upper).setValue(String.valueOf(totalSNissu));
		sheet.getCellAt(CC[1], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKinmuJi)));
		sheet.getCellAt(CC[2], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalZaJikan)));
		sheet.getCellAt(CC[3], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalSnJikan)));
		sheet.getCellAt(CC[4], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalTiJikan)));
		sheet.getCellAt(CC[5], upper).setValue(totalTisoKai);
		sheet.getCellAt(CC[7], upper).setValue(totalSyokujiKaisu);
		sheet.getCellAt(CC[8], upper).setValue(totalCyokuKaisu2);
		sheet.getCellAt(CC[9], upper).setValue(totalHokaKaisu1);
		sheet.getCellAt(CC[10], upper).setValue(totalHokaKaisu3);
		sheet.getCellAt(CC[11], upper).setValue(totalHokaKaisu5);
		sheet.getCellAt(CC[12], upper).setValue(String.valueOf(totalYukyu));
		sheet.getCellAt(CC[13], upper).setValue(String.valueOf(totalTokukyu));
		// i
		int lower = row + 1;
		sheet.getCellAt(CC[0], lower).setValue("");
		sheet.getCellAt(CC[1], lower).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKyukeiJi)));
		sheet.getCellAt(CC[2], lower).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKsJikan)));
		sheet.getCellAt(CC[7], lower).setValue(totalCyokuKaisu1);
		sheet.getCellAt(CC[8], lower).setValue(totalCyokuKaisu3);
		sheet.getCellAt(CC[9], lower).setValue(totalHokaKaisu2);
		sheet.getCellAt(CC[10], lower).setValue(totalHokaKaisu4);
		sheet.getCellAt(CC[11], lower).setValue(totalKaikin);
		sheet.getCellAt(CC[12], lower).setValue(String.valueOf(totalKekkin));
		sheet.getCellAt(CC[13], lower).setValue(String.valueOf(totalSKekkin));
	}
	
	/**
	 * v
	 */
	private void addTotal() {
		totalSNissu += snissu;
		totalKinmuJi += kinmuji;
		totalKyukeiJi += kyukeiji;
		totalYukyu += yukyu;
		totalTokukyu += tokukyu;
		totalKekkin += kekkin;
		totalSKekkin += skekkin;
		totalTisoKai += tisokai;
		totalTiJikan += tijikan;
		totalZaJikan += zajikan;
		totalKsJikan += ksjikan;
		totalSnJikan += snjikan;
		totalKaikin += kaikin;
		totalSyokujiKaisu += syokujikaisu;
		totalCyokuKaisu1 += cyokukaisu1;
		totalCyokuKaisu2 += cyokukaisu2;
		totalCyokuKaisu3 += cyokukaisu3;
		totalHokaKaisu1 += hokakaisu1;
		totalHokaKaisu2 += hokakaisu2;
		totalHokaKaisu3 += hokakaisu3;
		totalHokaKaisu4 += hokakaisu4;
		totalHokaKaisu5 += hokakaisu5;
	}
	
}
