/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.Date;

import jp.mosp.common.part.BasePart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.workflow.dao.CtOvertimeRequestDao;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;

/**
 * cƐ\ɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class OverTimePart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public OverTimePart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public OverTimePart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * CtOvertimeRequestDaoCX^X
	 */
	private CtOvertimeRequestDao	overtimeRequestDao;
	

	/**
	 * cƐ\e[uDAO̎擾
	 * @return	ςCtOvertimeRequestDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public CtOvertimeRequestDao getCtOvertimeRequestDao() throws Exception {
		if (VariousUtil.isNull(overtimeRequestDao)) {
			overtimeRequestDao = (CtOvertimeRequestDao)getPreparedDao(CtOvertimeRequestDao.class.getCanonicalName());
		}
		return overtimeRequestDao;
	}
	
	/**
	 * cƐ\擾
	 * @param voucher		Ώۓ`[ԍ
	 * @return	cƐ\DTO
	 * @throws Exception	Oꍇ
	 */
	public CtOvertimeRequestDto getOverTimeRequest(int voucher) throws Exception {
		return getCtOvertimeRequestDao().findForKey(voucher);
	}
	
	/**
	 * Ώ۔NcƐ\擾
	 * @param kCode				ΏێЈR[h
	 * @param targetDate		Ώ۔N
	 * @return	cƐ\DTO
	 * @throws Exception	Oꍇ
	 */
	public CtOvertimeRequestDto getOverTimeRequest(String kCode, Date targetDate) throws Exception {
		return getCtOvertimeRequestDao().findForWorkDate(kCode, targetDate);
	}
	
	/**
	 * cƐ\f
	 * @param kCode				ΏێЈR[h
	 * @param targetDate		Ώ۔N
	 * @return	cƐ\ꍇtrueAłȂꍇfalse
	 * @throws Exception	Oꍇ
	 */
	public boolean isOverTimeRequest(String kCode, Date targetDate) throws Exception {
		if (VariousUtil.isNotNull(getOverTimeRequest(kCode, targetDate))) {
			return true;
		}
		return false;
	}
	
}
