/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.List;
import java.util.Locale;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.part.BasePart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.report.dao.CmOutPutDao;
import jp.mosp.kintai.report.dao.ExportDataDao;
import jp.mosp.kintai.report.dao.MExportColumnDao;
import jp.mosp.kintai.report.dao.MExportDao;
import jp.mosp.kintai.report.dto.MExportColumnDto;

/**
 * GNX|[gɊւPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class ExportPart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public ExportPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo 	Part𗘗pۂɕKvȏ
	 */
	public ExportPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * MExportColumnDaoCX^X
	 */
	private MExportColumnDao	exportColumnDao;
	/**
	 * MExportDaoCX^X
	 */
	private MExportDao			exportDao;
	/**
	 * ExportDataDaoCX^X
	 */
	private ExportDataDao		exportDataDao;
	/**
	 * CmOutPutDaoCX^X
	 */
	private CmOutPutDao			outPutDao;
	

	/**
	 * 񍀖ڗpDAO̎擾
	 * @return exportColumnDao
	 * @throws MospException  MosPOꍇ
	 */
	public MExportColumnDao getExportColumnDao() throws MospException {
		if (VariousUtil.isNull(exportColumnDao)) {
			exportColumnDao = (MExportColumnDao)getPreparedDao(MExportColumnDao.class.getCanonicalName());
		}
		return exportColumnDao;
	}
	
	/**
	 * M_EXPORTe[upDAO擾
	 * @return	ςMExportDaoCX^X
	 * @throws MospException MosPOꍇ
	 */
	public MExportDao getMExportDao() throws MospException {
		if (VariousUtil.isNull(exportDao)) {
			exportDao = (MExportDao)getPreparedDao(MExportDao.class.getCanonicalName());
		}
		return exportDao;
	}
	
	/**
	 * GNX|[gpDAO擾
	 * @return	ςExportDataDaoCX^X
	 * @throws MospException MosPOꍇ
	 */
	public ExportDataDao getExportDataDao() throws MospException {
		if (VariousUtil.isNull(exportDataDao)) {
			exportDataDao = (ExportDataDao)getPreparedDao(ExportDataDao.class.getCanonicalName());
		}
		return exportDataDao;
	}
	
	/**
	 * o̓}X^pDAO擾
	 * @return ςCmOutPutDaoCX^X
	 * @throws MospException MosPOꍇ
	 */
	public CmOutPutDao getCmOutPutDao() throws MospException {
		if (VariousUtil.isNull(outPutDao)) {
			outPutDao = (CmOutPutDao)getPreparedDao(CmOutPutDao.class.getCanonicalName());
		}
		return outPutDao;
	}
	
	/**
	 * GNX|[g񍀖ڐݒ
	 * @param strFLID	Ώۃe[uR[h
	 * @return	String[][]	GNX|[g񍀖ڔz
	 * @throws Exception Oꍇ
	 */
	public String[][] getKintaiDataItem(String strFLID) throws Exception {
		return getColumnDataItem(strFLID, getTableColumnInfo(HumanPart.BASIS_TABLE),
				getTableColumnInfo(KintaiCompilePart.KINTAI_TABLE),
				getTableColumnInfo(KintaiCommonPart.SYUKKINBO_TABLE), getTableColumnInfo(PaidHolidayPart.OLD_TABLE));
	}
	
	/**
	 * 񍀖ڗpz擾
	 * @param tableName		Ώۃe[u
	 * @return	 񍀖ڗpz
	 * @throws Exception Oꍇ
	 */
	public String[] getTableColumnInfo(String tableName) throws Exception {
		List<MExportColumnDto> list = getExportColumnDao().findForCondition(tableName);
		String[] aryColumnInfo = new String[list.size()];
		int i = 0;
		for (MExportColumnDto dto : list) {
			StringBuffer sb = new StringBuffer();
			sb.append(tableName.toUpperCase(Locale.JAPANESE));
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(i + 1);
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(dto.getColumnField().toUpperCase(Locale.JAPANESE));
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(dto.getColumnComment());
			aryColumnInfo[i] = sb.toString();
			i++;
		}
		return aryColumnInfo;
	}
	

	/**
	 * l擾pz
	 */
	protected String[]	aryKihonItem;
	
	/**
	 * Αӏ񍀖ڗpz
	 */
	protected String[]	aryKintaiItem;
	
	/**
	 * oΕ񍀖ڗpz
	 */
	protected String[]	arySyukkinItem;
	
	/**
	 * Lxɏ񍀖ڗpz
	 */
	protected String[]	aryYukyuItem;
	

	/**
	 * GNX|[g񍀖ڐݒ
	 * @param strFLID			Ώۃe[uR[h
	 * @param aryKihonItem		l擾pz
	 * @param aryKintaiItem		Αӏ񍀖ڗpz
	 * @param arySyukkinItem	oΕ񍀖ڗpz
	 * @param aryYukyuItem		Lxɏ񍀖ڗpz
	 * @return	String[][]		GNX|[g񍀖ڔz
	 */
	public static String[][] getColumnDataItem(String strFLID, String[] aryKihonItem, String[] aryKintaiItem,
			String[] arySyukkinItem, String[] aryYukyuItem) {
		int itemLength = aryKihonItem.length;
		if (strFLID.equals(CommonConst.CODE_TABLE_M_KINTAI)) {
			itemLength += aryKintaiItem.length;
		}
		if (strFLID.equals(CommonConst.CODE_TABLE_M_SYUKKINBO)) {
			itemLength += arySyukkinItem.length;
		}
		if (strFLID.equals(CommonConst.CODE_TABLE_M_YUKYU)) {
			itemLength += aryYukyuItem.length;
		}
		int i = 0;
		String[][] aryItem = new String[itemLength][2];
		// l擾pz
		for (i = 0; i < aryKihonItem.length; i++) {
			aryItem[i][0] = aryKihonItem[i];
			aryItem[i][1] = VariousUtil.getCsvSplitInfo(aryKihonItem[i], 3);
		}
		// Αӏ񍀖ڗpz
		int j = i;
		if (strFLID.equals(CommonConst.CODE_TABLE_M_KINTAI)) {
			for (i = 0; i < aryKintaiItem.length; i++) {
				aryItem[j + i][0] = aryKintaiItem[i];
				aryItem[j + i][1] = VariousUtil.getCsvSplitInfo(aryKintaiItem[i], 3);
			}
		}
		// oΕ񍀖ڗpz
		if (strFLID.equals(CommonConst.CODE_TABLE_M_SYUKKINBO)) {
			for (i = 0; i < arySyukkinItem.length; i++) {
				aryItem[j + i][0] = arySyukkinItem[i];
				aryItem[j + i][1] = VariousUtil.getCsvSplitInfo(arySyukkinItem[i], 3);
			}
		}
		// Lxɏ񍀖ڗpz
		if (strFLID.equals(CommonConst.CODE_TABLE_M_YUKYU)) {
			for (i = 0; i < aryYukyuItem.length; i++) {
				aryItem[j + i][0] = aryYukyuItem[i];
				aryItem[j + i][1] = VariousUtil.getCsvSplitInfo(aryYukyuItem[i], 3);
			}
		}
		return aryItem;
	}
	
}
