/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.dto;

import jp.mosp.common.common.BaseDto;

/**
 * M_KAISYA(Њb)DTONXB
 */
public class MKaisyaDto extends BaseDto {
	
	private static final long	serialVersionUID	= 3115468966868261668L;
	
	// tB[h
	private String				id					= "";					//ƏR[h
	private String				kaimei				= "";					//Ж
	private String				kaifuri				= "";					//ӂ肪
	private String				kjigyonusi			= "";					//Ǝ
	private String				kaiyubin			= "";					//X֔ԍ
	private String				kaijyusyo			= "";					//Z
	private String				kaitel				= "";					//dbԍ
	private String				kaifax				= "";					//t@bNXԍ
	private int					rodoubi				= 0;					//ԏJ
	private int					roudouji			= 0;					//ԏJԐ
	private int					roudouji1			= 0;					//JԐ
	private int					zaritu				= 0;					//ʎcƊ
	private int					ksritu				= 0;					//xcƊ
	private int					snritu				= 0;					//[cƊ
	private String				zantankbn			= "";					//cƒPvZ
	private double				ritkoyou			= 0;					//ٗpی
	private double				ritkkoyou			= 0;					//ٗpی
	private double				ritkenpo			= 0;					//Nی
	private double				ritkkenpo			= 0;					//Nی
	private double				ritkaigo			= 0;					//ی
	private double				ritkkaigo			= 0;					//ی
	private double				ritkosei			= 0;					//N
	private double				ritkkosei			= 0;					//N
	private double				ritkosei3			= 0;					//NO헿
	private double				ritkkosei3			= 0;					//NO헿
	private String				kosei3kbn			= "";					//NO
	private String				kikinkbn			= "";					//N
	private double				ritkikin			= 0;					//N
	private double				ritkkikin			= 0;					//N
	private double				ritkikin3			= 0;					//NO헿
	private double				ritkkikin3			= 0;					//NO헿
	private String				syahofugo			= "";					//Ss敄
	private String				syahokigo			= "";					//ƏL
	private String				syahobango			= "";					//Əԍ
	private String				kenpojino			= "";					//NیƏԍ
	private String				kikinjino			= "";					//NƏԍ
	private String				kaibank				= "";					//s
	private String				server				= "";					//T[o[
																			
	
	/**
	 * RXgN^
	 */
	public MKaisyaDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return id 	ƏR[hB
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * @return kaimei 	ЖB
	 */
	public String getKaiMei() {
		return kaimei;
	}
	
	/**
	 * @return kaifuri 	ӂ肪ȁB
	 */
	public String getKaiFuri() {
		return kaifuri;
	}
	
	/**
	 * @return kjigyonusi 	ƎB
	 */
	public String getKJigyoNusi() {
		return kjigyonusi;
	}
	
	/**
	 * @return kaiyubin 	X֔ԍB
	 */
	public String getKaiYubin() {
		return kaiyubin;
	}
	
	/**
	 * @return kaijyusyo 	ZB
	 */
	public String getKaiJyusyo() {
		return kaijyusyo;
	}
	
	/**
	 * @return kaitel 	dbԍB
	 */
	public String getKaiTel() {
		return kaitel;
	}
	
	/**
	 * @return kaifax 	t@bNXԍB
	 */
	public String getKaiFax() {
		return kaifax;
	}
	
	/**
	 * @return rodoubi 	ԏJB
	 */
	public int getRodouBi() {
		return rodoubi;
	}
	
	/**
	 * @return roudouji 	ԏJԐB
	 */
	public int getRoudouJi() {
		return roudouji;
	}
	
	/**
	 * @return roudouji1 	JԐB
	 */
	public int getRoudouJi1() {
		return roudouji1;
	}
	
	/**
	 * @return zaritu 	ʎcƊB
	 */
	public int getZaRitu() {
		return zaritu;
	}
	
	/**
	 * @return ksritu 	xcƊB
	 */
	public int getKsRitu() {
		return ksritu;
	}
	
	/**
	 * @return snritu 	[cƊB
	 */
	public int getSnRitu() {
		return snritu;
	}
	
	/**
	 * @return zantankbn 	cƒPvZB
	 */
	public String getZanTanKbn() {
		return zantankbn;
	}
	
	/**
	 * @return ritkoyou 	ٗpیB
	 */
	public double getRitKoyou() {
		return ritkoyou;
	}
	
	/**
	 * @return ritkkoyou 	ٗpیЁB
	 */
	public double getRitKKoyou() {
		return ritkkoyou;
	}
	
	/**
	 * @return ritkenpo 	NیB
	 */
	public double getRitKenpo() {
		return ritkenpo;
	}
	
	/**
	 * @return ritkkenpo 	NیЁB
	 */
	public double getRitKKenpo() {
		return ritkkenpo;
	}
	
	/**
	 * @return ritkaigo 	یB
	 */
	public double getRitKaigo() {
		return ritkaigo;
	}
	
	/**
	 * @return ritkkaigo 	یЁB
	 */
	public double getRitKKaigo() {
		return ritkkaigo;
	}
	
	/**
	 * @return ritkosei 	NB
	 */
	public double getRitKosei() {
		return ritkosei;
	}
	
	/**
	 * @return ritkkosei 	NЁB
	 */
	public double getRitKKosei() {
		return ritkkosei;
	}
	
	/**
	 * @return ritkosei3 	NO헿B
	 */
	public double getRitKosei3() {
		return ritkosei3;
	}
	
	/**
	 * @return ritkkosei3 	NO헿B
	 */
	public double getRitKKosei3() {
		return ritkkosei3;
	}
	
	/**
	 * @return kosei3kbn 	NOB
	 */
	public String getKosei3Kbn() {
		return kosei3kbn;
	}
	
	/**
	 * @return kikinkbn 	NB
	 */
	public String getKikinKbn() {
		return kikinkbn;
	}
	
	/**
	 * @return ritkikin 	NB
	 */
	public double getRitKikin() {
		return ritkikin;
	}
	
	/**
	 * @return ritkkikin 	NB
	 */
	public double getRitKKikin() {
		return ritkkikin;
	}
	
	/**
	 * @return ritkikin3 	NO헿B
	 */
	public double getRitKikin3() {
		return ritkikin3;
	}
	
	/**
	 * @return ritkkikin3 	NO헿B
	 */
	public double getRitKKikin3() {
		return ritkkikin3;
	}
	
	/**
	 * @return syahofugo 	Ss敄B
	 */
	public String getSyahoFugo() {
		return syahofugo;
	}
	
	/**
	 * @return syahokigo 	ƏLB
	 */
	public String getSyahoKigo() {
		return syahokigo;
	}
	
	/**
	 * @return syahobango 	ƏB
	 */
	public String getSyahoBango() {
		return syahobango;
	}
	
	/**
	 * @return kenpojino 	NیƏԍB
	 */
	public String getKenpoJiNo() {
		return kenpojino;
	}
	
	/**
	 * @return kikinjino 	NƏԍB
	 */
	public String getKikinJiNo() {
		return kikinjino;
	}
	
	/**
	 * @return kaibank 	sB
	 */
	public String getKaiBank() {
		return kaibank;
	}
	
	/**
	 * @return server 	T[o[B
	 */
	public String getServer() {
		return server;
	}
	
	/**
	 * @param id 	Zbg鎖ƏR[hB
	 */
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * @param kaimei 	ZbgЖB
	 */
	public void setKaiMei(String kaimei) {
		this.kaimei = kaimei;
	}
	
	/**
	 * @param kaifuri 	Zbgӂ肪ȁB
	 */
	public void setKaiFuri(String kaifuri) {
		this.kaifuri = kaifuri;
	}
	
	/**
	 * @param kjigyonusi 	Zbg鎖ƎB
	 */
	public void setKJigyoNusi(String kjigyonusi) {
		this.kjigyonusi = kjigyonusi;
	}
	
	/**
	 * @param kaiyubin 	ZbgX֔ԍB
	 */
	public void setKaiYubin(String kaiyubin) {
		this.kaiyubin = kaiyubin;
	}
	
	/**
	 * @param kaijyusyo 	ZbgZB
	 */
	public void setKaiJyusyo(String kaijyusyo) {
		this.kaijyusyo = kaijyusyo;
	}
	
	/**
	 * @param kaitel 	ZbgdbԍB
	 */
	public void setKaiTel(String kaitel) {
		this.kaitel = kaitel;
	}
	
	/**
	 * @param kaifax 	Zbgt@bNXԍB
	 */
	public void setKaiFax(String kaifax) {
		this.kaifax = kaifax;
	}
	
	/**
	 * @param rodoubi 	Zbg錎ԏJB
	 */
	public void setRodouBi(int rodoubi) {
		this.rodoubi = rodoubi;
	}
	
	/**
	 * @param roudouji 	Zbg錎ԏJԐB
	 */
	public void setRoudouJi(int roudouji) {
		this.roudouji = roudouji;
	}
	
	/**
	 * @param roudouji1 	ZbgJԐB
	 */
	public void setRoudouJi1(int roudouji1) {
		this.roudouji1 = roudouji1;
	}
	
	/**
	 * @param zaritu 	Zbg镁ʎcƊB
	 */
	public void setZaRitu(int zaritu) {
		this.zaritu = zaritu;
	}
	
	/**
	 * @param ksritu 	ZbgxcƊB
	 */
	public void setKsRitu(int ksritu) {
		this.ksritu = ksritu;
	}
	
	/**
	 * @param snritu 	Zbg[cƊB
	 */
	public void setSnRitu(int snritu) {
		this.snritu = snritu;
	}
	
	/**
	 * @param zantankbn 	ZbgcƒPvZB
	 */
	public void setZanTanKbn(String zantankbn) {
		this.zantankbn = zantankbn;
	}
	
	/**
	 * @param ritkoyou 	ZbgٗpیB
	 */
	public void setRitKoyou(double ritkoyou) {
		this.ritkoyou = ritkoyou;
	}
	
	/**
	 * @param ritkkoyou 	ZbgٗpیЁB
	 */
	public void setRitKKoyou(double ritkkoyou) {
		this.ritkkoyou = ritkkoyou;
	}
	
	/**
	 * @param ritkenpo 	Zbg錒NیB
	 */
	public void setRitKenpo(double ritkenpo) {
		this.ritkenpo = ritkenpo;
	}
	
	/**
	 * @param ritkkenpo 	Zbg錒NیЁB
	 */
	public void setRitKKenpo(double ritkkenpo) {
		this.ritkkenpo = ritkkenpo;
	}
	
	/**
	 * @param ritkaigo 	ZbgیB
	 */
	public void setRitKaigo(double ritkaigo) {
		this.ritkaigo = ritkaigo;
	}
	
	/**
	 * @param ritkkaigo 	ZbgیЁB
	 */
	public void setRitKKaigo(double ritkkaigo) {
		this.ritkkaigo = ritkkaigo;
	}
	
	/**
	 * @param ritkosei 	ZbgNB
	 */
	public void setRitKosei(double ritkosei) {
		this.ritkosei = ritkosei;
	}
	
	/**
	 * @param ritkkosei 	ZbgNЁB
	 */
	public void setRitKKosei(double ritkkosei) {
		this.ritkkosei = ritkkosei;
	}
	
	/**
	 * @param ritkosei3 	ZbgNO헿B
	 */
	public void setRitKosei3(double ritkosei3) {
		this.ritkosei3 = ritkosei3;
	}
	
	/**
	 * @param ritkkosei3 	ZbgNO헿B
	 */
	public void setRitKKosei3(double ritkkosei3) {
		this.ritkkosei3 = ritkkosei3;
	}
	
	/**
	 * @param kosei3kbn 	ZbgNOB
	 */
	public void setKosei3Kbn(String kosei3kbn) {
		this.kosei3kbn = kosei3kbn;
	}
	
	/**
	 * @param kikinkbn 	ZbgNB
	 */
	public void setKikinKbn(String kikinkbn) {
		this.kikinkbn = kikinkbn;
	}
	
	/**
	 * @param ritkikin 	ZbgNB
	 */
	public void setRitKikin(double ritkikin) {
		this.ritkikin = ritkikin;
	}
	
	/**
	 * @param ritkkikin 	ZbgNB
	 */
	public void setRitKKikin(double ritkkikin) {
		this.ritkkikin = ritkkikin;
	}
	
	/**
	 * @param ritkikin3 	ZbgNO헿B
	 */
	public void setRitKikin3(double ritkikin3) {
		this.ritkikin3 = ritkikin3;
	}
	
	/**
	 * @param ritkkikin3 	ZbgNO헿B
	 */
	public void setRitKKikin3(double ritkkikin3) {
		this.ritkkikin3 = ritkkikin3;
	}
	
	/**
	 * @param syahofugo 	ZbgSs敄B
	 */
	public void setSyahoFugo(String syahofugo) {
		this.syahofugo = syahofugo;
	}
	
	/**
	 * @param syahokigo 	Zbg鎖ƏLB
	 */
	public void setSyahoKigo(String syahokigo) {
		this.syahokigo = syahokigo;
	}
	
	/**
	 * @param syahobango 	Zbg鎖ƏB
	 */
	public void setSyahoBango(String syahobango) {
		this.syahobango = syahobango;
	}
	
	/**
	 * @param kenpojino 	Zbg錒NیƏԍB
	 */
	public void setKenpoJiNo(String kenpojino) {
		this.kenpojino = kenpojino;
	}
	
	/**
	 * @param kikinjino 	ZbgNƏԍB
	 */
	public void setKikinJiNo(String kikinjino) {
		this.kikinjino = kikinjino;
	}
	
	/**
	 * @param kaibank 	ZbgsB
	 */
	public void setKaiBank(String kaibank) {
		this.kaibank = kaibank;
	}
	
	/**
	 * @param server 	ZbgT[o[B
	 */
	public void setServer(String server) {
		this.server = server;
	}
}
