/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.dto.CmWorkTypeDto;

/**
 * CM_WORKTYPE(Ζ`ԃ}X^)DAONX B
 */
public class CmWorkTypeDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * CM_WORKTYPE(Ζ`ԃ}X^)B
	 */
	public static final String	TABLE			= "CM_WORKTYPE";
	
	/**
	 * KEY_1 = SHIFTCODE(Ζ`ԃR[h)B
	 */
	public static final String	KEY_1			= "SHIFTCODE";
	
	// 
	/**
	 * SHIFTCODE(Ζ`ԃR[h)B
	 */
	public static final String	COL_SHIFTCODE	= "SHIFTCODE";
	/**
	 * SHIFTNAME(Ζ`Ԗ)B
	 */
	public static final String	COL_SHIFTNAME	= "SHIFTNAME";
	/**
	 * STARTTIME(oΎ)B
	 */
	public static final String	COL_STARTTIME	= "STARTTIME";
	/**
	 * QUITTIME(ގЎ)B
	 */
	public static final String	COL_QUITTIME	= "QUITTIME";
	/**
	 * WORKTIME(Ζ)B
	 */
	public static final String	COL_WORKTIME	= "WORKTIME";
	/**
	 * BREAKTIME(xe)B
	 */
	public static final String	COL_BREAKTIME	= "BREAKTIME";
	/**
	 * OVERSTART(cƊJn)B
	 */
	public static final String	COL_OVERSTART	= "OVERSTART";
	/**
	 * OVERBREAK(cƋxe)B
	 */
	public static final String	COL_OVERBREAK	= "OVERBREAK";
	/**
	 * OPTION1(IvV1)B
	 */
	public static final String	COL_OPTION1		= "OPTION1";
	/**
	 * OPTION2(IvV2)B
	 */
	public static final String	COL_OPTION2		= "OPTION2";
	/**
	 * OPTION3(IvV3)B
	 */
	public static final String	COL_OPTION3		= "OPTION3";
	/**
	 * OPTION4(IvV4)B
	 */
	public static final String	COL_OPTION4		= "OPTION4";
	/**
	 * OPTION5(IvV5)B
	 */
	public static final String	COL_OPTION5		= "OPTION5";
	/**
	 * DELETEFLAG(폜tO)B
	 */
	public static final String	COL_DELETEFLAG	= "DELETEFLAG";
	

	/**
	 * RXgN^
	 */
	public CmWorkTypeDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<CmWorkTypeDto> mappingAll() throws SQLException {
		List<CmWorkTypeDto> all = new ArrayList<CmWorkTypeDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return cm_worktypeDto cm_worktypeR[h
	 * @throws SQLException SQLOꍇ
	 */
	private CmWorkTypeDto mapping() throws SQLException {
		CmWorkTypeDto dto = new CmWorkTypeDto();
		dto.setShiftCode(rs.getString(COL_SHIFTCODE)); //Ζ`ԃR[h
		dto.setShiftName(rs.getString(COL_SHIFTNAME)); //Ζ`Ԗ
		dto.setStartTime(rs.getInt(COL_STARTTIME)); //oΎ
		dto.setQuitTime(rs.getInt(COL_QUITTIME)); //ގЎ
		dto.setWorkTime(rs.getInt(COL_WORKTIME)); //Ζ
		dto.setBreakTime(rs.getInt(COL_BREAKTIME)); //xe
		dto.setOverStart(rs.getInt(COL_OVERSTART)); //cƊJn
		dto.setOverBreak(rs.getInt(COL_OVERBREAK)); //cƋxe
		dto.setOption1(rs.getString(COL_OPTION1)); //IvV1
		dto.setOption2(rs.getString(COL_OPTION2)); //IvV2
		dto.setOption3(rs.getString(COL_OPTION3)); //IvV3
		dto.setOption4(rs.getString(COL_OPTION4)); //IvV4
		dto.setOption5(rs.getString(COL_OPTION5)); //IvV5
		dto.setDeleteFlag(rs.getInt(COL_DELETEFLAG)); //폜tO
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmWorkTypeDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmWorkTypeDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾iL̂݁j
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmWorkTypeDto> findAvailable() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETEFLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF + " ");
			this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<CmWorkTypeDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param shiftcode Ζ`ԃR[h(L[)
	 * @return cm_worktypeDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmWorkTypeDto findForKey(String shiftcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, shiftcode);
			executeQuery();
			CmWorkTypeDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param shiftcode Ζ`ԃR[h(L[)
	 * @return cm_worktypeDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmWorkTypeDto findForUpdate(String shiftcode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, shiftcode);
			executeQuery();
			CmWorkTypeDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param shiftcode Ζ`ԃR[h
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<?> findForCondition(String shiftcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_SHIFTCODE);
		sb.append(" LIKE ? ");
		this.pob.appendLike(COL_SHIFTCODE);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, shiftcode + "%");
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param shiftCode Ζ`ԃR[h
	 * @param shiftName Ζ`Ԗ
	 * @return list (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<?> findForCondition(String shiftCode, String shiftName) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF + " ");
		this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
		if (!shiftCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SHIFTCODE);
			sb.append(" LIKE ? ");
			this.pob.appendLike(COL_SHIFTCODE);
		}
		if (!shiftName.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SHIFTNAME);
			sb.append(" LIKE ? ");
			this.pob.appendLike(COL_SHIFTNAME);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (!shiftCode.equals("")) {
				setParam(index++, shiftCode + "%");
			}
			if (!shiftName.equals("")) {
				setParam(index++, "%" + shiftName + "%");
			}
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param shiftCode 	Ζ`ԃR[h
	 * @param shiftName		Ζ`Ԗ
	 * @param deleteFlag	폜tO
	 * @return list (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<?> findForCondition(String shiftCode, String shiftName, String deleteFlag) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_SHIFTCODE);
		sb.append(" LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_SHIFTNAME);
		sb.append(" LIKE ? ");
		this.pob.appendLike(COL_SHIFTCODE);
		this.pob.appendLike(COL_SHIFTNAME);
		if (!deleteFlag.equals("")) {
			sb.append(" AND ");
			sb.append(COL_DELETEFLAG);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, shiftCode + "%");
			setParam(index++, "%" + shiftName + "%");
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param shiftCode Ζ`ԃR[h(L[)
	 * @return cm_worktypeDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmWorkTypeDto findForAvailable(String shiftCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETEFLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_SHIFTCODE);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_SHIFTCODE, Query.FilterOperator.EQUAL);
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, shiftCode);
			executeQuery();
			CmWorkTypeDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(CmWorkTypeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(CmWorkTypeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getShiftCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(CmWorkTypeDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getShiftCode()); //Ζ`ԃR[h
		setParam(index++, dto.getShiftName()); //Ζ`Ԗ
		setParam(index++, dto.getStartTime()); //oΎ
		setParam(index++, dto.getQuitTime()); //ގЎ
		setParam(index++, dto.getWorkTime()); //Ζ
		setParam(index++, dto.getBreakTime()); //xe
		setParam(index++, dto.getOverStart()); //cƊJn
		setParam(index++, dto.getOverBreak()); //cƋxe
		setParam(index++, dto.getOption1()); //IvV1
		setParam(index++, dto.getOption2()); //IvV2
		setParam(index++, dto.getOption3()); //IvV3
		setParam(index++, dto.getOption4()); //IvV4
		setParam(index++, dto.getOption5()); //IvV5
		setParam(index++, dto.getDeleteFlag()); //폜tO
		setCommonParams(isInsert);
	}
	
}
