/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.human.dto.MKojinDto;

/**
 * @author yoshida
 *
 */
public class MKojinDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * M_KOJIN(Ј}X^[l)B
	 */
	public static final String	TABLE			= "M_KOJIN";
	
	/**
	 * KEY_1 = KCODE(ЈR[h)B
	 */
	public static final String	KEY_1			= "KCODE";
	
	// 
	/**
	 * KCODE(ЈR[h)B
	 */
	public static final String	COL_KCODE		= "KCODE";
	/**
	 * SEINENBI(N)B
	 */
	public static final String	COL_SEINENBI	= "SEINENBI";
	/**
	 * SEIBETU()B
	 */
	public static final String	COL_SEIBETU		= "SEIBETU";
	/**
	 * YUBINBAN(X֔ԍ)B
	 */
	public static final String	COL_YUBINBAN	= "YUBINBAN";
	/**
	 * PREFECTURES(s{R[h)B
	 */
	public static final String	COL_PREFECTURES	= "PREFECTURES";
	/**
	 * JYUUSYO1(Z1)B
	 */
	public static final String	COL_JYUUSYO1	= "JYUUSYO1";
	/**
	 * JYUUSYO2(Z2)B
	 */
	public static final String	COL_JYUUSYO2	= "JYUUSYO2";
	/**
	 * JYUUSYO3(Z3)B
	 */
	public static final String	COL_JYUUSYO3	= "JYUUSYO3";
	/**
	 * TEL(dbԍ)B
	 */
	public static final String	COL_TEL			= "TEL";
	/**
	 * FAX(Faxԍ)B
	 */
	public static final String	COL_FAX			= "FAX";
	/**
	 * KEITAI(gєԍ)B
	 */
	public static final String	COL_KEITAI		= "KEITAI";
	/**
	 * KETUEKI(t^)B
	 */
	public static final String	COL_KETUEKI		= "KETUEKI";
	/**
	 * SIKAKU(i)B
	 */
	public static final String	COL_SIKAKU		= "SIKAKU";
	/**
	 * KENKOU(N)B
	 */
	public static final String	COL_KENKOU		= "KENKOU";
	/**
	 * TEKIYOU(Ev)B
	 */
	public static final String	COL_TEKIYOU		= "TEKIYOU";
	

	/**
	 * RXgN^
	 */
	public MKojinDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MKojinDto> mappingAll() throws SQLException {
		List<MKojinDto> all = new ArrayList<MKojinDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_kojinDto m_kojinR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MKojinDto mapping() throws SQLException {
		MKojinDto dto = new MKojinDto();
		dto.setKCode(rs.getString(COL_KCODE));
		dto.setSeinenbi(rs.getInt(COL_SEINENBI));
		dto.setSeibetu(rs.getString(COL_SEIBETU));
		dto.setYubinban(rs.getString(COL_YUBINBAN));
		dto.setPrefectures(rs.getInt(COL_PREFECTURES));
		dto.setJyuusyo1(rs.getString(COL_JYUUSYO1));
		dto.setJyuusyo2(rs.getString(COL_JYUUSYO2));
		dto.setJyuusyo3(rs.getString(COL_JYUUSYO3));
		dto.setTel(rs.getString(COL_TEL));
		dto.setFax(rs.getString(COL_FAX));
		dto.setKeitai(rs.getString(COL_KEITAI));
		dto.setKetueki(rs.getString(COL_KETUEKI));
		dto.setSikaku(rs.getString(COL_SIKAKU));
		dto.setKenkou(rs.getString(COL_KENKOU));
		dto.setTekiyou(rs.getString(COL_TEKIYOU));
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<?> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @return m_kojinDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKojinDto findForKey(String kcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			executeQuery();
			MKojinDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @return m_kojinDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKojinDto findForUpdate(String kcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			executeQuery();
			MKojinDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String kcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_KCODE, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(MKojinDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(MKojinDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(MKojinDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MKojinDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode());
		setParam(index++, dto.getSeinenbi());
		setParam(index++, dto.getSeibetu());
		setParam(index++, dto.getYubinban());
		setParam(index++, dto.getPrefectures());
		setParam(index++, dto.getJyuusyo1());
		setParam(index++, dto.getJyuusyo2());
		setParam(index++, dto.getJyuusyo3());
		setParam(index++, dto.getTel());
		setParam(index++, dto.getFax());
		setParam(index++, dto.getKeitai());
		setParam(index++, dto.getKetueki());
		setParam(index++, dto.getSikaku());
		setParam(index++, dto.getKenkou());
		setParam(index++, dto.getTekiyou());
		setCommonParams(isInsert);
	}
	
}
