/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.component.ComponentsBundle;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.component.ComponentsXmlParser;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRSaxParserFactory;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class JRReportSaxParserFactory
implements JRSaxParserFactory {
    private static final Log log = LogFactory.getLog((Class)JRXmlDigesterFactory.class);
    public static final String PROPERTY_CACHE_SCHEMAS = "net.sf.jasperreports.compiler.xml.parser.cache.schemas";
    protected static final String PACKAGE_PREFIX_XERCES = "org.apache.xerces";
    protected static final String POOL_CLASS_XERCES = "org.apache.xerces.util.XMLGrammarPoolImpl";
    protected static final String PACKAGE_PREFIX_SUN_XERCES = "com.sun.org.apache.xerces";
    protected static final String POOL_CLASS_SUN_XERCES = "com.sun.org.apache.xerces.internal.util.XMLGrammarPoolImpl";
    protected static final String XERCES_PARSER_PROPERTY_GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final Object GRAMMAR_POOL_CACHE_NULL_KEY = new String("Null context classloader");
    private static final ReferenceMap GRAMMAR_POOL_CACHE = new ReferenceMap(2, 1);

    public SAXParser createParser() {
        try {
            SAXParserFactory parserFactory = this.createSAXParserFactory();
            SAXParser parser = parserFactory.newSAXParser();
            this.configureParser(parser);
            return parser;
        }
        catch (SAXException e) {
            throw new JRRuntimeException("Error creating SAX parser", e);
        }
        catch (ParserConfigurationException e) {
            throw new JRRuntimeException("Error creating SAX parser", e);
        }
    }

    protected SAXParserFactory createSAXParserFactory() throws ParserConfigurationException, SAXException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instantiated SAX parser factory of type " + parserFactory.getClass().getName()));
        }
        parserFactory.setNamespaceAware(true);
        boolean validating = JRProperties.getBooleanProperty("net.sf.jasperreports.compiler.xml.validation");
        parserFactory.setValidating(validating);
        parserFactory.setFeature("http://xml.org/sax/features/validation", validating);
        return parserFactory;
    }

    protected void configureParser(SAXParser parser) throws SAXException {
        List schemaLocations = this.getSchemaLocations();
        parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaLocations.toArray(new String[schemaLocations.size()]));
        boolean cache = JRProperties.getBooleanProperty(PROPERTY_CACHE_SCHEMAS);
        if (cache) {
            this.enableSchemaCaching(parser);
        }
    }

    protected List getSchemaLocations() {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(this.getResourceURI("net/sf/jasperreports/engine/dtds/jasperreport.xsd"));
        schemas.add(this.getResourceURI("net/sf/jasperreports/engine/dtds/jasperreport-dtd-compat.xsd"));
        Collection components = ComponentsEnvironment.getComponentBundles();
        Iterator it = components.iterator();
        while (it.hasNext()) {
            ComponentsBundle componentManager = (ComponentsBundle)it.next();
            ComponentsXmlParser xmlParser = componentManager.getXmlParser();
            String schemaResource = xmlParser.getInternalSchemaResource();
            String schemaURI = schemaResource != null ? this.getResourceURI(schemaResource) : xmlParser.getPublicSchemaLocation();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding components schema at " + schemaURI));
            }
            schemas.add(schemaURI);
        }
        return schemas;
    }

    protected String getResourceURI(String resource) {
        URL location = JRLoader.getResource(resource);
        if (location == null) {
            throw new JRRuntimeException("Could not find resource " + resource);
        }
        return location.toExternalForm();
    }

    protected void enableSchemaCaching(SAXParser parser) {
        String parserType = parser.getClass().getName();
        if (parserType.startsWith(PACKAGE_PREFIX_XERCES)) {
            this.setGrammarPoolProperty(parser, POOL_CLASS_XERCES);
        } else if (parserType.startsWith(PACKAGE_PREFIX_SUN_XERCES)) {
            this.setGrammarPoolProperty(parser, POOL_CLASS_SUN_XERCES);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Schema caching only works with Xerces parsers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGrammarPoolProperty(SAXParser parser, String poolClassName) {
        block7: {
            try {
                Object grammarPool;
                Object cacheKey = this.getGrammerPoolCacheKey();
                ReferenceMap referenceMap = GRAMMAR_POOL_CACHE;
                synchronized (referenceMap) {
                    grammarPool = GRAMMAR_POOL_CACHE.get(cacheKey);
                    if (grammarPool == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Instantiating grammar pool of type " + poolClassName + " for cache key " + cacheKey));
                        }
                        grammarPool = ClassUtils.instantiateClass(poolClassName, Object.class);
                        GRAMMAR_POOL_CACHE.put(cacheKey, grammarPool);
                    }
                }
                parser.setProperty(XERCES_PARSER_PROPERTY_GRAMMAR_POOL, grammarPool);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)("Error setting Xerces grammar pool of type " + poolClassName), (Throwable)e);
            }
        }
    }

    protected Object getGrammerPoolCacheKey() {
        Object key = Thread.currentThread().getContextClassLoader();
        if (key == null) {
            key = GRAMMAR_POOL_CACHE_NULL_KEY;
        }
        return key;
    }
}

