/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.ApiWriterVisitor;
import net.sf.jasperreports.engine.util.JRApiConstants;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.ReportCreator;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.time.Day;

public class JRApiWriter {
    private JRReport report;
    private Map stylesMap = new HashMap();
    private Map groupsMap = new HashMap();
    private Writer writer;
    private ApiWriterVisitor apiWriterVisitor = new ApiWriterVisitor(this);
    JasperDesign jasperDesign = null;
    private String indent;

    protected JRApiWriter(JRReport report) {
        this.report = report;
    }

    public static String writeReport(JRReport report) {
        JRApiWriter writer = new JRApiWriter(report);
        StringWriter buffer = new StringWriter();
        writer.writeReport(buffer);
        return buffer.toString();
    }

    public static void writeReport(JRReport report, String destFileName) throws JRException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFileName);
            String encoding = report.getProperty("net.sf.jasperreports.export.character.encoding") != null ? report.getProperty("net.sf.jasperreports.export.character.encoding") : "UTF-8";
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, encoding);
            JRApiWriter writer = new JRApiWriter(report);
            writer.writeReport(out);
        }
        catch (IOException e) {
            throw new JRException("Error writing to file : " + destFileName, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void writeReport(JRReport report, OutputStream outputStream) throws JRException {
        try {
            String encoding = report.getProperty("net.sf.jasperreports.export.character.encoding") != null ? report.getProperty("net.sf.jasperreports.export.character.encoding") : "UTF-8";
            OutputStreamWriter out = new OutputStreamWriter(outputStream, encoding);
            JRApiWriter writer = new JRApiWriter(report);
            writer.writeReport(out);
        }
        catch (Exception e) {
            throw new JRException("Error writing to OutputStream : " + report.getName(), e);
        }
    }

    protected void writeReport(Writer aWriter) {
        JRSection detail;
        JRDataset[] datasets;
        JRStyle[] styles;
        this.writer = aWriter;
        this.indent = "";
        this.write1("/*\n");
        this.write1(" * Generated by JasperReports - ");
        this.write1(new SimpleDateFormat().format(new Date()));
        this.write1("\n");
        this.write1(" */\n");
        this.write1("import java.awt.Color;\n");
        this.write1("import java.io.IOException;\n");
        this.write1("import java.util.HashMap;\n");
        this.write1("import java.util.HashSet;\n");
        this.write1("import java.util.Iterator;\n");
        this.write1("import java.util.List;\n");
        this.write1("import java.util.Map;\n");
        this.write1("import java.util.Set;\n");
        this.write1("import java.util.SortedSet;\n");
        this.write1("import java.util.TreeSet;\n");
        this.write1("\n");
        this.write1("import org.jfree.chart.plot.PlotOrientation;\n");
        this.write1("\n");
        this.write1("import net.sf.jasperreports.charts.JRCategoryAxisFormat;\n");
        this.write1("import net.sf.jasperreports.charts.design.*;\n");
        this.write1("import net.sf.jasperreports.charts.util.JRAxisFormat;\n");
        this.write1("import net.sf.jasperreports.crosstabs.design.*;\n");
        this.write1("import net.sf.jasperreports.engine.JRException;\n");
        this.write1("import net.sf.jasperreports.engine.design.*;\n");
        this.write1("import net.sf.jasperreports.engine.util.ReportCreator;\n");
        this.write1("\n");
        String[] imports = this.report.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                String value = imports[i];
                if (value == null) continue;
                this.write("import {0};\n", value);
            }
        }
        this.write1("\n");
        this.write1("\n");
        this.write1("public class " + JRStringUtil.escapeJavaStringLiteral(this.report.getName()) + " implements ReportCreator");
        this.write1("{\n");
        this.write1("\n");
        this.indent = this.indent + "  ";
        this.write1("public JasperDesign create() throws JRException\n");
        this.write1("{\n");
        this.indent = this.indent + "  ";
        this.write1("JasperDesign jasperDesign = new JasperDesign();\n");
        this.write1("jasperDesign.setName(\"" + JRStringUtil.escapeJavaStringLiteral(this.report.getName()) + "\");\n");
        this.write("jasperDesign.setLanguage(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(this.report.getLanguage()));
        this.write("jasperDesign.setColumnCount({0});\n", this.report.getColumnCount(), 1);
        this.write("jasperDesign.setPrintOrder((byte){0});\n", this.report.getPrintOrder(), (byte)1);
        this.write("jasperDesign.setPageWidth({0});\n", this.report.getPageWidth());
        this.write("jasperDesign.setPageHeight({0});\n", this.report.getPageHeight());
        this.write("jasperDesign.setOrientation((byte){0});\n", this.report.getOrientation(), (byte)1);
        this.write("jasperDesign.setWhenNoDataType((byte){0});\n", this.report.getWhenNoDataType(), (byte)1);
        this.write("jasperDesign.setColumnWidth({0});\n", this.report.getColumnWidth());
        this.write("jasperDesign.setColumnSpacing({0});\n", this.report.getColumnSpacing());
        this.write("jasperDesign.setLeftMargin({0});\n", this.report.getLeftMargin());
        this.write("jasperDesign.setRightMargin({0});\n", this.report.getRightMargin());
        this.write("jasperDesign.setTopMargin({0});\n", this.report.getTopMargin());
        this.write("jasperDesign.setBottomMargin({0});\n", this.report.getBottomMargin());
        this.write("jasperDesign.setTitleNewPage({0});\n", this.report.isTitleNewPage(), false);
        this.write("jasperDesign.setSummaryNewPage({0});\n", this.report.isSummaryNewPage(), false);
        this.write("jasperDesign.setSummaryWithPageHeaderAndFooter({0});\n", this.report.isSummaryWithPageHeaderAndFooter(), false);
        this.write("jasperDesign.setFloatColumnFooter({0});\n", this.report.isFloatColumnFooter(), false);
        this.write("jasperDesign.setScriptletClass(\"{0}\");\n", this.report.getScriptletClass());
        this.write("jasperDesign.setFormatFactoryClass(\"{0}\");\n", this.report.getFormatFactoryClass());
        this.write("jasperDesign.setgetResourceBundle(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(this.report.getResourceBundle()));
        this.write("jasperDesign.setWhenResourceMissingType((byte){0});\n", this.report.getWhenResourceMissingType(), (byte)1);
        this.write("jasperDesign.setIgnorePagination({0});\n\n", this.report.isIgnorePagination(), false);
        this.writeProperties(this.report, "jasperDesign");
        this.write1("\n");
        this.writeTemplates(this.indent);
        this.write1("\n");
        JRReportFont[] fonts = this.report.getFonts();
        if (fonts != null && fonts.length > 0) {
            this.write1("//report fonts\n\n");
            for (int i = 0; i < fonts.length; ++i) {
                this.writeReportFont(fonts[i], "reportFontStyle" + i);
                this.write1("jasperDesign.addStyle(reportFontStyle" + i + ");\n\n");
                this.flush();
            }
        }
        if ((styles = this.report.getStyles()) != null && styles.length > 0) {
            this.write1("//styles\n");
            for (int i = 0; i < styles.length; ++i) {
                this.writeStyle(styles[i], "reportStyle" + i);
                this.write1("jasperDesign.addStyle(reportStyle" + i + ");\n\n");
                if (!this.toWriteConditionalStyles()) continue;
                JRConditionalStyle[] conditionalStyles = styles[i].getConditionalStyles();
                if (styles[i] instanceof JRConditionalStyle || conditionalStyles == null) continue;
                for (int j = 0; j < conditionalStyles.length; ++j) {
                    String conditionalStyleName = "reportStyle" + i + "Conditional" + j;
                    this.writeConditionalStyle(conditionalStyles[j], conditionalStyleName);
                    this.write1("reportStyle" + i + ".addConditionalStyle(" + conditionalStyleName + ");\n\n");
                }
                this.flush();
            }
            this.flush();
        }
        if ((datasets = this.report.getDatasets()) != null && datasets.length > 0) {
            this.write1("//datasets\n");
            for (int i = 0; i < datasets.length; ++i) {
                this.writeDataset(datasets[i], "reportDataset" + i);
                if (datasets[i] == null) continue;
                this.write1("jasperDesign.addDataset(reportDataset" + i + ");\n");
            }
            this.write1("\n");
            this.flush();
        }
        if (this.report.getMainDataset() != null) {
            this.writeDataset(this.report.getMainDataset(), "reportMainDataset");
            this.write1("jasperDesign.setMainDataset(reportMainDataset);\n");
        }
        if (this.report.getBackground() != null) {
            this.write1("//background\n\n");
            this.writeBand(this.report.getBackground(), "backgroundBand");
            this.write1("jasperDesign.setBackground(backgroundBand);\n\n");
        }
        if (this.report.getTitle() != null) {
            this.write1("//title\n\n");
            this.writeBand(this.report.getTitle(), "titleBand");
            this.write1("jasperDesign.setTitle(titleBand);\n\n");
        }
        if (this.report.getPageHeader() != null) {
            this.write1("//page header\n\n");
            this.writeBand(this.report.getPageHeader(), "pageHeaderBand");
            this.write1("jasperDesign.setPageHeader(pageHeaderBand);\n\n");
        }
        if (this.report.getColumnHeader() != null) {
            this.write1("//column header\n\n");
            this.writeBand(this.report.getColumnHeader(), "columnHeaderBand");
            this.write1("jasperDesign.setColumnHeader(columnHeaderBand);\n\n");
        }
        if ((detail = this.report.getDetailSection()) != null && detail.getBands() != null && detail.getBands().length > 0) {
            this.writeSection(detail, "detailBand", this.indent + "((JRDesignSection)jasperDesign.getDetailSection()).getBandsList()");
        }
        if (this.report.getColumnFooter() != null) {
            this.write1("//column footer\n\n");
            this.writeBand(this.report.getColumnFooter(), "columnFooterBand");
            this.write1("jasperDesign.setColumnFooter(columnFooterBand);\n\n");
        }
        if (this.report.getPageFooter() != null) {
            this.write1("//page footer\n\n");
            this.writeBand(this.report.getPageFooter(), "pageFooterBand");
            this.write1("jasperDesign.setPageFooter(pageFooterBand);\n\n");
        }
        if (this.report.getLastPageFooter() != null) {
            this.write1("//last page footer\n\n");
            this.writeBand(this.report.getLastPageFooter(), "lastPageFooterBand");
            this.write1("jasperDesign.setLastPageFooter(lastPageFooterBand);\n\n");
        }
        if (this.report.getSummary() != null) {
            this.write1("//summary\n\n");
            this.writeBand(this.report.getSummary(), "summaryBand");
            this.write1("jasperDesign.setSummary(summaryBand);\n\n");
        }
        if (this.report.getNoData() != null) {
            this.write1("//no data\n\n");
            this.writeBand(this.report.getNoData(), "noDataBand");
            this.write1("jasperDesign.setNoData(noDataBand);\n\n");
        }
        this.write1("return jasperDesign;\n");
        this.write1("}\n\n");
        this.indent = "";
        this.write1("}\n");
        this.flush();
        this.close();
    }

    private void writeProperties(JRPropertiesHolder propertiesHolder, String propertiesHolderName) {
        if (propertiesHolder.hasProperties()) {
            JRPropertiesMap propertiesMap = propertiesHolder.getPropertiesMap();
            String[] propertyNames = propertiesMap.getPropertyNames();
            if (propertyNames != null && propertyNames.length > 0) {
                this.write1("//properties\n");
                for (int i = 0; i < propertyNames.length; ++i) {
                    String value = propertiesMap.getProperty(propertyNames[i]);
                    if (value == null) continue;
                    this.write1(propertiesHolderName + ".setProperty(\"" + propertyNames[i] + "\", \"" + JRStringUtil.escapeJavaStringLiteral(value) + "\");\n");
                }
                this.write1("\n");
            }
            this.flush();
        }
    }

    protected void writeTemplates(String indent) {
        JRReportTemplate[] templates = this.report.getTemplates();
        if (templates != null) {
            for (int i = 0; i < templates.length; ++i) {
                JRReportTemplate template = templates[i];
                this.writeTemplate(template, "reportTemplate" + i);
                this.write1("jasperDesign.addTemplate(reportTemplate" + i + ");\n");
            }
            this.write1("\n");
            this.flush();
        }
    }

    protected void writeTemplate(JRReportTemplate template, String templateName) {
        this.write1("JRDesignReportTemplate " + templateName + " = new JRDesignReportTemplate();\n");
        this.writeExpression(template.getSourceExpression(), templateName, "SourceExpression", String.class.getName());
        this.flush();
    }

    private void writeReportFont(JRReportFont font, String styleName) {
        if (font != null && this.stylesMap.get(font.getName()) == null) {
            this.write1(styleName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(font.getName()) + "\");\n");
            this.write(styleName + ".setDefault({0});\n", font.isDefault(), false);
            this.write(styleName + ".setFontName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(font.getOwnFontName()));
            this.write(styleName + ".setFontSize({0});\n", font.getOwnFontSize());
            this.write(styleName + ".setBold({0});\n", font.isOwnBold());
            this.write(styleName + ".setItalic({0});\n", font.isOwnItalic());
            this.write(styleName + ".setUnderline({0});\n", font.isOwnUnderline());
            this.write(styleName + ".setStrikeThrough({0});\n", font.isOwnStrikeThrough());
            this.write(styleName + ".setPdfFontName(\"{0}", JRStringUtil.escapeJavaStringLiteral(font.getOwnPdfFontName()));
            this.write(styleName + ".setPdfEncoding(\"{0}\");\n", font.getOwnPdfEncoding());
            this.write(styleName + ".setPdfEmbedded({0});\n", font.isOwnPdfEmbedded());
            this.stylesMap.put(font.getName(), styleName);
            this.flush();
        }
    }

    private void writeScriptlet(JRScriptlet scriptlet, String scriptletName) {
        if (scriptlet != null) {
            this.write1("JRDesignScriptlet " + scriptletName + " = new JRDesignScriptlet();\n");
            this.write(scriptletName + ".setDescription(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(scriptlet.getDescription()));
            this.write(scriptletName + ".setName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(scriptlet.getName()));
            this.write(scriptletName + ".setValueClassName(\"{0}\");\n", scriptlet.getValueClassName());
            this.writeProperties(scriptlet, scriptletName);
            this.flush();
        }
    }

    private void writeParameter(JRParameter parameter, String parameterName) {
        if (parameter != null) {
            this.write1("JRDesignParameter " + parameterName + " = new JRDesignParameter();\n");
            this.write(parameterName + ".setName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(parameter.getName()));
            this.write(parameterName + ".setDescription(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(parameter.getDescription()));
            this.write(parameterName + ".setValueClassName(\"{0}\");\n", parameter.getValueClassName());
            this.write(parameterName + ".setNestedTypeName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(parameter.getNestedTypeName()));
            this.write(parameterName + ".setForPrompting({0});\n", parameter.isForPrompting(), true);
            this.writeProperties(parameter, parameterName);
            this.writeExpression(parameter.getDefaultValueExpression(), parameterName, "DefaultValueExpression");
            this.flush();
        }
    }

    private void writeQuery(JRQuery query, String queryName) {
        if (query != null) {
            this.write("JRDesignQuery " + queryName + " = new JRDesignQuery();\n");
            this.write(queryName + ".setLanguage(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(query.getLanguage()), "sql");
            this.write(queryName + ".setText(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(query.getText()));
            this.flush();
        }
    }

    private void writeField(JRField field, String fieldName) {
        if (field != null) {
            this.write("JRDesignField " + fieldName + " = new JRDesignField();\n");
            this.write(fieldName + ".setName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(field.getName()));
            this.write(fieldName + ".setDescription(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(field.getDescription()));
            this.write(fieldName + ".setValueClassName(\"{0}\");\n", field.getValueClassName());
            this.writeProperties(field, fieldName);
            this.flush();
        }
    }

    private void writeSortField(JRSortField sortField, String sortFieldName) {
        if (sortField != null) {
            this.write("JRDesignSortField " + sortFieldName + " = new JRDesignSortField();\n");
            this.write(sortFieldName + ".setName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(sortField.getName()));
            this.write(sortFieldName + ".setOrder({0});\n", JRApiConstants.getSortOrder(new Byte(sortField.getOrder())));
            this.flush();
        }
    }

    private void writeVariable(JRVariable variable, String variableName) {
        if (variable != null) {
            String resetGroupName = this.getGroupName(variable.getResetGroup());
            String incrementGroupName = this.getGroupName(variable.getIncrementGroup());
            this.write("JRDesignVariable " + variableName + " = new JRDesignVariable();\n");
            this.write(variableName + ".setName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(variable.getName()));
            this.write(variableName + ".setValueClassName(\"{0}\");\n", variable.getValueClassName());
            this.write(variableName + ".setResetType({0});\n", JRApiConstants.getResetType(new Byte(variable.getResetType())), "JRVariable.RESET_TYPE_REPORT");
            this.write(variableName + ".setResetGroup({0});\n", resetGroupName);
            this.write(variableName + ".setIncrementType({0});\n", JRApiConstants.getResetType(new Byte(variable.getIncrementType())), "JRVariable.RESET_TYPE_NONE");
            this.write(variableName + ".setIncrementGroup({0});\n", incrementGroupName);
            this.write(variableName + ".setCalculation({0});\n", JRApiConstants.getCalculation(new Byte(variable.getCalculation())), "JRVariable.CALCULATION_NOTHING");
            this.write(variableName + ".setIncrementerFactoryClass(Class.forName(\"{0}\"));\n", JRStringUtil.escapeJavaStringLiteral(variable.getIncrementerFactoryClassName()));
            this.writeExpression(variable.getExpression(), variableName, "Expression");
            this.writeExpression(variable.getInitialValueExpression(), variableName, "InitialValueExpression");
            this.flush();
        }
    }

    private void writeGroup(JRGroup group) {
        JRSection groupFooter;
        String groupName = group.getName();
        this.groupsMap.put(groupName, groupName);
        this.write("JRDesignGroup " + groupName + "ResetGroup = new JRDesignGroup();\n");
        this.write(groupName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(groupName) + "\");\n");
        this.write(groupName + ".setStartNewColumn({0});\n", group.isStartNewColumn(), false);
        this.write(groupName + ".setStartNewPage({0});\n", group.isStartNewPage(), false);
        this.write(groupName + ".setReprintHeaderOnEachPage({0});\n", group.isReprintHeaderOnEachPage(), false);
        this.write(groupName + ".setMinHeightToStartNewPage({0});\n", group.getMinHeightToStartNewPage());
        this.write(groupName + ".setFooterPosition({0});\n", JRApiConstants.getFooterPosition(new Byte(group.getFooterPosition())), "JRGroup.FOOTER_POSITION_NORMAL");
        this.write(groupName + ".setKeepTogether({0});\n", group.isKeepTogether(), false);
        this.writeExpression(group.getExpression(), groupName, "Expression");
        JRSection groupHeader = group.getGroupHeaderSection();
        if (groupHeader != null) {
            this.writeSection(groupHeader, groupName + "Header", "((JRDesignSection)" + groupName + ".getGroupHeaderSection()).getBandsList()");
        }
        if ((groupFooter = group.getGroupFooterSection()) != null) {
            this.writeSection(groupFooter, groupName + "Footer", "((JRDesignSection)" + groupName + ".getGroupFooterSection()).getBandsList()");
        }
        this.flush();
    }

    protected void writeSection(JRSection section, String sectionName, String sectionBandListGetterName) {
        if (section != null) {
            JRBand[] bands = section.getBands();
            if (bands != null && bands.length > 0) {
                this.write("//" + sectionName + "\n\n");
                for (int i = 0; i < bands.length; ++i) {
                    this.writeBand(bands[i], sectionName + i);
                    this.write(sectionBandListGetterName + ".add(" + i + ", " + sectionName + i + ");\n\n");
                }
            }
            this.flush();
        }
    }

    private void writeBand(JRBand band, String bandName) {
        if (band != null) {
            this.write("//band name = " + bandName + "\n\n");
            this.write("JRDesignBand " + bandName + " = new JRDesignBand();\n");
            this.write(bandName + ".setHeight({0});\n", band.getHeight());
            this.write(bandName + ".setSplitType({0});\n", JRApiConstants.getSplitType(band.getSplitType()));
            this.writeExpression(band.getPrintWhenExpression(), bandName, "PrintWhenExpression");
            this.writeChildElements(band, bandName);
            this.flush();
        }
    }

    public void writeChildElements(JRElementGroup elementContainer, String parentName) {
        List children = elementContainer.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                if (children.get(i) == null) continue;
                this.apiWriterVisitor.setName(parentName + i);
                ((JRChild)children.get(i)).visit(this.apiWriterVisitor);
                this.write(parentName + ".addElement(" + parentName + i + ");\n\n");
            }
        }
    }

    public void writeElementGroup(JRElementGroup elementGroup, String groupName) {
        if (elementGroup != null) {
            this.write("JRDesignElementGroup " + groupName + " = new JRDesignElementGroup();\n");
            this.writeChildElements(elementGroup, groupName);
            this.flush();
        }
    }

    public void writeBreak(JRBreak breakElement, String breakName) {
        if (breakElement != null) {
            this.write("JRDesignBreak " + breakName + " = new JRDesignBreak(jasperDesign);\n");
            this.write(breakName + ".setType({0});\n", JRApiConstants.getBreakType(new Byte(breakElement.getType())), "JRBreak.TYPE_PAGE");
            this.writeReportElement(breakElement, breakName);
            this.flush();
        }
    }

    public void writeLine(JRLine line, String lineName) {
        if (line != null) {
            this.write("JRDesignLine " + lineName + " = new JRDesignLine(jasperDesign);\n");
            this.write(lineName + ".setDirection({0});\n", JRApiConstants.getDirection(new Byte(line.getDirection())), "JRLine.DIRECTION_TOP_DOWN");
            this.writeReportElement(line, lineName);
            this.writeGraphicElement(line, lineName);
            this.flush();
        }
    }

    private void writeReportElement(JRElement element, String elementName) {
        if (element != null) {
            this.write(elementName + ".setKey(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(element.getKey()));
            this.writeStyleReferenceAttr(element, elementName);
            this.write(elementName + ".setPositionType({0});\n", JRApiConstants.getPositionType(new Byte(element.getPositionType())), "JRElement.POSITION_TYPE_FIX_RELATIVE_TO_TOP");
            this.write(elementName + ".setStretchType({0});\n", JRApiConstants.getStretchType(new Byte(element.getStretchType())), "JRElement.STRETCH_TYPE_NO_STRETCH");
            this.write(elementName + ".setPrintRepeatedValues({0});\n", element.isPrintRepeatedValues(), true);
            this.write(elementName + ".setMode({0});\n", JRApiConstants.getMode(element.getOwnMode()));
            this.write(elementName + ".setX({0});\n", element.getX());
            this.write(elementName + ".setY({0});\n", element.getY());
            this.write(elementName + ".setWidth({0});\n", element.getWidth());
            this.write(elementName + ".setHeight({0});\n", element.getHeight());
            this.write(elementName + ".setRemoveLineWhenBlank({0});\n", element.isRemoveLineWhenBlank(), false);
            this.write(elementName + ".setPrintInFirstWholeBand({0});\n", element.isPrintInFirstWholeBand(), false);
            this.write(elementName + ".setPrintWhenDetailOverflows({0});\n", element.isPrintWhenDetailOverflows(), false);
            if (element.getPrintWhenGroupChanges() != null) {
                String groupName = this.getGroupName(element.getPrintWhenGroupChanges());
                this.write(elementName + ".setPrintWhenGroupChanges(" + groupName + ");\n");
            }
            this.write(elementName + ".setForecolor({0});\n", this.getColorText(element.getOwnForecolor()));
            this.write(elementName + ".setBackcolor({0});\n", this.getColorText(element.getOwnBackcolor()));
            this.writeProperties(element, elementName + ".getPropertiesMap()");
            this.writePropertyExpressions(element.getPropertyExpressions(), elementName);
            this.writeExpression(element.getPrintWhenExpression(), elementName, "PrintWhenExpression");
            this.flush();
        }
    }

    protected void writePropertyExpressions(JRPropertyExpression[] propertyExpressions, String propertyHolderName) {
        if (propertyExpressions != null && propertyExpressions.length > 0) {
            for (int i = 0; i < propertyExpressions.length; ++i) {
                this.writePropertyExpression(propertyExpressions[i], propertyHolderName + "PropertyExpression" + i);
                this.write(propertyHolderName + ".addPropertyExpression(" + propertyHolderName + "PropertyExpression" + i + ");\n");
            }
            this.flush();
        }
    }

    protected void writePropertyExpression(JRPropertyExpression propertyExpression, String propertyExpressionName) {
        if (propertyExpression != null) {
            this.write("JRDesignPropertyExpression " + propertyExpressionName + " = new JRDesignPropertyExpression();\n");
            this.write(propertyExpressionName + ".setName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(propertyExpression.getName()));
            this.writeExpression(propertyExpression.getValueExpression(), propertyExpressionName, "ValueExpression");
            this.flush();
        }
    }

    private void writeGraphicElement(JRGraphicElement element, String elementName) {
        if (element != null) {
            this.write(elementName + ".setFill((byte)" + element.getFill() + ");\n");
            this.writePen(element.getLinePen(), elementName + ".getLinePen()");
            this.flush();
        }
    }

    public void writeRectangle(JRRectangle rectangle, String rectangleName) {
        if (rectangle != null) {
            this.write("JRDesignRectangle " + rectangleName + " = new JRDesignRectangle(jasperDesign);\n");
            this.write(rectangleName + ".setRadius({0});\n", rectangle.getRadius());
            this.writeReportElement(rectangle, rectangleName);
            this.writeGraphicElement(rectangle, rectangleName);
            this.flush();
        }
    }

    public void writeEllipse(JREllipse ellipse, String ellipseName) {
        if (ellipse != null) {
            this.write("JRDesignEllipse " + ellipseName + " = new JRDesignEllipse(jasperDesign);\n");
            this.writeReportElement(ellipse, ellipseName);
            this.writeGraphicElement(ellipse, ellipseName);
            this.flush();
        }
    }

    public void writeImage(JRImage image, String imageName) {
        if (image != null) {
            this.write("JRDesignImage " + imageName + " = new JRDesignImage(jasperDesign);\n");
            this.write(imageName + ".setScaleImage({0});\n", JRApiConstants.getScaleImage(image.getOwnScaleImage()));
            this.write(imageName + ".setHorizontalAlignment({0});\n", JRApiConstants.getHorizontalAlign(image.getOwnHorizontalAlignment()));
            this.write(imageName + ".setVerticalAlignment({0});\n", JRApiConstants.getHorizontalAlign(image.getOwnVerticalAlignment()));
            this.write(imageName + ".setUsingCache({0});\n", image.isOwnUsingCache());
            this.write(imageName + ".setLazy({0});\n", image.isLazy(), false);
            this.write(imageName + ".setOnErrorType({0});\n", JRApiConstants.getOnErrorType(new Byte(image.getOnErrorType())), "JRImage.ON_ERROR_TYPE_ERROR");
            this.write(imageName + ".setEvaluationTime({0});\n", JRApiConstants.getEvaluationTime(new Byte(image.getEvaluationTime())), "JRExpression.EVALUATION_TIME_NOW");
            if (image.getEvaluationGroup() != null) {
                String groupName = this.getGroupName(image.getEvaluationGroup());
                this.write(imageName + ".setEvaluationGroup(" + groupName + ");\n");
            }
            this.write(imageName + ".setLinkType({0});\n", JRStringUtil.escapeJavaStringLiteral(image.getLinkType()), "JRHyperlinkHelper.HYPERLINK_TYPE_NONE");
            this.write(imageName + ".setLinkTarget({0});\n", JRStringUtil.escapeJavaStringLiteral(image.getLinkTarget()), "JRHyperlinkHelper.HYPERLINK_TARGET_SELF");
            this.write(imageName + ".setBookmarkLevel({0});\n", image.getBookmarkLevel(), 0);
            this.writeReportElement(image, imageName);
            this.writeBox(image.getLineBox(), imageName + ".getLineBox()");
            this.writeGraphicElement(image, imageName);
            this.writeExpression(image.getExpression(), imageName, "Expression");
            this.writeExpression(image.getAnchorNameExpression(), imageName, "AnchorNameExpression");
            this.writeExpression(image.getHyperlinkReferenceExpression(), imageName, "HyperlinkReferenceExpression");
            this.writeExpression(image.getHyperlinkAnchorExpression(), imageName, "HyperlinkAnchorExpression");
            this.writeExpression(image.getHyperlinkPageExpression(), imageName, "HyperlinkPageExpression");
            this.writeExpression(image.getHyperlinkTooltipExpression(), imageName, "HyperlinkTooltipExpression");
            this.writeHyperlinkParameters(image.getHyperlinkParameters(), imageName);
            this.flush();
        }
    }

    public void writeStaticText(JRStaticText staticText, String staticTextName) {
        if (staticText != null) {
            this.write("JRDesignStaticText " + staticTextName + " = new JRDesignStaticText(jasperDesign);\n");
            this.writeReportElement(staticText, staticTextName);
            this.writeBox(staticText.getLineBox(), staticTextName + ".getLineBox()");
            this.writeTextElement(staticText, staticTextName);
            this.write(staticTextName + ".setText(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(staticText.getText()));
            this.flush();
        }
    }

    private void writeTextElement(JRTextElement textElement, String textElementName) {
        if (textElement != null) {
            this.write(textElementName + ".setHorizontalAlignment({0});\n", JRApiConstants.getHorizontalAlign(textElement.getOwnHorizontalAlignment()));
            this.write(textElementName + ".setVerticalAlignment({0});\n", JRApiConstants.getHorizontalAlign(textElement.getOwnVerticalAlignment()));
            this.write(textElementName + ".setRotation({0});\n", JRApiConstants.getRotation(textElement.getOwnRotation()));
            this.write(textElementName + ".setLineSpacing({0});\n", JRApiConstants.getLineSpacing(textElement.getOwnLineSpacing()));
            this.write(textElementName + ".setMarkup(\"{0}\");\n", textElement.getMarkup());
            this.writeFont(textElement, textElementName);
            this.flush();
        }
    }

    private void writeFont(JRFont font, String fontHolderName) {
        if (font != null) {
            String reportFontStyle = null;
            if (font.getReportFont() != null) {
                reportFontStyle = (String)this.stylesMap.get(font.getReportFont().getName());
                if (reportFontStyle != null) {
                    this.write(fontHolderName + ".setStyle(" + reportFontStyle + ");\n");
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            this.write(fontHolderName + ".setFontName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(font.getOwnFontName()));
            this.write(fontHolderName + ".setFontSize({0});\n", font.getOwnFontSize());
            this.write(fontHolderName + ".setBold({0});\n", font.isOwnBold());
            this.write(fontHolderName + ".setItalic({0});\n", font.isOwnItalic());
            this.write(fontHolderName + ".setUnderline({0});\n", font.isOwnUnderline());
            this.write(fontHolderName + ".setStrikeThrough({0});\n", font.isOwnStrikeThrough());
            this.write(fontHolderName + ".setPdfFontName(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(font.getOwnPdfFontName()));
            this.write(fontHolderName + ".setPdfEncoding(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(font.getOwnPdfEncoding()));
            this.write(fontHolderName + ".setPdfEmbedded({0});\n", font.isOwnPdfEmbedded());
            this.flush();
        }
    }

    private void writeStyle(JRStyle style, String styleName) {
        if (style != null && this.stylesMap.get(style.getName()) == null) {
            this.write("JRDesignStyle " + styleName + " = new JRDesignStyle();\n");
            this.write(styleName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(style.getName()) + "\");\n");
            if (style.getStyle() == null && style.getStyleNameReference() != null) {
                this.write(styleName + ".setParentStyleNameReference(" + style.getStyleNameReference() + ");\n");
            }
            this.write(styleName + ".setDefault(" + style.isDefault() + ");\n");
            if (style.getMode() != null) {
                this.write(styleName + ".setMode((byte)" + style.getMode() + ");\n");
            }
            this.write(styleName + ".setFontName(\"" + JRStringUtil.escapeJavaStringLiteral(style.getFontName()) + "\");\n");
            this.write(styleName + ".setFontSize(" + style.getFontSize() + ");\n");
            this.write(styleName + ".setBold(" + style.isBold() + ");\n");
            this.write(styleName + ".setItalic(" + style.isItalic() + ");\n");
            this.write(styleName + ".setUnderline(" + style.isUnderline() + ");\n");
            this.write(styleName + ".setStrikeThrough(" + style.isStrikeThrough() + ");\n");
            this.write(styleName + ".setPdfFontName(\"" + JRStringUtil.escapeJavaStringLiteral(style.getPdfFontName()) + "\");\n");
            this.write(styleName + ".setPdfEncoding(\"" + JRStringUtil.escapeJavaStringLiteral(style.getPdfEncoding()) + "\");\n");
            this.write(styleName + ".setPdfEmbedded(" + style.isPdfEmbedded() + ");\n");
            this.write(styleName + ".setForecolor(" + this.getColorText(style.getForecolor()) + ");\n");
            this.write(styleName + ".setBackcolor(" + this.getColorText(style.getBackcolor()) + ");\n");
            this.write(styleName + ".setFill((byte)" + style.getFill() + ");\n");
            this.write(styleName + ".setRadius(" + style.getRadius() + ");\n");
            this.write(styleName + ".setScaleImage((byte)" + style.getScaleImage() + ");\n");
            this.write(styleName + ".setHorizontalAlignment((byte)" + style.getHorizontalAlignment() + ");\n");
            this.write(styleName + ".setVerticalAlignment((byte)" + style.getVerticalAlignment() + ");\n");
            this.write(styleName + ".setRotation((byte)" + style.getRotation() + ");\n");
            this.write(styleName + ".setLineSpacing((byte)" + style.getLineSpacing() + ");\n");
            this.write(styleName + ".setMarkup(\"" + JRStringUtil.escapeJavaStringLiteral(style.getMarkup()) + "\");\n");
            if (style.getPattern() != null) {
                this.write(styleName + ".setPattern(\"" + JRStringUtil.escapeJavaStringLiteral(style.getPattern()) + "\");\n");
            }
            this.write(styleName + ".setBlankWhenNull(" + style.isBlankWhenNull() + ");\n");
            this.stylesMap.put(style.getName(), styleName);
            this.flush();
        }
    }

    public void writeTextField(JRTextField textField, String textFieldName) {
        if (textField != null) {
            this.write("JRDesignTextField " + textFieldName + " = new JRDesignTextField(jasperDesign);\n");
            this.write(textFieldName + ".setStretchWithOverflow(" + textField.isStretchWithOverflow() + ");\n");
            this.write(textFieldName + ".setEvaluationTime((byte)" + (textField.getEvaluationTime() > 0 ? textField.getEvaluationTime() : (byte)1) + ");\n");
            String evaluationGroupName = this.getGroupName(textField.getEvaluationGroup());
            if (evaluationGroupName != null) {
                this.write(textFieldName + ".setEvaluationGroup(" + evaluationGroupName + ");\n");
            }
            this.write(textFieldName + ".setPattern(\"" + JRStringUtil.escapeJavaStringLiteral(textField.getPattern()) + "\");\n");
            this.write(textFieldName + ".setBlankWhenNull(" + textField.isBlankWhenNull() + ");\n");
            this.write(textFieldName + ".setLinkType(\"" + JRStringUtil.escapeJavaStringLiteral(textField.getLinkType() != null ? textField.getLinkType() : "None") + "\");\n");
            this.write(textFieldName + ".setLinkTarget(\"" + JRStringUtil.escapeJavaStringLiteral(textField.getLinkTarget() != null ? textField.getLinkTarget() : "Self") + "\");\n");
            this.write(textFieldName + ".setBookmarkLevel(" + (textField.getBookmarkLevel() > 0 ? textField.getBookmarkLevel() : 0) + ");\n");
            this.writeReportElement(textField, textFieldName);
            this.writeBox(textField.getLineBox(), textFieldName + ".getLineBox()");
            this.writeTextElement(textField, textFieldName);
            this.writeExpression(textField.getExpression(), textFieldName, "Expression");
            this.writeExpression(textField.getAnchorNameExpression(), textFieldName, "AnchorNameExpression");
            this.writeExpression(textField.getHyperlinkReferenceExpression(), textFieldName, "HyperlinkReferenceExpression");
            this.writeExpression(textField.getHyperlinkAnchorExpression(), textFieldName, "HyperlinkAnchorExpression");
            this.writeExpression(textField.getHyperlinkPageExpression(), textFieldName, "HyperlinkPageExpression");
            this.writeExpression(textField.getHyperlinkTooltipExpression(), textFieldName, "HyperlinkTooltipExpression");
            this.writeHyperlinkParameters(textField.getHyperlinkParameters(), textFieldName);
            this.flush();
        }
    }

    public void writeSubreport(JRSubreport subreport, String subreportName) {
        if (subreport != null) {
            this.write("JRDesignSubreport " + subreportName + " = new JRDesignSubreport(jasperDesign);\n");
            this.write(subreportName + ".setUsingCache(" + subreport.isUsingCache() + ");\n");
            this.write(subreportName + ".setRunToBottom(" + subreport.isRunToBottom() + ");\n");
            this.writeReportElement(subreport, subreportName);
            this.writeExpression(subreport.getParametersMapExpression(), subreportName, "ParametersMapExpression");
            JRSubreportParameter[] parameters = subreport.getParameters();
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    this.writeSubreportParameter(parameters[i], subreportName + "Parameter" + i);
                    this.write(subreportName + ".addParameter(" + subreportName + "Parameter" + i + ");\n");
                }
            }
            this.writeExpression(subreport.getConnectionExpression(), subreportName, "ConnectionExpression");
            this.writeExpression(subreport.getDataSourceExpression(), subreportName, "DataSourceExpression");
            JRSubreportReturnValue[] returnValues = subreport.getReturnValues();
            if (returnValues != null && returnValues.length > 0) {
                for (int i = 0; i < returnValues.length; ++i) {
                    this.writeSubreportReturnValue(returnValues[i], subreportName + "ReturnValue" + i);
                    this.write(subreportName + ".addReturnValue(" + subreportName + "ReturnValue" + i + ");\n");
                }
            }
            this.writeExpression(subreport.getExpression(), subreportName, "Expression");
            this.flush();
        }
    }

    private void writeSubreportParameter(JRSubreportParameter subreportParameter, String subreportParameterName) {
        if (subreportParameter != null) {
            this.write("JRDesignSubreportParameter " + subreportParameterName + " = new JRDesignSubreportParameter();\n");
            this.write(subreportParameterName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(subreportParameter.getName()) + "\");\n");
            this.writeExpression(subreportParameter.getExpression(), subreportParameterName, "Expression");
            this.flush();
        }
    }

    private void writeDatasetParameter(JRDatasetParameter datasetParameter, String datasetParameterName) {
        if (datasetParameter != null) {
            this.write("JRDesignDatasetParameter " + datasetParameterName + " = new JRDesignSubreportParameter();\n");
            this.write(datasetParameterName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(datasetParameter.getName()) + "\");\n");
            this.writeExpression(datasetParameter.getExpression(), datasetParameterName, "Expression");
            this.flush();
        }
    }

    private void writeChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write(chartName + ".setShowLegend(Boolean.valueOf(" + chart.getShowLegend() + "));\n");
            this.write(chartName + ".setEvaluationTime((byte)" + (chart.getEvaluationTime() > 0 ? chart.getEvaluationTime() : (byte)1) + ");\n");
            if (chart.getEvaluationTime() == 5) {
                String evaluationGroupName = this.getGroupName(chart.getEvaluationGroup());
                this.write(chartName + ".setEvaluationGroup(" + evaluationGroupName + ");\n");
            }
            this.write(chartName + ".setLinkType(\"" + JRStringUtil.escapeJavaStringLiteral(chart.getLinkType() != null ? chart.getLinkType() : "None") + "\");\n");
            this.write(chartName + ".setLinkTarget(\"" + JRStringUtil.escapeJavaStringLiteral(chart.getLinkTarget() != null ? chart.getLinkTarget() : "Self") + "\");\n");
            this.write(chartName + ".setBookmarkLevel(" + (chart.getBookmarkLevel() > 0 ? chart.getBookmarkLevel() : 0) + ");\n");
            if (chart.getCustomizerClass() != null) {
                this.write(chartName + ".setCustomizerClass(\"" + JRStringUtil.escapeJavaStringLiteral(chart.getCustomizerClass()) + "\");\n");
            }
            this.write(chartName + ".setRenderType(\"" + JRStringUtil.escapeJavaStringLiteral(chart.getRenderType()) + "\");\n");
            this.write(chartName + ".setTheme(\"" + JRStringUtil.escapeJavaStringLiteral(chart.getTheme()) + "\");\n");
            this.writeReportElement(chart, chartName);
            this.writeBox(chart.getLineBox(), chartName + ".getLineBox()");
            this.write(chartName + ".setTitlePosition(Byte.valueOf((byte)" + chart.getTitlePositionByte() + "));\n");
            if (chart.getSubtitleColor() != null) {
                this.write(chartName + ".setTitleColor(" + this.getColorText(chart.getOwnTitleColor()) + ");\n");
            }
            this.writeFont(chart.getTitleFont(), chartName + ".getTitleFont()");
            this.writeExpression(chart.getTitleExpression(), chartName, "TitleExpression");
            if (chart.getSubtitleColor() != null) {
                this.write(chartName + ".setSubtitleColor(" + this.getColorText(chart.getOwnSubtitleColor()) + ");\n");
            }
            this.writeFont(chart.getSubtitleFont(), chartName + ".getSubtitleFont()");
            this.writeExpression(chart.getSubtitleExpression(), chartName, "SubtitleExpression");
            if (chart.getOwnLegendColor() != null) {
                this.write(chartName + ".setLegendColor(" + this.getColorText(chart.getOwnLegendColor()) + ");\n");
            }
            if (chart.getOwnLegendBackgroundColor() != null) {
                this.write(chartName + ".setLegendBackgroundColor(" + this.getColorText(chart.getOwnLegendBackgroundColor()) + ");\n");
            }
            this.write(chartName + ".setLegendPosition(Byte.valueOf((byte)" + chart.getLegendPositionByte() + "));\n");
            this.writeFont(chart.getLegendFont(), chartName + ".getLegendFont()");
            this.writeExpression(chart.getAnchorNameExpression(), chartName, "AnchorNameExpression");
            this.writeExpression(chart.getHyperlinkReferenceExpression(), chartName, "HyperlinkReferenceExpression");
            this.writeExpression(chart.getHyperlinkAnchorExpression(), chartName, "HyperlinkAnchorExpression");
            this.writeExpression(chart.getHyperlinkPageExpression(), chartName, "HyperlinkPageExpression");
            this.writeExpression(chart.getHyperlinkTooltipExpression(), chartName, "HyperlinkTooltipExpression");
            this.writeHyperlinkParameters(chart.getHyperlinkParameters(), chartName);
            this.flush();
        }
    }

    public void writeElementDataset(JRElementDataset dataset, String datasetName) {
        this.writeElementDataset(dataset, true, datasetName);
    }

    public void writeElementDataset(JRElementDataset dataset, boolean skipIfEmpty, String datasetName) {
        if (dataset != null) {
            this.write(datasetName + ".setResetType((byte)" + (dataset.getResetType() > 0 ? dataset.getResetType() : (byte)1) + ");\n");
            if (dataset.getResetType() == 4) {
                String resetGroupName = this.getGroupName(dataset.getResetGroup());
                this.write(datasetName + ".setResetGroup(" + resetGroupName + ");\n");
            }
            this.write(datasetName + ".setIncrementType((byte)" + (dataset.getIncrementType() > 0 ? (int)dataset.getIncrementType() : 5) + ");\n");
            if (dataset.getIncrementType() == 4) {
                String incrementGroupName = this.getGroupName(dataset.getIncrementGroup());
                this.write(datasetName + ".setIncrementGroup(" + incrementGroupName + ");\n");
            }
            this.writeExpression(dataset.getIncrementWhenExpression(), datasetName, "IncrementWhenExpression");
            JRDatasetRun datasetRun = dataset.getDatasetRun();
            if (datasetRun != null) {
                this.writeDatasetRun(datasetRun, datasetName);
            }
            this.flush();
        }
    }

    private void writeCategoryDataSet(JRCategoryDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignCategoryDataset " + datasetName + " = (JRDesignCategoryDataset)" + parentName + ".getDataset();\n");
            this.writeElementDataset(dataset, datasetName);
            JRCategorySeries[] categorySeries = dataset.getSeries();
            if (categorySeries != null && categorySeries.length > 0) {
                for (int i = 0; i < categorySeries.length; ++i) {
                    this.writeCategorySeries(categorySeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeTimeSeriesDataset(JRTimeSeriesDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignTimeSeriesDataset " + datasetName + " = (JRDesignTimeSeriesDataset)" + parentName + ".getDataset();\n");
            if (dataset.getTimePeriod() != null && !Day.class.getName().equals(dataset.getTimePeriod().getName())) {
                this.write(datasetName + ".setTimePeriod(Class.forName(\"" + dataset.getTimePeriod().getName() + "\"));\n");
            }
            this.writeElementDataset(dataset, datasetName);
            JRTimeSeries[] timeSeries = dataset.getSeries();
            if (timeSeries != null && timeSeries.length > 0) {
                for (int i = 0; i < timeSeries.length; ++i) {
                    this.writeTimeSeries(timeSeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeGanttDataset(JRGanttDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignGanttDataset " + datasetName + " = (JRDesignGanttDataset)" + parentName + ".getDataset();\n");
            this.writeElementDataset(dataset, datasetName);
            JRGanttSeries[] ganttSeries = dataset.getSeries();
            if (ganttSeries != null && ganttSeries.length > 0) {
                for (int i = 0; i < ganttSeries.length; ++i) {
                    this.writeGanttSeries(ganttSeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeTimePeriodDataset(JRTimePeriodDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignTimePeriodDataset " + datasetName + " = (JRDesignTimePeriodDataset)" + parentName + ".getDataset();\n");
            this.writeElementDataset(dataset, datasetName);
            JRTimePeriodSeries[] timePeriodSeries = dataset.getSeries();
            if (timePeriodSeries != null && timePeriodSeries.length > 0) {
                for (int i = 0; i < timePeriodSeries.length; ++i) {
                    this.writeTimePeriodSeries(timePeriodSeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writePieSeries(JRPieSeries pieSeries, String parentName, int index) {
        if (pieSeries != null) {
            String pieSeriesName = parentName + "PieSeries" + index;
            this.write("JRDesignPieSeries " + pieSeriesName + " = " + parentName + ".getSeries()[" + index + "];\n");
            this.writeExpression(pieSeries.getKeyExpression(), pieSeriesName, "KeyExpression");
            this.writeExpression(pieSeries.getValueExpression(), pieSeriesName, "ValueExpression");
            this.writeExpression(pieSeries.getLabelExpression(), pieSeriesName, "LabelExpression");
            this.writeHyperlink(pieSeries.getSectionHyperlink(), pieSeriesName, "SectionHyperlink");
            this.write(parentName + ".addPieSeries(" + pieSeriesName + ");\n");
            this.flush();
        }
    }

    private void writeCategorySeries(JRCategorySeries categorySeries, String parentName, int index) {
        if (categorySeries != null) {
            String categorySeriesName = parentName + "CategorySeries" + index;
            this.write("JRDesignCategorySeries " + categorySeriesName + " = " + parentName + ".getSeries()[" + index + "];\n");
            this.writeExpression(categorySeries.getSeriesExpression(), categorySeriesName, "SeriesExpression");
            this.writeExpression(categorySeries.getCategoryExpression(), categorySeriesName, "CategoryExpression");
            this.writeExpression(categorySeries.getValueExpression(), categorySeriesName, "ValueExpression");
            this.writeExpression(categorySeries.getLabelExpression(), categorySeriesName, "LabelExpression");
            this.writeHyperlink(categorySeries.getItemHyperlink(), categorySeriesName, "ItemHyperlink");
            this.write(parentName + ".addCategorySeries(" + categorySeriesName + ");\n");
            this.flush();
        }
    }

    private void writeXyzDataset(JRXyzDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignXyzDataset " + datasetName + " = (JRDesignXyzDataset)" + parentName + ".getDataset();\n");
            this.writeElementDataset(dataset, datasetName);
            JRXyzSeries[] series = dataset.getSeries();
            if (series != null && series.length > 0) {
                for (int i = 0; i < series.length; ++i) {
                    this.writeXyzSeries(series[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeXyzSeries(JRXyzSeries series, String parentName, int index) {
        if (series != null) {
            String xyzSeriesName = parentName + "XyzSeries" + index;
            this.write("JRDesignXyzSeries " + xyzSeriesName + " = " + parentName + ".getSeries()[" + index + "];\n");
            this.writeExpression(series.getSeriesExpression(), xyzSeriesName, "SeriesExpression");
            this.writeExpression(series.getXValueExpression(), xyzSeriesName, "XValueExpression");
            this.writeExpression(series.getYValueExpression(), xyzSeriesName, "YValueExpression");
            this.writeExpression(series.getZValueExpression(), xyzSeriesName, "ZValueExpression");
            this.writeHyperlink(series.getItemHyperlink(), xyzSeriesName, "ItemHyperlink");
            this.write(parentName + ".addXyzSeries(" + xyzSeriesName + ");\n");
            this.flush();
        }
    }

    private void writeXySeries(JRXySeries xySeries, String parentName, int index) {
        if (xySeries != null) {
            String xySeriesName = parentName + "XySeries" + index;
            this.write("JRDesignXySeries " + xySeriesName + " = " + parentName + ".getSeries()[" + index + "];\n");
            this.writeExpression(xySeries.getSeriesExpression(), xySeriesName, "SeriesExpression");
            this.writeExpression(xySeries.getXValueExpression(), xySeriesName, "XValueExpression");
            this.writeExpression(xySeries.getYValueExpression(), xySeriesName, "YValueExpression");
            this.writeExpression(xySeries.getLabelExpression(), xySeriesName, "LabelExpression");
            this.writeHyperlink(xySeries.getItemHyperlink(), xySeriesName, "ItemHyperlink");
            this.write(parentName + ".addXySeries(" + xySeriesName + ");\n");
            this.flush();
        }
    }

    private void writeXyDataset(JRXyDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignXyDataset " + datasetName + " = (JRDesignXyDataset)" + parentName + ".getDataset();\n");
            this.writeElementDataset(dataset, datasetName);
            JRXySeries[] xySeries = dataset.getSeries();
            if (xySeries != null && xySeries.length > 0) {
                for (int i = 0; i < xySeries.length; ++i) {
                    this.writeXySeries(xySeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeTimeSeries(JRTimeSeries timeSeries, String parentName, int index) {
        if (timeSeries != null) {
            String timeSeriesName = parentName + "TimeSeries" + index;
            this.write("JRDesignTimeSeries " + timeSeriesName + " = " + parentName + ".getSeries()[" + index + "];\n");
            this.writeExpression(timeSeries.getSeriesExpression(), timeSeriesName, "SeriesExpression");
            this.writeExpression(timeSeries.getTimePeriodExpression(), timeSeriesName, "TimePeriodExpression");
            this.writeExpression(timeSeries.getValueExpression(), timeSeriesName, "ValueExpression");
            this.writeExpression(timeSeries.getLabelExpression(), timeSeriesName, "LabelExpression");
            this.writeHyperlink(timeSeries.getItemHyperlink(), timeSeriesName, "ItemHyperlink");
            this.write(parentName + ".addTimeSeries(" + timeSeriesName + ");\n");
            this.flush();
        }
    }

    private void writeGanttSeries(JRGanttSeries ganttSeries, String parentName, int index) {
        if (ganttSeries != null) {
            String ganttSeriesName = parentName + "GanttSeries" + index;
            this.write("JRDesignGanttSeries " + ganttSeriesName + " = " + parentName + ".getSeries()[" + index + "];\n");
            this.writeExpression(ganttSeries.getSeriesExpression(), ganttSeriesName, "SeriesExpression");
            this.writeExpression(ganttSeries.getTaskExpression(), ganttSeriesName, "TaskExpression");
            this.writeExpression(ganttSeries.getSubtaskExpression(), ganttSeriesName, "SubtaskExpression");
            this.writeExpression(ganttSeries.getStartDateExpression(), ganttSeriesName, "StartDateExpression");
            this.writeExpression(ganttSeries.getEndDateExpression(), ganttSeriesName, "EndDateExpression");
            this.writeExpression(ganttSeries.getPercentExpression(), ganttSeriesName, "PercentExpression");
            this.writeExpression(ganttSeries.getLabelExpression(), ganttSeriesName, "LabelExpression");
            this.writeHyperlink(ganttSeries.getItemHyperlink(), ganttSeriesName, "ItemHyperlink");
            this.write(parentName + ".addGanttSeries(" + ganttSeriesName + ");\n");
            this.flush();
        }
    }

    private void writeTimePeriodSeries(JRTimePeriodSeries timePeriodSeries, String parentName, int index) {
        if (timePeriodSeries != null) {
            String timePeriodSeriesName = parentName + "TimePeriodSeries" + index;
            this.write("JRDesignTimePeriodSeries " + timePeriodSeriesName + " = " + parentName + ".getSeries()[" + index + "];\n");
            this.writeExpression(timePeriodSeries.getSeriesExpression(), timePeriodSeriesName, "SeriesExpression");
            this.writeExpression(timePeriodSeries.getStartDateExpression(), timePeriodSeriesName, "StartDateExpression");
            this.writeExpression(timePeriodSeries.getEndDateExpression(), timePeriodSeriesName, "EndDateExpression");
            this.writeExpression(timePeriodSeries.getValueExpression(), timePeriodSeriesName, "ValueExpression");
            this.writeExpression(timePeriodSeries.getLabelExpression(), timePeriodSeriesName, "LabelExpression");
            this.writeHyperlink(timePeriodSeries.getItemHyperlink(), timePeriodSeriesName, "ItemHyperlink");
            this.write(parentName + ".addTimePeriodSeries(" + timePeriodSeriesName + ");\n");
            this.flush();
        }
    }

    public void writePieDataset(JRPieDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignPieDataset " + datasetName + " = (JRDesignPieDataset)" + parentName + ".getDataset();\n");
            this.write(datasetName + ".setMaxCount(Integer.valueOf(" + dataset.getMaxCount() + "));\n");
            this.write(datasetName + ".setMinPercentage(Float.valueOf(" + dataset.getMinPercentage() + "f));\n");
            this.writeElementDataset(dataset, datasetName);
            JRPieSeries[] pieSeries = dataset.getSeries();
            if (pieSeries != null) {
                if (pieSeries.length > 1) {
                    for (int i = 0; i < pieSeries.length; ++i) {
                        this.writePieSeries(pieSeries[i], datasetName, i);
                    }
                } else {
                    this.writePieSeries(pieSeries[0], datasetName, 0);
                }
            }
            this.writeExpression(dataset.getOtherKeyExpression(), datasetName, "OtherKeyExpression");
            this.writeExpression(dataset.getOtherLabelExpression(), datasetName, "OtherLabelExpression");
            this.writeHyperlink(dataset.getOtherSectionHyperlink(), datasetName, "OtherSectionHyperlink");
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    public void writeValueDataset(JRValueDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignValueDataset " + datasetName + " = (JRDesignValueDataset)" + parentName + ".getDataset();\n");
            this.writeElementDataset(dataset, datasetName);
            this.writeExpression(dataset.getValueExpression(), datasetName, "ValueExpression");
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    public void writeValueDisplay(JRValueDisplay valueDisplay, String parentName) {
        if (valueDisplay != null) {
            String valueDisplayName = parentName + "ValueDisplay";
            this.write("JRDesignValueDataset " + valueDisplayName + " = " + parentName + ".getValueDisplay();\n");
            this.write(valueDisplayName + ".setColor(" + this.getColorText(valueDisplay.getColor()) + ");\n");
            if (valueDisplay.getMask() != null) {
                this.write(valueDisplayName + ".setMask(\"" + valueDisplay.getMask() + "\");\n");
            }
            this.writeFont(valueDisplay.getFont(), valueDisplayName + ".getFont()");
            this.write(parentName + "setValueDisplay(" + valueDisplayName + ");\n");
            this.flush();
        }
    }

    public void writeItemLabel(JRItemLabel itemLabel, String parentName, String itemLabelSuffix) {
        if (itemLabel != null) {
            String itemLabelName = parentName + itemLabelSuffix;
            this.write("JRDesignItemLabel " + itemLabelName + " = " + parentName + ".getItemLabel();\n");
            this.write(itemLabelName + ".setColor(" + this.getColorText(itemLabel.getColor()) + ");\n");
            this.write(itemLabelName + ".setBackgroundColor(" + this.getColorText(itemLabel.getBackgroundColor()) + ");\n");
            this.writeFont(itemLabel.getFont(), itemLabelName + ".getFont()");
            this.write(parentName + ".set" + itemLabelSuffix + "(" + itemLabelName + ");\n");
            this.flush();
        }
    }

    public void writeDataRange(JRDataRange dataRange, String parentName, String dataRangeSuffix) {
        if (dataRange != null) {
            String dataRangeName = parentName + dataRangeSuffix;
            this.write("JRDesignDataRange " + dataRangeName + " = " + parentName + ".get" + dataRangeSuffix + "();\n");
            this.writeExpression(dataRange.getLowExpression(), dataRangeName, "LowExpression");
            this.writeExpression(dataRange.getHighExpression(), dataRangeName, "HighExpression");
            this.write(parentName + ".set" + dataRangeSuffix + "(" + dataRangeName + ");\n");
            this.flush();
        }
    }

    private void writeMeterInterval(JRMeterInterval interval, String parentName, String meterIntervalName) {
        if (interval != null) {
            this.write("JRMeterInterval " + meterIntervalName + " = new JRMeterInterval();\n");
            this.write(meterIntervalName + ".setLabel(\"" + JRStringUtil.escapeJavaStringLiteral(interval.getLabel()) + "\");\n");
            this.write(meterIntervalName + ".setBackgroundColor(" + this.getColorText(interval.getBackgroundColor()) + ");\n");
            this.write(meterIntervalName + ".setAlpha(Double.valueOf(" + interval.getAlphaDouble() + "));\n");
            this.writeDataRange(interval.getDataRange(), meterIntervalName, "DataRange");
            this.write(parentName + ".addInterval(" + meterIntervalName + ");\n");
            this.flush();
        }
    }

    private void writeSeriesColors(SortedSet seriesColors, String parentName) {
    }

    private void writeChartAxis(JRChartAxis chartAxis, String parentName, String axisName) {
        if (chartAxis != null) {
            this.write("JRChartAxis " + axisName + " = new JRChartAxis();\n");
            this.write(axisName + ".setPosition(Byte.valueOf((byte)" + chartAxis.getPositionByte() + "));\n");
            this.writeChartTag(chartAxis.getChart(), axisName + "Chart");
            this.write(parentName + ".addAxis(" + axisName + ");\n");
            this.flush();
        }
    }

    private void writePlot(JRChartPlot plot, String plotName) {
        if (plot != null) {
            this.write(plotName + ".setBackcolor(" + this.getColorText(plot.getBackcolor()) + ");\n");
            String orientation = PlotOrientation.HORIZONTAL.equals((Object)plot.getOrientation()) ? "PlotOrientation.HORIZONTAL" : "PlotOrientation.VERTICAL";
            this.write(plotName + ".setOrientation(" + orientation + ");\n");
            this.write(plotName + ".setBackgroundAlpha(Float.valueOf(" + plot.getBackgroundAlphaFloat().floatValue() + "f));\n");
            this.write(plotName + ".setForegroundAlpha(Float.valueOf(" + plot.getForegroundAlphaFloat().floatValue() + "f));\n");
            this.writeSeriesColors(plot.getSeriesColors(), plotName);
            this.flush();
        }
    }

    public void writePieChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_PIE);\n");
            this.writeChart(chart, chartName);
            this.writePieDataset((JRPieDataset)chart.getDataset(), chartName, "PieDataset");
            JRPiePlot plot = (JRPiePlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "PiePlot";
                this.write("JRDesignPiePlot " + plotName + " = (JRDesignPiePlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setCircular(Boolean.valueOf(" + plot.getCircular() + "));\n");
                this.write(plotName + ".setLabelFormat(\"" + JRStringUtil.escapeJavaStringLiteral(plot.getLabelFormat()) + "\");\n");
                this.write(plotName + ".setLegendLabelFormat(\"" + JRStringUtil.escapeJavaStringLiteral(plot.getLegendLabelFormat()) + "\");\n");
                this.writePlot(plot, plotName);
                this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
                this.flush();
            }
            this.flush();
        }
    }

    public void writePie3DChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_PIE3D);\n");
            this.writeChart(chart, chartName);
            this.writePieDataset((JRPieDataset)chart.getDataset(), chartName, "PieDataset");
            JRPie3DPlot plot = (JRPie3DPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "Pie3DPlot";
                this.write("JRDesignPie3DPlot " + plotName + " = (JRDesignPie3DPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setCircular(Boolean.valueOf(" + plot.getCircular() + "));\n");
                this.write(plotName + ".setLabelFormat(\"" + JRStringUtil.escapeJavaStringLiteral(plot.getLabelFormat()) + "\");\n");
                this.write(plotName + ".setLegendLabelFormat(\"" + JRStringUtil.escapeJavaStringLiteral(plot.getLegendLabelFormat()) + "\");\n");
                this.write(plotName + ".setDepthFactor(Double.valueOf(" + plot.getDepthFactorDouble() + "));\n");
                this.writePlot(plot, plotName);
                this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
                this.flush();
            }
            this.flush();
        }
    }

    public void writeCategoryAxisFormat(String indent, JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Boolean axisVerticalTickLabels, Double labelRotation, Color axisLineColor, String parentName, String axisNameSuffix) {
        if (axisLabelFont == null && axisLabelColor == null && axisTickLabelFont == null && axisTickLabelColor == null && axisLineColor == null) {
            return;
        }
        String axisName = parentName + axisNameSuffix;
        this.write(axisName + ".setCategoryAxisTickLabelRotation(Double.valueOf(" + labelRotation + "));\n");
        this.writeAxisFormat(indent, axisLabelFont, axisLabelColor, axisTickLabelFont, axisTickLabelColor, axisTickLabelMask, axisVerticalTickLabels, axisLineColor, parentName, axisNameSuffix, false);
        this.write(parentName + ".set" + axisNameSuffix + "(" + axisName + ");\n");
        this.flush();
    }

    public void writeAxisFormat(String indent, JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Boolean axisVerticalTickLabels, Color axisLineColor, String parentName, String axisNameSuffix, boolean isToSet) {
        if (axisLabelFont == null && axisLabelColor == null && axisTickLabelFont == null && axisTickLabelColor == null && axisLineColor == null) {
            return;
        }
        String axisName = parentName + axisNameSuffix;
        if (isToSet) {
            this.write("JRAxisFormat " + axisName + " = new JRAxisFormat();\n");
        }
        this.write(axisName + ".setLabelColor(" + this.getColorText(axisLabelColor) + ");\n");
        this.write(axisName + ".setTickLabelColor(" + this.getColorText(axisTickLabelColor) + ");\n");
        this.write(axisName + ".setLineColor(" + this.getColorText(axisLineColor) + ");\n");
        this.write(axisName + ".setTickLabelMask(\"" + JRStringUtil.escapeJavaStringLiteral(axisTickLabelMask) + "\");\n");
        this.write(axisName + ".setVerticalTickLabel(Boolean.valueOf(" + axisVerticalTickLabels + "));\n");
        if (axisLabelFont != null) {
            this.writeFont(axisLabelFont, axisName + ".getLabelFont()");
        }
        if (axisTickLabelFont != null) {
            this.writeFont(axisTickLabelFont, axisName + ".getTickLabelFont()");
        }
        if (isToSet) {
            this.write(parentName + ".set" + axisNameSuffix + "(" + axisName + ");\n");
        }
        this.flush();
    }

    private void writeBarPlot(JRBarPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "BarPlot";
            this.write("JRDesignBarPlot " + plotName + " = (JRDesignBarPlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLabels(Boolean.valueOf(" + plot.getShowLabels() + "));\n");
            this.write(plotName + ".setShowTickLabels(Boolean.valueOf(" + plot.getShowTickLabels() + "));\n");
            this.write(plotName + ".setShowTickMarks(Boolean.valueOf(" + plot.getShowTickMarks() + "));\n");
            this.writePlot(plot, plotName);
            this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
            this.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.indent, plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName, "CategoryAxisFormat");
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    private void writeBubblePlot(JRBubblePlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "BubblePlot";
            this.write("JRDesignBubblePlot " + plotName + " = (JRDesignBubblePlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setScaleType(" + plot.getScaleTypeInteger() + ");\n");
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getXAxisLabelExpression(), plotName, "XAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getXAxisVerticalTickLabels(), plot.getOwnXAxisLineColor(), plotName, "XAxisFormat", true);
            this.writeExpression(plot.getYAxisLabelExpression(), plotName, "YAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getYAxisVerticalTickLabels(), plot.getOwnYAxisLineColor(), plotName, "YAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    private void writeLinePlot(JRLinePlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "LinePlot";
            this.write("JRDesignLinePlot " + plotName + " = (JRDesignLinePlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLines(Boolean.valueOf(" + plot.getShowLines() + "));\n");
            this.write(plotName + ".setShowShapes(Boolean.valueOf(" + plot.getShowShapes() + "));\n");
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.indent, plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName, "CategoryAxisFormat");
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    private void writeTimeSeriesPlot(JRTimeSeriesPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "TimeSeriesPlot";
            this.write("JRDesignTimeSeriesPlot " + plotName + " = (JRDesignTimeSeriesPlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLines(Boolean.valueOf(" + plot.getShowLines() + "));\n");
            this.write(plotName + ".setShowShapes(Boolean.valueOf(" + plot.getShowShapes() + "));\n");
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getTimeAxisLabelExpression(), plotName, "TimeAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor(), plotName, "TimeAxisFormat", true);
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    public void writeBar3DPlot(JRBar3DPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "Bar3DPlot";
            this.write("JRDesignBar3DPlot " + plotName + " = (JRDesignBar3DPlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLabels(Boolean.valueOf(" + plot.getShowLabels() + "));\n");
            this.write(plotName + ".setXOffset(" + plot.getXOffsetDouble() + ");\n");
            this.write(plotName + ".setYOffset(" + plot.getYOffsetDouble() + ");\n");
            this.writePlot(plot, plotName);
            this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
            this.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.indent, plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName, "CategoryAxisFormat");
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    public void writeBarChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_BAR);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeBar3DChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_BAR3D);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBar3DPlot((JRBar3DPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeBubbleChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_BUBBLE);\n");
            this.writeChart(chart, chartName);
            this.writeXyzDataset((JRXyzDataset)chart.getDataset(), chartName, "XyzDataset");
            this.writeBubblePlot((JRBubblePlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeStackedBarChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_STACKEDBAR);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeStackedBar3DChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_STACKEDBAR3D);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBar3DPlot((JRBar3DPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeLineChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_LINE);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeLinePlot((JRLinePlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeTimeSeriesChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_TIMESERIES);\n");
            this.writeChart(chart, chartName);
            this.writeTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset(), chartName, "TimeSeriesDataset");
            this.writeTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeHighLowDataset(JRHighLowDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignHighLowDataset " + datasetName + " = (JRDesignHighLowDataset)" + parentName + ".getDataset();\n");
            this.writeElementDataset(dataset, datasetName);
            this.writeExpression(dataset.getSeriesExpression(), datasetName, "SeriesExpression");
            this.writeExpression(dataset.getDateExpression(), datasetName, "DateExpression");
            this.writeExpression(dataset.getHighExpression(), datasetName, "HighExpression");
            this.writeExpression(dataset.getLowExpression(), datasetName, "LowExpression");
            this.writeExpression(dataset.getOpenExpression(), datasetName, "OpenExpression");
            this.writeExpression(dataset.getCloseExpression(), datasetName, "CloseExpression");
            this.writeExpression(dataset.getVolumeExpression(), datasetName, "VolumeExpression");
            this.writeHyperlink(dataset.getItemHyperlink(), datasetName, "ItemHyperlink");
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    public void writeHighLowChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_HIGHLOW);\n");
            this.writeChart(chart, chartName);
            this.writeHighLowDataset((JRHighLowDataset)chart.getDataset(), chartName, "HighLowDataset");
            JRHighLowPlot plot = (JRHighLowPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "HighLowPlot";
                this.write("JRDesignHighLowPlot " + plotName + " = (JRDesignHighLowPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setShowOpenTicks(Boolean.valueOf(" + plot.getShowOpenTicks() + "));\n");
                this.write(plotName + ".setShowCloseTicks(Boolean.valueOf(" + plot.getShowCloseTicks() + "));\n");
                this.writePlot(plot, plotName);
                this.writeExpression(plot.getTimeAxisLabelExpression(), plotName, "TimeAxisLabelExpression");
                this.writeAxisFormat(this.indent, plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor(), plotName, "TimeAxisFormat", true);
                this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
                this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
                this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
                this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
                this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
                this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
                this.flush();
            }
            this.flush();
        }
    }

    public void writeGanttChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_GANTT);\n");
            this.writeChart(chart, chartName);
            this.writeGanttDataset((JRGanttDataset)chart.getDataset(), chartName, "GanttDataset");
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeCandlestickChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_CANDLESTICK);\n");
            this.writeChart(chart, chartName);
            this.writeHighLowDataset((JRHighLowDataset)chart.getDataset(), chartName, "HighLowDataset");
            JRCandlestickPlot plot = (JRCandlestickPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "CandlestickPlot";
                this.write("JRDesignCandlestickPlot " + plotName + " = (JRDesignCandlestickPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setShowVolume(Boolean.valueOf(" + plot.getShowVolume() + "));\n");
                this.writePlot(plot, plotName);
                this.writeExpression(plot.getTimeAxisLabelExpression(), plotName, "TimeAxisLabelExpression");
                this.writeAxisFormat(this.indent, plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor(), plotName, "TimeAxisFormat", true);
                this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
                this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
                this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
                this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
                this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
                this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
                this.flush();
            }
            this.flush();
        }
    }

    private void writeAreaPlot(JRAreaPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "AreaPlot";
            this.write("JRDesignAreaPlot " + plotName + " = (JRDesignAreaPlot)" + chartName + ".getPlot();\n");
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.indent, plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName, "CategoryAxisFormat");
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    public void writeAreaChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_AREA);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeAreaPlot((JRAreaPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    private void writeScatterPlot(JRScatterPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "ScatterPlot";
            this.write("JRDesignScatterPlot " + plotName + " = (JRDesignScatterPlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLines(Boolean.valueOf(" + plot.getShowLines() + "));\n");
            this.write(plotName + ".setShowShapes(Boolean.valueOf(" + plot.getShowShapes() + "));\n");
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getXAxisLabelExpression(), plotName, "XAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getXAxisVerticalTickLabels(), plot.getOwnXAxisLineColor(), plotName, "XAxisFormat", true);
            this.writeExpression(plot.getYAxisLabelExpression(), plotName, "YAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getYAxisVerticalTickLabels(), plot.getOwnYAxisLineColor(), plotName, "YAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    public void writeScatterChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_SCATTER);\n");
            this.writeChart(chart, chartName);
            this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            this.writeScatterPlot((JRScatterPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeXyAreaChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_XYAREA);\n");
            this.writeChart(chart, chartName);
            this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            this.writeAreaPlot((JRAreaPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeXyBarChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_XYBAR);\n");
            this.writeChart(chart, chartName);
            JRChartDataset dataset = chart.getDataset();
            if (dataset.getDatasetType() == 6) {
                this.writeTimeSeriesDataset((JRTimeSeriesDataset)dataset, chartName, "TimeSeriesDataset");
            } else if (dataset.getDatasetType() == 5) {
                this.writeTimePeriodDataset((JRTimePeriodDataset)dataset, chartName, "XyDataset");
            } else if (dataset.getDatasetType() == 3) {
                this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            }
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeXyLineChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_XYLINE);\n");
            this.writeChart(chart, chartName);
            this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            this.writeLinePlot((JRLinePlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeMeterChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_METER);\n");
            this.writeChart(chart, chartName);
            this.writeValueDataset((JRValueDataset)chart.getDataset(), chartName, "ValueDataset");
            JRMeterPlot plot = (JRMeterPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "MeterPlot";
                this.write("JRDesignMeterPlot " + plotName + " = (JRDesignMeterPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setShape(Byte.valueOf((byte)" + plot.getShapeByte() + "));\n");
                this.write(plotName + ".setMeterAngle(Integer.valueOf(" + plot.getMeterAngleInteger() + "));\n");
                this.write(plotName + ".setUnits(\"" + JRStringUtil.escapeJavaStringLiteral(plot.getUnits()) + "\");\n");
                this.write(plotName + ".setTickInterval(Double.valueOf(" + plot.getTickIntervalDouble() + "));\n");
                this.write(plotName + ".setMeterBackgroundColor(" + this.getColorText(plot.getMeterBackgroundColor()) + ");\n");
                this.write(plotName + ".setNeedleColor(" + this.getColorText(plot.getNeedleColor()) + ");\n");
                this.write(plotName + ".setTickColor(" + this.getColorText(plot.getTickColor()) + ");\n");
                this.writePlot(plot, plotName);
                if (plot.getTickLabelFont() != null) {
                    this.writeFont(plot.getTickLabelFont(), plotName + ".getTickLabelFont()");
                    this.flush();
                }
                this.writeValueDisplay(plot.getValueDisplay(), plotName);
                this.writeDataRange(plot.getDataRange(), plotName, "DataRange");
                List intervals = plot.getIntervals();
                if (intervals != null && intervals.size() > 0) {
                    for (int i = 0; i < intervals.size(); ++i) {
                        JRMeterInterval meterInterval = (JRMeterInterval)intervals.get(i);
                        this.writeMeterInterval(meterInterval, plotName, plotName + "Interval" + i);
                    }
                }
                this.flush();
            }
            this.flush();
        }
    }

    public void writeThermometerChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_THERMOMETER);\n");
            this.writeChart(chart, chartName);
            this.writeValueDataset((JRValueDataset)chart.getDataset(), chartName, "ValueDataset");
            JRThermometerPlot plot = (JRThermometerPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "ThermometerPlot";
                this.write("JRDesignThermometerPlot " + plotName + " = (JRDesignThermometerPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setValueLocation(Byte.valueOf((byte)" + plot.getValueLocationByte() + "));\n");
                this.write(plotName + ".setMercuryColor(" + this.getColorText(plot.getMercuryColor()) + ");\n");
                this.writePlot(plot, plotName);
                this.writeValueDisplay(plot.getValueDisplay(), plotName);
                this.writeDataRange(plot.getDataRange(), plotName, "DataRange");
                if (plot.getLowRange() != null) {
                    this.writeDataRange(plot.getLowRange(), plotName, "LowRange");
                }
                if (plot.getMediumRange() != null) {
                    this.writeDataRange(plot.getMediumRange(), plotName, "MediumRange");
                }
                if (plot.getHighRange() != null) {
                    this.writeDataRange(plot.getHighRange(), plotName, "HighRange");
                }
                this.flush();
            }
            this.flush();
        }
    }

    public void writeMultiAxisChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_MULTI_AXIS);\n");
            this.writeChart(chart, chartName);
            JRMultiAxisPlot plot = (JRMultiAxisPlot)chart.getPlot();
            String plotName = chartName + "MultiAxisPlot";
            this.write("JRDesignMultiAxisPlot " + plotName + " = (JRDesignMultiAxisPlot)" + chartName + ".getPlot();\n");
            this.writePlot(chart.getPlot(), plotName);
            List axes = plot.getAxes();
            if (axes != null && axes.size() > 0) {
                for (int i = 0; i < axes.size(); ++i) {
                    JRChartAxis chartAxis = (JRChartAxis)axes.get(i);
                    this.writeChartAxis(chartAxis, plotName, plotName + "Axis" + i);
                }
            }
            this.flush();
        }
    }

    public void writeStackedAreaChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_STACKEDAREA);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeAreaPlot((JRAreaPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeChartTag(JRChart chart, String chartName) {
        switch (chart.getChartType()) {
            case 1: {
                this.writeAreaChart(chart, chartName);
                break;
            }
            case 3: {
                this.writeBarChart(chart, chartName);
                break;
            }
            case 2: {
                this.writeBar3DChart(chart, chartName);
                break;
            }
            case 4: {
                this.writeBubbleChart(chart, chartName);
                break;
            }
            case 5: {
                this.writeCandlestickChart(chart, chartName);
                break;
            }
            case 6: {
                this.writeHighLowChart(chart, chartName);
                break;
            }
            case 7: {
                this.writeLineChart(chart, chartName);
                break;
            }
            case 17: {
                this.writeMeterChart(chart, chartName);
                break;
            }
            case 19: {
                this.writeMultiAxisChart(chart, chartName);
                break;
            }
            case 9: {
                this.writePieChart(chart, chartName);
                break;
            }
            case 8: {
                this.writePie3DChart(chart, chartName);
                break;
            }
            case 10: {
                this.writeScatterChart(chart, chartName);
                break;
            }
            case 12: {
                this.writeStackedBarChart(chart, chartName);
                break;
            }
            case 11: {
                this.writeStackedBar3DChart(chart, chartName);
                break;
            }
            case 18: {
                this.writeThermometerChart(chart, chartName);
                break;
            }
            case 16: {
                this.writeTimeSeriesChart(chart, chartName);
                break;
            }
            case 13: {
                this.writeXyAreaChart(chart, chartName);
                break;
            }
            case 14: {
                this.writeXyBarChart(chart, chartName);
                break;
            }
            case 15: {
                this.writeXyLineChart(chart, chartName);
                break;
            }
            case 20: {
                this.writeStackedAreaChart(chart, chartName);
                break;
            }
            case 21: {
                this.writeGanttChart(chart, chartName);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    private void writeSubreportReturnValue(JRSubreportReturnValue returnValue, String returnValueName) {
        if (returnValue != null) {
            this.write("JRDesignReturnValue " + returnValueName + " = new JRDesignReturnValue();\n");
            this.write(returnValueName + ".setSubreportVariable(\"" + JRStringUtil.escapeJavaStringLiteral(returnValue.getSubreportVariable()) + "\");\n");
            this.write(returnValueName + ".setToVariable(\"" + JRStringUtil.escapeJavaStringLiteral(returnValue.getToVariable()) + "\");\n");
            this.write(returnValueName + ".setCalculation((byte)" + (returnValue.getCalculation() > -1 ? returnValue.getCalculation() : (byte)0) + ");\n");
            this.write(returnValueName + ".setIncrementerFactoryClassName(\"" + JRStringUtil.escapeJavaStringLiteral(returnValue.getIncrementerFactoryClassName()) + "\");\n");
            this.flush();
        }
    }

    public void writeCrosstab(JRCrosstab crosstab, String crosstabName) {
        if (crosstab != null) {
            this.write("JRDesignCrosstab " + crosstabName + " = new JRDesignCrosstab(jasperDesign);\n");
            this.write(crosstabName + ".setRepeatColumnHeaders(" + crosstab.isRepeatColumnHeaders() + ");\n");
            this.write(crosstabName + ".setRepeatRowHeaders(" + crosstab.isRepeatRowHeaders() + ");\n");
            this.write(crosstabName + ".setColumnBreakOffset(" + (crosstab.getColumnBreakOffset() > 0 ? crosstab.getColumnBreakOffset() : 10) + ");\n");
            this.write(crosstabName + ".setRunDirection((byte)" + (crosstab.getRunDirection() > 0 ? crosstab.getRunDirection() : (byte)0) + ");\n");
            this.write(crosstabName + ".setIgnoreWidth(" + crosstab.getIgnoreWidth() + ");\n");
            this.writeReportElement(crosstab, crosstabName);
            JRCrosstabParameter[] parameters = crosstab.getParameters();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i].isSystemDefined()) continue;
                    this.writeCrosstabParameter(parameters[i], crosstabName + "Parameter" + i);
                    this.write(crosstabName + ".addParameter(" + crosstabName + "Parameter" + i + ");\n");
                }
            }
            this.writeExpression(crosstab.getParametersMapExpression(), crosstabName, "ParametersMapExpression");
            this.writeCrosstabDataset(crosstab, crosstabName);
            this.writeCrosstabHeaderCell(crosstab, crosstabName);
            JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
            for (int i = 0; i < rowGroups.length; ++i) {
                this.writeCrosstabRowGroup(rowGroups[i], crosstabName + "RowGroup" + i);
                this.write(crosstabName + ".addRowGroup(" + crosstabName + "RowGroup" + i + ");\n");
            }
            JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
            for (int i = 0; i < columnGroups.length; ++i) {
                this.writeCrosstabColumnGroup(columnGroups[i], crosstabName + "ColumnGroup" + i);
                this.write(crosstabName + ".addColumnGroup(" + crosstabName + "ColumnGroup" + i + ");\n");
            }
            JRCrosstabMeasure[] measures = crosstab.getMeasures();
            for (int i = 0; i < measures.length; ++i) {
                this.writeCrosstabMeasure(measures[i], crosstabName + "Measure" + i);
                this.write(crosstabName + ".addMeasure(" + crosstabName + "Measure" + i + ");\n");
            }
            if (crosstab instanceof JRDesignCrosstab) {
                List cellsList = ((JRDesignCrosstab)crosstab).getCellsList();
                for (int i = 0; i < cellsList.size(); ++i) {
                    JRCrosstabCell cell = (JRCrosstabCell)cellsList.get(i);
                    this.writeCrosstabCell(cell, crosstabName + "Cell" + i);
                    this.write(crosstabName + ".addCell(" + crosstabName + "Cell" + i + ");\n");
                }
            } else {
                JRCrosstabCell[][] cells = crosstab.getCells();
                HashSet<JRCrosstabCell> cellsSet = new HashSet<JRCrosstabCell>();
                for (int i = cells.length - 1; i >= 0; --i) {
                    for (int j = cells[i].length - 1; j >= 0; --j) {
                        JRCrosstabCell cell = cells[i][j];
                        if (cell == null || !cellsSet.add(cell)) continue;
                        this.writeCrosstabCell(cell, crosstabName + "Cell" + i + "" + j);
                        this.write(crosstabName + ".addCell(" + crosstabName + "Cell" + i + "" + j + ");\n");
                    }
                }
            }
            this.writeCrosstabWhenNoDataCell(crosstab, crosstabName + "NoDataCell");
            this.write(crosstabName + ".setWhenNoDataCell(" + crosstabName + "NoDataCell);\n");
            this.flush();
        }
    }

    private void writeCrosstabDataset(JRCrosstab crosstab, String crosstabName) {
        if (crosstab != null) {
            String datasetName = crosstabName + "Dataset";
            JRCrosstabDataset dataset = crosstab.getDataset();
            this.write("JRDesignCrosstabDataset " + datasetName + " = new JRDesignCrosstabDataset();\n");
            this.write(datasetName + ".setDataPreSorted(" + dataset.isDataPreSorted() + ");\n");
            this.writeElementDataset(dataset, datasetName);
            this.write(crosstabName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeCrosstabWhenNoDataCell(JRCrosstab crosstab, String cellName) {
        JRCellContents whenNoDataCell = crosstab.getWhenNoDataCell();
        if (whenNoDataCell != null) {
            this.writeCellContents(whenNoDataCell, cellName);
            this.flush();
        }
    }

    private void writeCrosstabHeaderCell(JRCrosstab crosstab, String parentName) {
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null) {
            this.writeCellContents(headerCell, parentName + "HeaderCellContents");
            this.write(parentName + ".setHeaderCell(" + parentName + "HeaderCellContents);\n");
            this.flush();
        }
    }

    protected void writeCrosstabRowGroup(JRCrosstabRowGroup group, String groupName) {
        if (group != null) {
            this.write("JRDesignCrosstabRowGroup " + groupName + " = new JRDesignCrosstabRowGroup();\n");
            this.write(groupName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(group.getName()) + "\");\n");
            this.write(groupName + ".setWidth(" + group.getWidth() + ");\n");
            this.write(groupName + ".setTotalPosition((byte)" + (group.getTotalPosition() > 0 ? group.getTotalPosition() : (byte)0) + ");\n");
            this.write(groupName + ".setPosition(" + (group.getPosition() > 0 ? group.getPosition() : (byte)1) + ");\n");
            this.writeBucket(group.getBucket(), groupName);
            JRCellContents header = group.getHeader();
            this.writeCellContents(header, groupName + "HeaderContents");
            this.write(groupName + ".setHeader(" + groupName + "HeaderContents);\n");
            JRCellContents totalHeader = group.getTotalHeader();
            this.writeCellContents(totalHeader, groupName + "TotalHeaderContents");
            this.write(groupName + ".setTotalHeader(" + groupName + "TotalHeaderContents);\n");
            this.flush();
        }
    }

    protected void writeCrosstabColumnGroup(JRCrosstabColumnGroup group, String groupName) {
        if (group != null) {
            this.write("JRDesignColumnRowGroup " + groupName + " = new JRDesignCrosstabColumnGroup();\n");
            this.write(groupName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(group.getName()) + "\");\n");
            this.write(groupName + ".setHeight(" + group.getHeight() + ");\n");
            this.write(groupName + ".setTotalPosition((byte)" + (group.getTotalPosition() > 0 ? group.getTotalPosition() : (byte)0) + ");\n");
            this.write(groupName + ".setPosition((byte)" + (group.getPosition() > 0 ? group.getPosition() : (byte)1) + ");\n");
            this.writeBucket(group.getBucket(), groupName);
            JRCellContents header = group.getHeader();
            this.writeCellContents(header, groupName + "HeaderContents");
            this.write(groupName + ".setHeader(" + groupName + "HeaderContents);\n");
            JRCellContents totalHeader = group.getTotalHeader();
            this.writeCellContents(totalHeader, groupName + "TotalHeaderContents");
            this.write(groupName + ".setTotalHeader(" + groupName + "TotalHeaderContents);\n");
            this.flush();
        }
    }

    protected void writeBucket(JRCrosstabBucket bucket, String parentName) {
        if (bucket != null) {
            String bucketName = parentName + "Bucket";
            this.write("JRDesignCrosstabBucket " + bucketName + " = new JRDesignCrosstabBucket();\n");
            this.write(bucketName + ".setOrder((byte)" + (bucket.getOrder() > 0 ? bucket.getOrder() : (byte)1) + ");\n");
            this.writeExpression(bucket.getExpression(), bucketName, "Expression");
            this.writeExpression(bucket.getComparatorExpression(), bucketName, "ComparatorExpression");
            this.writeExpression(bucket.getOrderByExpression(), bucketName, "OrderByExpression", Object.class.getName());
            this.flush();
        }
    }

    protected void writeCrosstabMeasure(JRCrosstabMeasure measure, String measureName) {
        if (measure != null) {
            this.write("JRDesignCrosstabMeasure " + measureName + " = new JRDesignCrosstabMeasure();\n");
            this.write(measureName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(measure.getName()) + "\");\n");
            this.write(measureName + ".setValueClassName(\"{0}\");\n", measure.getValueClassName());
            this.write(measureName + ".setCalculation((byte)" + (measure.getCalculation() > 0 ? measure.getCalculation() : (byte)0) + ");\n");
            this.write(measureName + ".setPercentageOfType((byte)" + (measure.getPercentageOfType() > 0 ? measure.getPercentageOfType() : (byte)0) + ");\n");
            this.write(measureName + ".setPercentageCalculatorClassName(\"" + JRStringUtil.escapeJavaStringLiteral(measure.getPercentageCalculatorClassName()) + "\");\n");
            this.writeExpression(measure.getValueExpression(), measureName, "ValueExpression");
            this.flush();
        }
    }

    protected void writeCrosstabCell(JRCrosstabCell cell, String cellName) {
        if (cell != null) {
            this.write("JRDesignCrosstabCell " + cellName + " = new JRDesignCrosstabCell();\n");
            this.write(cellName + ".setWidth(" + cell.getWidth() + ");\n");
            this.write(cellName + ".setHeight(" + cell.getHeight() + ");\n");
            this.write(cellName + ".setRowTotalGroup(\"" + JRStringUtil.escapeJavaStringLiteral(cell.getRowTotalGroup()) + "\");\n");
            this.write(cellName + ".setColumnTotalGroup(\"" + JRStringUtil.escapeJavaStringLiteral(cell.getColumnTotalGroup()) + "\");\n");
            this.writeCellContents(cell.getContents(), cellName + "Contents");
            this.write(cellName + ".setContents(" + cellName + "Contents);\n");
            this.flush();
        }
    }

    protected void writeCellContents(JRCellContents contents, String cellName) {
        if (contents != null) {
            this.write("JRDesignCellContents " + cellName + " = new JRDesignCellContents();\n");
            this.write(cellName + ".setBackcolor(" + this.getColorText(contents.getBackcolor()) + ");\n");
            this.write(cellName + ".setMode((byte)" + contents.getMode() + ");\n");
            this.writeStyleReferenceAttr(contents, cellName);
            this.writeBox(contents.getLineBox(), cellName + ".getLineBox()");
            this.writeChildElements(contents, cellName);
            this.flush();
        }
    }

    protected void writeCrosstabParameter(JRCrosstabParameter parameter, String parameterName) {
        if (parameter != null) {
            this.write("JRDesignCrosstabParameter " + parameterName + " = new JRDesignCrosstabParameter();\n");
            this.write(parameterName + ".setDescription(" + parameter.getDescription() + ");\n");
            this.write(parameterName + ".setName(" + parameter.getName() + ");\n");
            this.write(parameterName + ".setValueClassName(\"{0}\");\n", parameter.getValueClassName(), "java.lang.String");
            this.writeExpression(parameter.getExpression(), parameterName, "Expression");
            this.flush();
        }
    }

    public void writeDataset(JRDataset dataset, String datasetName) {
        if (dataset != null) {
            this.write("JRDesignDataset " + datasetName + " = new JRDesignDataset(" + dataset.isMainDataset() + ");\n");
            this.write(datasetName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(dataset.getName()) + "\");\n");
            this.write(datasetName + ".setScriptletClass(\"" + JRStringUtil.escapeJavaStringLiteral(dataset.getScriptletClass()) + "\");\n");
            this.write(datasetName + ".setResourceBundle(\"" + JRStringUtil.escapeJavaStringLiteral(dataset.getResourceBundle()) + "\");\n");
            this.write(datasetName + ".setWhenResourceMissingType((byte)" + (dataset.getWhenResourceMissingType() < 1 ? (byte)1 : dataset.getWhenResourceMissingType()) + ");\n");
            this.writeProperties(dataset, datasetName);
            this.writeDatasetContents(dataset, datasetName);
            this.flush();
        }
    }

    protected void writeDatasetContents(JRDataset dataset, String datasetName) {
        JRVariable[] variables;
        JRSortField[] sortFields;
        JRField[] fields;
        JRParameter[] parameters;
        JRScriptlet[] scriptlets = dataset.getScriptlets();
        if (scriptlets != null && scriptlets.length > 0) {
            for (int i = 0; i < scriptlets.length; ++i) {
                this.writeScriptlet(scriptlets[i], datasetName + "Scriptlet" + i);
                this.write(datasetName + ".addScriptlet(" + datasetName + "Scriptlet" + i + ");\n");
            }
        }
        if ((parameters = dataset.getParameters()) != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeParameter(parameters[i], datasetName + "Parameter" + i);
                this.write(datasetName + ".addParameter(" + datasetName + "Parameter" + i + ");\n");
            }
        }
        if (dataset.getQuery() != null) {
            this.writeQuery(dataset.getQuery(), datasetName + "Query");
        }
        if ((fields = dataset.getFields()) != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                this.writeField(fields[i], datasetName + "Field" + i);
                this.write(datasetName + ".addField(" + datasetName + "Field" + i + ");\n");
            }
        }
        if ((sortFields = dataset.getSortFields()) != null && sortFields.length > 0) {
            for (int i = 0; i < sortFields.length; ++i) {
                this.writeSortField(sortFields[i], datasetName + "SortField" + i);
                this.write(datasetName + ".addSortField(" + datasetName + "SortField" + i + ");\n");
            }
        }
        if ((variables = dataset.getVariables()) != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].isSystemDefined()) continue;
                this.writeVariable(variables[i], datasetName + "Variable" + i);
                this.write(datasetName + ".addVariable(" + datasetName + "Variable" + i + ");\n");
            }
        }
        this.writeExpression(dataset.getFilterExpression(), datasetName, "FilterExpression");
        JRGroup[] groups = dataset.getGroups();
        if (groups != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                String groupName = this.getGroupName(groups[i]);
                if (groupName == null) continue;
                this.write(datasetName + ".addGroup(" + groupName + ");\n");
            }
        }
        this.flush();
    }

    public void writeDatasetRun(JRDatasetRun datasetRun, String parentName) {
        if (datasetRun != null) {
            String runName = parentName + "Run";
            this.write("JRDesignDatasetRun " + runName + " = new JRDesignDatasetRun();\n");
            this.write(runName + ".setDatasetName(\"" + JRStringUtil.escapeJavaStringLiteral(datasetRun.getDatasetName()) + "\");\n");
            this.writeExpression(datasetRun.getParametersMapExpression(), runName, "ParametersMapExpression");
            JRDatasetParameter[] parameters = datasetRun.getParameters();
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    this.writeDatasetParameter(parameters[i], runName + "Parameter" + i);
                }
            }
            this.writeExpression(datasetRun.getConnectionExpression(), runName, "ConnectionExpression");
            this.writeExpression(datasetRun.getDataSourceExpression(), runName, "DataSourceExpression");
            this.write(parentName + ".setDatasetRun(" + runName + ");\n");
            this.flush();
        }
    }

    public void writeFrame(JRFrame frame, String frameName) {
        if (frame != null) {
            JRDesignFrame f = new JRDesignFrame(this.jasperDesign);
            this.write("JRDesignFrame " + frameName + " = new JRDesignFrame(jasperDesign);\n");
            this.writeReportElement(frame, frameName);
            this.writeBox(frame.getLineBox(), frameName + ".getLineBox()");
            this.writeChildElements(frame, frameName);
            this.flush();
        }
    }

    protected void writeHyperlinkParameters(JRHyperlinkParameter[] parameters, String parentName) {
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRHyperlinkParameter parameter = parameters[i];
                this.writeHyperlinkParameter(parameter, parentName + "HyperlinkParameter" + i);
                this.write(parentName + ".addHyperlinkParameter(" + parentName + "HyperlinkParameter" + i + ");\n");
            }
            this.flush();
        }
    }

    protected void writeHyperlinkParameter(JRHyperlinkParameter parameter, String parameterName) {
        if (parameter != null) {
            this.write("JRDesignHyperlinkParameter " + parameterName + " = new JRDesignHyperlinkParameter();\n");
            this.write(parameterName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(parameter.getName()) + "\");\n");
            this.writeExpression(parameter.getValueExpression(), parameterName, "ValueExpression", String.class.getName());
            this.flush();
        }
    }

    public void writeHyperlink(JRHyperlink hyperlink, String parentName, String hyperlinkSuffix) {
        if (hyperlink != null) {
            String hyperlinkName = parentName + hyperlinkSuffix;
            this.write("JRDesignHyperlink " + hyperlinkName + " = new JRDesignHyperlink();\n");
            this.write(hyperlinkName + ".setLinkType(\"" + JRStringUtil.escapeJavaStringLiteral(hyperlink.getLinkType() != null ? hyperlink.getLinkType() : "None") + "\");\n");
            this.write(hyperlinkName + ".setLinkTarget(\"" + JRStringUtil.escapeJavaStringLiteral(hyperlink.getLinkTarget() != null ? hyperlink.getLinkTarget() : "Self") + "\");\n");
            this.writeExpression(hyperlink.getHyperlinkReferenceExpression(), hyperlinkName, "HyperlinkReferenceExpression");
            this.writeExpression(hyperlink.getHyperlinkAnchorExpression(), hyperlinkName, "HyperlinkAnchorExpression");
            this.writeExpression(hyperlink.getHyperlinkPageExpression(), hyperlinkName, "HyperlinkPageExpression");
            this.writeExpression(hyperlink.getHyperlinkTooltipExpression(), hyperlinkName, "HyperlinkTooltipExpression");
            this.writeHyperlinkParameters(hyperlink.getHyperlinkParameters(), hyperlinkName);
            this.write(parentName + ".set" + hyperlinkSuffix + "(" + hyperlinkName + ");\n");
            this.flush();
        }
    }

    protected boolean toWriteConditionalStyles() {
        return true;
    }

    protected void writeConditionalStyle(JRConditionalStyle style, String styleName) {
        if (style != null) {
            this.write("JRDesignConditionalStyle " + styleName + " = new JRDesignConditionalStyle(jasperDesign);\n");
            this.writeExpression(style.getConditionExpression(), styleName, "ConditionExpression");
            this.write(styleName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(style.getName()) + "\");\n");
            this.writeStyleReferenceAttr(style, styleName);
            this.write(styleName + ".setDefault(" + style.isDefault() + ");\n");
            this.write(styleName + ".setMode((byte)" + style.getMode() + ");\n");
            this.write(styleName + ".setFontName(\"" + JRStringUtil.escapeJavaStringLiteral(style.getFontName()) + "\");\n");
            this.write(styleName + ".setFontSize(" + style.getFontSize() + ");\n");
            this.write(styleName + ".setBold(" + style.isBold() + ");\n");
            this.write(styleName + ".setItalic(" + style.isItalic() + ");\n");
            this.write(styleName + ".setUnderline(" + style.isUnderline() + ");\n");
            this.write(styleName + ".setStrikeThrough(" + style.isStrikeThrough() + ");\n");
            this.write(styleName + ".setPdfFontName(\"" + JRStringUtil.escapeJavaStringLiteral(style.getPdfFontName()) + "\");\n");
            this.write(styleName + ".setPdfEncoding(\"" + JRStringUtil.escapeJavaStringLiteral(style.getPdfEncoding()) + "\");\n");
            this.write(styleName + ".setPdfEmbedded(" + style.isPdfEmbedded() + ");\n");
            this.write(styleName + ".setForecolor(" + this.getColorText(style.getForecolor()) + ");\n");
            this.write(styleName + ".setBackcolor(" + this.getColorText(style.getBackcolor()) + ");\n");
            this.write(styleName + ".setFill((byte)" + style.getFill() + ");\n");
            this.write(styleName + ".setRadius(" + style.getRadius() + ");\n");
            this.write(styleName + ".setScaleImage((byte)" + style.getScaleImage() + ");\n");
            this.write(styleName + ".setHorizontalAlignment((byte)" + style.getHorizontalAlignment() + ");\n");
            this.write(styleName + ".setVerticalAlignment((byte)" + style.getVerticalAlignment() + ");\n");
            this.write(styleName + ".setRotation((byte)" + style.getRotation() + ");\n");
            this.write(styleName + ".setLineSpacing((byte)" + style.getLineSpacing() + ");\n");
            this.write(styleName + ".setMarkup(\"" + JRStringUtil.escapeJavaStringLiteral(style.getMarkup()) + "\");\n");
            this.write(styleName + ".setPattern(\"" + JRStringUtil.escapeJavaStringLiteral(style.getPattern()) + "\");\n");
            this.write(styleName + ".setBlankWhenNull(" + style.isBlankWhenNull() + ");\n");
            this.flush();
        }
    }

    public void writeComponentElement(JRComponentElement componentElement, String componentName) {
        if (componentElement != null) {
            this.write("JRDesignComponentElement " + componentName + " = new JRDesignComponentElement(jasperDesign);\n");
            this.writeReportElement(componentElement, componentName);
            ComponentKey componentKey = componentElement.getComponentKey();
            Component component = componentElement.getComponent();
            this.flush();
        }
    }

    public void writeGenericElement(JRGenericElement element, String elementName) {
        this.write("JRDesignGenericElement " + elementName + " = new JRDesignGenericElement(jasperDesign);\n");
        this.write(elementName + ".setEvaluationTime((byte)" + (element.getEvaluationTime() > 0 ? element.getEvaluationTime() : (byte)1) + ");\n");
        if (element.getEvaluationGroupName() != null) {
            this.write(elementName + ".setEvaluationGroupName(\"" + JRStringUtil.escapeJavaStringLiteral(element.getEvaluationGroupName()) + "\");\n");
        }
        this.writeReportElement(element, elementName);
        JRGenericElementType printKey = element.getGenericType();
        JRGenericElementType t = new JRGenericElementType(printKey.getNamespace(), printKey.getName());
        this.write("JRGenericElementType " + elementName + "Type = new JRGenericElementType(\"" + JRStringUtil.escapeJavaStringLiteral(printKey.getNamespace()) + "\", \"" + JRStringUtil.escapeJavaStringLiteral(printKey.getName()) + "\");\n");
        this.write(elementName + ".setGenericType(" + elementName + "Type);\n");
        this.flush();
        JRGenericElementParameter[] params = element.getParameters();
        for (int i = 0; i < params.length; ++i) {
            JRGenericElementParameter param = params[i];
        }
        this.flush();
    }

    public String getColorText(Color color) {
        if (color == null) {
            return null;
        }
        return "new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")";
    }

    protected void writeStyleReferenceAttr(JRStyleContainer styleContainer, String styleName) {
        if (styleContainer.getStyle() == null && styleContainer.getStyleNameReference() != null) {
            this.write(styleName + ".setStyleNameReference(" + styleContainer.getStyleNameReference() + ");\n");
        }
        this.flush();
    }

    private void writePen(JRPen pen, String penHolder) {
        if (pen != null) {
            this.write(penHolder + ".setLineWidth(" + pen.getLineWidth() + "f);\n");
            this.write(penHolder + ".setLineStyle((byte)" + pen.getLineStyle() + ");\n");
            this.write(penHolder + ".setLineColor(" + this.getColorText(pen.getLineColor()) + ");\n");
            this.flush();
        }
    }

    protected void writeBox(JRLineBox box, String boxHolder) {
        if (box != null) {
            this.write(boxHolder + ".setPadding(Integer.valueOf(" + box.getPadding() + "));\n");
            this.write(boxHolder + ".setTopPadding(Integer.valueOf(" + box.getTopPadding() + "));\n");
            this.write(boxHolder + ".setLeftPadding(Integer.valueOf(" + box.getLeftPadding() + "));\n");
            this.write(boxHolder + ".setBottomPadding(Integer.valueOf(" + box.getBottomPadding() + "));\n");
            this.write(boxHolder + ".setRightPadding(Integer.valueOf(" + box.getRightPadding() + "));\n");
            this.writePen(box.getPen(), boxHolder + ".getPen()");
            this.writePen(box.getTopPen(), boxHolder + ".getTopPen()");
            this.writePen(box.getLeftPen(), boxHolder + ".getLeftPen()");
            this.writePen(box.getBottomPen(), boxHolder + ".getBottomPen()");
            this.writePen(box.getRightPen(), boxHolder + ".getRightPen()");
            this.flush();
        }
    }

    public void writeExpression(JRExpression expression, String parentName, String expressionSuffix) {
        this.writeExpression(expression, parentName, expressionSuffix, null);
    }

    public void writeExpression(JRExpression expression, String parentName, String expressionSuffix, String defaultClassName) {
        if (expression != null) {
            String expressionName = parentName + expressionSuffix;
            this.write("JRDesignExpression " + expressionName + " = new JRDesignExpression();\n");
            this.write(expressionName + ".setId(" + expression.getId() + ");\n");
            this.write(expressionName + ".setText(\"" + JRStringUtil.escapeJavaStringLiteral(expression.getText()) + "\");\n");
            this.write(expressionName + ".setValueClassName(\"{0}\");\n", expression.getValueClassName(), defaultClassName);
            JRExpressionChunk[] chunks = expression.getChunks();
            if (chunks != null && chunks.length > 0) {
                String chunksName = "chunks_" + expressionName;
                this.write("JRDesignExpressionChunk[] " + chunksName + " = new JRDesignExpressionChunk[" + chunks.length + "];\n");
                for (int i = 0; i < chunks.length; ++i) {
                    this.write(chunksName + "[" + i + "] = new JRDesignExpressionChunk();\n");
                    this.write(chunksName + "[" + i + "].setType((byte)" + chunks[i].getType() + ");\n");
                    this.write(chunksName + "[" + i + "].setText(\"" + JRStringUtil.escapeJavaStringLiteral(chunks[i].getText()) + "\");\n");
                    this.write(expressionName + ".addChunk(" + chunksName + "[" + i + "]);\n");
                }
            }
            this.write(parentName + ".set" + expressionSuffix + "(" + expressionName + ");\n");
            this.flush();
        }
    }

    private String getGroupName(JRGroup group) {
        if (group != null) {
            if (this.groupsMap.get(group.getName()) == null) {
                this.writeGroup(group);
            }
            return group.getName();
        }
        return null;
    }

    protected void write(String text) {
        try {
            if (text.indexOf("null") < 0) {
                this.writer.write(this.indent + text);
            }
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void write1(String text) {
        try {
            this.writer.write(this.indent + text);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void write(String pattern, Object value) {
        if (value != null) {
            MessageFormat.format(pattern, value);
        }
    }

    protected void write(String pattern, Object value, Object defaultValue) {
        if (defaultValue == null && value != null || defaultValue != null && !defaultValue.equals(value)) {
            MessageFormat.format(pattern, value);
        }
    }

    protected void write(String pattern, int value) {
        MessageFormat.format(pattern, new Integer(value));
    }

    protected void write(String pattern, int value, int defaultValue) {
        if (value != defaultValue) {
            MessageFormat.format(pattern, new Integer(value));
        }
    }

    protected void write(String pattern, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            MessageFormat.format(pattern, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void write(String pattern, byte value, byte defaultValue) {
        if (value != defaultValue) {
            MessageFormat.format(pattern, new Byte(value));
        }
    }

    protected void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("JRApiWriter usage:");
            System.out.println("\tjava JRApiWriter reportCreatorClassName file");
            return;
        }
        String reportCreatorClassName = args[0];
        String destFileName = args[1];
        try {
            Class<?> reportCreatorClass = Class.forName(reportCreatorClassName);
            ReportCreator reportCreator = (ReportCreator)reportCreatorClass.newInstance();
            JasperDesign jasperDesign = reportCreator.create();
            JRXmlWriter.writeReport((JRReport)jasperDesign, destFileName, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

