/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.DocxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxParagraphHelper;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class XlsxStyleInfo {
    protected int fontIndex = 0;
    protected int borderIndex = 0;
    protected String backcolor = null;
    protected String horizontalAlign = null;
    protected String verticalAlign = null;

    public XlsxStyleInfo(int fontIndex, int borderIndex, JRExporterGridCell gridCell) {
        JRAlignment align;
        this.fontIndex = fontIndex;
        this.borderIndex = borderIndex;
        JRPrintElement element = gridCell.getElement();
        if (element != null && element.getMode() == 1) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        } else if (gridCell.getBackcolor() != null) {
            this.backcolor = JRColorUtil.getColorHexa(gridCell.getBackcolor());
        }
        JRAlignment jRAlignment = align = element instanceof JRAlignment ? (JRAlignment)((Object)element) : null;
        if (align != null) {
            this.horizontalAlign = XlsxParagraphHelper.getHorizontalAlignment(new Byte(align.getHorizontalAlignment()));
            this.verticalAlign = DocxCellHelper.getVerticalAlignment(new Byte(align.getVerticalAlignment()));
        }
    }

    public String getId() {
        return this.fontIndex + "|" + this.borderIndex + "|" + this.backcolor + "|" + this.horizontalAlign + "|" + this.verticalAlign;
    }
}

