/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.MaxFontSizeFinder;

public class TextRenderer {
    public static final FontRenderContext LINE_BREAK_FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private Graphics2D grx = null;
    private int x = 0;
    private int y = 0;
    private int topPadding = 0;
    private int leftPadding = 0;
    private float formatWidth = 0.0f;
    private float verticalOffset = 0.0f;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private float drawPosY = 0.0f;
    private float drawPosX = 0.0f;
    private boolean isMaxHeightReached = false;
    private byte horizontalAlignment = 0;
    private int fontSize = 0;
    private MaxFontSizeFinder maxFontSizeFinder = null;
    private boolean isMinimizePrinterJobSize = true;
    private boolean ignoreMissingFont = false;

    public static TextRenderer getInstance() {
        return new TextRenderer(JRProperties.getBooleanProperty("net.sf.jasperreports.export.graphics2d.min.job.size"), JRProperties.getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
    }

    public TextRenderer(boolean isMinimizePrinterJobSize, boolean ignoreMissingFont) {
        this.isMinimizePrinterJobSize = isMinimizePrinterJobSize;
        this.ignoreMissingFont = ignoreMissingFont;
    }

    public void render(Graphics2D initGrx, int initX, int initY, int initWidth, int initHeight, int initTopPadding, int initLeftPadding, int initBottomPadding, int initRightPadding, float initTextHeight, byte initHorizontalAlignment, byte initVerticalAlignment, float initLineSpacingFactor, float initLeadingOffset, int initFontSize, boolean isStyledText, JRStyledText styledText, String allText) {
        this.initialize(initGrx, initX, initY, initWidth, initHeight, initTopPadding, initLeftPadding, initBottomPadding, initRightPadding, initTextHeight, initHorizontalAlignment, initVerticalAlignment, initLineSpacingFactor, initLeadingOffset, initFontSize, isStyledText);
        AttributedCharacterIterator allParagraphs = styledText.getAwtAttributedString(this.ignoreMissingFont).getIterator();
        int tokenPosition = 0;
        int lastParagraphStart = 0;
        String lastParagraphText = null;
        StringTokenizer tkzer = new StringTokenizer(allText, "\n", true);
        while (tkzer.hasMoreTokens() && !this.isMaxHeightReached) {
            String token = tkzer.nextToken();
            if ("\n".equals(token)) {
                this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
                lastParagraphStart = tokenPosition;
                lastParagraphText = null;
            } else {
                lastParagraphStart = tokenPosition;
                lastParagraphText = token;
            }
            tokenPosition += token.length();
        }
        if (!this.isMaxHeightReached && lastParagraphStart < allText.length()) {
            this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
        }
    }

    private void initialize(Graphics2D initGrx, int initX, int initY, int initWidth, int initHeight, int initTopPadding, int initLeftPadding, int initBottomPadding, int initRightPadding, float initTextHeight, byte initHorizontalAlignment, byte initVerticalAlignment, float initLineSpacingFactor, float initLeadingOffset, int initFontSize, boolean isStyledText) {
        this.grx = initGrx;
        this.horizontalAlignment = initHorizontalAlignment;
        this.verticalOffset = 0.0f;
        switch (initVerticalAlignment) {
            case 1: {
                this.verticalOffset = 0.0f;
                break;
            }
            case 2: {
                this.verticalOffset = ((float)(initHeight - initTopPadding - initBottomPadding) - initTextHeight) / 2.0f;
                break;
            }
            case 3: {
                this.verticalOffset = (float)(initHeight - initTopPadding - initBottomPadding) - initTextHeight;
                break;
            }
            default: {
                this.verticalOffset = 0.0f;
            }
        }
        this.lineSpacingFactor = initLineSpacingFactor;
        this.leadingOffset = initLeadingOffset;
        this.x = initX;
        this.y = initY;
        this.topPadding = initTopPadding;
        this.leftPadding = initLeftPadding;
        this.formatWidth = initWidth - initLeftPadding - initRightPadding;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.textHeight = initTextHeight;
        this.drawPosY = 0.0f;
        this.drawPosX = 0.0f;
        this.isMaxHeightReached = false;
        this.fontSize = initFontSize;
        this.maxFontSizeFinder = MaxFontSizeFinder.getInstance(isStyledText);
    }

    private void renderParagraph(AttributedCharacterIterator allParagraphs, int lastParagraphStart, String lastParagraphText) {
        AttributedCharacterIterator paragraph = null;
        paragraph = lastParagraphText == null ? new AttributedString(" ", new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + 1).getIterator().getAttributes()).getIterator() : new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + lastParagraphText.length()).getIterator();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, LINE_BREAK_FONT_RENDER_CONTEXT);
        while (lineMeasurer.getPosition() < paragraph.getEndIndex() && !this.isMaxHeightReached) {
            float lineHeight;
            int startIndex = lineMeasurer.getPosition();
            TextLayout layout = lineMeasurer.nextLayout(this.formatWidth);
            if (this.isMinimizePrinterJobSize) {
                AttributedString tmpText = new AttributedString(paragraph, startIndex, startIndex + layout.getCharacterCount());
                layout = new TextLayout(tmpText.getIterator(), this.grx.getFontRenderContext());
            }
            if (this.drawPosY + (lineHeight = this.lineSpacingFactor * (float)this.maxFontSizeFinder.findMaxFontSize(new AttributedString(paragraph, startIndex, startIndex + layout.getCharacterCount()).getIterator(), this.fontSize)) <= this.textHeight) {
                this.drawPosY += lineHeight;
                switch (this.horizontalAlignment) {
                    case 4: {
                        this.drawPosX = layout.isLeftToRight() ? 0.0f : this.formatWidth - layout.getAdvance();
                        if (lineMeasurer.getPosition() >= paragraph.getEndIndex()) break;
                        layout = layout.getJustifiedLayout(this.formatWidth);
                        break;
                    }
                    case 3: {
                        this.drawPosX = this.formatWidth - layout.getAdvance();
                        break;
                    }
                    case 2: {
                        this.drawPosX = (this.formatWidth - layout.getAdvance()) / 2.0f;
                        break;
                    }
                    default: {
                        this.drawPosX = 0.0f;
                    }
                }
                this.draw(layout);
                continue;
            }
            this.isMaxHeightReached = true;
        }
    }

    public void draw(TextLayout layout) {
        layout.draw(this.grx, this.drawPosX + (float)this.x + (float)this.leftPadding, this.drawPosY + (float)this.y + (float)this.topPadding + this.verticalOffset + this.leadingOffset);
    }
}

