/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
var COLOR_FIELD_CHANGE = "orange";
var KEY_SEPARATOR      = ",";
var PRM_TXT_CHANGE_K_CODE = "txtChangeKCode";

/**
 * ʓǍǉ
 * @param 
 * @return 
 * @throws sO
 */
function onLoadExtra() {
	// ڔwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID,     COLOR_FIELD_NORMAL);
	setFieldsBgColor(ARY_ERR_FIELDS_ID, COLOR_FIELD_ERROR);
	// ڒݒ
	setMaxLength(PRM_TXT_CHANGE_K_CODE	, LEN_K_CODE);
	setMaxLength(PRM_TXT_K_CODE			, LEN_K_CODE);
	setMaxLength(PRM_TXT_K_NAME			, LEN_K_NAME);
	setMaxLength(PRM_TXT_K_KANA			, LEN_K_KANA);
	setMaxLength(PRM_TXT_E_MAIL			, LEN_E_MAIL);

	// ݒ
	if (MODE == 0) {
		// tH[JXݒ(INSERT̏ꍇ)
		setFocus(PRM_TXT_K_CODE);
		// l{^p
		setVisibility("btnBasic", false);
		setVisibility("btnKojin", false);
		setVisibility("btnList", false);
	} else if (MODE == 1) {
		// tH[JXݒ(UPDATȄꍇ)
		setFocus(PRM_TXT_K_NAME);
		setFieldsBgColor(PRM_TXT_K_CODE, COLOR_TABLE_BACKGROUND);
		setVisibility("btnNewData", false);
	}
	// [h^Cg
	switch (MODE) {
		case 0:
			setInnerHtml('spnMode', NAM_MODE_INSERT);
			break;
		case 1:
			setInnerHtml('spnMode', NAM_MODE_UPDATE);
			setColor('spnMode', COLOR_MSG_WARNING);
			break;
		default:
	}
	
	// changeCxgݒ
	setOnChangeHandler(PRM_TXT_K_NAME			, onChangeFields	);
	setOnChangeHandler(PRM_TXT_K_KANA			, onChangeFields	);
	setOnChangeHandler(PRM_TXT_E_MAIL			, onChangeFields	);
	setOnChangeHandler(PRM_PLT_OFFICE			, onChangeFields	);
	setOnChangeHandler(PRM_PLT_SECTION			, onChangeFields	);
	setOnChangeHandler(PRM_PLT_POSITION			, onChangeFields	);
	setOnChangeHandler(PRM_PLT_RETIREMENT		, onChangeFields	);
	setOnChangeHandler(PRM_PLT_ENTRANCE_YEAR	, onChangeFields	);
	setOnChangeHandler(PRM_PLT_ENTRANCE_MONTH	, onChangeFields	);
	setOnChangeHandler(PRM_PLT_ENTRANCE_DAY		, onChangeFields	);
	setOnChangeHandler(PRM_PLT_RETIREMENT_YEAR	, onChangeFields	);
	setOnChangeHandler(PRM_PLT_RETIREMENT_MONTH	, onChangeFields	);
	setOnChangeHandler(PRM_PLT_RETIREMENT_DAY	, onChangeFields	);
	// ύX(F)
	onChangeFields();
}

/**
 * tB[hύX
 * @param 
 * @return 
 * @throws sO
 */
function onChangeFields() {
	try {
		if (MODE == 0) {
			return;
		}
		checkChangedValue(PRM_TXT_K_NAME			, PRM_HID_K_NAME			);
		checkChangedValue(PRM_TXT_K_KANA			, PRM_HID_K_KANA			);
		checkChangedValue(PRM_TXT_E_MAIL			, PRM_HID_E_MAIL			);
		checkChangedValue(PRM_PLT_OFFICE			, PRM_HID_OFFICE			);
		checkChangedValue(PRM_PLT_SECTION			, PRM_HID_SECTION			);
		checkChangedValue(PRM_PLT_POSITION			, PRM_HID_POSITION			);
		checkChangedValue(PRM_PLT_RETIREMENT		, PRM_HID_RETIREMENT		);
		checkChangedValue(PRM_PLT_ENTRANCE_YEAR		, PRM_HID_ENTRANCE_YEAR		);
		checkChangedValue(PRM_PLT_ENTRANCE_MONTH	, PRM_HID_ENTRANCE_MONTH	);
		checkChangedValue(PRM_PLT_ENTRANCE_DAY		, PRM_HID_ENTRANCE_DAY		);
		checkChangedValue(PRM_PLT_RETIREMENT_YEAR	, PRM_HID_RETIREMENT_YEAR	);
		checkChangedValue(PRM_PLT_RETIREMENT_MONTH	, PRM_HID_RETIREMENT_MONTH	);
		checkChangedValue(PRM_PLT_RETIREMENT_DAY	, PRM_HID_RETIREMENT_DAY	);
	} catch (e) {
		handleException(e);
	}
}


/**
 * ύXmF
 * @param strTargetId    ύXmFΏۃIuWFNgID
 * @param strBaseValueId lIuWFNgID
 * @return 
 * @throws sO
 */
function checkChangedValue(strTargetId, strBaseValueId) {
	var color = getBgColor(strTargetId);
	if (color == COLOR_FIELD_ERROR) {
		return;
	}
	setBgColor(strTargetId, COLOR_FIELD_NORMAL);
	if (getFormValue(strTargetId) != getFormValue(strBaseValueId)) {
		setBgColor(strTargetId, COLOR_FIELD_CHANGE);
	}
}

/**
 * T[o[ʐM
 * @param 
 * @return 
 * @throws sO
 */
function submitForm(objForm) {
	// ̓`FbN
	if (validate()) {
		// T[o[ʐM(̓G[̏ꍇ)
		if (MODE == 0) {
			doSubmitMessage(objForm, 'H1022', 'QU0001', NAM_MAKE_NEW_DATA);
		} else if (MODE == 1) {
			doSubmitMessage(objForm, 'H1023', 'QC0001', '');
		}
	}
}

/**
 * ̓`FbN
 * @param 
 * @return `FbN(trueFOKAfalseFNG)
 * @throws sO
 */
function validate() {
	// tB[hwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID, COLOR_FIELD_NORMAL);
	onChangeFields();
	// pϊ
	convSbSpace(PRM_TXT_K_NAME);
	convSbSpace(PRM_TXT_K_KANA);
	convSbKana (PRM_TXT_K_KANA);
	// ̓`FbN
	var aryMessage = new Array();
	if (MODE == 1) {
		setFieldsBgColor(PRM_TXT_K_CODE, COLOR_TABLE_BACKGROUND);
	} else {
		checkRequired(PRM_TXT_K_CODE, NAM_K_CODE, aryMessage);
		checkCode    (PRM_TXT_K_CODE, NAM_K_CODE, aryMessage);
	}
	checkRequired(PRM_TXT_K_NAME	, NAM_K_NAME	, aryMessage);
	checkRequired(PRM_TXT_K_KANA	, NAM_K_KANA	, aryMessage);

	checkKana    (PRM_TXT_K_KANA	, NAM_K_KANA	, aryMessage);
	checkLength	 (PRM_TXT_K_KANA	, LEN_K_KANA	, NAM_K_KANA, aryMessage);
	
	checkDate(PRM_PLT_ENTRANCE_YEAR, PRM_PLT_ENTRANCE_MONTH, PRM_PLT_ENTRANCE_DAY,
				NAM_ENTRANCE_DATE, aryMessage);
	
	if (getFormValue(PRM_PLT_RETIREMENT) > 2) {
		checkRequired(PRM_PLT_RETIREMENT_YEAR	, NAM_RETIREMENT_DATE_YEAR	, aryMessage);
		checkRequired(PRM_PLT_RETIREMENT_MONTH	, NAM_RETIREMENT_DATE_MONTH	, aryMessage);
		checkRequired(PRM_PLT_RETIREMENT_DAY	, NAM_RETIREMENT_DATE_DAY	, aryMessage);
		checkCompareDate(PRM_PLT_RETIREMENT_YEAR, PRM_PLT_RETIREMENT_MONTH, PRM_PLT_RETIREMENT_DAY,
						PRM_PLT_ENTRANCE_YEAR, PRM_PLT_ENTRANCE_MONTH, PRM_PLT_ENTRANCE_DAY, aryMessage);
		
	} else {
		setFormValue(PRM_PLT_RETIREMENT_YEAR, "");
		setFormValue(PRM_PLT_RETIREMENT_MONTH, "");
		setFormValue(PRM_PLT_RETIREMENT_DAY, "");
	}		

	if (aryMessage.length == 0) {
		return true;
	} else {
		showMessage(aryMessage);
		return false;
	}
}

function checkCompareDate(year1, month1, day1, year2, month2, day2, aryMessage) {
	checkDate(year1, month1, day1, NAM_RETIREMENT_DATE, aryMessage);
	var targetDate1 = new Date(getFormValue(year1), getFormValue(month1) - 1, getFormValue(day1));
	var targetDate2 = new Date(getFormValue(year2), getFormValue(month2) - 1, getFormValue(day2));
	if (targetDate1.getTime() < targetDate2.getTime()) {
		setBgColor(PRM_PLT_RETIREMENT_YEAR, COLOR_FIELD_ERROR);
		setBgColor(PRM_PLT_RETIREMENT_MONTH, COLOR_FIELD_ERROR);
		setBgColor(PRM_PLT_RETIREMENT_DAY, COLOR_FIELD_ERROR);
		aryMessage.push(NAM_RETIREMENT_DATE + "" + NAM_ENTRANCE_DATE + "̓t͂ĂB");
	} 
}

function checkDate(yyyy, mm, dd, msg, aryMessage) {
	//N`FbN
	dayMonth = new Array(31,29,31,30,31,30,31,31,30,31,30,31);
	ValidFlag = true;
	yyyy2 = getFormValue(yyyy);
	mm2 = getFormValue(mm);
	dd2 = getFormValue(dd);
	if ((mm2 < 1) || (mm2 > 12)){
		setBgColor(yyyy, COLOR_FIELD_ERROR);
		aryMessage.push(msg + "̌1--12͂ĂB");
		ValidFlag = false;
	}
	if ((dd2 < 1) || (dd2 > dayMonth[mm2 - 1])){
		setBgColor(dd, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0006", msg));
		ValidFlag = false;
	}
	if (!chkUrudosi(yyyy2) && (mm2 == 2) && (dd2 == 29)){
		setBgColor(dd, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0006", msg));
		ValidFlag = false;
	}
	return ValidFlag;
}

function chkUrudosi(y) {
	if (((y % 4 == 0) && (y % 100 != 0)) || (y % 400 == 0)) {
		return true;
	}
	return false;
}
